/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationRule;
import java.util.ArrayList;
import java.util.List;

public class Selection {
    private Object members;
    private IDimension dimension;

    Selection(List<IMember> mems) {
        this.members = mems.size() == 1 ? mems.get(0) : mems;
        if (!mems.isEmpty()) {
            this.dimension = mems.get(0).getLevel().getDimension();
        }
    }

    Selection(IMember member) {
        this.members = member;
        this.dimension = member.getLevel().getDimension();
    }

    protected List<Selection> decomposeSelection(AggregateCombinationRule rule) {
        return this.decomposeSelection();
    }

    int size() {
        if (this.members instanceof List) {
            return ((List)this.members).size();
        }
        if (this.members instanceof IMember) {
            return 1;
        }
        return 0;
    }

    public List<IMember> getMembersList() {
        if (this.members instanceof List) {
            return (List)this.members;
        }
        ArrayList<IMember> memsList = new ArrayList<IMember>();
        memsList.add((IMember)this.members);
        return memsList;
    }

    public IMember getFirstMember() {
        if (this.members instanceof List) {
            return (IMember)((List)this.members).get(0);
        }
        return (IMember)this.members;
    }

    Object getMembers() {
        if (this.members instanceof List) {
            return (List)this.members;
        }
        return this.members;
    }

    public List<IMember> getMembersListWithSummary() {
        if (this.members instanceof List) {
            IMember mem = (IMember)((List)this.members).get(0);
            if (!mem.getLevel().isRootLevel()) {
                ((List)this.members).add(mem.getDimension().getDefaultHierarchy().getDefaultMember());
            }
            return (List)this.members;
        }
        ArrayList<IMember> memsList = new ArrayList<IMember>();
        memsList.add((IMember)this.members);
        IMember mem = (IMember)memsList.get(0);
        if (!mem.getLevel().isRootLevel()) {
            memsList.add(mem.getDimension().getDefaultHierarchy().getDefaultMember());
        }
        return memsList;
    }

    Object getMembersWithSummary() {
        return this.getMembersListWithSummary();
    }

    public String toString() {
        String closingBracket = "]";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.members instanceof List) {
            for (Object o : (List)this.members) {
                sb.append(o);
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append(this.members);
        }
        sb.append(closingBracket);
        return sb.toString();
    }

    public IDimension getDimension() {
        return this.dimension;
    }

    public boolean isSlicer() {
        return !(this.members instanceof List);
    }

    protected List<Selection> decomposeSelection() {
        ArrayList<Selection> selections = new ArrayList<Selection>(1);
        selections.add(this);
        return selections;
    }
}

