/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.qfw;

import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultIterator;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultPart;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QFWQueryResult
extends V5QueryResult {
    private final QFWQuery result;
    private final int datasetCount;
    private final Map<Integer, List<Object[]>> indexToDatset;
    private final Map<String, List<Object[]>> nameToDataset;
    private final String[] indexToName;

    public QFWQueryResult(QFWQuery theResult) {
        this.result = theResult;
        this.datasetCount = this.result.getDatasetCount();
        this.indexToDatset = new HashMap<Integer, List<Object[]>>(this.datasetCount);
        this.nameToDataset = new HashMap<String, List<Object[]>>(this.datasetCount);
        this.indexToName = new String[this.datasetCount];
        for (int j = 0; j < this.datasetCount; ++j) {
            String resultName;
            this.indexToName[j] = resultName = this.result.getDatasetInfo(j).getName();
        }
    }

    public void fetchRemainingDatasets() {
        for (int j = 0; j < this.datasetCount; ++j) {
            if (this.indexToDatset.containsKey(j)) continue;
            this.toList(Object[].class, j);
        }
    }

    public void close() {
        this.result.release();
    }

    public String getResultName(int index) throws ArrayIndexOutOfBoundsException {
        return this.indexToName[index];
    }

    public List<Object[]> getNamedResult(String name) {
        List<Object[]> ret = this.nameToDataset.get(name);
        if (ret == null) {
            for (int j = 0; j < this.datasetCount; ++j) {
                String resultName = this.result.getDatasetInfo(j).getName();
                if (!resultName.equals(name)) continue;
                Integer in = j;
                ret = this.indexToDatset.get(in);
                if (ret == null) {
                    QFWResultPart part = this.result.getResultPart(j);
                    QFWResultIterator iter = part.getEdgeIterator(0);
                    ret = iter.toArrayList();
                    iter.release();
                    part.release();
                    this.indexToDatset.put(in, ret);
                    this.nameToDataset.put(name, ret);
                }
                return ret;
            }
        }
        return ret;
    }

    public int getResultCount() {
        return this.datasetCount;
    }

    @Override
    public <T> List<T> toList(Class<T> elementType) {
        int lastResult = this.datasetCount - 1;
        Integer in = new Integer(lastResult);
        ArrayList<Object[]> ret = (ArrayList<Object[]>)this.indexToDatset.get(in);
        if (ret == null) {
            String name = this.getResultName(lastResult);
            QFWResultPart part = this.result.getResultPart(lastResult);
            QFWResultIterator iter = part.getEdgeIterator(0);
            ret = iter.toArrayList();
            iter.release();
            part.release();
            this.indexToDatset.put(in, ret);
            this.nameToDataset.put(name, ret);
        }
        return CollectionCast.downcast(ret, Object[].class, elementType);
    }

    @Override
    public <T> List<T> toList(Class<T> elementType, int index) {
        Integer in = new Integer(index);
        ArrayList<Object[]> ret = (ArrayList<Object[]>)this.indexToDatset.get(in);
        if (ret == null) {
            String name = this.getResultName(index);
            QFWResultPart part = this.result.getResultPart(index);
            QFWResultIterator iter = part.getEdgeIterator(0);
            ret = iter.toArrayList();
            iter.release();
            part.release();
            this.indexToDatset.put(in, ret);
            this.nameToDataset.put(name, ret);
        }
        return CollectionCast.downcast(ret, Object[].class, elementType);
    }

    @Override
    public void release() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        this.result.release();
    }
}

