/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RSAPIPartialQueryResult
extends RSAPIQueryResult {
    final int rowCount;
    final int index;

    public RSAPIPartialQueryResult(RSAPIDataset dataset, ExecutionEnvironment env, int id) {
        super(dataset, env);
        this.index = id;
        this.rowCount = Math.abs(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> toList(Class<T> elementType) {
        ArrayList<Object> result = new ArrayList<Object>();
        int rowPosition = 1;
        CircularHashMap<Integer, Value[]> tailResultQueue = new CircularHashMap<Integer, Value[]>();
        RSAPIPartialDataset partialDataset = QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, this.execEnv);
        RSAPIEdgeRowset rowset = partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        try {
            RSAPIColumn[] cols = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            FormatId[] formatIds = new FormatId[cols.length];
            Value[] headers = new Value[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                headers[i] = DataValueFactory.createStringValue();
                headers[i].set(cols[i].getName());
                String format = cols[i].getFormat();
                formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (cols[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
            result.add(headers);
            RSAPIRow rsapiRow = null;
            while ((rsapiRow = it.next()) != null) {
                Value[] row = new Value[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    Value val = (Value)rsapiRow.getColumn(i);
                    if (val == null || val.isNull()) {
                        row[i] = null;
                        continue;
                    }
                    row[i] = (Value)val.copy();
                    if (row[i].getFormatId() != FormatId.INVALID_FORMAT_FID) continue;
                    row[i].setFormatId(formatIds[i]);
                }
                if (this.index == 0) {
                    result.add(row);
                    continue;
                }
                if (!this.isTail()) {
                    if (rowPosition <= this.rowCount) {
                        result.add(row);
                        ++rowPosition;
                        continue;
                    }
                    break;
                }
                if (!this.isTail()) continue;
                tailResultQueue.put(XQEIntegerPool.getInteger(rowPosition), row);
                ++rowPosition;
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (partialDataset != null) {
                partialDataset.release();
            }
            this.rsapiDataset.releaseResultset(this.execEnv);
        }
        if (this.isTail() && tailResultQueue.size() > 0) {
            result.addAll(tailResultQueue.values());
        }
        return CollectionCast.downcast(result, Value[].class, elementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateResult(RSAPIRowCallback callback) {
        XQETrace trace;
        RSAPIPartialDataset partialDataset = null;
        RSAPIEdgeRowset rowset = null;
        RSAPIEdgeIterator it = null;
        if (this.index == 0) {
            super.iterateResult(callback);
        }
        if ((trace = this.execEnv.getTrace()) == null) {
            trace = new XQETrace();
            QueryEngineLoggingUtils.addExecutionTraceLevels(trace, this.execEnv.getRequestEnvironment());
        }
        IteratorProfilingManager profilingMgr = IteratorProfilingManager.getInstance();
        profilingMgr.registerProfiler(trace);
        try {
            partialDataset = !this.isTail() ? QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{this.rowCount}, true, false, this.execEnv) : QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, this.execEnv);
            rowset = partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
            it = partialDataset.edgeIterator(0);
            RSAPIColumn[] columns = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            FormatId[] formatIds = new FormatId[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String format = columns[i].getFormat();
                formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (columns[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
            int rowPosition = 0;
            RSAPIRow rsapiRow = it.next();
            CircularHashMap<Integer, RSAPIRow> rowQueue = new CircularHashMap<Integer, RSAPIRow>();
            while (rsapiRow != null) {
                if (this.isTail()) {
                    rowQueue.put(XQEIntegerPool.getInteger(rowPosition), (RSAPIRow)rsapiRow.copy());
                } else {
                    callback.consumeRow(rsapiRow, columns, formatIds);
                }
                rsapiRow = it.next();
                ++rowPosition;
            }
            if (this.isTail()) {
                for (RSAPIRow row : rowQueue.values()) {
                    callback.consumeRow(row, columns, formatIds);
                }
            }
            if (callback.reRun()) {
                throw new XQERuntimeException();
            }
            profilingMgr.logProfiling(partialDataset.getMasterDataset(), (IExecutionEnvironment)this.execEnv);
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (partialDataset != null) {
                partialDataset.release();
                profilingMgr.unregisterProfiler();
            }
        }
    }

    private boolean isTail() {
        return this.index < 0;
    }

    private class CircularHashMap<K, V>
    extends LinkedHashMap<Integer, V> {
        private static final long serialVersionUID = 5034547672977278170L;

        private CircularHashMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, V> eldest) {
            return this.size() > RSAPIPartialQueryResult.this.rowCount;
        }
    }
}

