/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfLevelWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeV5Query;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.BaseOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.DoubleNativeValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LoadDMRCubeSingleV5Query {
    public static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SingleCubeLoading", LogLevel.INFO);
    protected static final String SINGLEQUERYNAME = "singleTabularQuery";
    protected static final String SINGLEQRD = "singleTabularQueryResult";
    protected static final String ANAME = "aName";
    protected static final String COLUMN_NAME = "c";
    protected static final String KEY = "key";
    protected static final String CAPTION = "caption";
    protected static final String REF_MEASURE = "RefMeasure";
    protected static final String COLUMN_REF_LEVEL = "columnRefLevel";
    protected DMRCube ownerCube;
    protected HashMap<DMRLevel, LevelInfo> mapping = new HashMap();
    protected IMember[] currentMembers;
    protected IMember[] scopeMembers;
    protected ArrayList<DMRLevel> lowestLevelHier = new ArrayList();
    protected ArrayList<Boolean> useDefaultHierarchyMember = new ArrayList();
    protected IHierarchy firstRealHierarchy = null;
    protected List<DMRMeasure> projectedMeasures = null;
    protected DMRMeasure defaultMeasure = null;
    protected ArrayList<ArrayList<Integer>> projectedMeasuresColPos = null;
    protected ArrayList<ArrayList<DMRLevel>> measureRollUpScopes = null;
    protected Map<List<DMRLevel>, Integer> measureRollUpColPos = new HashMap<List<DMRLevel>, Integer>();
    protected ArrayList<IHierarchy> nonMeasureHierarchies = new ArrayList();
    protected AdaptiveCubeletStorageManager.ParamDefinition paramCubelet = null;
    protected IXQEQueryNode selection;
    protected IXQEQueryNode groupBody;
    protected IXQEQueryNode clonedSrc;
    protected V5QuerySet querySet;
    protected int detailFilterDataItemIndice = 0;
    protected boolean bNeedToSortmembers = true;
    private boolean setExprLocale = false;

    public static void logSingleLoading(String queryName, String s, String msg) {
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log(queryName + s + msg);
        }
    }

    public static boolean checkLoadCubeFromSingleV5Query(DMRCube cube) {
        if (cube.isReusedCube()) {
            return false;
        }
        if (cube.getModelCube() instanceof CubeWrapper) {
            return cube.getModelCube().getSingleQueryLoading();
        }
        return false;
    }

    public LoadDMRCubeSingleV5Query(DMRCube cube) {
        this.ownerCube = cube;
        AdaptiveCubeletStorageManager adaptiveCubeletStorageManager = this.ownerCube.getLocalCubelet();
        adaptiveCubeletStorageManager.getClass();
        this.paramCubelet = new AdaptiveCubeletStorageManager.ParamDefinition(adaptiveCubeletStorageManager, this.ownerCube.getLocalCubelet());
    }

    protected DMRLevel getLowestLevelToLoad(IHierarchy hierarchy, int dimPos) {
        return this.ownerCube.getLowestProjectedLevel(hierarchy);
    }

    protected void getMUNRestriction(IHierarchy hierarchy, int dimPos, ArrayList<List<Pair>> restrictionMembers) {
        if (!this.ownerCube.getOptimizationInfo().getPushMemberRestrictionsToRelationalSubquery()) {
            return;
        }
        if (this.ownerCube.getProjectedMembers().isEmpty()) {
            return;
        }
        ArrayList<BaseMember> restrictionMembersOfHierarchy = new ArrayList<BaseMember>();
        Map.Entry<ILevel, List<BaseMember>> restriction = this.ownerCube.getRestrictionMembersForHierarchy(hierarchy);
        for (BaseMember aRestrictionMember : restriction.getValue()) {
            if (!aRestrictionMember.getHierarchy().equals(hierarchy)) continue;
            restrictionMembersOfHierarchy.add(aRestrictionMember);
        }
        ArrayList<Pair> munRestriction = new ArrayList<Pair>();
        for (BaseMember m : restrictionMembersOfHierarchy) {
            String externalMUN = null;
            externalMUN = m.getType() == 1129 ? ((MDXParameterMember)m).getExternalValues().get(0) : m.getExternalName();
            if (externalMUN == null || externalMUN.length() == 0) continue;
            ILevel level = ((LevelWrapper)m.getLevel()).getWrappedLevel();
            Pair p = new Pair(externalMUN, level);
            munRestriction.add(p);
        }
        if (!munRestriction.isEmpty()) {
            restrictionMembers.add(munRestriction);
        }
    }

    protected List<DMRMeasure> getProjectedMeasure() {
        return this.ownerCube.getMeasureInfo();
    }

    protected void generateRollUpCombinations(ArrayList<ILevel> scopes) {
        ArrayList<ArrayList<DMRLevel>> tempLevels = null;
        for (int i = 0; i < scopes.size(); ++i) {
            tempLevels = i == 0 ? this.getLevels((DMRLevel)scopes.get(0)) : this.crossProduct(tempLevels, this.getLevels((DMRLevel)scopes.get(i)));
        }
        tempLevels.remove(tempLevels.size() - 1);
        for (ArrayList<DMRLevel> combination : tempLevels) {
            if (!this.rollUpIsrequired(combination)) continue;
            this.measureRollUpScopes.add(combination);
        }
    }

    protected boolean rollUpIsrequired(ArrayList<DMRLevel> combination) {
        Map<IXQEQueryNode, MDXLevelInfo> summaryInfo = this.ownerCube.getAggregationLevelInfo();
        for (MDXLevelInfo levelInfo : summaryInfo.values()) {
            if (!this.requiredRollUp(combination, levelInfo)) continue;
            return true;
        }
        return false;
    }

    protected void logFactDrivenLoadingStart() {
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("Start to load cube with a single sub-query: " + QueryStrategy.getReportName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCube() {
        this.logFactDrivenLoadingStart();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MultiRequestContext originalMultiReqCtx = execEnv.getMultiRequestContext();
        RequestEnvironment mainQueryReqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        RequestEnvironment newReqEnv = mainQueryReqEnv.duplicate();
        PlanningEnvironment newPlanningEnv = QueryPlanner.setupEnvironment(newReqEnv);
        ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(newExecEnv);
        try {
            originalMultiReqCtx.incrementRefCount();
            try {
                newReqEnv.initializeRequestPAC(newExecEnv.getConnectionElement());
                DMRUtilities.SubqueryType type = DMRUtilities.SubqueryType.LOAD_NON_REUSABLE_CUBE;
                this.buildCubeStreamV5QuerySet(newPlanningEnv, type);
                PlannedV5QuerySet plannedQuerySet = null;
                if (newReqEnv.getMaxSeverityLevel() == 3) {
                    for (IXQEQueryNode child : this.querySet.getChildrenOfType(101055)) {
                        V5QueryResultDefinition qrd = (V5QueryResultDefinition)child;
                        qrd.addQueryFeedback("CognosCommandText");
                        qrd.addQueryFeedback("nativeCommandText");
                    }
                }
                try {
                    plannedQuerySet = QueryPlanner.getInstance().planQuery(this.querySet, newPlanningEnv);
                }
                catch (Exception e) {
                    throw XQERuntimeException.wrap(XQEMessageKeys.PLN_UnsupportedDMRSubQuery, e);
                }
                Set<String> executionParameters = newReqEnv.getBoundParameters();
                for (String parameter : executionParameters) {
                    mainQueryReqEnv.addBoundParameter(parameter);
                }
                RSAPIDataset dataset = (RSAPIDataset)plannedQuerySet.getFirstChildByType(401005);
                if (newReqEnv.getMaxSeverityLevel() == 3) {
                    DMRUtilities.addSQLNags(execEnv, dataset, type);
                }
                RSAPIQueryResult tabularResult = new RSAPIQueryResult(dataset, newExecEnv);
                try {
                    SingleV5Handler callback = new SingleV5Handler();
                    tabularResult.iterateResult(callback);
                    if (INFO_LOGGER.isOn()) {
                        INFO_LOGGER.log("Single cube loading finishes: " + QueryStrategy.getReportName());
                    }
                }
                finally {
                    tabularResult.release();
                }
            }
            finally {
                originalMultiReqCtx.decrementRefCount();
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
    }

    protected void setDefaultMeasure(DMRMeasure measure) {
        IMember dm;
        if (measure.isReUseable() && this.defaultMeasure == null && !this.projectedMeasures.contains(dm = measure.getHierarchy().getDefaultMember())) {
            this.defaultMeasure = (DMRMeasure)dm;
        }
    }

    protected void buildCubeStreamV5QuerySet(PlanningEnvironment planningEnv, DMRUtilities.SubqueryType type) {
        planningEnv.setMetdataConnection(this.ownerCube.getConnection());
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        CubeWrapper cubeWrapper = this.ownerCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        boolean bridgeQuery = false;
        if (prePlan != null) {
            bridgeQuery = PrePlanUtilities.isBridgeQuery(prePlan);
        }
        this.createV5QuerySet(planningEnv, nodeFactory);
        IXQEQueryNode query = this.createV5Query(planningEnv, nodeFactory, type);
        this.createV5Source(nodeFactory, query);
        this.createGroupBody(nodeFactory, query);
        this.selection = nodeFactory.createNode(101009);
        query.addChild(this.selection);
        int columnIdx = 0;
        ArrayList<IMember> rootMembers = new ArrayList<IMember>();
        ArrayList<ILevel> lowestLevels = new ArrayList<ILevel>();
        ArrayList<List<Pair>> restrictionMembers = new ArrayList<List<Pair>>();
        List<IDimension> dims = this.ownerCube.getDimensions();
        for (int dimPos = 0; dimPos < dims.size(); ++dimPos) {
            IDimension iDimension = dims.get(dimPos);
            if (iDimension.isMeasuresDimension()) continue;
            for (IHierarchy hierarchy : iDimension.getHierarchies()) {
                if (!this.bNeedToSortmembers) {
                    this.paramCubelet.addNonMeasureHierarchy(hierarchy);
                }
                this.nonMeasureHierarchies.add(hierarchy);
                DMRLevel loadLevel = this.getLowestLevelToLoad(hierarchy, dimPos);
                this.addlowestLevelHier(loadLevel, dimPos);
                if (loadLevel != null) {
                    lowestLevels.add(loadLevel);
                } else {
                    lowestLevels.add(hierarchy.getLevel(0));
                }
                IMember rootMember = this.getHierarchyRootMember(hierarchy, dimPos);
                if (this.isSingleLoading()) {
                    ((DMRMember)rootMember).setGotAllChildren();
                }
                rootMembers.add(rootMember);
                if (loadLevel == null || loadLevel.getIndex() == 0) continue;
                List<DMRLevel> levels = loadLevel.getParentLevelToQueryWith();
                Collections.reverse(levels);
                for (DMRLevel level : levels) {
                    columnIdx = this.createDataItemsForLevel(planningEnv, nodeFactory, level, columnIdx);
                }
                this.getMUNRestriction(hierarchy, dimPos, restrictionMembers);
                if (this.firstRealHierarchy != null || loadLevel.isV5LevelWrapper()) continue;
                this.firstRealHierarchy = hierarchy;
                this.addSorting(nodeFactory, levels);
            }
        }
        this.paramCubelet.initialLevelIndex();
        this.currentMembers = rootMembers.toArray(new IMember[rootMembers.size()]);
        this.scopeMembers = new IMember[this.currentMembers.length];
        System.arraycopy(this.currentMembers, 0, this.scopeMembers, 0, this.currentMembers.length);
        this.projectedMeasures = this.getProjectedMeasure();
        this.projectedMeasuresColPos = new ArrayList();
        if (columnIdx > 0 && !this.projectedMeasures.isEmpty()) {
            this.measureRollUpScopes = new ArrayList();
            this.generateRollUpCombinations(lowestLevels);
        }
        for (DMRMeasure dMRMeasure : this.projectedMeasures) {
            this.setDefaultMeasure(dMRMeasure);
            columnIdx = this.createDataItemsForMeasure(planningEnv, bridgeQuery, nodeFactory, dMRMeasure, columnIdx);
        }
        for (CogMDXDetailFilter cogMDXDetailFilter : this.ownerCube.getDetailFilters()) {
            IDimension dimension = cogMDXDetailFilter.getDimensionFromModel();
            IMetadata filterOwner = cogMDXDetailFilter.getFilterOwner();
            if (dimension != null && filterOwner != null && dimension != filterOwner || !this.isFilterRequired(cogMDXDetailFilter) || !this.isDimensionEmbeddedFilterRequired(cogMDXDetailFilter, dimension)) continue;
            this.createDetailFilter(nodeFactory, query, cogMDXDetailFilter);
        }
        for (List list : restrictionMembers) {
            this.createDetailFilterForRestrictMember(nodeFactory, query, list);
        }
        this.querySet.addToIndex();
    }

    protected void addlowestLevelHier(DMRLevel loadLevel, int dimPos) {
        this.lowestLevelHier.add(loadLevel);
        this.useDefaultHierarchyMember.add(this.isDefaultMemberIgnoreEmbeddedFilter(dimPos));
    }

    protected boolean isDefaultMemberIgnoreEmbeddedFilter(int dimPos) {
        return false;
    }

    protected IMember getHierarchyRootMember(IHierarchy hierarchy, int dimPos) {
        return ((DMRLevel)hierarchy.getLevel(0)).getMember(0);
    }

    protected boolean isFilterRequired(CogMDXDetailFilter astDetailFilter) {
        return true;
    }

    protected boolean isDimensionEmbeddedFilterRequired(CogMDXDetailFilter astDetailFilter, IDimension dimension) {
        return true;
    }

    protected void createV5QuerySet(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
        MetadataConnection metadataConnection = planningEnv.getMetadataConnection();
        this.querySet = (V5QuerySet)nodeFactory.createNode(101002);
        String expressionLocale = LocaleConverter.localeToStr(metadataConnection.getDefaultLocale(null));
        this.querySet.setPropertyValue("expressionLocale", expressionLocale);
        this.querySet.setPropertyValue("modelPath", this.getRawModelPath(metadataConnection, this.ownerCube.getModelName()));
        ((RequestEnvironment)planningEnv.getRequestEnvironment()).setModelPath(this.getRawModelPath(metadataConnection, this.ownerCube.getModelName()));
        this.querySet.setUnreferencedQueriesRemoved();
    }

    protected boolean isSingleLoading() {
        return true;
    }

    protected IXQEQueryNode createV5Query(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory, DMRUtilities.SubqueryType type) {
        CubeWrapper cubeWrapper;
        RQPPrePlan prePlan;
        IXQEQueryNode query = nodeFactory.createNode(101006);
        this.querySet.addChild(query);
        query.setPropertyValue("name", SINGLEQUERYNAME);
        planningEnv.setRoot(query);
        query.setPropertyValue("relationalSubquery", true);
        query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.DMR.getName());
        if (this.isSingleLoading()) {
            query.setPropertyValue("singleLoadingCubeFromDMR", true);
        }
        if ((prePlan = (cubeWrapper = this.ownerCube.getModelCube()).getRQPPrePlanQuery()) != null) {
            List<IMetadata> allJoins = PrePlanUtilities.getAllJoins(prePlan);
            query.setPropertyValue("allJoins", allJoins);
        }
        Governors governors = cubeWrapper.getGovernors();
        query.setPropertyValue("governors", governors);
        DMRUtilities.useRelationalCache(this.ownerCube, planningEnv, governors, type);
        List<DMRMeasure> measures = this.ownerCube.getMeasureInfo();
        if (measures != null) {
            for (DMRMeasure m : measures) {
                if (!m.getName().equals("TBDummyMeasureName")) continue;
                Integer stitchingFlag = (Integer)m.getProperty("stitchingType");
                if (stitchingFlag == null || stitchingFlag != 2) break;
                governors.setRowStitchForFactLessQuery("TRUE");
                break;
            }
        }
        return query;
    }

    protected void createV5Source(XQENodeFactory nodeFactory, IXQEQueryNode query) {
        IXQEQueryNode source = null;
        V5QuerySet srcQuerySet = this.ownerCube.getModelCube().getV5QuerySetForV5Source();
        if (srcQuerySet != null && !srcQuerySet.isMultidimensionalSubquery()) {
            this.clonedSrc = source = MixedDMRRelUtil.copyV5SourceForSubQuery(nodeFactory, srcQuerySet, this.querySet);
        } else {
            source = nodeFactory.createNode(101007);
        }
        source.setPropertyValue("relational", true);
        query.addChild(source);
    }

    protected IXQEQueryNode createGroupBody(XQENodeFactory nodeFactory, IXQEQueryNode query) {
        IXQEQueryNode qrd = nodeFactory.createNode(101055);
        qrd.setPropertyValue("name", SINGLEQRD);
        qrd.setPropertyValue("refQuery", SINGLEQUERYNAME);
        qrd.setPropertyValue("governors", query.getPropertyValue("governors"));
        this.querySet.addChild(qrd);
        IXQEQueryNode edge = nodeFactory.createNode(101049);
        edge.setPropertyValue("name", ANAME);
        qrd.addChild(edge);
        IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
        valueSet.setNameProperty(ANAME);
        edgeGroup.addChild(valueSet);
        this.groupBody = nodeFactory.createNode(101051);
        this.groupBody.setPropertyValue("name", ANAME);
        valueSet.addChild(this.groupBody);
        return this.groupBody;
    }

    protected Governors getGovernors() {
        CubeWrapper cubeWrapper = this.ownerCube.getModelCube();
        return cubeWrapper.getGovernors();
    }

    protected String getAggregateForLevelAttributes(DMRLevel level, Governors gv) {
        if (level.isV5LevelWrapper()) {
            return "minimum";
        }
        String aggr = "none";
        if (gv == null) {
            return aggr;
        }
        if (gv.getSqlGenerationLevAttr() == Governors.SqlGenerationForAttr.MINIMUM || level.needToConvertEmptyKeyToNull(gv)) {
            aggr = "minimum";
        }
        return aggr;
    }

    protected int createDataItemsForLevel(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory, DMRLevel level, int columnIdx) {
        LevelInfo info = new LevelInfo();
        IXQEQueryNode expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, KEY);
        info.keyPosition = this.getExistingExpression(expression, "none");
        if (info.keyPosition == -1) {
            info.keyPosition = columnIdx++;
            this.addDataItem(nodeFactory, "none", info.keyPosition, expression);
        }
        String aggrTypeLevelAttr = this.getAggregateForLevelAttributes(level, this.getGovernors());
        info.captionPosition = info.keyPosition;
        if (level.needCaptionWhenLoadMembers()) {
            expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, CAPTION);
            info.captionPosition = this.getExistingExpression(expression, aggrTypeLevelAttr);
            if (info.captionPosition == -1) {
                info.captionPosition = columnIdx++;
                this.addDataItem(nodeFactory, aggrTypeLevelAttr, info.captionPosition, expression);
            }
        }
        List<String> props = this.ownerCube.getProjectedLevelProperties(level);
        HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
        List<IProperty> memberProperties = level.getMemberProperties();
        for (IProperty property : memberProperties) {
            allProps.put(property.getName(), (DMRProperty)property);
        }
        ISortItem[] levelSortItems = level.getSortItems();
        for (ISortItem sortItem : levelSortItems) {
            String n;
            DMRProperty p;
            String refObj = sortItem.getRefObject();
            String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
            if (nameParts == null || nameParts.length <= 0 || (p = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null || p.isBusinessKey() || p.isMemberCaption()) continue;
            if (props == null) {
                props = new ArrayList<String>();
                props.add(n);
                continue;
            }
            if (props.contains(n)) continue;
            props.add(n);
        }
        if (props != null) {
            for (String prop : props) {
                ArrayList<DMRProperty> list;
                DMRProperty propMeta = (DMRProperty)level.getMemberProperty(prop);
                if (propMeta == null || propMeta.isDynamicProperty()) continue;
                expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, propMeta);
                int propPos = this.getExistingExpression(expression, aggrTypeLevelAttr);
                if (propPos == -1) {
                    propPos = columnIdx++;
                    this.addDataItem(nodeFactory, aggrTypeLevelAttr, propPos, expression);
                }
                if (info.properties == null) {
                    info.properties = new HashMap();
                }
                if ((list = info.properties.get(XQEIntegerPool.getInteger(propPos))) == null) {
                    list = new ArrayList();
                    info.properties.put(XQEIntegerPool.getInteger(propPos), list);
                }
                list.add(propMeta);
            }
        }
        this.mapping.put(level, info);
        return columnIdx;
    }

    protected IXQEQueryNode getExpressionForLevelProp(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory, DMRLevel level, Object prop) {
        IXQEQueryNode expression = null;
        if (prop == KEY) {
            if (level.isV5LevelWrapper()) {
                expression = nodeFactory.deepCopyNode(level.getBinaryExpression());
                if (this.clonedSrc != null) {
                    MixedDMRRelUtil.reBindReferences(nodeFactory, expression, this.clonedSrc, this.querySet);
                }
            } else {
                expression = nodeFactory.createNode(101004);
                String keyExpr = level.getQueryItemExpressionForKey();
                if (level.needToConvertEmptyKeyToNull(this.getGovernors())) {
                    keyExpr = level.convertEmptyToNull(keyExpr);
                }
                expression.setPropertyValue("expression", keyExpr);
                if (!this.setExprLocale) {
                    this.setExprLocale = V5QueryOverTabularStream.setExpressionLocale(planningEnv, V5QueryOverTabularStream.getLevelModel(level));
                }
                this.setMetadataContext(level, expression);
            }
        } else if (prop == CAPTION) {
            expression = nodeFactory.createNode(101004);
            String capExpr = level.getQueryItemExpressionForCaption();
            expression.setPropertyValue("expression", capExpr);
            if (!this.setExprLocale) {
                this.setExprLocale = V5QueryOverTabularStream.setExpressionLocale(planningEnv, V5QueryOverTabularStream.getLevelModel(level));
            }
            this.setMetadataContext(level, expression);
        } else if (prop instanceof DMRProperty) {
            DMRProperty propMeta = (DMRProperty)prop;
            if (propMeta.isV5LevelPropertyWrapper()) {
                expression = nodeFactory.deepCopyNode(propMeta.getBinaryExpression());
                if (this.clonedSrc != null) {
                    MixedDMRRelUtil.reBindReferences(nodeFactory, expression, this.clonedSrc, this.querySet);
                }
            } else {
                expression = nodeFactory.createNode(101004);
                expression.setPropertyValue("expression", propMeta.getQueryItemExpressionForKey(planningEnv));
                if (!this.setExprLocale) {
                    this.setExprLocale = V5QueryOverTabularStream.setExpressionLocale(planningEnv, V5QueryOverTabularStream.getLevelModel(level));
                }
                this.setMetadataContext(level, expression);
            }
        }
        return expression;
    }

    private void setMetadataContext(DMRLevel level, IXQEQueryNode expression) {
        MetadataContext c = level.getMetadataContext();
        if (c != null) {
            expression.setPropertyValue("metadataContext", c);
        }
    }

    protected int getExistingExpression(IXQEQueryNode expression, String aggrType) {
        return -1;
    }

    protected void addDataItem(XQENodeFactory nodeFactory, boolean bridgeQuery, String aggr, int pos, IXQEQueryNode expression) {
        V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", aggr);
        String dataItemName = COLUMN_NAME + pos;
        if (bridgeQuery) {
            dataItem.setPropIsRollupExpression(true);
        }
        dataItem.setPropertyValue("name", dataItemName);
        this.selection.addChild(dataItem);
        dataItem.addChild(expression);
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", dataItemName);
        this.groupBody.addChild(dataItemRef);
    }

    protected void addDataItem(XQENodeFactory nodeFactory, String aggr, int pos, IXQEQueryNode expression) {
        boolean bridgeQuery = false;
        this.addDataItem(nodeFactory, bridgeQuery, aggr, pos, expression);
    }

    protected int createDataItemsForMeasure(PlanningEnvironment planningEnv, boolean bridgeQuery, XQENodeFactory nodeFactory, DMRMeasure measure, int columnIdx) {
        String aggregateAttribute = measure.getV5AggregateAttribute();
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregateAttribute)) {
            aggregateAttribute = measure.getV5AggregateForModelAggregate();
        }
        IXQEQueryNode measureExpr = null;
        IXQEQueryNode expression = measure.getBinaryExpression();
        if (expression != null) {
            expression = nodeFactory.deepCopyNode(expression);
            if (this.clonedSrc != null) {
                MixedDMRRelUtil.reBindReferences(nodeFactory, expression, this.clonedSrc, this.querySet);
            }
            this.unwindWrapObjects(planningEnv, nodeFactory, expression);
        } else {
            String measureExprStr = measure.getQueryItemExpression(planningEnv);
            expression = DMRUtilities.createExpression(nodeFactory, measureExprStr);
            measureExpr = RQPUtilities.createV5ValueExpressionMetadata(measureExprStr, planningEnv, null, V5QueryOverTabularStream.getMeasureModel(measure));
        }
        String measureAggrType = aggregateAttribute;
        if (measureAggrType == null || measureAggrType.equals(AggregateTypeEnum.UNSUPPORTED.toV5Type()) || measureAggrType.equals(AggregateTypeEnum.UNKNOWN.toV5Type()) || measureAggrType.equals("notApplicable")) {
            int subtype = RQPUtilities.getDefaultAggregateBasedOnDataType(measure.getDataType());
            measureAggrType = V5AggregateFunctionSubtype.getName(subtype);
        }
        int measurePos = this.getExistingExpression(expression, measureAggrType);
        String measureReferenceName = COLUMN_NAME;
        if (measurePos == -1) {
            measurePos = columnIdx;
            if (AggregateTypeEnum.valueOfV5String(measureAggrType).isAdditive() || measureAggrType.equals(AggregateTypeEnum.CALCULATED.toV5Type()) && measure.getWrappedModelMeasure() != null) {
                measureReferenceName = REF_MEASURE;
                IXQEQueryNode dataItem = nodeFactory.createNode(101003);
                dataItem.setPropertyValue("aggregate", measureAggrType);
                dataItem.setPropertyValue("name", REF_MEASURE + columnIdx);
                dataItem.addChild(expression);
                this.selection.addChild(dataItem);
                IXQEQueryNode dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, measureReferenceName + columnIdx);
                expression = nodeFactory.createNode(201031);
                if (measureExpr != null && measureExpr.getType() == 201031 && ((V5ValueSummaryFunction)measureExpr).getSubType() == 43) {
                    ((V5ValueSummaryFunction)expression).setSubType(43);
                    ((V5ValueSummaryFunction)expression).setNativeName(((V5ValueSummaryFunction)measureExpr).getNativeName());
                } else {
                    AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planningEnv, measure.getUniqueName(), aggregateAttribute, (V5ValueSummaryFunction)expression, measure.getDataType(), this.ownerCube.getDecomposeCalculatedMeasure());
                }
                expression.addChild(dataItemIdentifier);
                V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
                expression.addChild(forClause);
                if (this.mapping.isEmpty() || measure.getName().equals("TBDummyMeasureName")) {
                    forClause.setSubType(0);
                } else {
                    int[] levelKeyPositions = new int[this.mapping.size()];
                    int i = 0;
                    for (LevelInfo levelInfo : this.mapping.values()) {
                        levelKeyPositions[i++] = levelInfo.keyPosition;
                    }
                    Arrays.sort(levelKeyPositions);
                    for (Object j : (Object)levelKeyPositions) {
                        dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, COLUMN_NAME + (int)j);
                        forClause.addChild(dataItemIdentifier);
                    }
                }
                this.addDataItem(nodeFactory, AggregateTypeEnum.CALCULATED.toV5Type(), measurePos, expression);
            } else {
                this.addDataItem(nodeFactory, measureAggrType, measurePos, expression);
            }
            ++columnIdx;
        }
        ArrayList<Integer> range = new ArrayList<Integer>();
        range.add(XQEIntegerPool.getInteger(measurePos));
        this.projectedMeasuresColPos.add(range);
        if (this.measureRollUpScopes != null) {
            for (ArrayList<DMRLevel> c : this.measureRollUpScopes) {
                TreeSet<Integer> r = this.getForClause(c);
                IXQEQueryNode dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, measureReferenceName + measurePos);
                expression = nodeFactory.createNode(201031);
                if (measureExpr != null && measureExpr.getType() == 201031 && ((V5ValueSummaryFunction)measureExpr).getSubType() == 43) {
                    ((V5ValueSummaryFunction)expression).setSubType(43);
                    ((V5ValueSummaryFunction)expression).setNativeName(((V5ValueSummaryFunction)measureExpr).getNativeName());
                } else {
                    AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planningEnv, measure.getUniqueName(), aggregateAttribute, (V5ValueSummaryFunction)expression, measure.getDataType());
                }
                expression.addChild(dataItemIdentifier);
                V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
                expression.addChild(forClause);
                if (r.isEmpty() || measure.getName().equals("TBDummyMeasureName")) {
                    forClause.setSubType(0);
                } else {
                    for (Integer l : r) {
                        dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, COLUMN_NAME + l);
                        forClause.addChild(dataItemIdentifier);
                    }
                }
                int rollPos = this.getExistingExpression(expression, AggregateTypeEnum.CALCULATED.toV5Type());
                if (rollPos == -1) {
                    rollPos = columnIdx++;
                    this.addDataItem(nodeFactory, bridgeQuery, AggregateTypeEnum.CALCULATED.toV5Type(), rollPos, expression);
                }
                range.add(XQEIntegerPool.getInteger(rollPos));
                this.measureRollUpColPos.put(c, rollPos);
            }
        }
        return columnIdx;
    }

    protected void unwindWrapObjects(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory, IXQEQueryNode expression) {
        IXQEQueryNode[] boundItems;
        for (IXQEQueryNode boundItem : boundItems = expression.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier modelID = (V5BoundModelIdentifier)boundItem;
            IMetadata metadata = modelID.getMetadata();
            String qExpression = null;
            String diName = null;
            if (metadata instanceof MeasureWrapper) {
                qExpression = (String)metadata.getProperty("expression");
                if (qExpression == null) {
                    qExpression = metadata.getV5UniqueName();
                }
                if ((diName = DMRUtilities.findDataItem(this.selection, qExpression = MetadataUtil.extractExpressionFromModelString(qExpression, planningEnv))) == null) {
                    String colNamePart1 = COLUMN_NAME + this.detailFilterDataItemIndice++;
                    diName = colNamePart1 + REF_MEASURE;
                    DMRUtilities.createDataItemWithExpression(nodeFactory, this.selection, diName, qExpression);
                }
            } else if (metadata instanceof LevelWrapper) {
                DMRLevel dmrLevel = (DMRLevel)this.ownerCube.getWrapper(metadata);
                qExpression = dmrLevel.getQueryItemExpressionForKey();
                diName = DMRUtilities.findDataItem(this.selection, qExpression);
                if (diName == null) {
                    diName = COLUMN_REF_LEVEL + this.detailFilterDataItemIndice++;
                    DMRUtilities.createDataItemWithExpression(nodeFactory, this.selection, diName, qExpression);
                }
            } else if (metadata instanceof QueryItemOfLevelWrapper && (diName = DMRUtilities.findDataItem(this.selection, qExpression = MetadataUtil.extractExpressionFromModelString(((QueryItemOfLevelWrapper)metadata).getExpression(), planningEnv))) == null) {
                diName = COLUMN_REF_LEVEL + this.detailFilterDataItemIndice++;
                DMRUtilities.createDataItemWithExpression(nodeFactory, this.selection, diName, qExpression);
            }
            if (diName == null) continue;
            IXQEQueryNode dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, diName);
            boundItem.exchange(dataItemIdentifier);
        }
    }

    protected TreeSet<Integer> getForClause(ArrayList<DMRLevel> c) {
        TreeSet<Integer> r = new TreeSet<Integer>();
        for (DMRLevel l : c) {
            List<DMRLevel> lvls = l.getParentLevelToQueryWith();
            for (DMRLevel lvl : lvls) {
                if (!this.mapping.containsKey(lvl)) continue;
                r.add(XQEIntegerPool.getInteger(this.mapping.get((Object)lvl).keyPosition));
            }
        }
        return r;
    }

    protected String getRawModelPath(MetadataConnection metadataConnection, String modelName) {
        if (modelName != null && modelName.endsWith("model.xml")) {
            return modelName;
        }
        if (modelName != null) {
            return metadataConnection.verifyModelPath(modelName);
        }
        return null;
    }

    protected boolean requiredRollUp(ArrayList<DMRLevel> combination, MDXLevelInfo levelInfo) {
        for (DMRLevel level : combination) {
            ILevel wrapperLevel;
            IHierarchy hierarchy = level.getHierarchy();
            IHierarchy hierarchyWrapper = (IHierarchy)this.ownerCube.getWrapped(hierarchy);
            if (!levelInfo.getHierarchyInfo().projectsHierarchy(hierarchyWrapper)) {
                if (level.isRootLevel()) continue;
                return false;
            }
            List<ILevel> projLevels = levelInfo.getProjectedLevels(hierarchyWrapper);
            if (projLevels.contains(wrapperLevel = (ILevel)this.ownerCube.getWrapped(level))) continue;
            return false;
        }
        return true;
    }

    protected ArrayList<ArrayList<DMRLevel>> getLevels(DMRLevel level) {
        ArrayList<ArrayList<DMRLevel>> rt = new ArrayList<ArrayList<DMRLevel>>();
        ArrayList lvls = (ArrayList)level.getParentLevelToQueryWith();
        lvls.add((DMRLevel)level.getHierarchy().getLevel(0));
        Collections.reverse(lvls);
        for (DMRLevel l : lvls) {
            ArrayList<DMRLevel> r = new ArrayList<DMRLevel>();
            r.add(l);
            rt.add(r);
        }
        return rt;
    }

    protected ArrayList<ArrayList<DMRLevel>> crossProduct(ArrayList<ArrayList<DMRLevel>> v3, ArrayList<ArrayList<DMRLevel>> v4) {
        ArrayList<ArrayList<DMRLevel>> rt2 = new ArrayList<ArrayList<DMRLevel>>();
        for (ArrayList<DMRLevel> x : v3) {
            for (ArrayList<DMRLevel> y : v4) {
                ArrayList<DMRLevel> n = new ArrayList<DMRLevel>();
                n.addAll(x);
                n.addAll(y);
                rt2.add(n);
            }
        }
        return rt2;
    }

    protected void extractOutOfScopeDMRSlicerMembers(V5DetailFilter detailFilter) {
    }

    protected void setIsOriginalToFalse(IXQEQueryNode dataItem) {
    }

    protected void createDetailFilter(XQENodeFactory nodeFactory, IXQEQueryNode query, CogMDXDetailFilter astDetailFilter) {
        IXQEQueryNode[] descs;
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        query.addChild(detailFilter);
        V5Selection theSelection = ((V5Query)query).getV5Selection();
        IXQEQueryNode detailFilterChild = nodeFactory.deepCopyNode(astDetailFilter.getChild(0));
        detailFilter.addChild(detailFilterChild);
        if (this.clonedSrc != null) {
            MixedDMRRelUtil.reBindReferences(nodeFactory, detailFilterChild, this.clonedSrc, this.querySet);
        }
        for (IXQEQueryNode desc : descs = detailFilterChild.getDescendantsOfType(201127, false)) {
            V5BoundParameter param = (V5BoundParameter)desc;
            if (param.getMetadata() == null || param.getMetadata().isMFW()) continue;
            IMetadata wrapperMetadata = param.getMetadata();
            param.setMetadata(this.ownerCube.getModelCube().getWrapped(wrapperMetadata));
        }
        IMetadata filterOwner = astDetailFilter.getFilterOwner();
        if (filterOwner != null) {
            detailFilter.setFilterOwner(filterOwner);
        }
        if (astDetailFilter.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
            this.extractOutOfScopeDMRSlicerMembers(detailFilter);
        }
        if (detailFilter.getNumberChildren() == 0) {
            detailFilter.extract();
            return;
        }
        List<IXQEQueryNode> dataItemRefUnderFilter = detailFilter.getDescendantsOfTypeOrdered(101003, false);
        for (IXQEQueryNode dataItemInDetailFilter : dataItemRefUnderFilter) {
            if (V5QueryOverTabularStream.convertToDataItemRef((V5DataItem)dataItemInDetailFilter, nodeFactory, this.querySet, this.ownerCube.getModelCube())) continue;
            dataItemInDetailFilter.extract();
        }
        List<IXQEQueryNode> v5MultipartIdentifiers = detailFilter.getDescendantsOfTypeOrdered(201030, false);
        for (IXQEQueryNode v5MultipartIdentifier : v5MultipartIdentifiers) {
            IXQEQueryNode dataItemRefMeasure = nodeFactory.createNode(101003);
            ((V5DataItem)dataItemRefMeasure).setIsReferenced();
            String dataItemIdentifier = "_detailFilter_" + this.detailFilterDataItemIndice++;
            dataItemRefMeasure.setPropertyValue("name", dataItemIdentifier);
            theSelection.addChild(dataItemRefMeasure);
            IXQEQueryNode expression = nodeFactory.createNode(101004);
            this.setIsOriginalToFalse(dataItemRefMeasure);
            MetadataContext mc = (MetadataContext)v5MultipartIdentifier.getPropertyValue("metadataContext");
            if (mc != null) {
                expression.setPropertyValue("metadataContext", mc);
            }
            dataItemRefMeasure.addChild(expression);
            expression.setPropertyValue("expression", ((V5MultiPartIdentifier)v5MultipartIdentifier).getIdentifier());
            ((V5MultiPartIdentifier)v5MultipartIdentifier).setIdentifier('[' + dataItemIdentifier + ']');
            ((V5MultiPartIdentifier)v5MultipartIdentifier).setNameParts(null);
        }
        detailFilter.setPostAutoAggregation(astDetailFilter.getPostAutoAggregation());
    }

    protected void createDetailFilterForRestrictMember(XQENodeFactory nodeFactory, IXQEQueryNode query, List<Pair> restrictMun) {
        IXQEQueryNode filterExpr = null;
        for (Pair member : restrictMun) {
            IXQEQueryNode in = nodeFactory.createNode(201011);
            V5BoundMemberUniqueName v5BoundMemberUniqueName = (V5BoundMemberUniqueName)nodeFactory.createNode(201117);
            v5BoundMemberUniqueName.setExternalMemberUniqueName((String)member.getFirst());
            v5BoundMemberUniqueName.setLevel((ILevel)member.getSecond());
            V5BoundModelIdentifier modelHierarchy = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            modelHierarchy.setMetadata((ILevel)member.getSecond());
            in.addChild(modelHierarchy);
            in.addChild(v5BoundMemberUniqueName);
            if (filterExpr == null) {
                filterExpr = in;
                continue;
            }
            V5LogicalExpression or = (V5LogicalExpression)nodeFactory.createNode(201003);
            or.setSubType(1);
            or.addChild(filterExpr);
            or.addChild(in);
            filterExpr = or;
        }
        if (filterExpr != null) {
            V5DetailFilter detailFilter = null;
            detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPostAutoAggregation(false);
            query.addChild(detailFilter);
            detailFilter.addChild(filterExpr);
        }
    }

    protected void addSorting(XQENodeFactory nodeFactory, List<DMRLevel> levels) {
        for (DMRLevel level : levels) {
            LevelInfo levelInfo = this.mapping.get(level);
            ISortItem[] levelSortItems = level.getSortItems();
            if (levelSortItems.length == 0) {
                IXQEQueryNode sortItemNode = nodeFactory.createNode(101056);
                sortItemNode.setPropertyValue("refDataItem", COLUMN_NAME + levelInfo.captionPosition);
                sortItemNode.setPropertyValue("sortOrder", "ascending");
                this.groupBody.getParent().addChild(sortItemNode);
                sortItemNode = nodeFactory.createNode(101056);
                sortItemNode.setPropertyValue("refDataItem", COLUMN_NAME + levelInfo.keyPosition);
                sortItemNode.setPropertyValue("sortOrder", "ascending");
                this.groupBody.getParent().addChild(sortItemNode);
                continue;
            }
            HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
            List<IProperty> memberProperties = level.getMemberProperties();
            for (IProperty property : memberProperties) {
                allProps.put(property.getName(), (DMRProperty)property);
            }
            for (ISortItem sortItem : levelSortItems) {
                String n;
                DMRProperty prop;
                String refObj = sortItem.getRefObject();
                String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
                if (nameParts == null || nameParts.length <= 0 || (prop = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null) continue;
                int pos = 0;
                if (prop.isBusinessKey()) {
                    pos = levelInfo.keyPosition;
                } else if (prop.isMemberCaption()) {
                    pos = levelInfo.captionPosition;
                } else {
                    for (Map.Entry<Integer, ArrayList<DMRProperty>> e : levelInfo.properties.entrySet()) {
                        int propColumnNum = e.getKey();
                        ArrayList<DMRProperty> createdProps = e.getValue();
                        if (!createdProps.contains(prop)) continue;
                        pos = propColumnNum;
                        break;
                    }
                }
                ISortItem.SortType s = sortItem.getSort();
                IXQEQueryNode sortItemNode = nodeFactory.createNode(101056);
                sortItemNode.setPropertyValue("refDataItem", COLUMN_NAME + pos);
                sortItemNode.setPropertyValue("sortOrder", s.toString());
                this.groupBody.getParent().addChild(sortItemNode);
            }
        }
    }

    public void sortAllLevelMembers(List<DMRLevel> allLevels, IHierarchy firstReal) {
        List<DMRLevel> levels;
        DMRLevel aLevel;
        int i;
        boolean bSortAllHierLevel = true;
        if (this instanceof LoadDMRCubeV5Query) {
            bSortAllHierLevel = false;
        }
        for (i = 0; i < allLevels.size(); ++i) {
            if (allLevels.get(i) == null) continue;
            aLevel = allLevels.get(i);
            levels = null;
            if (bSortAllHierLevel) {
                levels = new ArrayList<DMRLevel>();
                List<ILevel> lvls = aLevel.getHierarchy().getLevels();
                Iterator iterator = lvls.iterator();
                while (iterator.hasNext()) {
                    ILevel l = (ILevel)iterator.next();
                    levels.add((DMRLevel)l);
                }
            } else {
                levels = aLevel.getParentLevelToQueryWith();
                Collections.reverse(levels);
            }
            for (ILevel iLevel : levels) {
                ((DMRLevel)iLevel).setGotAllMembers();
            }
        }
        for (i = 0; i < allLevels.size(); ++i) {
            if (allLevels.get(i) == null || (aLevel = allLevels.get(i)).getIndex() <= 0 || aLevel.isV5LevelWrapper() || aLevel.getHierarchy() == firstReal) continue;
            levels = aLevel.getParentLevelToQueryWith();
            Collections.reverse(levels);
            HashMap<IMember, Integer> parentMembers = new HashMap<IMember, Integer>();
            parentMembers.put(((DMRLevel)aLevel.getHierarchy().getLevel(0)).getMember(0), XQEIntegerPool.getInteger(0));
            for (DMRLevel level : levels) {
                parentMembers = this.sortLevelMembers(level, parentMembers);
            }
        }
    }

    protected HashMap<IMember, Integer> sortLevelMembers(DMRLevel level, HashMap<IMember, Integer> parentMembers) {
        IOrderedMap<IMember> memberMap = level.getMembersOrderedMap();
        ArrayList<IMember> members = memberMap.getList();
        HashMap<IMember, Integer> newMap = new HashMap<IMember, Integer>();
        if (members != null) {
            MemberComparator cmp = new MemberComparator(parentMembers, level);
            Collections.sort(members, cmp);
            for (int i = 0; i < members.size(); ++i) {
                newMap.put((IMember)members.get(i), XQEIntegerPool.getInteger(i));
            }
        } else {
            return newMap;
        }
        MemberComparator cmpMembers = new MemberComparator((HashMap)newMap);
        for (Map.Entry<IMember, Integer> e : parentMembers.entrySet()) {
            DMRMember aParentMember = (DMRMember)e.getKey();
            IOrderedMap<IMember> childMap = aParentMember.getChildrenOrderedMap();
            ArrayList<IMember> childMembers = childMap.getList();
            if (childMembers == null) continue;
            Collections.sort(childMembers, cmpMembers);
            for (int i = 0; i < childMembers.size(); ++i) {
                ((IDMRMember)childMembers.get(i)).setIndexInParentsChildren(i);
            }
        }
        return newMap;
    }

    protected void setGotAllChildren(DMRMember member, boolean bLastMember) {
        member.setGotAllChildren();
    }

    private final class MemberComparator
    implements Comparator<IMember> {
        private HashMap<IMember, Integer> parent = null;
        private ArrayList<Object> sorts = null;
        private ArrayList<Integer> directions = null;
        private ArrayList<ISortItem.NullPlacementType> nullOrder = null;

        private MemberComparator(HashMap<IMember, Integer> levelMembers) {
            this.parent = levelMembers;
        }

        private MemberComparator(HashMap<IMember, Integer> p, DMRLevel level) {
            this.parent = p;
            this.sorts = new ArrayList();
            this.directions = new ArrayList();
            this.nullOrder = new ArrayList();
            ISortItem[] levelSortItems = level.getSortItems();
            if (levelSortItems.length == 0) {
                this.sorts.add(LoadDMRCubeSingleV5Query.CAPTION);
                this.sorts.add(LoadDMRCubeSingleV5Query.KEY);
                this.directions.add(XQEIntegerPool.getInteger(1));
                this.directions.add(XQEIntegerPool.getInteger(1));
                this.nullOrder.add(null);
                this.nullOrder.add(null);
            } else {
                HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
                List<IProperty> memberProperties = level.getMemberProperties();
                for (IProperty property : memberProperties) {
                    allProps.put(property.getName(), (DMRProperty)property);
                }
                for (ISortItem sortItem : levelSortItems) {
                    String n;
                    DMRProperty prop;
                    String refObj = sortItem.getRefObject();
                    String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
                    if (nameParts == null || nameParts.length <= 0 || (prop = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null) continue;
                    if (prop.isBusinessKey()) {
                        this.sorts.add(LoadDMRCubeSingleV5Query.KEY);
                    } else if (prop.isMemberCaption()) {
                        this.sorts.add(LoadDMRCubeSingleV5Query.CAPTION);
                    } else {
                        this.sorts.add(prop);
                    }
                    ISortItem.SortType s = sortItem.getSort();
                    if (s == ISortItem.SortType.ASCENDING) {
                        this.directions.add(XQEIntegerPool.getInteger(1));
                    } else {
                        this.directions.add(XQEIntegerPool.getInteger(-1));
                    }
                    this.nullOrder.add(sortItem.getNullPlacement());
                }
            }
        }

        @Override
        public int compare(IMember lhs, IMember rhs) {
            Integer rP;
            int r = 0;
            if (this.sorts == null) {
                return this.parent.get(lhs).compareTo(this.parent.get(rhs));
            }
            Integer lP = this.parent.get(lhs.getParent());
            r = lP.compareTo(rP = this.parent.get(rhs.getParent()));
            if (r != 0) {
                return r;
            }
            for (int i = 0; i < this.sorts.size(); ++i) {
                Value lV = this.getValue(this.sorts.get(i), lhs);
                Value rV = this.getValue(this.sorts.get(i), rhs);
                if (lV.isNull() && rV.isNull()) continue;
                if ((lV.isNull() || rV.isNull()) && this.nullOrder.get(i) != null) {
                    if (lV.isNull()) {
                        if (this.nullOrder.get(i) == ISortItem.NullPlacementType.NULL_FIRST) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this.nullOrder.get(i) == ISortItem.NullPlacementType.NULL_LAST) {
                        return -1;
                    }
                    return 1;
                }
                r = lV.compareTo(rV);
                if (r == 0) continue;
                return r *= this.directions.get(i).intValue();
            }
            return 0;
        }

        private Value getValue(Object o, IMember m) {
            if (o == LoadDMRCubeSingleV5Query.KEY) {
                return ((DMRMember)m).getBusinessKeyValue();
            }
            if (o == LoadDMRCubeSingleV5Query.CAPTION) {
                return ((DMRMember)m).getCaptionValue();
            }
            DMRProperty p = (DMRProperty)o;
            return (Value)m.getProperty(p.getUniqueName());
        }
    }

    private final class SingleV5Handler
    implements RSAPIRowCallback {
        private Map<Integer, FormatId> resolvedFormatIDs = new HashMap<Integer, FormatId>();
        private Map<Integer, TreeSet[]> mapLevelCombinationKeyToIntQuerySet;
        private Map<Integer, HashMapIntObject<IMember>[]> mapLevelCombinationKeyToMembersMap;
        private Map<Integer, int[]> mapLevelCombinationKeyToLevelIDArray;
        private Map<DMRMeasure, Map<Integer, List<OrdinalValueWrapper>>> mapValuesPerMeasureLevelCombination;
        private Map<String, Map<Integer, int[]>> tupleOrdinalHashCodes;
        private Map<String, Map<Integer, List<int[]>>> tupleOrdinalHashCollisionMap;
        private Map<String, Map<Integer, List<int[]>>> nullValueTuples;

        private SingleV5Handler() {
            this.mapValuesPerMeasureLevelCombination = new HashMap<DMRMeasure, Map<Integer, List<OrdinalValueWrapper>>>(LoadDMRCubeSingleV5Query.this.projectedMeasures.size());
            this.tupleOrdinalHashCodes = new HashMap<String, Map<Integer, int[]>>();
            this.tupleOrdinalHashCollisionMap = new HashMap<String, Map<Integer, List<int[]>>>();
            this.nullValueTuples = new HashMap<String, Map<Integer, List<int[]>>>();
            this.mapLevelCombinationKeyToIntQuerySet = new HashMap<Integer, TreeSet[]>();
            this.mapLevelCombinationKeyToMembersMap = new HashMap<Integer, HashMapIntObject<IMember>[]>();
            this.mapLevelCombinationKeyToLevelIDArray = new HashMap<Integer, int[]>();
            for (int i = 0; i < LoadDMRCubeSingleV5Query.this.projectedMeasures.size(); ++i) {
                this.mapValuesPerMeasureLevelCombination.put(LoadDMRCubeSingleV5Query.this.projectedMeasures.get(i), new HashMap());
            }
            if (LoadDMRCubeSingleV5Query.this.defaultMeasure != null) {
                this.mapValuesPerMeasureLevelCombination.put(LoadDMRCubeSingleV5Query.this.defaultMeasure, new HashMap());
            }
        }

        @Override
        public void consumeRow(RSAPIRow aRow, RSAPIColumn[] columns, FormatId[] formatIDs) {
            for (int i = 0; i < LoadDMRCubeSingleV5Query.this.lowestLevelHier.size(); ++i) {
                DMRLevel aLevel = LoadDMRCubeSingleV5Query.this.lowestLevelHier.get(i);
                if (aLevel == null) continue;
                List<DMRLevel> levels = aLevel.getParentLevelToQueryWith();
                Collections.reverse(levels);
                Boolean bDefaultMember = LoadDMRCubeSingleV5Query.this.useDefaultHierarchyMember.get(i);
                IMember parentMember = null;
                parentMember = bDefaultMember == false ? ((DMRLevel)aLevel.getHierarchy().getLevel(0)).getMember(0) : aLevel.getHierarchy().getDefaultMember();
                if (!LoadDMRCubeSingleV5Query.this.isSingleLoading()) {
                    LoadDMRCubeSingleV5Query.this.setGotAllChildren((DMRMember)parentMember, false);
                }
                int sz = levels.size();
                for (int lvlPos = 0; lvlPos < sz; ++lvlPos) {
                    DMRLevel level = levels.get(lvlPos);
                    LevelInfo info = LoadDMRCubeSingleV5Query.this.mapping.get(level);
                    Value key = (Value)aRow.getColumn(info.keyPosition);
                    Value caption = (Value)aRow.getColumn(info.captionPosition);
                    parentMember = this.addNewMember(key, formatIDs[info.keyPosition], caption, formatIDs[info.captionPosition], level, parentMember);
                    boolean bLastMember = lvlPos == sz - 1;
                    LoadDMRCubeSingleV5Query.this.setGotAllChildren((DMRMember)parentMember, bLastMember);
                    if (info.properties == null) continue;
                    for (Map.Entry<Integer, ArrayList<DMRProperty>> e : info.properties.entrySet()) {
                        int propColumnNum = e.getKey();
                        ArrayList<DMRProperty> memberProperties = e.getValue();
                        for (IProperty iProperty : memberProperties) {
                            Value prop = (Value)aRow.getColumn(propColumnNum);
                            prop.setFormatId(formatIDs[propColumnNum]);
                            ((DMRMember)parentMember).setProperty(iProperty.getUniqueName(), prop.copy());
                        }
                    }
                }
                LoadDMRCubeSingleV5Query.this.currentMembers[i] = parentMember;
            }
            for (int k = 0; k < LoadDMRCubeSingleV5Query.this.projectedMeasures.size(); ++k) {
                ArrayList<Integer> range;
                int measurePos;
                DMRMeasure measure = LoadDMRCubeSingleV5Query.this.projectedMeasures.get(k);
                Value measureValue = this.getValueAtPos(measure, aRow, formatIDs, measurePos = (range = LoadDMRCubeSingleV5Query.this.projectedMeasuresColPos.get(k)).get(0).intValue());
                if (measureValue.isNull()) continue;
                if (!LoadDMRCubeSingleV5Query.this.bNeedToSortmembers) {
                    LoadDMRCubeSingleV5Query.this.paramCubelet.updateValueMap(this.createTupleValue(LoadDMRCubeSingleV5Query.this.currentMembers, measure, measureValue), Boolean.FALSE);
                } else {
                    this.storeValue(this.mapValuesPerMeasureLevelCombination.get(measure), measure, measureValue, LoadDMRCubeSingleV5Query.this.currentMembers);
                }
                if (LoadDMRCubeSingleV5Query.this.defaultMeasure != null && k == LoadDMRCubeSingleV5Query.this.projectedMeasures.size() - 1) {
                    if (!LoadDMRCubeSingleV5Query.this.bNeedToSortmembers) {
                        LoadDMRCubeSingleV5Query.this.paramCubelet.updateValueMap(this.createTupleValue(LoadDMRCubeSingleV5Query.this.currentMembers, LoadDMRCubeSingleV5Query.this.defaultMeasure, DataValueFactory.createIntegerValue(0)), Boolean.FALSE);
                    } else {
                        this.storeValue(this.mapValuesPerMeasureLevelCombination.get(LoadDMRCubeSingleV5Query.this.defaultMeasure), LoadDMRCubeSingleV5Query.this.defaultMeasure, DataValueFactory.createIntegerValue(0), LoadDMRCubeSingleV5Query.this.currentMembers);
                    }
                }
                for (int r = 1; r < range.size(); ++r) {
                    int rollUpPos = range.get(r);
                    Value rollUpValue = this.getValueAtPos(measure, aRow, formatIDs, rollUpPos);
                    this.getScopeMembers(r - 1);
                    if (!LoadDMRCubeSingleV5Query.this.bNeedToSortmembers) {
                        LoadDMRCubeSingleV5Query.this.paramCubelet.updateValueMap(this.createTupleValue(LoadDMRCubeSingleV5Query.this.scopeMembers, measure, rollUpValue), Boolean.TRUE);
                    } else {
                        this.storeValue(this.mapValuesPerMeasureLevelCombination.get(measure), measure, rollUpValue, LoadDMRCubeSingleV5Query.this.scopeMembers);
                    }
                    if (LoadDMRCubeSingleV5Query.this.defaultMeasure == null || k != LoadDMRCubeSingleV5Query.this.projectedMeasures.size() - 1) continue;
                    if (!LoadDMRCubeSingleV5Query.this.bNeedToSortmembers) {
                        LoadDMRCubeSingleV5Query.this.paramCubelet.updateValueMap(this.createTupleValue(LoadDMRCubeSingleV5Query.this.scopeMembers, LoadDMRCubeSingleV5Query.this.defaultMeasure, DataValueFactory.createIntegerValue(0)), Boolean.TRUE);
                        continue;
                    }
                    this.storeValue(this.mapValuesPerMeasureLevelCombination.get(LoadDMRCubeSingleV5Query.this.defaultMeasure), LoadDMRCubeSingleV5Query.this.defaultMeasure, DataValueFactory.createIntegerValue(0), LoadDMRCubeSingleV5Query.this.scopeMembers);
                }
            }
        }

        private TreeSet[] getIntQuerySet(ILevel[] levels) {
            Integer levelCombinationKey = this.getLevelCombinationKey(levels);
            TreeSet[] intQuerySet = this.mapLevelCombinationKeyToIntQuerySet.get(levelCombinationKey);
            if (intQuerySet == null) {
                intQuerySet = new TreeSet[LoadDMRCubeSingleV5Query.this.currentMembers.length];
                for (int idx = 0; idx < LoadDMRCubeSingleV5Query.this.currentMembers.length; ++idx) {
                    TreeSet idList;
                    intQuerySet[idx] = idList = new TreeSet();
                }
                this.mapLevelCombinationKeyToIntQuerySet.put(levelCombinationKey, intQuerySet);
                int[] levelIDs = new int[levels.length];
                for (int i = 0; i < levels.length; ++i) {
                    levelIDs[i] = levels[i].getIndex();
                }
                this.mapLevelCombinationKeyToLevelIDArray.put(levelCombinationKey, levelIDs);
            }
            return intQuerySet;
        }

        private void storeValue(Map<Integer, List<OrdinalValueWrapper>> storage, DMRMeasure measure, IValue measureValue, IMember[] tupleMembers) {
            int i;
            ILevel[] levels = new ILevel[tupleMembers.length];
            for (int i2 = 0; i2 < tupleMembers.length; ++i2) {
                levels[i2] = tupleMembers[i2].getLevel();
            }
            Integer levelCombinationKey = this.getLevelCombinationKey(levels);
            List<OrdinalValueWrapper> storagePerLevelOrdinal = storage.get(levelCombinationKey);
            if (storagePerLevelOrdinal == null) {
                storagePerLevelOrdinal = new ArrayList<OrdinalValueWrapper>();
                storage.put(levelCombinationKey, storagePerLevelOrdinal);
            }
            int[] tupleMemberIndex = new int[tupleMembers.length];
            for (int idx = 0; idx < tupleMembers.length; ++idx) {
                tupleMemberIndex[idx] = ((IDMRMember)tupleMembers[idx]).getIndex();
            }
            if (this.isDuplicate(measure, measureValue, tupleMemberIndex)) {
                return;
            }
            HashMapIntObject<IMember>[] membersMap = this.mapLevelCombinationKeyToMembersMap.get(levelCombinationKey);
            if (membersMap == null) {
                membersMap = new HashMapIntObject[tupleMembers.length];
                for (i = 0; i < tupleMembers.length; ++i) {
                    membersMap[i] = new HashMapIntObject(1);
                }
                this.mapLevelCombinationKeyToMembersMap.put(levelCombinationKey, membersMap);
            }
            for (i = 0; i < tupleMembers.length; ++i) {
                membersMap[i].put(tupleMemberIndex[i], tupleMembers[i]);
            }
            TreeSet[] intQuerySet = this.getIntQuerySet(levels);
            for (int idx = 0; idx < intQuerySet.length; ++idx) {
                intQuerySet[idx].add(tupleMemberIndex[idx]);
            }
            OrdinalValueWrapper ordinalValue = new OrdinalValueWrapper();
            ordinalValue.memberIndex = tupleMemberIndex;
            ordinalValue.value = measureValue;
            storagePerLevelOrdinal.add(ordinalValue);
        }

        private boolean isDuplicate(DMRMeasure measure, IValue measureValue, int[] tupleMemberIndex) {
            String measureName = measure.getUniqueName();
            Map<Integer, int[]> processedTuples = this.tupleOrdinalHashCodes.get(measureName);
            Map<Integer, List<int[]>> collisions = this.tupleOrdinalHashCollisionMap.get(measureName);
            Map<Integer, List<int[]>> nullTuples = this.nullValueTuples.get(measureName);
            if (processedTuples == null) {
                processedTuples = new HashMap<Integer, int[]>();
                this.tupleOrdinalHashCodes.put(measureName, processedTuples);
                collisions = new HashMap<Integer, List<int[]>>();
                this.tupleOrdinalHashCollisionMap.put(measureName, collisions);
                nullTuples = new HashMap<Integer, List<int[]>>();
                this.nullValueTuples.put(measureName, nullTuples);
            }
            int hash = Arrays.hashCode(tupleMemberIndex);
            int[] aProcessedTuple = processedTuples.get(hash);
            List<int[]> collisionList = collisions.get(hash);
            List<int[]> nulls = nullTuples.get(hash);
            if (aProcessedTuple != null) {
                if (Arrays.equals(aProcessedTuple, tupleMemberIndex)) {
                    if (measureValue.isNull()) {
                        return true;
                    }
                    if (nulls == null) {
                        return true;
                    }
                    boolean isNull = false;
                    for (int[] aNullTuple : nulls) {
                        if (!Arrays.equals(aNullTuple, tupleMemberIndex)) continue;
                        isNull = true;
                        break;
                    }
                    if (!isNull) {
                        return true;
                    }
                } else if (collisionList != null) {
                    for (int[] aCollision : collisionList) {
                        if (!Arrays.equals(aCollision, tupleMemberIndex)) continue;
                        if (measureValue.isNull()) {
                            return true;
                        }
                        if (nulls == null) {
                            return true;
                        }
                        boolean isNull = false;
                        for (int[] aNullTuple : nulls) {
                            if (!Arrays.equals(aNullTuple, tupleMemberIndex)) continue;
                            isNull = true;
                            break;
                        }
                        if (isNull) continue;
                        return true;
                    }
                }
            }
            if (aProcessedTuple == null) {
                processedTuples.put(hash, tupleMemberIndex);
            } else {
                if (collisionList == null) {
                    collisionList = new ArrayList<int[]>();
                    collisions.put(hash, collisionList);
                }
                collisionList.add(tupleMemberIndex);
            }
            if (measureValue.isNull()) {
                if (nulls == null) {
                    nulls = new ArrayList<int[]>();
                    nullTuples.put(hash, nulls);
                }
                nulls.add(tupleMemberIndex);
            }
            return false;
        }

        private Integer getLevelCombinationKey(ILevel[] levels) {
            int[] levelIds = new int[levels.length];
            int i = 0;
            int j = 0;
            int ord = 0;
            int baseSectionSize = 1;
            for (i = 0; i < levels.length; ++i) {
                if (levels[i].getDimension().isMeasuresDimension()) continue;
                ILevel level = levels[j];
                IDimension dim = level.getDimension();
                levelIds[j] = level.getIndex();
                int dimLevels = dim.getLevelCount();
                ord += levelIds[j] * baseSectionSize;
                baseSectionSize *= dimLevels;
                ++j;
            }
            Integer localOrd = XQEIntegerPool.getInteger(ord);
            return localOrd;
        }

        protected Value getValueAtPos(DMRMeasure measure, RSAPIRow aRow, FormatId[] formatIDs, int measurePos) {
            FormatId formatId;
            Value measureValue = (Value)aRow.getColumn(measurePos);
            if (measureValue == null) {
                measureValue = (Value)measure.getDataType().createValue();
                measureValue.setNull();
            }
            measureValue = (Value)measureValue.copy();
            if (formatIDs[measurePos] != FormatId.INVALID_FORMAT_FID) {
                measureValue.setFormatId(formatIDs[measurePos]);
            }
            if ((formatId = this.resolvedFormatIDs.get(measurePos)) == null) {
                formatId = this.resolveFormatIdForMeasure(measure, measureValue);
                this.resolvedFormatIDs.put(measurePos, formatId);
            }
            measureValue.setFormatId(formatId);
            return measureValue;
        }

        private DMRMember addNewMember(Value key, FormatId keyFormat, Value cap, FormatId capFormat, Level level, IMember parentMember) {
            DMRMember member;
            Value keyValueCopy = (Value)key.copy();
            if (keyValueCopy.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                keyValueCopy.setFormatId(keyFormat);
            }
            String businessKeyText = keyValueCopy.getV5formattedString();
            if (keyValueCopy.isNull()) {
                businessKeyText = "";
            }
            if ((member = (DMRMember)parentMember.getChildMember(businessKeyText)) != null) {
                return member;
            }
            Value captionValue = (Value)cap.copy();
            if (captionValue.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                captionValue.setFormatId(capFormat);
            }
            member = new DMRMember(captionValue, keyValueCopy, level);
            ((DMRMember)parentMember).addMemberToChildrenOrderedMap(member);
            if (member instanceof IDMRMember) {
                ((DMRMember)parentMember).addChildToBusinessKeyMap(member);
            }
            member.setParentMember(parentMember);
            level.addMember(member);
            return member;
        }

        private FormatId resolveFormatIdForMeasure(IMember measure, Value measureValue) {
            FormatId formatId = null;
            String measureFormat = (String)measure.getProperty("format");
            if (measureFormat != null) {
                formatId = FormatService.getInstance().registerV5Format(measureFormat, null);
            } else {
                formatId = measureValue.getFormatId();
                if ((formatId == null || formatId == FormatId.INVALID_FORMAT_FID) && measureValue.isNumeric()) {
                    formatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
                }
            }
            return formatId;
        }

        private void getScopeMembers(Integer pos) {
            ArrayList<DMRLevel> scopeLevels = LoadDMRCubeSingleV5Query.this.measureRollUpScopes.get(pos);
            for (int i = 0; i < LoadDMRCubeSingleV5Query.this.currentMembers.length; ++i) {
                DMRMember m = (DMRMember)LoadDMRCubeSingleV5Query.this.currentMembers[i];
                int targetLevelIdx = scopeLevels.get(i).getIndex();
                int currentLevelIdx = m.getLevel().getIndex();
                while (targetLevelIdx < currentLevelIdx) {
                    m = (DMRMember)m.getParent();
                    currentLevelIdx = m.getLevel().getIndex();
                }
                LoadDMRCubeSingleV5Query.this.scopeMembers[i] = m;
            }
        }

        @Override
        public boolean reRun() {
            if (LoadDMRCubeSingleV5Query.this.bNeedToSortmembers) {
                LoadDMRCubeSingleV5Query.this.sortAllLevelMembers(LoadDMRCubeSingleV5Query.this.lowestLevelHier, LoadDMRCubeSingleV5Query.this.firstRealHierarchy);
                this.putValuesIntoStorage();
            }
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }

        protected void putValuesIntoStorage() {
            ArrayList<DMRMeasure> allMeasures = new ArrayList<DMRMeasure>();
            allMeasures.addAll(LoadDMRCubeSingleV5Query.this.projectedMeasures);
            if (LoadDMRCubeSingleV5Query.this.defaultMeasure != null) {
                allMeasures.add(LoadDMRCubeSingleV5Query.this.defaultMeasure);
            }
            for (int idx = 0; idx < allMeasures.size(); ++idx) {
                DMRMeasure measure = (DMRMeasure)allMeasures.get(idx);
                String measureName = measure.getName();
                for (Map.Entry<Integer, List<OrdinalValueWrapper>> entry : this.mapValuesPerMeasureLevelCombination.get(measure).entrySet()) {
                    BaseOrdinalValueStorage valuesStorage = new ArrayOrdinalValueStorage();
                    Integer levelCombinationKey = entry.getKey();
                    HashMapIntObject<IMember>[] membersMap = this.mapLevelCombinationKeyToMembersMap.get(levelCombinationKey);
                    TreeSet[] intQuerySetAsSet = this.mapLevelCombinationKeyToIntQuerySet.get(levelCombinationKey);
                    int[][] intQuerySet = new int[intQuerySetAsSet.length][];
                    long[] pageSizes = new long[intQuerySetAsSet.length];
                    for (int i = 0; i < intQuerySetAsSet.length; ++i) {
                        intQuerySet[i] = new int[intQuerySetAsSet[i].size()];
                        Iterator it = intQuerySetAsSet[i].iterator();
                        int index = 0;
                        while (it.hasNext()) {
                            intQuerySet[i][index] = (Integer)it.next();
                            ++index;
                        }
                        long otherSetsSize = 1L;
                        for (int j = i + 1; j < intQuerySetAsSet.length; ++j) {
                            otherSetsSize *= (long)intQuerySetAsSet[j].size();
                        }
                        pageSizes[i] = otherSetsSize;
                    }
                    List<OrdinalValueWrapper> valuesToBeStored = entry.getValue();
                    for (OrdinalValueWrapper valueToStore : valuesToBeStored) {
                        if (valueToStore.value.isNull()) continue;
                        if (valueToStore.value.getDataType().isDouble()) {
                            valuesStorage = new DoubleNativeValueStorage();
                            break;
                        }
                        valuesStorage = new ArrayOrdinalValueStorage();
                        break;
                    }
                    for (OrdinalValueWrapper valueToStore : valuesToBeStored) {
                        if (valueToStore.value == NullValue.NULLVALUE) continue;
                        int[] tupleOrdinal = new int[valueToStore.memberIndex.length];
                        for (int i = 0; i < valueToStore.memberIndex.length; ++i) {
                            tupleOrdinal[i] = Arrays.binarySearch(intQuerySet[i], valueToStore.memberIndex[i]);
                        }
                        long valueOrdinal = this.computeOrdinalFromSetOffsets(tupleOrdinal, pageSizes);
                        valuesStorage.put(new OrdinalValue(valueOrdinal, valueToStore.value));
                    }
                    LoadDMRCubeSingleV5Query.this.ownerCube.getLocalCubelet().insertCubelet(measureName, LoadDMRCubeSingleV5Query.this.nonMeasureHierarchies, this.mapLevelCombinationKeyToLevelIDArray.get(levelCombinationKey), intQuerySet, membersMap, valuesStorage, pageSizes);
                }
            }
        }

        protected long computeOrdinalFromSetOffsets(int[] setOffsets, long[] pageSizes) {
            long ordinal = 0L;
            for (int i = 0; i < setOffsets.length - 1; ++i) {
                ordinal += pageSizes[i] * (long)setOffsets[i];
            }
            return ordinal += (long)setOffsets[setOffsets.length - 1];
        }

        protected TupleValue createTupleValue(IMember[] members, DMRMeasure measure, Value measureValue) {
            IMember[] outputTuple = new IMember[members.length + 1];
            outputTuple[0] = measure;
            System.arraycopy(members, 0, outputTuple, 1, members.length);
            Tuple dataTuple = new Tuple((IMember[])outputTuple.clone(), false);
            return new TupleValue(dataTuple, new Cell(measureValue));
        }

        private class OrdinalValueWrapper {
            protected int[] memberIndex;
            protected IValue value;

            private OrdinalValueWrapper() {
            }
        }
    }

    protected final class LevelInfo {
        protected int keyPosition;
        protected int captionPosition;
        protected HashMap<Integer, ArrayList<DMRProperty>> properties;

        protected LevelInfo() {
        }
    }
}

