/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.DimensionWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.ReusableDMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRCubeForPreciseLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreciseCubeLoadInfo;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PreLoadDMRCubeUtil {
    private static final int NUMBER_OF_ROLLUPS_THRESHOLD = 10;
    private static final String NO_SINGLE_LOADING = " can't use fact driven Loading: ";
    private static final String MSG_VALUE_EXP_CONTEXT = "member restriction changes value expression context.";
    private static final String MSG_SUMMARY_FUNC = "requires all children exist.";
    private static final String MSG_NO_PRECISE_INFO = "failed to collect precise loading information.";
    private static final String MSG_MEASURE = "measure ";
    public static final int[] RELATIVE_FUNCS = new int[]{1034, 1156, 1047, 1051, 1074, 1049, 1050, 1075, 1035};

    public static boolean cubeHasTemporaryObjects(ICube modelCube, XMdxLocal mdxLocal) {
        MDXLevelInfo levelInfo = mdxLocal.getLevelInfoProperty();
        for (IHierarchy infoHierarchy : levelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            ILevel lowestLevel;
            IDimension dimension = infoHierarchy.getDimension();
            if (infoHierarchy.getDimension().isMeasuresDimension() || dimension instanceof DimensionWrapper && ((DimensionWrapper)dimension).getWrappedDimension() instanceof ReusableDMRDimension || (lowestLevel = levelInfo.getLowestProjectedLevelsSkipCalculation(infoHierarchy)) == null || !(lowestLevel instanceof MDXLevelInfo.LevelInfo) || (lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel()).isRootLevel() || !(lowestLevel instanceof V5DataItemToLevelWrapper)) continue;
            return true;
        }
        List<IMeasure> cubeMeasures = mdxLocal.getMDXQuery().getInvolvedMeasures();
        for (IMeasure m : cubeMeasures) {
            if (!(m instanceof V5DataItemToMeasureWrapper)) continue;
            return true;
        }
        return false;
    }

    private static void throwIfFactDrivenCustomValueUnsupported(boolean bThrow) {
        if (bThrow) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "temporary measure for fact driven customValue is generated, but, fact drievn cube loading can't be done.");
        }
    }

    public static boolean useSingleTabularQueryForTemporaryDMRCube(ICube fmCube, XMdxLocal mdxLocal, boolean usesBridge, List<PreciseCubeLoadInfo> preciseLoadInfo, DMRQueryStrategyPreCellLoading.LoadType[] rtLoadType) {
        boolean[] extraFalg;
        ArrayList<ILevel> realLevels;
        ArrayList<ILevel> tempLevels;
        IXQEQueryNode[] topBottomFunctions;
        String nm;
        RSAPIDataset dataset;
        CubeWrapper cubeWrapper;
        if (mdxLocal.getParent().getType() == 501088) {
            return false;
        }
        if (!(fmCube instanceof CubeWrapper)) {
            return false;
        }
        CubeWrapper modelCube = (CubeWrapper)fmCube;
        if (modelCube.getTabStreamWrapper() != null) {
            return false;
        }
        MDXQuery q = mdxLocal.getMDXQuery();
        if (q == null) {
            return false;
        }
        if (!q.getSuppressNullsProviderDefault() && (cubeWrapper = modelCube).getDetailFilters().size() > 0) {
            return false;
        }
        IXQEQueryNode dataSetNode = mdxLocal.getAncestorOfType(401005);
        if (dataSetNode != null && (dataset = (RSAPIDataset)dataSetNode).projectsMeasures()) {
            for (MDXEdge edge : q.getEdges()) {
                if (edge.getMDXNonEmptyProperty()) continue;
                return false;
            }
        }
        if ((nm = q.getV5NameProperty()) != null && nm.endsWith("MultiDimensionalSubquery")) {
            return false;
        }
        if (modelCube.getModelDataSource().isDummy()) {
            return true;
        }
        V5QuerySet srcQuerySet = modelCube.getV5QuerySetForV5Source();
        if (srcQuerySet != null && !srcQuerySet.isMultidimensionalSubquery()) {
            return true;
        }
        List<IMeasure> cubeMeasures = mdxLocal.getMDXQuery().getInvolvedMeasures();
        if (cubeMeasures.size() == 1 && cubeMeasures.get(0).getName().equals("TBDummyMeasureName")) {
            return true;
        }
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        if (!providerCapabilities.isSupported("v5.suppress.queryhint.ignore") && modelCube.getGovernors().getSuppress() == Governors.Suppress.NONE) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "Null Suppression is off.");
            return false;
        }
        String singleLoadingSetting = providerCapabilities.getStringValue("enablePreLoadCubeWithSingleSubQuery", "true");
        String preloadType = providerCapabilities.getStringValue("CellFetchingAfterPreloading", "");
        rtLoadType[0] = preloadType.equalsIgnoreCase("overload") ? DMRQueryStrategyPreCellLoading.LoadType.OVERLOAD : (preloadType.equalsIgnoreCase("noload") ? DMRQueryStrategyPreCellLoading.LoadType.NOLOAD : DMRQueryStrategyPreCellLoading.LoadType.PRECISELOAD);
        if ("false".equalsIgnoreCase(singleLoadingSetting)) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "explicitly turned off.");
            return false;
        }
        if (providerCapabilities.isSupported("pushdownFilterToRelational")) {
            return false;
        }
        if (providerCapabilities.isSupported("pushdownHeadTailToRelational")) {
            return false;
        }
        if (providerCapabilities.isSupported("pushdownTopBottomCountToRelational")) {
            return false;
        }
        if (providerCapabilities.isSupported("pushdownTopPercentSumToRelational")) {
            return false;
        }
        List<IMeasure> measuresCustomValue = modelCube.getMeasuresForCustomValues();
        if (!mdxLocal.getMDXQuery().getDescendantsOfCategories(RELATIVE_FUNCS, true, true, true, true, true).isEmpty()) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "relative set/member function.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return false;
        }
        if (!providerCapabilities.isSupported("enablePreLoadCubeDuringPushdown") && !mdxLocal.getMDXQuery().getDescendantsOfCategories(new int[]{1192, 1196}, true, true, true, true, true).isEmpty()) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "The query contains CustomSet pushdown and enablePreLoadCubeDuringPushdown is not supported.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return false;
        }
        Governors gv = modelCube.getGovernors();
        if (gv != null && gv.getEnablePushdownLevelOOM() > 0.0 && !mdxLocal.getMDXQuery().getDescendantsOfCategories(new int[]{1192}, true, true, true, true, true).isEmpty()) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "The query contains CustomSet pushdown.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return false;
        }
        boolean cubehasTempObjects = PreLoadDMRCubeUtil.cubeHasTemporaryObjects(modelCube, mdxLocal);
        if (!cubehasTempObjects && mdxLocal.isDMR() && mdxLocal.isDMRCubeReuseEnabled() && !usesBridge) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "cube is reused.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return false;
        }
        boolean factDrivenpreciseLoading = false;
        boolean bHasUnprojectedMUN = false;
        HashMap<ILevel, LevelStatus> bigLevels = new HashMap<ILevel, LevelStatus>();
        double oomLimit = 0.0;
        String topN = modelCube.getTopN();
        if (topN == null) {
            oomLimit = providerCapabilities.getDoubleValue("ThrowNoFactDrivenLoadingForLevelOOMLargerThan", 0.0);
        }
        if ("auto".equalsIgnoreCase(singleLoadingSetting) && !usesBridge) {
            factDrivenpreciseLoading = true;
            bHasUnprojectedMUN = PreLoadDMRCubeUtil.checkUnProjectedMUNandGetBigLevels(modelCube, mdxLocal, oomLimit, bigLevels);
        }
        boolean bContextDependentAggrRule = providerCapabilities.getBooleanValue("contextDependentIgnoreNullsAggregateRule", false);
        for (IXQEQueryNode aTopBottomFunction : topBottomFunctions = mdxLocal.getMDXQuery().getDescendantsOfType(1041, false)) {
            if (!PreLoadDMRCubeUtil.useRealDMRHierarchyInSet((AbstractMDXNode)aTopBottomFunction)) continue;
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "top/bottom functions.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (!cubehasTempObjects) {
            if (!PreLoadDMRCubeUtil.checkMeasureDimensionEmbeddedFilter(q, modelCube)) {
                LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "measures from different measure dimensions with embedded filter.");
                PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
            }
            if (!PreLoadDMRCubeUtil.checkConstantTuple(q, modelCube)) {
                LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "constant tuple.");
                PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
            }
            if (!PreLoadDMRCubeUtil.checkProjectedMeasure(q)) {
                LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "no projected measure.");
                PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
            }
        }
        if (!PreLoadDMRCubeUtil.checkProjectedLevel(tempLevels = new ArrayList<ILevel>(), mdxLocal, realLevels = new ArrayList<ILevel>(), extraFalg = new boolean[]{true}) && !PreLoadDMRCubeUtil.contextDependentMeasureAggrRule(extraFalg[0], factDrivenpreciseLoading, bContextDependentAggrRule, cubeMeasures)) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "no projected level or complete tuple.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (cubeMeasures.isEmpty() && measuresCustomValue.isEmpty()) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "no measure.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        StringBuilder rtMsg = new StringBuilder();
        if (!PreLoadDMRCubeUtil.checkMeasureAggrRule(modelCube, tempLevels, cubeMeasures, realLevels, rtMsg, factDrivenpreciseLoading && bContextDependentAggrRule)) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, rtMsg.toString());
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (!PreLoadDMRCubeUtil.checkSummaryFunction(mdxLocal, usesBridge)) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_SUMMARY_FUNC);
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (!(factDrivenpreciseLoading && bContextDependentAggrRule || PreLoadDMRCubeUtil.checkEmbeddedFilterInRegularDimension(modelCube))) {
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_SUMMARY_FUNC);
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (bHasUnprojectedMUN) {
            DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
            if (preciseLoadInfo.isEmpty()) {
                LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
            }
            return true;
        }
        rtMsg = new StringBuilder();
        if (!PreLoadDMRCubeUtil.checkMeasureScope(modelCube, tempLevels, cubeMeasures, realLevels, rtMsg)) {
            if (factDrivenpreciseLoading) {
                DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
                if (preciseLoadInfo.isEmpty()) {
                    LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                    PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                    return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
                }
                return true;
            }
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, rtMsg.toString());
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        rtMsg = new StringBuilder();
        if (!PreLoadDMRCubeUtil.checkMeasureDiffTable(modelCube, cubeMeasures, rtMsg)) {
            if (factDrivenpreciseLoading) {
                DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
                if (preciseLoadInfo.isEmpty()) {
                    LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                    PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                    return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
                }
                return true;
            }
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, rtMsg.toString());
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (!PreLoadDMRCubeUtil.checkValueExpressionNotChangeContext(mdxLocal)) {
            if (factDrivenpreciseLoading) {
                DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
                if (preciseLoadInfo.isEmpty()) {
                    LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                    PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                    return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
                }
                return true;
            }
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_VALUE_EXP_CONTEXT);
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        Map<IXQEQueryNode, MDXLevelInfo> aggregationLevelInfo = mdxLocal.getMDXQuery().getReportSummaryAggregationLevelInfo();
        MDXLevelInfo aggregationLevels = new MDXLevelInfo();
        for (MDXLevelInfo mDXLevelInfo : aggregationLevelInfo.values()) {
            aggregationLevels.unionProjectedHierarchies(mDXLevelInfo);
        }
        int totalNumberOfAggregations = 1;
        for (IHierarchy hier : aggregationLevels.getHierarchyInfo().getProjectedHierarchies()) {
            totalNumberOfAggregations *= aggregationLevels.getNumProjectedLevels(hier);
        }
        int n = providerCapabilities.getIntegerValue("dmrMaximumNumberOfAggregationsInCubeLoadingQuery", 10);
        if (totalNumberOfAggregations > n && !usesBridge) {
            if (factDrivenpreciseLoading) {
                DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
                if (preciseLoadInfo.isEmpty()) {
                    LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                    PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                    return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
                }
                return true;
            }
            LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, "too many window aggregate functions for roll-ups.");
            PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
            return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
        }
        if (factDrivenpreciseLoading) {
            DMRCubeForPreciseLoading.collectInformationForPreciseCubeLoading(mdxLocal, preciseLoadInfo);
            if (preciseLoadInfo.isEmpty()) {
                LoadDMRCubeSingleV5Query.logSingleLoading(q.getRefQueryProperty(), NO_SINGLE_LOADING, MSG_NO_PRECISE_INFO);
                PreLoadDMRCubeUtil.throwIfFactDrivenCustomValueUnsupported(!measuresCustomValue.isEmpty());
                return PreLoadDMRCubeUtil.verifyAndReturnFalse(oomLimit, bigLevels);
            }
        }
        return true;
    }

    private static boolean contextDependentMeasureAggrRule(boolean status, boolean factDriven, boolean arrgRuleSetting, List<IMeasure> cubeMeasures) {
        if (!(status && factDriven && arrgRuleSetting)) {
            return false;
        }
        for (IMeasure m : cubeMeasures) {
            if (!(m instanceof MeasureWrapper) || m.getAggregateRules().length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean checkEmbeddedFilterInRegularDimension(CubeWrapper modelCube) {
        for (CogMDXDetailFilter filter : modelCube.getDetailFilters()) {
            IMetadata filterOwner;
            IDimension dimension = filter.getDimensionFromModel();
            if (dimension == null || dimension.isMeasuresDimension() || (filterOwner = filter.getFilterOwner()) != null && dimension != filterOwner) continue;
            return false;
        }
        return true;
    }

    public static boolean dimensionHasEmbeddedFilter(CubeWrapper modelCube, IDimension dim) {
        if (dim.isMeasuresDimension()) {
            return false;
        }
        for (CogMDXDetailFilter filter : modelCube.getDetailFilters()) {
            IMetadata filterOwner;
            IDimension dimension = filter.getDimensionFromModel();
            if (dimension == null || dimension.isMeasuresDimension() || (filterOwner = filter.getFilterOwner()) != null && dimension != filterOwner || !dimension.getV5UniqueName().equals(dim.getV5UniqueName())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkValueExpressionNotChangeContext(XMdxLocal mdxLocal) {
        IXQEQueryNode[] members;
        HashSet<IHierarchy> hierWithRestriction = new HashSet<IHierarchy>();
        for (BaseMember aRestrictionMember : mdxLocal.getMDXQuery().getOptimizationInfo().getProjectedMembers()) {
            hierWithRestriction.add(aRestrictionMember.getHierarchy());
        }
        for (IXQEQueryNode mem : members = mdxLocal.getMDXQuery().getDescendantsOfType(1067, false)) {
            MDXLevelInfo measureContext;
            BaseMember member = (BaseMember)mem;
            if (member.isMeasure() && !(measureContext = member.getValueContextLevelInfo()).isEmpty()) {
                for (IHierarchy hier : hierWithRestriction) {
                    if (!measureContext.getHierarchyInfo().projectsHierarchy(hier)) {
                        return false;
                    }
                    List<ILevel> contextLevels = measureContext.getProjectedLevels(hier);
                    for (ILevel aContextLevel : contextLevels) {
                        if (!aContextLevel.isRootLevel() || !(aContextLevel instanceof MDXLevelInfo.LevelInfo) || ((MDXLevelInfo.LevelInfo)aContextLevel).isFromCalculation()) continue;
                        return false;
                    }
                }
            }
            if (member.isMeasure() || !member.getLevel().isRootLevel() || member.getParent().getType() != 1069 || member.getParent().getNumberChildren() != 1 || !((AbstractMDXNode)member.getParent()).isValueExpressionOperand()) continue;
            for (BaseMember aRestrictionMember : mdxLocal.getMDXQuery().getOptimizationInfo().getProjectedMembers()) {
                if (!aRestrictionMember.getHierarchy().equals(member.getHierarchy())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkSummaryFunction(XMdxLocal mdxLocal, boolean usesBridge) {
        IXQEQueryNode[] countFunctions;
        int[] countTypes = new int[]{1060, 1087, 1042};
        for (IXQEQueryNode aCountFunction : countFunctions = mdxLocal.getMDXQuery().getDescendantsOfTypes(countTypes, false)) {
            if (aCountFunction.getType() == 1087 && ((MDXCount)aCountFunction).getHeadSuppression() || aCountFunction.getType() == 1042 && ((MDXHeadTailFunction)aCountFunction).getHeadSuppression() || !PreLoadDMRCubeUtil.useRealDMRHierarchyInSet((AbstractMDXNode)aCountFunction)) continue;
            int funcType = aCountFunction.getType();
            boolean bMoreCheck = false;
            if (usesBridge) {
                bMoreCheck = true;
            } else if (funcType == 1060 || funcType == 1087) {
                if (funcType == 1087) {
                    bMoreCheck = ((MDXCount)aCountFunction).includeEmpty();
                }
                if (!bMoreCheck && aCountFunction.getNumberChildren() > 1) {
                    IXQEQueryNode second = aCountFunction.getChild(1);
                    int tp = second.getType();
                    bMoreCheck = tp == 1064 || tp == 1127 || tp == 1151;
                }
            } else {
                bMoreCheck = true;
            }
            if (!bMoreCheck) continue;
            ArrayList<IXQEQueryNode> projectedMembersFuncs = new ArrayList<IXQEQueryNode>();
            AbstractMDXNode set = (AbstractMDXNode)aCountFunction.getChild(0);
            IsProjectedDescendant isProjMembersFunc = new IsProjectedDescendant(set);
            isProjMembersFunc.setNodeTypes(new int[]{1040, 1048, 1052});
            set.getDescendantsForCondition(projectedMembersFuncs, isProjMembersFunc, true);
            if (projectedMembersFuncs.size() <= 0) continue;
            if (usesBridge) {
                return false;
            }
            int[] memberTypes = new int[]{1067, 1077};
            for (IXQEQueryNode membersFunc : projectedMembersFuncs) {
                boolean bFilterredByMeasure = false;
                IXQEQueryNode filterExpr = membersFunc.getAncestorOfTypes(new int[]{1053, 1060});
                if (filterExpr != null && filterExpr.getNumberChildren() > 1) {
                    List<AbstractMDXNode> mbrs = ((AbstractMDXNode)filterExpr.getChild(1)).getDescendantsOfTypes(memberTypes, true, true, true, false, true);
                    for (AbstractMDXNode aMember : mbrs) {
                        if (!aMember.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) continue;
                        bFilterredByMeasure = true;
                        break;
                    }
                    if (bFilterredByMeasure) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean checkMeasureDimensionEmbeddedFilter(MDXQuery q, CubeWrapper modelCube) {
        List<IMeasure> involvedMeasures = q.getInvolvedMeasures();
        if (involvedMeasures.size() > 1) {
            boolean hasMultipleMeasuresWithModelFilter = false;
            for (CogMDXDetailFilter astDetailFilter : modelCube.getDetailFilters()) {
                IDimension dimension;
                if (!astDetailFilter.isModelFilter() || (dimension = astDetailFilter.getDimensionFromModel()) == null || !dimension.isMeasuresDimension()) continue;
                hasMultipleMeasuresWithModelFilter = true;
                break;
            }
            if (hasMultipleMeasuresWithModelFilter) {
                IDimension measureDimension = null;
                for (IMeasure measure : involvedMeasures) {
                    if (!(measure instanceof MeasureWrapper)) continue;
                    IDimension aMeasureDimension = ((MeasureWrapper)measure).getWrapped().getDimension();
                    IDimension targetDim = MetadataUtil.getTargetDim(aMeasureDimension);
                    if (targetDim != aMeasureDimension && targetDim.getObjectType() == MetadataType.DIMENSION) {
                        aMeasureDimension = targetDim;
                    }
                    if (measureDimension == null) {
                        measureDimension = aMeasureDimension;
                        continue;
                    }
                    if (aMeasureDimension.equals(measureDimension)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkConstantTuple(MDXQuery q, CubeWrapper modelCube) {
        IXQEQueryNode[] exprs;
        MDXHierInfo cubeHierInfo = new MDXHierInfo();
        for (IDimension dimension : modelCube.getDimensions()) {
            String isManualProp;
            if (dimension.isMeasuresDimension() || (isManualProp = (String)dimension.getProperty("isManual")) != null && Boolean.parseBoolean(isManualProp)) continue;
            for (IHierarchy hierarchy : dimension.getHierarchies()) {
                cubeHierInfo.appendProjectedHierarchy(hierarchy);
            }
        }
        for (IXQEQueryNode expr : exprs = q.getDescendantsOfTypes(new int[]{1069, 1005}, false)) {
            if (!PreLoadDMRCubeUtil.isConstantValue(expr, cubeHierInfo)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkProjectedMeasure(MDXQuery q) {
        boolean hasProjectedMeasure = false;
        ArrayList<IXQEQueryNode> projectedMeasures = new ArrayList<IXQEQueryNode>();
        int[] nodeTypes = new int[]{1067, 1077, 1013};
        for (MDXEdge edge : q.getEdges()) {
            IsProjectedDescendant isProjMeasure = new IsProjectedDescendant(edge);
            isProjMeasure.setNodeTypes(nodeTypes);
            edge.getDescendantsForCondition(projectedMeasures, isProjMeasure, true);
        }
        MDXDimensionLine dimensionLine = q.getDimensionLine();
        if (dimensionLine != null) {
            IsProjectedDescendant isProjMeasure = new IsProjectedDescendant(dimensionLine);
            isProjMeasure.setNodeTypes(nodeTypes);
            dimensionLine.getDescendantsForCondition(projectedMeasures, isProjMeasure, true);
        }
        block1: for (IXQEQueryNode aMeasure : projectedMeasures) {
            if (aMeasure.getType() == 1013) {
                MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)aMeasure;
                if (calc.isFillerTag() || !calc.getHierarchy().getDimension().isMeasuresDimension()) continue;
                MDXCalculatedMemberDefinition calcDef = calc.getDefinition();
                if (PreLoadDMRCubeUtil.isFactDrivenMDXCustomValue(calcDef.getChild(0))) {
                    hasProjectedMeasure = true;
                    break;
                }
                List<AbstractMDXNode> memberRefs = calcDef.getDescendantsOfCategories(new int[]{1067, 1077}, true, true, true, true, false);
                for (AbstractMDXNode aMemberRef : memberRefs) {
                    if (!((AbstractMDXMember)aMemberRef).getHierarchy().getDimension().isMeasuresDimension()) continue;
                    hasProjectedMeasure = true;
                    continue block1;
                }
                continue;
            }
            if (!((AbstractMDXMember)aMeasure).getHierarchy().getDimension().isMeasuresDimension()) continue;
            hasProjectedMeasure = true;
            break;
        }
        return hasProjectedMeasure;
    }

    private static boolean checkProjectedLevel(ArrayList<ILevel> tempLevels, XMdxLocal mdxLocal, ArrayList<ILevel> realLevels, boolean[] extraFlag) {
        MDXLevelInfo levelInfo = mdxLocal.getLevelInfoProperty();
        boolean bHasProjectedLevel = false;
        for (IHierarchy infoHierarchy : levelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            ILevel lowestLevel;
            if (infoHierarchy.getDimension().isMeasuresDimension() || (lowestLevel = levelInfo.getLowestProjectedLevelsSkipCalculation(infoHierarchy)) == null || !(lowestLevel instanceof MDXLevelInfo.LevelInfo)) continue;
            if ((lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel()).getName() == "tagLevelForCompleteTuple") {
                extraFlag[0] = false;
                return false;
            }
            if (lowestLevel.isRootLevel()) continue;
            bHasProjectedLevel = true;
            if (lowestLevel instanceof LevelWrapper) {
                realLevels.add(lowestLevel);
                continue;
            }
            if (lowestLevel instanceof V5DataItemToLevelWrapper) {
                tempLevels.add(lowestLevel);
                continue;
            }
            extraFlag[0] = false;
            return false;
        }
        return bHasProjectedLevel;
    }

    private static boolean checkMeasureAggrRule(CubeWrapper modelCube, ArrayList<ILevel> tempLevels, List<IMeasure> cubeMeasures, ArrayList<ILevel> realLevels, StringBuilder rtMsg, boolean bIgnoreAggrRule) {
        for (IMeasure m : cubeMeasures) {
            if (!(m instanceof MeasureWrapper)) continue;
            if (!tempLevels.isEmpty()) {
                rtMsg.append("temporary level is created. real DMR measure ");
                rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(m));
                rtMsg.append(" has no scope to temporary level.");
                return false;
            }
            if (!((MeasureWrapper)m).isReUseable() && !PreLoadDMRCubeUtil.isMeasureForCustomValue(m.getName())) {
                rtMsg.append(MSG_MEASURE);
                rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(m));
                rtMsg.append(" is modified by propagateV5Aggregate.");
                return false;
            }
            if (bIgnoreAggrRule || m.getAggregateRules().length <= 0) continue;
            rtMsg.append(MSG_MEASURE);
            rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(m));
            rtMsg.append(" has aggregate rule.");
            return false;
        }
        return true;
    }

    private static boolean checkMeasureScope(CubeWrapper modelCube, ArrayList<ILevel> tempLevels, List<IMeasure> cubeMeasures, ArrayList<ILevel> realLevels, StringBuilder rtMsg) {
        for (IMeasure m : cubeMeasures) {
            if (!(m instanceof MeasureWrapper) || PreLoadDMRCubeUtil.isMeasureForCustomValue(m.getName())) continue;
            for (ILevel l : realLevels) {
                ILevel scopeLevel = PreLoadDMRCubeUtil.getLowestLevelFromScope(m, l);
                if (scopeLevel != null && scopeLevel.getIndex() >= l.getIndex()) continue;
                rtMsg.append(MSG_MEASURE);
                rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(m));
                rtMsg.append(" has higher scope than level ");
                rtMsg.append(l.getName());
                return false;
            }
        }
        return true;
    }

    private static boolean checkMeasureDiffTable(CubeWrapper modelCube, List<IMeasure> cubeMeasures, StringBuilder rtMsg) {
        SetOfTables involvedTableReal = null;
        IMeasure firstRealMeasure = null;
        HashSet<SetOfTables> involvedTableTemp = new HashSet<SetOfTables>();
        for (IMeasure m : cubeMeasures) {
            SetOfTables tabs = PreLoadDMRCubeUtil.getInvolvedTables(modelCube, m);
            if (tabs == null) {
                return false;
            }
            if (m instanceof MeasureWrapper) {
                if (involvedTableReal == null) {
                    involvedTableReal = tabs;
                    firstRealMeasure = m;
                    if (involvedTableTemp.size() > 1) {
                        rtMsg.append("there are temporary and real measures.");
                        return false;
                    }
                    if (involvedTableTemp.size() != 1 || involvedTableTemp.contains(involvedTableReal)) continue;
                    rtMsg.append("real measure ");
                    rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(firstRealMeasure));
                    rtMsg.append(" uses different table from that used by temporary measure.");
                    return false;
                }
                if (involvedTableReal.equals(tabs)) continue;
                rtMsg.append("measures ");
                rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(firstRealMeasure));
                rtMsg.append(" and ");
                rtMsg.append(PreLoadDMRCubeUtil.getMeasureNameForLogging(m));
                rtMsg.append(" use different table.");
                return false;
            }
            involvedTableTemp.add(tabs);
        }
        return true;
    }

    private static String getMeasureNameForLogging(IMeasure m) {
        String nm = "";
        if (m != null) {
            nm = m.getV5UniqueName();
            if (nm == null) {
                nm = m.getName();
            }
            if (nm == null) {
                nm = "";
            }
        }
        return nm;
    }

    private static boolean verifyAndReturnFalse(double oomLimit, HashMap<ILevel, LevelStatus> bigLevels) {
        if (oomLimit > 0.0 && !bigLevels.isEmpty()) {
            StringBuilder levelName = new StringBuilder();
            for (Map.Entry<ILevel, LevelStatus> entry : bigLevels.entrySet()) {
                if (levelName.length() > 0) {
                    levelName.append(", ");
                }
                levelName.append(entry.getKey().getV5UniqueName());
            }
            throw new XQERuntimeException(XQEMessageKeys.EXE_DMRBigLevelNoRestriction, levelName.toString());
        }
        return false;
    }

    protected static boolean useRealDMRHierarchyInSet(AbstractMDXNode mdxNode) {
        Set<MDXHierInfo> hierInfos = mdxNode.getHierarchyInfoFromFirstChild(null);
        for (MDXHierInfo hierInfo : hierInfos) {
            List<IHierarchy> hiers = hierInfo.getProjectedHierarchies();
            for (IHierarchy hier : hiers) {
                ILevel lvl;
                if (hier.getDimension().isMeasuresDimension() || !((lvl = hier.getLevel(hier.getLevelCount() - 1)) instanceof V5DataItemToLevelWrapper)) continue;
                return false;
            }
        }
        return true;
    }

    public static SetOfTables getInvolvedTablesForMeasureForCustomValue(String name) {
        if (PreLoadDMRCubeUtil.isMeasureForCustomValue(name)) {
            SetOfTables t = new SetOfTables();
            t.add(name);
            return t;
        }
        return null;
    }

    protected static SetOfTables getInvolvedTables(CubeWrapper cubeWrapper, IMeasure measure) {
        SetOfTables t = PreLoadDMRCubeUtil.getInvolvedTablesForMeasureForCustomValue(measure.getName());
        if (t != null) {
            return t;
        }
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan == null) {
            return null;
        }
        IMetadata qItem = null;
        if (measure instanceof QueryItemWrapper) {
            qItem = ((QueryItemWrapper)((Object)measure)).getQueryItem();
        } else if (measure instanceof V5DataItemToMeasureWrapper) {
            qItem = measure;
        } else if (measure instanceof MeasureWrapper) {
            qItem = measure;
        } else {
            return null;
        }
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        queryItems.add(qItem);
        return PrePlanUtilities.getInvolvedTables(prePlan, queryItems, false);
    }

    public static ILevel getLowestLevelFromScope(IMeasure measure, ILevel levelOfDimension) {
        IDimension dimension = levelOfDimension.getDimension();
        IScopeRelationship scopeRelationship = measure.getScopeRelationship(dimension);
        if (scopeRelationship == null) {
            return null;
        }
        return scopeRelationship.getLowestLevel(measure, levelOfDimension);
    }

    private static boolean isFactDrivenMDXCustomValue(IXQEQueryNode node) {
        if (node.getType() != 1196) {
            return false;
        }
        MDXStringConstant flag = (MDXStringConstant)node.getChild(1);
        String sf = flag.getConstantValue();
        return sf != null && PreLoadDMRCubeUtil.isMeasureForCustomValue(sf);
    }

    public static boolean isMeasureForCustomValue(String name) {
        return name.endsWith("_FactDrivenMDXCustomValue");
    }

    private static boolean isConstantValue(IXQEQueryNode expr, MDXHierInfo cubeHierInfo) {
        if (expr.getType() == 1005) {
            if (PreLoadDMRCubeUtil.isFactDrivenMDXCustomValue(expr.getChild(0))) {
                return false;
            }
            if (expr.getChild(0).getType() != 1089 && !((MDXCalculatedMemberDefinition)expr).isFillerTag() && !((MDXCalculatedMemberDefinition)expr).isTag()) {
                int[] categories = new int[]{1022, 1023, 1072};
                return ((AbstractMDXNode)expr.getChild(0)).getDescendantsOfCategories(categories, true, true, true, false, false).isEmpty();
            }
        }
        if (cubeHierInfo.getNumProjectedHierarchies() == 0) {
            return false;
        }
        if (expr.getType() == 1069) {
            MDXHierInfo hierInfo = ((AbstractMDXNode)expr).getHierarchyInfo();
            for (int i = 0; i < expr.getNumberChildren(); ++i) {
                AbstractMDXNode child = (AbstractMDXNode)expr.getChild(i);
                if (child.getType() == 1067 && !((BaseMember)child).isRootMember()) continue;
                hierInfo.extractHierInfo(child.getHierarchyInfo());
            }
            return hierInfo.projectsHierarchies(cubeHierInfo);
        }
        return false;
    }

    protected static boolean checkUnProjectedMUNandGetBigLevels(ICube modelCube, XMdxLocal mdxLocal, double oom, HashMap<ILevel, LevelStatus> bigLevels) {
        boolean bUnProjectedMUN = false;
        MDXLevelInfo levelInfo = mdxLocal.getLevelInfoProperty();
        for (IHierarchy infoHierarchy : levelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            double computedOOM;
            ILevel lowestLevel;
            if (infoHierarchy.getDimension().isMeasuresDimension() || (lowestLevel = levelInfo.getLowestProjectedLevelsSkipCalculation(infoHierarchy)) == null || !(lowestLevel instanceof MDXLevelInfo.LevelInfo) || (lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel()) instanceof V5DataItemToLevelWrapper || lowestLevel.isRootLevel() || lowestLevel.getName() == "tagLevelForCompleteTuple") continue;
            LevelStatus levelSt = PreLoadDMRCubeUtil.getLevelStatus(lowestLevel, modelCube, mdxLocal);
            if (levelSt == LevelStatus.MUN_RESTRICT_NOTPROJECTED) {
                bUnProjectedMUN = true;
            }
            if (!(oom > 0.0) || !((computedOOM = lowestLevel.getOrderOfMagnitude()) >= oom)) continue;
            if (levelSt != LevelStatus.NO_MUN_RESTRICT) {
                computedOOM = PreLoadDMRCubeUtil.recomputeOOMWithRestriction(lowestLevel, modelCube, mdxLocal);
                StringBuilder sb = new StringBuilder();
                sb.append("Its OOM is adjusted from  ");
                sb.append(lowestLevel.getOrderOfMagnitude());
                sb.append(" to ");
                sb.append(computedOOM);
                LoadDMRCubeSingleV5Query.logSingleLoading(lowestLevel.getName(), " has MUN restriction. ", sb.toString());
            }
            if (!(computedOOM >= oom)) continue;
            bigLevels.put(lowestLevel, levelSt);
        }
        return bUnProjectedMUN;
    }

    protected static LevelStatus getLevelStatus(ILevel level, ICube modelCube, XMdxLocal mdxLocal) {
        if (PreLoadDMRCubeUtil.hasDetailFilterRestriction(level, modelCube)) {
            return LevelStatus.MUN_RESTRICT;
        }
        IHierarchy hier = level.getHierarchy();
        for (BaseMember aRestrictionMember : mdxLocal.getMDXQuery().getOptimizationInfo().getProjectedMembers()) {
            if (!hier.equals(aRestrictionMember.getHierarchy())) continue;
            return LevelStatus.MUN_RESTRICT;
        }
        Map<ILevel, List<BaseMember>> restrictions = mdxLocal.getMDXQuery().getOptimizationInfo().getLevelRestrictions();
        for (Map.Entry<ILevel, List<BaseMember>> entry : restrictions.entrySet()) {
            if (!entry.getKey().getHierarchy().equals(hier) || entry.getValue().isEmpty()) continue;
            return LevelStatus.MUN_RESTRICT_NOTPROJECTED;
        }
        return LevelStatus.NO_MUN_RESTRICT;
    }

    protected static boolean hasDetailFilterRestriction(ILevel level, ICube modelCube) {
        List<CogMDXDetailFilter> detailFilters = ((CubeWrapper)modelCube).getDetailFilters();
        IHierarchy hier = level.getHierarchy();
        List<ILevel> lvls = hier.getLevels();
        ArrayList<IMetadata> projectedColumns = new ArrayList<IMetadata>();
        projectedColumns.addAll(lvls.subList(1, lvls.size()));
        ArrayList<Measure> projectedMeasures = new ArrayList<Measure>();
        for (CogMDXDetailFilter filter : detailFilters) {
            IMetadata filterOwner;
            if (filter.isModelFilter() || !V5QueryOverTabularStream.filterIsRequired(filter, filterOwner = filter.getFilterOwner(), false, projectedMeasures, projectedColumns, null, false)) continue;
            return true;
        }
        return false;
    }

    protected static double recomputeOOMWithRestriction(ILevel level, ICube modelCube, XMdxLocal mdxLocal) {
        if (PreLoadDMRCubeUtil.hasDetailFilterRestriction(level, modelCube)) {
            return 0.0;
        }
        ArrayList members = new ArrayList();
        IHierarchy hier = level.getHierarchy();
        Map<ILevel, List<BaseMember>> restrictions = mdxLocal.getMDXQuery().getOptimizationInfo().getLevelRestrictions();
        for (Map.Entry<ILevel, List<BaseMember>> entry : restrictions.entrySet()) {
            if (!entry.getKey().getHierarchy().equals(hier) || entry.getValue().isEmpty()) continue;
            members.addAll(entry.getValue());
        }
        TreeMap munGroupedByLevel = new TreeMap();
        TreeMap<Integer, ILevel> levels = new TreeMap<Integer, ILevel>();
        for (BaseMember baseMun : members) {
            Object extName;
            ILevel munLevel = baseMun.getLevel();
            int levelId = munLevel.getIndex();
            HashSet<String> lst = (HashSet<String>)munGroupedByLevel.get(levelId);
            if (lst == null) {
                lst = new HashSet<String>();
                munGroupedByLevel.put(levelId, lst);
            }
            if ((extName = baseMun.getExternalName()) == null) continue;
            lst.add((String)extName);
            levels.put(levelId, munLevel);
        }
        if (munGroupedByLevel.isEmpty()) {
            return level.getOrderOfMagnitude();
        }
        HashSet<String> toRemove = new HashSet<String>();
        ArrayList lst = new ArrayList(munGroupedByLevel.keySet());
        int sz = lst.size();
        if (sz > 1) {
            for (int i = 0; i < sz - 1; ++i) {
                HashSet st = (HashSet)munGroupedByLevel.get(lst.get(i));
                for (String extMUN : st) {
                    for (int j = i + 1; j < sz; ++j) {
                        toRemove.clear();
                        HashSet st1 = (HashSet)munGroupedByLevel.get(lst.get(j));
                        Iterator iterator = st1.iterator();
                        while (iterator.hasNext()) {
                            String extMUN1 = (String)iterator.next();
                            if (!extMUN1.startsWith(extMUN)) continue;
                            toRemove.add(extMUN1);
                        }
                        st1.removeAll(toRemove);
                    }
                }
            }
        }
        double rtOOM = 0.0;
        int lowestLevelId = level.getIndex();
        double lowestOOM = level.getOrderOfMagnitude();
        for (Integer id : lst) {
            HashSet st;
            if (id >= lowestLevelId || (sz = (st = (HashSet)munGroupedByLevel.get(id)).size()) <= 0) continue;
            rtOOM += Math.log10(sz) + (lowestOOM - ((ILevel)levels.get(id)).getOrderOfMagnitude());
        }
        HashSet st = (HashSet)munGroupedByLevel.get(lowestLevelId);
        if (st != null && !st.isEmpty()) {
            rtOOM += Math.log10(st.size());
        }
        return rtOOM;
    }

    public static enum LevelStatus {
        NO_MUN_RESTRICT,
        MUN_RESTRICT_NOTPROJECTED,
        MUN_RESTRICT;

    }
}

