/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.runtree.olap.mdx.functions.CellStreamProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.ICellStreamResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class BaseSumResultCalculator
implements ICellStreamResultCalculator {
    protected final boolean nullsLargest;
    protected final double goalSum;
    protected final long setSize;
    protected final Comparator<Object> cellComparator;
    protected double currentSum = 0.0;
    protected TreeSet<Cell> values;
    protected ArrayList<Cell> allSeenCells = null;
    private long totalCellCount = 0L;
    private int insertedCellCount = 0;
    private int valuesListMaxSize = 0;
    protected int returnedCellCount = 0;

    public BaseSumResultCalculator(double sumParam, Comparator<Object> aCellComparator, long aSetSize, boolean areNullsLargest) {
        this.setSize = aSetSize;
        this.cellComparator = aCellComparator;
        this.goalSum = sumParam;
        this.nullsLargest = areNullsLargest;
        this.values = new TreeSet<Object>(aCellComparator);
        this.allSeenCells = new ArrayList();
    }

    protected void trackCell(Cell cell) {
        ++this.totalCellCount;
        if (this.allSeenCells != null) {
            this.allSeenCells.add(cell);
        }
    }

    protected void insertValue(Cell cell, boolean addCellValueToCurrentSum) {
        ++this.insertedCellCount;
        this.values.add(cell);
        if (addCellValueToCurrentSum) {
            this.currentSum += cell.getNumericValue();
        }
        if (this.values.size() > this.valuesListMaxSize) {
            this.valuesListMaxSize = this.values.size();
        }
        if (this.exceededGoalAmount()) {
            this.trimValues();
        }
    }

    private void trimValues() {
        Iterator<Cell> descInter = this.values.descendingIterator();
        while (descInter.hasNext()) {
            Cell c = descInter.next();
            if (!descInter.hasNext()) continue;
            if (c.isError()) {
                descInter.remove();
                continue;
            }
            double cellValue = c.getNumericValue();
            if (!(this.currentSum - cellValue >= this.goalSum)) break;
            descInter.remove();
            this.currentSum -= cellValue;
        }
    }

    public final boolean madeGoalAmount() {
        return this.currentSum >= this.goalSum;
    }

    public final boolean exceededGoalAmount() {
        return this.currentSum > this.goalSum;
    }

    public void insertSingleValueAsEntireAnswer(Cell cell) {
        this.values.clear();
        this.values.add(cell);
        this.currentSum = cell.getNumericValue();
    }

    public Cell getLeastDesireableValue() {
        return this.values.last();
    }

    @Override
    public String getLogMsgText() {
        String msg = CellStreamProcessor.generateLogMsg(this.totalCellCount, this.insertedCellCount, this.returnedCellCount);
        NumberFormat nf = NumberFormat.getInstance();
        msg = msg + "  Values list max size=" + nf.format(this.valuesListMaxSize);
        return msg;
    }
}

