/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;

public class Levels
implements Function {
    private static final String LEVELS_FUNCTION_NAME = "Levels";
    private static final String NUMERIC_OR_STRING_STR = "CMP_TYPENUMERIC, CMP_TYPESTRING";

    @Override
    public Class<?> getSubjectType() {
        return Dimension.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Level.class;
    }

    @Override
    public String getName() {
        return LEVELS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block hierarchyParamB = (Block)subject;
        Block levelParamB = (Block)parameterFetcher.getParameter(0);
        levelParamB.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{hierarchyParamB, levelParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            ILevel level = this.levels(blockObj[0], blockObj[1]);
            block.add(blockIter, (Object)level);
        }
        return block;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ILevel levels(Object hierarchyParam, Object levelParam) throws InterpreterException {
        if (hierarchyParam == null) {
            throw new InterpreterException("X01498", new String[]{this.getName()});
        }
        Hierarchy hierarchy = null;
        if (hierarchyParam instanceof Hierarchy) {
            hierarchy = (Hierarchy)hierarchyParam;
        } else {
            if (!(hierarchyParam instanceof Dimension)) throw new InterpreterException("X01434", new String[]{this.getName(), "CMP_TYPEHIERARCHY"});
            hierarchy = (Hierarchy)((Dimension)hierarchyParam).getDefaultHierarchy();
        }
        ILevel result = null;
        if (this.getName().equals("Generations")) {
            int levelIndex;
            if (levelParam instanceof Double) {
                double index = (Double)levelParam - 1.0;
                return hierarchy.getLevel((int)index);
            }
            if (!(levelParam instanceof Value)) throw new InterpreterException("X01490", new String[]{levelParam.getClass().getSimpleName(), this.getName(), NUMERIC_OR_STRING_STR});
            Value v = (Value)levelParam;
            if (v.isNull()) {
                throw new InterpreterException("X01490", new String[]{"(null)", this.getName(), NUMERIC_OR_STRING_STR});
            }
            try {
                levelIndex = ((Value)levelParam).getInteger() - 1;
            }
            catch (ValueConversionException vce) {
                throw new InterpreterException("X01490", new String[]{levelParam.toString(), this.getName(), "CMP_TYPENUMERIC"});
            }
            if (levelIndex < 0 || levelIndex >= hierarchy.getLevelCount()) {
                throw new InterpreterException("X01520", new String[]{levelIndex + 1 + "", hierarchy.getName()}, 4L);
            }
            result = hierarchy.getLevel(levelIndex);
            return hierarchy.getLevel(levelIndex);
        }
        if (levelParam instanceof Double) {
            double index = (Double)levelParam;
            if (!(index >= 0.0) || (int)index >= hierarchy.getLevelCount()) {
                throw new InterpreterException("X01520", new String[]{index + "", hierarchy.getName()}, 4L);
            }
            result = hierarchy.getLevel((int)index);
            if (result != null) return result;
            throw new InterpreterException("X01498", new String[]{this.getName()}, 2L);
        }
        if (levelParam instanceof Value) {
            Value v = (Value)levelParam;
            if (v.isNull()) {
                result = hierarchy.getLevel(0);
            } else if (v.isNumeric()) {
                int index = v.getInteger();
                if (index < 0 || index >= hierarchy.getLevelCount()) throw new InterpreterException("X01520", new String[]{index + "", hierarchy.getName()}, 4L);
                result = hierarchy.getLevel(index);
            } else {
                String levelString = v.getString();
                result = hierarchy.getLevel(levelString);
                if (result == null) {
                    throw new InterpreterException("X01521", new String[]{levelString, hierarchy.getName()}, 4L);
                }
            }
            if (result != null) return result;
            throw new InterpreterException("X01498", new String[]{this.getName()}, 2L);
        }
        if (levelParam instanceof String) {
            String levelString = (String)levelParam;
            result = hierarchy.getLevel(levelString);
            if (result != null) return result;
            throw new InterpreterException("X01521", new String[]{levelString, hierarchy.getName()}, 4L);
        }
        if (levelParam == null) return hierarchy.getLevel(0);
        if (!(levelParam instanceof NullObject)) throw new InterpreterException("X01490", new String[]{levelParam.getClass().getSimpleName(), this.getName(), NUMERIC_OR_STRING_STR});
        return hierarchy.getLevel(0);
    }
}

