/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.IOrdinalFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.OrdinalSparseFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SortedTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Utilities {
    public static final long SET_SIZE_TO_USE_SPARSE_FILTER = 5000000L;

    public static String getReportName() {
        String reportName = null;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null) {
            reportName = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportName();
        }
        return reportName;
    }

    public static Cell createNullCell(long ordinal) {
        DoubleValue nv = DataValueFactory.createDoubleValue();
        nv.setNull();
        Cell nullCell = new Cell(ordinal, nv);
        return nullCell;
    }

    public static Set createSortedSet(Set s, Cell[] sortedValues) {
        Set orderedSet = null;
        if (sortedValues == null) {
            orderedSet = s;
        } else {
            long[] orderMap = new long[sortedValues.length];
            for (int i = 0; i < sortedValues.length; ++i) {
                orderMap[i] = sortedValues[i].getOrdinal();
            }
            ITupleList tl = SortedTupleList.construct(s.getTupleList(), orderMap);
            orderedSet = new Set(tl);
        }
        return orderedSet;
    }

    public static List<Cell> getFirstNulls(int count, boolean useLowerOrdinalsFirst, long setSize, Collection<Cell> nonNullCells) {
        IOrdinalFilter of = Utilities.getBestOrdinalFilter(setSize);
        for (Cell c : nonNullCells) {
            of.set(c.getOrdinal(), true);
        }
        return Utilities.getFirstNulls(count, useLowerOrdinalsFirst, setSize, of);
    }

    public static List<Cell> getFirstNulls(int count, boolean useLowerOrdinalsFirst, long setSize, IOrdinalFilter of) {
        ArrayList<Cell> nullValueCells = new ArrayList<Cell>();
        long ordinal = 0L;
        if (!useLowerOrdinalsFirst) {
            ordinal = setSize - 1L;
        }
        while (count > 0 && ordinal < setSize && ordinal >= 0L) {
            if (!of.isEnabled(ordinal)) {
                nullValueCells.add(Utilities.createNullCell(ordinal));
                --count;
            }
            if (useLowerOrdinalsFirst) {
                ++ordinal;
                continue;
            }
            --ordinal;
        }
        return nullValueCells;
    }

    public static int calcNumContexts(Block retBlock) {
        Set[] sets = retBlock.getSets();
        long totalSize = 1L;
        for (Set s : sets) {
            totalSize *= s.size();
        }
        if (totalSize > Integer.MAX_VALUE) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot have total number of contexts greater than Integer.MAX_VALUE");
        }
        return (int)totalSize;
    }

    public static Cell[] buildEntireSetInSortedOrder(long setSize, List<Cell> nonNullCells, Comparator<Object> cellComparator) {
        int intSetSize = (int)setSize;
        Cell[] allCells = new Cell[intSetSize];
        for (Cell c : nonNullCells) {
            int intCellOrdinal = (int)c.getOrdinal();
            allCells[intCellOrdinal] = c;
        }
        for (int i = 0; i < allCells.length; ++i) {
            if (allCells[i] != null) continue;
            allCells[i] = Utilities.createNullCell(i);
        }
        Arrays.sort(allCells, cellComparator);
        return allCells;
    }

    public static IOrdinalFilter getBestOrdinalFilter(long setSize) {
        if (setSize > 5000000L) {
            return new OrdinalSparseFilter();
        }
        return new TupleListFilter(setSize);
    }

    public static NullBehavior getNullBehavior(InterpreterContext ic) {
        IDataSource dataSource = ic.getXDataContext().getEnvironment().getDataSource();
        NullBehavior nullHandling = NullBehavior.ZERO_FIRST;
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            nullHandling = NullBehavior.getDataSourceNullOrderBehavior(capabilities, NullBehavior.ZERO_FIRST);
        }
        return nullHandling;
    }
}

