/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.math.MathFunction;
import java.util.ArrayList;

public class Log10
extends MathFunction {
    private static final String LOG10_FUNCTION_NAME = "Log10";
    private static final double DOUBLE_10 = 10.0;

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return LOG10_FUNCTION_NAME;
    }

    @Override
    public Double doMathFunction(Double value) {
        return new Double(Math.log(value) / Math.log(10.0));
    }

    @Override
    public Value doMathFunction(Value value) {
        DoubleValue v = DataValueFactory.createDoubleValue();
        FormatService service = FormatService.getInstance();
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        operandIds.add(value.getFormatId());
        FormatId resultFormatId = service.formatResult("Ln", operandIds);
        v.setFormatId(resultFormatId);
        ((Value)v).set(Math.log(value.getDouble()) / Math.log(10.0));
        return v;
    }
}

