/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;

public abstract class MathFunction
implements Function {
    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block valueParamB = (Block)parameterFetcher.getParameter(0);
        valueParamB.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{valueParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object resultValue = this.doExecute(parameterFetcher, blockObj[0]);
            block.add(blockIter, resultValue);
        }
        return block;
    }

    private Object doExecute(ParameterFetcher parameterFetcher, Object value) throws InterpreterException {
        Double doubleValue = null;
        if (value instanceof String) {
            try {
                doubleValue = Double.valueOf((String)value);
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(value);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else if (value instanceof Double) {
            doubleValue = (double)((Double)value);
        } else if (value instanceof Integer) {
            doubleValue = ((Integer)value).doubleValue();
        } else {
            if (value instanceof Value) {
                Value v = (Value)value;
                if (v.isError()) {
                    return TextValue.ERROR_VALUE;
                }
                if (!v.isOK() && !v.isNull()) {
                    DoubleValue resultValue = DataValueFactory.createDoubleValue();
                    resultValue.setState(v.getState());
                    return resultValue;
                }
                if (!v.isNull()) {
                    return this.doMathFunction(v);
                }
                String paramString = ParameterFetcher.getParameterName(value);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
            }
            String paramString = ParameterFetcher.getParameterName(value);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
        }
        Double result = this.doMathFunction(doubleValue);
        return result;
    }

    public abstract Double doMathFunction(Double var1);

    public abstract Value doMathFunction(Value var1);
}

