/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.math.MathFunction;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;

public class Random
extends MathFunction {
    private static final String RANDOM_FUNCTION_NAME = "Random";
    private static java.util.Random randomSeeded = new java.util.Random();

    private synchronized double getRandom(long seed) {
        if (seed != Long.MAX_VALUE) {
            randomSeeded.setSeed(seed);
        }
        return randomSeeded.nextDouble();
    }

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}, new Class[0]};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return RANDOM_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        if (parameterFetcher.getParameterCount() == 0) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(this.getRandom(Long.MAX_VALUE));
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            return new Block(interpreterContext, v);
        }
        return super.execute(subject, parameterFetcher);
    }

    @Override
    public Double doMathFunction(Double value) {
        long seed = value.longValue();
        return new Double(this.getRandom(seed));
    }

    @Override
    public Value doMathFunction(Value value) {
        DoubleValue v = DataValueFactory.createDoubleValue();
        long seed = value.getLong();
        ((Value)v).set(this.getRandom(seed));
        FormatId resultFormatId = value.getFormatId();
        v.setFormatId(resultFormatId);
        return v;
    }
}

