/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;

public class Ancestor
implements Function {
    private static final String ANCESTOR_FUNCTION_NAME = "Ancestor";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{IMember.class, Level.class}, {IMember.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Level.class;
    }

    @Override
    public String getName() {
        return ANCESTOR_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block memberParamB = (Block)parameterFetcher.getParameter(0);
        memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext);
        Block distanceParamB = (Block)parameterFetcher.getParameter(1);
        Object firstObj = distanceParamB.first();
        if (firstObj instanceof Integer || firstObj instanceof Double || firstObj instanceof Boolean || firstObj instanceof String || firstObj instanceof NullObject || firstObj instanceof Value) {
            distanceParamB = Caster.castToInt(distanceParamB, interpreterContext);
        }
        Block[] wrkBlocks = new Block[]{memberParamB, distanceParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IMember ancestorMember = this.ancestor(blockObj[0], blockObj[1], interpreterContext);
            block.add(blockIter, (Object)ancestorMember);
        }
        return block;
    }

    private IMember ancestor(Object memberParam, Object distanceParam, InterpreterContext interpreterContext) throws InterpreterException {
        IMember member = (IMember)memberParam;
        if (member instanceof NullMember) {
            return member;
        }
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        if (distanceParam == null) {
            distanceParam = 0;
        }
        IMember ancestor = member;
        if (distanceParam instanceof Level) {
            Level ancestorLevel = (Level)distanceParam;
            if (ancestorLevel.getHierarchy() != member.getHierarchy()) {
                throw new InterpreterException("X01432", new String[]{ancestorLevel.getHierarchy().toString(), member.getHierarchy().toString()});
            }
            int levelIndex = ancestorLevel.getIndex();
            if (ancestor.getLevel().getIndex() < levelIndex) {
                ancestor = null;
            }
            while (ancestor != null && !(ancestor instanceof NullMember) && ancestor.getLevel().getIndex() > levelIndex) {
                if ((ancestor = MemberOperations.getParentOp(ancestor.getParent(), false, interpreterContext)).getLevel().getIndex() >= levelIndex) continue;
                ancestor = null;
            }
        } else if (distanceParam instanceof Integer) {
            int distance = (Integer)distanceParam;
            if (distance >= 0) {
                while (distance > 0 && ancestor != null && !(ancestor instanceof NullMember)) {
                    ancestor = MemberOperations.getParentOp(ancestor.getParent(), false, interpreterContext);
                    --distance;
                }
            } else {
                ancestor = null;
            }
        } else if (distanceParam instanceof Value) {
            int distance = 0;
            Value v = (Value)distanceParam;
            if (!v.isNull()) {
                distance = ((Value)distanceParam).getInteger();
            }
            if (distance >= 0) {
                while (distance > 0 && ancestor != null && !(ancestor instanceof NullMember)) {
                    ancestor = MemberOperations.getParentOp(ancestor.getParent(), false, interpreterContext);
                    --distance;
                }
            } else {
                ancestor = null;
            }
        } else {
            throw new InterpreterException("X01434", new String[]{distanceParam.toString(), "Level, Double"});
        }
        if (ancestor == null || ancestor.isExtendedCalculatedMemberWithFormula()) {
            ancestor = NullMember.getNullMember(member);
        }
        return ancestor;
    }
}

