/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;

public class Cousin
implements Function {
    private static final String COUSIN_FUNCTION_NAME = "Cousin";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public String getName() {
        return COUSIN_FUNCTION_NAME;
    }

    @Override
    public Class<?> getReturnType() {
        return IMember.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{IMember.class, IMember.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount != 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block memberParamB = (Block)parameterFetcher.getParameter(0);
        memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext);
        Block ancestorParamB = (Block)parameterFetcher.getParameter(1);
        ancestorParamB = Caster.cast(ancestorParamB, IMember.class, interpreterContext);
        IDataSource dataSource = null;
        if (interpreterContext.getXDataContext() != null && interpreterContext.getXDataContext().getEnvironment() != null) {
            dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        }
        boolean forceOperationOnRaggedUnbalanced = false;
        if (dataSource != null) {
            forceOperationOnRaggedUnbalanced = dataSource.getCapabilities().getStringValue("engine.forceOperationsOnRaggedTimeHierarchies", "false").equals("true");
        }
        Block[] wrkBlocks = new Block[]{memberParamB, ancestorParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IMember cousinMember = this.cousin((IMember)blockObj[0], (IMember)blockObj[1], interpreterContext, forceOperationOnRaggedUnbalanced);
            block.add(blockIter, (Object)cousinMember);
        }
        return block;
    }

    private IMember cousin(IMember member, IMember ancestor, InterpreterContext interpreterContext, boolean forceOperationOnRaggedUnbalanced) throws InterpreterException {
        boolean mayContainFillers;
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        ancestor = (IMember)MemberOperations.getOriginalCalculatedMember(ancestor);
        if (member.isExtendedCalculatedMember() != ancestor.isExtendedCalculatedMember()) {
            return NullMember.getNullMember(member);
        }
        if (MemberOperations.isExtendedCalculatedMemberTypeParent(member) || MemberOperations.isExtendedCalculatedMemberTypeParent(ancestor)) {
            return NullMember.getNullMember(member);
        }
        boolean bl = mayContainFillers = member.getHierarchy().isRagged() || member.getHierarchy().isUnbalanced();
        if (mayContainFillers && !forceOperationOnRaggedUnbalanced) {
            throw new InterpreterException("X01460", new String[]{this.getName()});
        }
        if (MemberOperations.isRegularCalculatedMember(member)) {
            return NullMember.getNullMember(member);
        }
        if (member instanceof NullMember) {
            return member;
        }
        if (member.getHierarchy() != ancestor.getHierarchy()) {
            throw new InterpreterException("X01432", new String[]{ancestor.getClass().toString(), member.getClass().toString()});
        }
        IMember cousin = MemberOperations.cousin(member, ancestor, interpreterContext);
        return cousin;
    }
}

