/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.member.PeriodFunction;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;

public class OpeningPeriod
extends PeriodFunction {
    private static final String OPENINGPERIOD_FUNCTION_NAME = "OpeningPeriod";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Level level;
        Block[] wrkBlocks;
        Block levelParamB = null;
        Block memberParamB = null;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount == 0) {
            ICube cube = interpreterContext.getCube();
            Dimension timeDimension = (Dimension)this.getTimeDimension(cube);
            memberParamB = new Block(interpreterContext, timeDimension);
            memberParamB.getCurrentMembers();
            wrkBlocks = new Block[]{memberParamB};
            levelParamB = new Block(interpreterContext, wrkBlocks);
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                IMember member = (IMember)blockObj[0];
                if (member instanceof NullMember) continue;
                level = (Level)member.getLevel();
                if (!level.isBottomLevel()) {
                    level = (Level)level.getNextLevel();
                }
                levelParamB.add(blockIter, (Object)level);
            }
        } else if (paramCount == 1) {
            levelParamB = (Block)parameterFetcher.getParameter(0);
            levelParamB = Caster.cast(levelParamB, Level.class, interpreterContext, this.getName());
            Level level2 = (Level)levelParamB.first();
            IHierarchy levelHierarchy = level2.getHierarchy();
            memberParamB = new Block(interpreterContext, levelHierarchy);
            memberParamB.getCurrentMembers();
        } else if (paramCount == 2) {
            levelParamB = (Block)parameterFetcher.getParameter(0);
            levelParamB = Caster.cast(levelParamB, Level.class, interpreterContext, this.getName());
            memberParamB = (Block)parameterFetcher.getParameter(1);
            memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext, this.getName());
        } else {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        IDataSource dataSource = null;
        if (interpreterContext.getXDataContext() != null && interpreterContext.getXDataContext().getEnvironment() != null) {
            dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        }
        boolean forceOperationOnRaggedUnbalanced = false;
        if (dataSource != null) {
            forceOperationOnRaggedUnbalanced = dataSource.getCapabilities().getStringValue("engine.forceOperationsOnRaggedTimeHierarchies", "false").equals("true");
        }
        wrkBlocks = new Block[]{levelParamB, memberParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            level = (Level)blockObj[0];
            IMember member = (IMember)blockObj[1];
            IMember openingPeriodMem = this.openingPeriod(level, member, forceOperationOnRaggedUnbalanced, interpreterContext);
            block.add(blockIter, (Object)openingPeriodMem);
        }
        return block;
    }

    private IMember openingPeriod(Level levelParam, IMember memberParam, boolean forceOperationOnRaggedUnbalanced, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<IMember> descendants;
        boolean mayContainFillers;
        boolean bl = mayContainFillers = levelParam.getHierarchy().isRagged() || levelParam.getHierarchy().isUnbalanced();
        if (mayContainFillers && !forceOperationOnRaggedUnbalanced) {
            throw new InterpreterException("X01460", new String[]{this.getName()});
        }
        if (memberParam instanceof NullMember) {
            return memberParam;
        }
        memberParam = (IMember)MemberOperations.getOriginalCalculatedMember(memberParam);
        IMember resultMember = null;
        if (levelParam.getHierarchy() != memberParam.getHierarchy()) {
            throw new InterpreterException("X01490", new String[]{levelParam.getHierarchy().toString(), this.getName(), memberParam.getHierarchy().toString()});
        }
        try {
            descendants = MemberOperations.getDescendantsOp((IMemberCubics)memberParam, (ILevel)levelParam, false, interpreterContext);
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
            descendants = null;
        }
        if (descendants != null && descendants.size() > 0) {
            int descendantIdx = this.getName() == OPENINGPERIOD_FUNCTION_NAME ? 0 : descendants.size() - 1;
            resultMember = descendants.get(descendantIdx);
        } else {
            resultMember = NullMember.getNullMember(memberParam);
        }
        return resultMember;
    }

    @Override
    public String getName() {
        return OPENINGPERIOD_FUNCTION_NAME;
    }

    @Override
    public Class<?> getReturnType() {
        return IMember.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Level.class}, {Level.class, IMember.class}, new Class[0]};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }
}

