/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.member.PeriodFunction;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;

public class ParallelPeriod
extends PeriodFunction {
    private static final String PARALLELPERIOD_FUNCTION_NAME = "ParallelPeriod";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Level.class}, {Level.class, Double.class}, {Level.class, Double.class, IMember.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return IMember.class;
    }

    @Override
    public String getName() {
        return PARALLELPERIOD_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Block levelParamB = null;
        Block indexParamB = null;
        Block memberParamB = null;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 0) {
            levelParamB = (Block)parameterFetcher.getParameter(0);
            levelParamB = Caster.cast(levelParamB, Level.class, interpreterContext, this.getName());
            if (paramCount > 1) {
                indexParamB = (Block)parameterFetcher.getParameter(1);
                indexParamB.getValues(interpreterContext);
                indexParamB = Caster.castToInt(indexParamB, interpreterContext);
                if (paramCount > 2) {
                    memberParamB = (Block)parameterFetcher.getParameter(2);
                    memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext, this.getName());
                }
            }
        }
        if (memberParamB == null) {
            ICube cube = interpreterContext.getCube();
            Dimension timeDimension = null;
            if (levelParamB != null) {
                Level level = (Level)levelParamB.first();
                timeDimension = (Dimension)level.getDimension();
            } else {
                timeDimension = (Dimension)this.getTimeDimension(cube);
            }
            memberParamB = new Block(interpreterContext, timeDimension);
            memberParamB.getCurrentMembers();
        }
        if (levelParamB == null) {
            Block[] wrkBlocks = new Block[]{memberParamB};
            levelParamB = new Block(interpreterContext, wrkBlocks);
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                IMember member = (IMember)blockObj[0];
                if (member instanceof NullMember) continue;
                Level level = (Level)member.getLevel();
                if (level.getIndex() > 0) {
                    level = (Level)level.getPreviousLevel();
                }
                levelParamB.add(blockIter, (Object)level);
            }
        }
        if (indexParamB == null) {
            indexParamB = new Block(interpreterContext, new Integer(1));
        }
        IDataSource dataSource = null;
        if (interpreterContext.getXDataContext() != null && interpreterContext.getXDataContext().getEnvironment() != null) {
            dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        }
        boolean forceOperationOnRaggedUnbalanced = false;
        if (dataSource != null) {
            forceOperationOnRaggedUnbalanced = dataSource.getCapabilities().getStringValue("engine.forceOperationsOnRaggedTimeHierarchies", "false").equals("true");
        }
        Block[] wrkBlocks = new Block[]{levelParamB, indexParamB, memberParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Level level = (Level)blockObj[0];
            IMember member = (IMember)blockObj[2];
            IMember parallelPeriodMem = this.parallelPeriod(level, blockObj[1], member, forceOperationOnRaggedUnbalanced, interpreterContext);
            block.add(blockIter, (Object)parallelPeriodMem);
        }
        return block;
    }

    private IMember parallelPeriod(Level level, Object indexParam, IMember member, boolean forceOperationOnRaggedUnbalanced, InterpreterContext interpreterContext) throws InterpreterException {
        IMember ancestorMember;
        Value v;
        boolean mayContainFillers;
        boolean bl = mayContainFillers = level.getHierarchy().isRagged() || level.getHierarchy().isUnbalanced();
        if (mayContainFillers && !forceOperationOnRaggedUnbalanced) {
            throw new InterpreterException("X01460", new String[]{this.getName()});
        }
        if (member instanceof NullMember || member == null) {
            return member;
        }
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        int index = 0;
        if (indexParam instanceof Integer) {
            index = (Integer)indexParam;
        } else if (indexParam instanceof Value && !(v = (Value)indexParam).isNull()) {
            index = v.getInteger();
        }
        IMember resultMember = null;
        for (ancestorMember = member; ancestorMember != null && ancestorMember.getLevel() != level; ancestorMember = ancestorMember.getParent()) {
        }
        if (ancestorMember == null) {
            return NullMember.getNullMember(member);
        }
        int ancestorLevelIndex = -1;
        try {
            List<IMember> levelMemberList = null;
            if (!member.isExtendedCalculatedMember()) {
                levelMemberList = level.getMembers();
                ancestorLevelIndex = level.getMemberIndex(ancestorMember);
            } else {
                levelMemberList = new ArrayList<IMember>();
                ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
                ArrayList<IMember> calcMembers = calcEngine.getCalculatedMembers(level);
                for (int i = 0; i < calcMembers.size(); ++i) {
                    IMember calcMember = calcMembers.get(i);
                    if (!calcMember.isExtendedCalculatedMemberTypeChildRef()) continue;
                    levelMemberList.add(calcMember);
                    if (calcMember != ancestorMember) continue;
                    ancestorLevelIndex = levelMemberList.size() - 1;
                }
            }
            IMember[] levelMembers = levelMemberList.toArray(new IMember[0]);
            int siblingOffset = ancestorLevelIndex - index;
            resultMember = siblingOffset < 0 || siblingOffset >= levelMembers.length ? NullMember.getNullMember(member) : ((IMemberCubics)member).cousin(levelMembers[siblingOffset]);
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        return resultMember;
    }
}

