/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.trace.XQEDebugLog;

public abstract class PeriodFunction
implements Function {
    protected IDimension getTimeDimension(IMetadata metadata) {
        MetadataType metadataType = metadata.getObjectType();
        switch (metadataType) {
            case CUBE: {
                for (IDimension dim : ((ICube)metadata).getDimensions()) {
                    if (!dim.isTimeDimension()) continue;
                    return dim;
                }
                XQEDebugLog.out.println(" Error getting time dimension of cube " + ((ICube)metadata).getName());
                return null;
            }
            case DIMENSION: {
                return (IDimension)metadata;
            }
            case HIERARCHY: {
                return ((IHierarchy)metadata).getDimension();
            }
            case LEVEL: {
                return ((ILevel)metadata).getDimension();
            }
            case MEMBER: {
                return ((IMember)metadata).getDimension();
            }
        }
        return null;
    }
}

