/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.numeric;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.set.Avg;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.util.math.Statistics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MDXAggregateProcessor
implements IMDXFunctionProcessor {
    protected int op;
    protected Double[] ds;
    protected boolean aggregateTime = false;
    protected List<FormatId> operandIds;
    protected int dsIdx = 0;

    @Override
    public void setFunctionCode(int functionCode, int parameterSize) {
        this.op = functionCode;
        this.ds = new Double[parameterSize];
        this.aggregateTime = false;
        this.operandIds = new ArrayList<FormatId>();
        this.dsIdx = 0;
    }

    @Override
    public Object addParameter(InterpreterContext interpreterContext, Object cellValueObj) {
        if (cellValueObj instanceof String) {
            return TextValue.ERROR_VALUE;
        }
        if (cellValueObj instanceof Value) {
            Value v = (Value)cellValueObj;
            if (!v.isNumeric() && v instanceof TimeValue) {
                Calendar calendar = ((TimeValue)v).getCalendar();
                this.ds[this.dsIdx++] = new Double(calendar.getTimeInMillis() + (long)calendar.get(15));
                this.operandIds.add(v.getFormatId());
                this.aggregateTime = true;
            } else {
                if (v.isError()) {
                    return TextValue.ERROR_VALUE;
                }
                if (!v.isNumeric() && this.ds.length == 1) {
                    return v;
                }
                if (!v.isNumeric()) {
                    return TextValue.ERROR_VALUE;
                }
                if (!v.isOK() && !v.isNull()) {
                    DoubleValue resultValue = DataValueFactory.createDoubleValue();
                    resultValue.setState(v.getState());
                    return resultValue;
                }
                this.ds[this.dsIdx++] = v.getDouble();
                this.operandIds.add(v.getFormatId());
            }
        } else {
            this.ds[this.dsIdx++] = (Double)cellValueObj;
            this.operandIds.add(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        }
        return null;
    }

    @Override
    public Object getResult(InterpreterContext interpreterContext) {
        FormatService service = FormatService.getInstance();
        double value = 0.0;
        DoubleValue resultValue = DataValueFactory.createDoubleValue();
        FormatId resultFormatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
        if (this.op == 0) {
            value = Statistics.getSum(this.ds);
            resultFormatId = service.formatResult("Sum", this.operandIds);
        } else if (this.op == 4) {
            value = Statistics.getMean(this.ds);
            resultFormatId = Avg.AvgFormatManager.calculateFormatId(this.operandIds);
        } else if (this.op == 7) {
            value = Statistics.getMedian(this.ds);
            resultFormatId = this.operandIds.get(0);
        } else if (this.op == 2) {
            value = Statistics.getMax(this.ds);
            resultFormatId = this.operandIds.get(0);
        } else if (this.op == 1) {
            value = Statistics.getMin(this.ds);
            resultFormatId = this.operandIds.get(0);
        } else if (this.op == 6) {
            value = Statistics.getStdDev(this.ds);
            resultFormatId = service.formatResult("StandardDeviation", this.operandIds);
        } else if (this.op == 8) {
            value = Statistics.getStdDevP(this.ds);
            resultFormatId = service.formatResult("StandardDeviation", this.operandIds);
        } else if (this.op == 5) {
            value = Statistics.getVariance(this.ds);
            resultFormatId = service.formatResult("Variance", this.operandIds);
        } else if (this.op == 9) {
            value = Statistics.getVarianceP(this.ds);
            resultFormatId = service.formatResult("Variance", this.operandIds);
        }
        if (this.aggregateTime) {
            TimeValue timeValue = DataValueFactory.createTimeValue();
            long offset = timeValue.getCalendar().get(15);
            timeValue.set((long)value - offset);
            timeValue.setFormatId(resultFormatId);
            return timeValue;
        }
        resultValue.setFormatId(resultFormatId);
        ((Value)resultValue).set(value);
        if (Double.isNaN(value)) {
            resultValue.setState(ValueState.DIV_BY_ZERO);
        }
        return resultValue;
    }
}

