/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.numeric;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import java.util.HashMap;
import java.util.TreeSet;

public class Rank
implements Function {
    private static final String RANK_FUNCTION_NAME = "Rank";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return ResultSet.class;
    }

    @Override
    public String getName() {
        return RANK_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block tupleBlock = (Block)parameterFetcher.getParameter(0);
        tupleBlock = Caster.cast(tupleBlock, Tuple.class, interpreterContext, this.getName());
        Block setBlock = (Block)parameterFetcher.getParameter(1);
        Block[] childBlocks = null;
        if (parameterFetcher.getParameterCount() > 2) {
            Block numExpBlock = new Block(interpreterContext, setBlock, parameterFetcher, 2, true, true);
            childBlocks = new Block[]{tupleBlock, setBlock, numExpBlock};
        } else {
            childBlocks = new Block[]{tupleBlock, setBlock};
        }
        Block retBlock = new Block(interpreterContext, childBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Tuple tupleParam = (Tuple)blockObj[0];
            Set setParam = (Set)blockObj[1];
            TreeSet numExpParam = null;
            if (blockObj.length > 2 && (numExpParam = (TreeSet)blockObj[2]) == null) {
                numExpParam = new TreeSet();
            }
            retBlock.add(blockIter, this.rank(tupleParam, setParam, numExpParam));
        }
        return retBlock;
    }

    private Object rank(Tuple tuple, Set set, TreeSet<Cell> values) throws InterpreterException {
        if (tuple.containsNullMember()) {
            return null;
        }
        if (values != null) {
            DoubleValue v;
            Double d;
            Double d2;
            HashMap<Object, Double> valuesToRank = new HashMap<Object, Double>();
            HashMap<ITuple, Comparable<Double>> tupleToRank = new HashMap<ITuple, Comparable<Double>>();
            Double rank = new Double(1.0);
            long tupleOrd = 0L;
            Double emptyTupleRank = new Double(-1.0);
            for (Cell cell : values) {
                Object tieRank;
                for (long i = tupleOrd; i < cell.getOrdinal(); ++i) {
                    ITuple emptyTuple;
                    if (emptyTupleRank == -1.0) {
                        emptyTupleRank = rank;
                    }
                    if (!tupleToRank.containsKey(emptyTuple = set.getTuple(i))) {
                        tupleToRank.put(emptyTuple, emptyTupleRank);
                    }
                    d2 = rank;
                    Double d3 = rank = Double.valueOf(rank + 1.0);
                }
                Object cellValue = cell.getObjectValue();
                ITuple nonEmptyTuple = set.getTuple(cell.getOrdinal());
                if (cellValue instanceof Double || cellValue instanceof NullObject) {
                    if (valuesToRank.containsKey(cellValue)) {
                        if (!tupleToRank.containsKey(nonEmptyTuple)) {
                            tieRank = valuesToRank.get(cellValue);
                            tupleToRank.put(nonEmptyTuple, (Comparable<Double>)tieRank);
                        }
                    } else {
                        valuesToRank.put(cellValue, rank);
                        tupleToRank.put(nonEmptyTuple, rank);
                    }
                } else if (cellValue instanceof Value) {
                    if (ValueState.ERROR == ((Value)cellValue).getState()) {
                        tupleToRank.put(nonEmptyTuple, TextValue.ERROR_VALUE);
                    } else if (valuesToRank.containsKey(cellValue)) {
                        if (!tupleToRank.containsKey(nonEmptyTuple)) {
                            tieRank = valuesToRank.get(cellValue);
                            tupleToRank.put(nonEmptyTuple, (Comparable<Double>)tieRank);
                        }
                    } else {
                        valuesToRank.put(cellValue, rank);
                        tupleToRank.put(nonEmptyTuple, rank);
                    }
                } else {
                    tupleToRank.put(nonEmptyTuple, TextValue.ERROR_VALUE);
                }
                d = rank;
                d2 = rank = Double.valueOf(rank + 1.0);
                tupleOrd = cell.getOrdinal() + 1L;
            }
            for (long i = tupleOrd; i < set.size(); ++i) {
                ITuple emptyTuple;
                if (emptyTupleRank == -1.0) {
                    emptyTupleRank = rank;
                }
                if (!tupleToRank.containsKey(emptyTuple = set.getTuple(i))) {
                    tupleToRank.put(emptyTuple, emptyTupleRank);
                }
                d = rank;
                d2 = rank = Double.valueOf(rank + 1.0);
            }
            Object retVal = tupleToRank.get(tuple);
            if (retVal != null) {
                if (retVal instanceof Double) {
                    v = DataValueFactory.createDoubleValue();
                    ((Value)v).set((Double)retVal);
                    v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    return v;
                }
                return TextValue.ERROR_VALUE;
            }
            v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            return v;
        }
        HashMap<Tuple, long[]> tupleToIndexes = set.getOrdinalsMap(set.getHierarchies());
        long[] rank = tupleToIndexes.get(tuple);
        if (rank != null) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(rank[0] + 1L);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            return v;
        }
        DoubleValue v = DataValueFactory.createDoubleValue();
        ((Value)v).set(0);
        v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        return v;
    }
}

