/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.other;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;

public class CellProperties
implements Function {
    private static final String CELLPROPERTIES_FUNCTION_NAME = "CellProperties";

    @Override
    public Class<?> getSubjectType() {
        return String.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Parameter.values().length;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return CELLPROPERTIES_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        IResultSet rs;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Object oValue = parameterFetcher.getParameter(Parameter.VALUE.ordinal());
        Object o1 = parameterFetcher.getParameter(Parameter.PROPERTY_NAME.ordinal());
        if (!(o1 instanceof String) && !(o1 instanceof Value)) {
            throw new InterpreterException("Invalid second parameter for CellProperties " + o1);
        }
        String propertyName = o1 instanceof Value ? ((Value)o1).getString().toUpperCase() : ((String)o1).toUpperCase();
        if (oValue instanceof Double || oValue instanceof String || oValue instanceof Value) {
            throw new InterpreterException("Invalid first parameter for CellProperties " + oValue);
        }
        if (oValue instanceof TupleValue[]) {
            rs = (ResultSet)Caster.cast(oValue, ResultSet.class);
        } else if (oValue instanceof ResultSet) {
            rs = (ResultSet)oValue;
        } else {
            Set[] sets = (Set[])Caster.cast(oValue, Set[].class);
            SetEvaluator se = new SetEvaluator(interpreterContext);
            se.setNonEmpty(true);
            rs = se.getSetResults(sets[0], new Set(new Tuple[0]));
        }
        rs = ResultSetFactory.ensureInstanceSupportsRandomAccess(rs);
        Long delayedRemovalCellOrdinal = null;
        IResultSetIterator it = rs.iterator();
        while (it.hasNext()) {
            Double propertyValue;
            Cell d = (Cell)it.next();
            if (delayedRemovalCellOrdinal != null) {
                ((ResultSet)rs).removeCell(delayedRemovalCellOrdinal);
                delayedRemovalCellOrdinal = null;
            }
            if ((propertyValue = (Double)d.getCellProperty(propertyName)) != null) {
                d.setValue(propertyValue);
                continue;
            }
            it.remove();
            delayedRemovalCellOrdinal = d.getOrdinal();
        }
        return rs;
    }

    public static enum Parameter {
        PROPERTY_NAME,
        VALUE;

    }
}

