/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.other;

import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.util.primitive.ArrayListLong;
import java.util.ArrayList;

public class CoalesceEmpty
implements Function {
    private static final String COALESCE_EMPTY_FUNCTION = "CoalesceEmpty";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class}, {String.class}, {Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return COALESCE_EMPTY_FUNCTION;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() == 0) {
            return new Block(parameterFetcher.getInterpreterContext(), (Object)null);
        }
        Block retBlock = this.evaluateParameter(0, parameterFetcher);
        return retBlock;
    }

    private Block evaluateParameter(int parameterIndex, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterIndex >= parameterFetcher.getParameterCount()) {
            return null;
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block bThis = (Block)parameterFetcher.getParameter(parameterIndex);
        bThis.getValues(interpreterContext);
        if (bThis.getDefaultValue() != null) {
            return bThis;
        }
        ArrayListLong emptyMap = new ArrayListLong();
        Set emptySet = this.getEmptySet(bThis, emptyMap, interpreterContext);
        if (emptySet.size() == 0L) {
            return bThis;
        }
        interpreterContext.pushPartialContext(bThis, emptySet);
        Block bRest = this.evaluateParameter(parameterIndex + 1, parameterFetcher);
        if (bRest == null) {
            interpreterContext.popContext();
            return bThis;
        }
        bRest.changeToPreviousContext(bThis, emptyMap, false);
        interpreterContext.popContext();
        Block[] childBlocks = new Block[]{bThis, bRest};
        Block retBlock = new Block(interpreterContext, childBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object o = null;
            o = blockObj[0] != null ? blockObj[0] : blockObj[1];
            retBlock.add(blockIter, o);
        }
        return retBlock;
    }

    private Set getEmptySet(Block paramB, ArrayListLong emptyMap, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<Tuple> emptyTuples = new ArrayList<Tuple>();
        Block constBlock = new Block(interpreterContext, 1.0);
        Block[] childBlocks = new Block[]{paramB, constBlock};
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Tuple currTuple = (Tuple)blockIter.getCurrentTuple();
            if (blockObj[0] != null) continue;
            emptyTuples.add(currTuple);
            emptyMap.add(blockIter.pos());
        }
        Set emptySet = new Set(emptyTuples.toArray(new Tuple[emptyTuples.size()]));
        return emptySet;
    }
}

