/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import java.util.ArrayList;

public class Ancestors
implements Function {
    private static final String ANCESTORS_FUNCTION_NAME = "Ancestors";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{IMember.class, Level.class}, {IMember.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return ANCESTORS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block memberParamB = (Block)parameterFetcher.getParameter(0);
        memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext);
        Block distanceParamB = (Block)parameterFetcher.getParameter(1);
        if (!(distanceParamB.first() instanceof Level)) {
            if (distanceParamB.first() instanceof IMember) {
                String paramString = ParameterFetcher.getParameterName(distanceParamB.first());
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPELEVEL, CMP_TYPENUMERIC"});
            }
            distanceParamB.getValues(interpreterContext);
            distanceParamB = Caster.castToInt(distanceParamB, interpreterContext);
        }
        Block[] wrkBlocks = new Block[]{memberParamB, distanceParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set ancestors = this.ancestors((IMember)blockObj[0], blockObj[1], interpreterContext);
            block.add(blockIter, (Object)ancestors);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set ancestors(IMember member, Object distanceParam, InterpreterContext interpreterContext) throws InterpreterException {
        Set resultSet;
        Level level = null;
        int targetLevelIndex = 0;
        int requiredDist = 0;
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        if (distanceParam instanceof Level) {
            level = (Level)distanceParam;
            if (level.getHierarchy() != member.getHierarchy()) {
                throw new InterpreterException("X01490", new String[]{level.getHierarchy().getUniqueName(), this.getName(), member.getHierarchy().getUniqueName()});
            }
            targetLevelIndex = level.getIndex();
        } else {
            if (distanceParam == null) {
                distanceParam = 0;
            }
            if (distanceParam instanceof Value) {
                Value v = (Value)distanceParam;
                if (!v.isNull()) {
                    requiredDist = v.getInteger();
                }
            } else {
                requiredDist = (Integer)distanceParam;
            }
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int distance = 0;
        IMember parent = member;
        boolean bDistanceReached = false;
        if (member instanceof NullMember || level == null && requiredDist < 0 || level != null && targetLevelIndex > member.getLevel().getIndex()) {
            resultSet = new Set(new Tuple[0]);
        } else {
            while (!bDistanceReached && parent != null) {
                if (parent.isExtendedCalculatedMemberWithFormula()) {
                    parent = NullMember.getNullMember(parent);
                }
                if (parent instanceof NullMember || level != null && parent.getLevel().getIndex() == targetLevelIndex || level == null && distance == requiredDist) {
                    bDistanceReached = true;
                    tuples.add(new Tuple(parent));
                    continue;
                }
                if (level != null && parent.getLevel().getIndex() < targetLevelIndex) {
                    bDistanceReached = true;
                    continue;
                }
                parent = MemberOperations.getParentOp(parent.getParent(), false, interpreterContext);
                ++distance;
            }
            resultSet = new Set(tuples.toArray(new Tuple[tuples.size()]));
        }
        return resultSet;
    }
}

