/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import java.util.ArrayList;

public class Ascendants
implements Function {
    private static final String ASCENDANTS_FUNCTION_NAME = "Ascendants";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{IMember.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return ASCENDANTS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block memberParamB = (Block)parameterFetcher.getParameter(0);
        memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext);
        Block[] wrkBlocks = new Block[]{memberParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set ascendantsSet = this.getAncestors((IMember)blockObj[0], interpreterContext);
            block.add(blockIter, (Object)ascendantsSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set getAncestors(IMember m, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        while (m != null && !(m instanceof NullMember)) {
            tuples.add(new Tuple(m));
            m = MemberOperations.getParentOp(m.getParent(), false, interpreterContext);
        }
        Set s = new Set(tuples.toArray(new Tuple[0]));
        return s;
    }
}

