/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.runtree.olap.mdx.functions.BaseSumResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.CellStreamProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.ICellStreamResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.IResultCalculatorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.set.TopSum;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BottomSum
extends TopSum {
    public static final String BOTTOMSUM_FUNCTION_NAME = "BottomSum";

    @Override
    public String getName() {
        return BOTTOMSUM_FUNCTION_NAME;
    }

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    protected boolean isBlockFullyPopulated(CellStreamProcessor streamProcessor) {
        ICellStreamResultCalculator[] resultCalculators;
        for (ICellStreamResultCalculator resultCalculator : resultCalculators = streamProcessor.getResultCalculators()) {
            if (!(resultCalculator instanceof BottomSumCalculator) || !(((BottomSumCalculator)resultCalculator).getUnaccountedForNegatives() < 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IResultCalculatorFactory getCalculatorFactory(InterpreterContext interpreterContext, ICellStreamResultCalculator[] previousResultCalculators) {
        ReverseComparator cellComparator = CellValueComparatorFactory.getComparator(interpreterContext, true);
        cellComparator = new ReverseComparator(cellComparator);
        boolean nullsFirst = NullBehavior.NULL_FIRST.equals((Object)Utilities.getNullBehavior(interpreterContext));
        return new BottomSumCalculatorFactory((Comparator<Object>)cellComparator, previousResultCalculators, nullsFirst);
    }

    private static class NoOpResultCalculator
    implements ICellStreamResultCalculator {
        private NoOpResultCalculator() {
        }

        @Override
        public void processCell(Cell nextCell) {
        }

        @Override
        public Cell[] getResult() {
            return null;
        }

        @Override
        public String getLogMsgText() {
            return "NoOpResultCalculator skipped all values.";
        }
    }

    private static class BottomSumCalculator
    extends BaseSumResultCalculator {
        private double unaccountedForNegatives = 0.0;
        private Cell smallestCell = null;
        private final boolean negativesAccountedForInInitialSum;

        BottomSumCalculator(double sumParam, Comparator<Object> aCellComparator, long aSetSize, double initialCurrentSum, boolean areNullsLargest) {
            super(sumParam, aCellComparator, aSetSize, areNullsLargest);
            this.negativesAccountedForInInitialSum = initialCurrentSum < 0.0;
            this.currentSum = initialCurrentSum;
        }

        @Override
        public void processCell(Cell nextCell) {
            super.trackCell(nextCell);
            if (nextCell.isError()) {
                this.insertValue(nextCell, false);
                return;
            }
            double newCellValue = nextCell.getNumericValue();
            if (!this.negativesAccountedForInInitialSum && newCellValue < 0.0) {
                this.unaccountedForNegatives += newCellValue;
                if (this.smallestCell == null || this.cellComparator.compare(this.smallestCell, nextCell) > 0) {
                    this.smallestCell = nextCell;
                }
                this.allSeenCells = null;
            }
            if (!this.negativesAccountedForInInitialSum && this.unaccountedForNegatives < 0.0) {
                return;
            }
            if (this.negativesAccountedForInInitialSum && newCellValue <= 0.0) {
                this.insertValue(nextCell, false);
            } else if (!this.madeGoalAmount() || this.values.size() == 0) {
                this.insertValue(nextCell, true);
            } else {
                Cell leastDesireableValue = this.getLeastDesireableValue();
                if (this.cellComparator.compare(nextCell, leastDesireableValue) < 0) {
                    this.insertValue(nextCell, true);
                }
            }
        }

        @Override
        public Cell[] getResult() {
            Cell[] bottomSumValues = null;
            if (this.unaccountedForNegatives < 0.0) {
                if (this.smallestCell.getNumericValue() >= this.goalSum) {
                    bottomSumValues = new Cell[]{this.smallestCell};
                }
            } else if (this.values.size() > 0 && this.madeGoalAmount()) {
                SequencedCollection<Object> returnValues = this.values;
                if (!this.nullsLargest) {
                    List<Cell> nullCells = Utilities.getFirstNulls(Integer.MAX_VALUE, false, this.setSize, this.allSeenCells);
                    Cell firstCell = (Cell)this.values.first();
                    if (!firstCell.isError() && firstCell.getNumericValue() > 0.0) {
                        nullCells.addAll(this.values);
                        returnValues = nullCells;
                    } else {
                        for (Cell nullCell : nullCells) {
                            this.processCell(nullCell);
                        }
                    }
                }
                bottomSumValues = returnValues.toArray(new Cell[returnValues.size()]);
            } else {
                bottomSumValues = Utilities.buildEntireSetInSortedOrder(this.setSize, this.allSeenCells, this.cellComparator);
            }
            this.returnedCellCount = bottomSumValues != null ? bottomSumValues.length : -1;
            return bottomSumValues;
        }

        public double getUnaccountedForNegatives() {
            return this.unaccountedForNegatives;
        }
    }

    private class BottomSumCalculatorFactory
    implements IResultCalculatorFactory {
        private Comparator<Object> cellComparator = null;
        private final ICellStreamResultCalculator[] previousResultCalculators;
        private final boolean nullsLargest;

        BottomSumCalculatorFactory(Comparator<Object> aCellComparator, ICellStreamResultCalculator[] aPreviousResultCalculators, boolean aNullsLargest) {
            this.cellComparator = aCellComparator;
            this.previousResultCalculators = aPreviousResultCalculators;
            this.nullsLargest = aNullsLargest;
        }

        @Override
        public ICellStreamResultCalculator createCalculatorForNewContext(Object[] blockObj, int contextId) {
            double unaccountedForNegatives;
            Set s = (Set)blockObj[0];
            double sumParam = TopSum.calcSumParam(blockObj[1]);
            ICellStreamResultCalculator newCalculator = null;
            newCalculator = this.previousResultCalculators == null ? new BottomSumCalculator(sumParam, this.cellComparator, s.size(), 0.0, this.nullsLargest) : ((unaccountedForNegatives = ((BottomSumCalculator)this.previousResultCalculators[contextId]).getUnaccountedForNegatives()) < 0.0 ? new BottomSumCalculator(sumParam, this.cellComparator, s.size(), unaccountedForNegatives, this.nullsLargest) : new NoOpResultCalculator());
            return newCalculator;
        }
    }
}

