/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import java.util.ArrayList;

public class Crossjoin
implements Function {
    private static final String CROSSJOIN_FUNCTION_NAME = "Crossjoin";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return CROSSJOIN_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block set1ParamB = (Block)parameterFetcher.getParameter(0);
        set1ParamB = Caster.cast(set1ParamB, Set.class, interpreterContext);
        Block set2ParamB = (Block)parameterFetcher.getParameter(1);
        set2ParamB = Caster.cast(set2ParamB, Set.class, interpreterContext);
        Block[] wrkBlocks = new Block[]{set1ParamB, set2ParamB};
        boolean sparseIterator = true;
        Set set1DefaultValue = (Set)set1ParamB.getDefaultValue();
        Set set2DefaultValue = (Set)set2ParamB.getDefaultValue();
        if (!set1ParamB.isConstant() && set2DefaultValue != null && !set2DefaultValue.isEmpty() || !set2ParamB.isConstant() && set1DefaultValue != null && !set1DefaultValue.isEmpty()) {
            sparseIterator = false;
        }
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks, sparseIterator);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set cjSet = this.crossjoinSets((Set)blockObj[0], (Set)blockObj[1]);
            block.add(blockIter, (Object)cjSet);
        }
        if (block.hasEmptyCells()) {
            if (set1ParamB.isConstant() && set2ParamB.getDefaultValue() != null) {
                block.setDefaultValue(this.crossjoinSets((Set)set1ParamB.first(), (Set)set2ParamB.getDefaultValue()));
            } else if (set2ParamB.isConstant() && set1ParamB.getDefaultValue() != null) {
                block.setDefaultValue(this.crossjoinSets((Set)set1ParamB.getDefaultValue(), (Set)set2ParamB.first()));
            } else if (set1ParamB.getDefaultValue() != null && set2ParamB.getDefaultValue() != null) {
                block.setDefaultValue(this.crossjoinSets((Set)set1ParamB.getDefaultValue(), (Set)set2ParamB.getDefaultValue()));
            } else {
                block.setDefaultValue(new Set(new Tuple[0]));
            }
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set crossjoinSets(Set s1, Set s2) throws InterpreterException {
        CrossJoinedSet crossjoinedSet;
        if (s1.isEmpty() || s2.isEmpty()) {
            crossjoinedSet = new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
        } else {
            IHierarchy[] s1Hiers = s1.getHierarchies();
            IHierarchy[] s2Hiers = s2.getHierarchies();
            s1 = s1.removeNullMembers();
            s2 = s2.removeNullMembers();
            if (s1.isEmpty() || s2.isEmpty()) {
                int dimIdx;
                IMember[] nullMembers = new IMember[s1Hiers.length];
                ArrayList<Set> crossjoinSets = new ArrayList<Set>();
                if (s1Hiers.length > 0) {
                    for (dimIdx = 0; dimIdx < s1Hiers.length; ++dimIdx) {
                        nullMembers[dimIdx] = NullMember.getNullMember(s1Hiers[dimIdx]);
                    }
                    crossjoinSets.add(new Set(new Tuple(nullMembers)));
                }
                nullMembers = new IMember[s2Hiers.length];
                if (s2Hiers.length > 0) {
                    for (dimIdx = 0; dimIdx < s2Hiers.length; ++dimIdx) {
                        nullMembers[dimIdx] = NullMember.getNullMember(s2Hiers[dimIdx]);
                    }
                    crossjoinSets.add(new Set(new Tuple(nullMembers)));
                }
                crossjoinedSet = crossjoinSets.size() > 0 ? new CrossJoinedSet(crossjoinSets.toArray(new Set[0])) : new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
            } else {
                crossjoinedSet = new CrossJoinedSet(new Set[]{s1, s2});
            }
        }
        return crossjoinedSet;
    }
}

