/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.ast.olap.util.DescendantsRangeFlagEnum;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.ArrayList;

public class Descendants
implements Function {
    private static final String DESCENDANTS_FUNCTION_NAME = "Descendants";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{IMember.class}, {IMember.class, Level.class}, {IMember.class, Level.class, String.class}, {IMember.class, Double.class}, {IMember.class, Double.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return DESCENDANTS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        ArrayList<Block> paramBlocks = new ArrayList<Block>();
        paramBlocks.add(setParamB);
        boolean haveDistanceParam = false;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 1) {
            Block distanceParamB = (Block)parameterFetcher.getParameter(1);
            if (distanceParamB != null) {
                haveDistanceParam = true;
                if (!(distanceParamB.first() instanceof Level)) {
                    distanceParamB.getValues(interpreterContext);
                    distanceParamB = Caster.castToInt(distanceParamB, interpreterContext);
                }
                paramBlocks.add(distanceParamB);
            }
            if (paramCount > 2) {
                Block descFlagParamB = (Block)parameterFetcher.getParameter(2);
                paramBlocks.add(descFlagParamB);
            }
        }
        Block[] wrkBlocks = paramBlocks.toArray(new Block[0]);
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set setParam = (Set)blockObj[0];
            Object distanceParam = null;
            String descFlagParam = null;
            if (haveDistanceParam) {
                distanceParam = blockObj[1];
                if (blockObj.length > 2) {
                    descFlagParam = ((Value)blockObj[2]).getString();
                }
            } else if (blockObj.length > 1) {
                descFlagParam = ((Value)blockObj[1]).getString();
            }
            Set descendants = this.descendants(setParam, haveDistanceParam, distanceParam, DescendantsRangeFlagEnum.getIntFlag(descFlagParam), interpreterContext);
            block.add(blockIter, (Object)descendants);
        }
        block.removeInvalidTuples();
        return block;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set descendants(Set set, boolean haveDistanceParam, Object distanceParam, int descFlag, InterpreterContext interpreterContext) throws InterpreterException {
        if (set.getHierarchyCount() > 1) {
            throw new InterpreterException("X01482", new String[]{this.getName()}, 1L);
        }
        if (haveDistanceParam && distanceParam == null) {
            distanceParam = 0;
        }
        ResourceMonitor.checkMaxSetSize(set.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        Set[] descSets = new Set[(int)set.size()];
        int i = 0;
        while ((long)i < set.size()) {
            IMember member = set.getTuple(i).getMember(0);
            if (member instanceof NullMember) {
                descSets[i] = new Set(new Tuple(member));
            } else {
                IMemberCubics memberCubics = (IMemberCubics)MemberOperations.getOriginalCalculatedMember(member);
                ArrayList<IMember> descList = new ArrayList<IMember>();
                try {
                    if (haveDistanceParam) {
                        if (distanceParam instanceof Integer) {
                            if (descFlag == -1) {
                                descFlag = 0;
                            }
                            MemberOperations.getDescendantsOp(memberCubics, (Integer)distanceParam, descFlag, false, descList, interpreterContext);
                        } else if (distanceParam instanceof Value) {
                            if (descFlag == -1) {
                                descFlag = 0;
                            }
                            int distance = 0;
                            Value v = (Value)distanceParam;
                            if (!v.isNull()) {
                                distance = v.getInteger();
                            }
                            boolean includeFillerMembers = false;
                            if (member instanceof ROLAPRelativeTimeMember) {
                                includeFillerMembers = ((ROLAPRelativeTimeMember)member).isCustomRollingTotalMember();
                            }
                            MemberOperations.getDescendantsOp(memberCubics, distance, descFlag, includeFillerMembers, descList, interpreterContext);
                        } else {
                            if (!(distanceParam instanceof Level)) throw new InterpreterException("X01490", new String[]{ParameterFetcher.getParameterName(distanceParam), this.getName(), "CMP_TYPENUMERIC, CMP_TYPELEVEL"});
                            descList = MemberOperations.getDescendantsOp(memberCubics, (Level)distanceParam, descFlag, true, interpreterContext);
                        }
                    } else if (descFlag == -1) {
                        MemberOperations.getDescendantsOp(memberCubics, 0, 4, true, descList, interpreterContext);
                    } else {
                        MemberOperations.getDescendantsOp(memberCubics, Integer.MAX_VALUE, descFlag, false, descList, interpreterContext);
                    }
                    descSets[i] = new Set(Tuple.createTupleList(descList.toArray(new IMember[0])));
                }
                catch (MetadataException e) {
                    throw new InterpreterException("X01494", new String[]{member.getName(), e.toString()}, e);
                }
                IHierarchy hier = member.getHierarchy();
                if (hier instanceof IROLAPHierarchy && hier.getDimension().isTimeDimension() && (member == ((IROLAPHierarchy)hier).getROLAPAllMember() || member instanceof ROLAPRelativeTimeMember) && descFlag == 4) {
                    descSets[i].setRelativeTimeAncestorObject(member);
                }
            }
            ++i;
        }
        return Set.union(descSets, true);
    }
}

