/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;

public class DrillDownLevel
implements Function {
    private static final String DRILLDOWNLEVEL_FUNCTION_NAME = "DrillDownLevel";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class}, {Set.class, Level.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return DRILLDOWNLEVEL_FUNCTION_NAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        XQEDebugLog.out.println(this.getName());
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        ArrayList<Block> wrkBlocks = new ArrayList<Block>();
        Block setB = (Block)parameterFetcher.getParameter(0);
        setB = Caster.cast(setB, Set.class, interpreterContext, this.getName());
        wrkBlocks.add(setB);
        int paramCount = parameterFetcher.getParameterCount();
        Block levelParamB = null;
        if (paramCount > 1) {
            levelParamB = (Block)parameterFetcher.getParameter(1);
            if (levelParamB == null) {
                levelParamB = new Block(interpreterContext, (Object)null);
            }
            wrkBlocks.add(levelParamB);
        }
        Block dimIdxParamB = null;
        if (paramCount > 2) {
            dimIdxParamB = (Block)parameterFetcher.getParameter(2);
            dimIdxParamB.getValues(interpreterContext);
            wrkBlocks.add(dimIdxParamB);
        }
        Block[] blockArray = wrkBlocks.toArray(new Block[0]);
        Block block = new Block(interpreterContext, blockArray);
        BlockIterator blockIter = new BlockIterator(blockArray);
        while (true) {
            int hierIndex;
            if (!blockIter.hasNext()) {
                block.removeInvalidTuples();
                return block;
            }
            Object[] blockObj = (Object[])blockIter.next();
            Set set = (Set)blockObj[0];
            if (set.isEmpty()) {
                block.add(blockIter, (Object)new Set(new Tuple[0]));
                continue;
            }
            Level drillLevel = null;
            if (paramCount > 1) {
                if (blockObj[1] instanceof Level) {
                    drillLevel = (Level)blockObj[1];
                } else if (blockObj[0] instanceof IMember) {
                    drillLevel = (Level)((IMember)blockObj[1]).getLevel();
                }
            }
            if (drillLevel != null) {
                hierIndex = set.getHierarchyIndex(drillLevel.getHierarchy());
                if (hierIndex < 0) {
                    throw new InterpreterException("X01456", new String[]{drillLevel.getHierarchy().getName()});
                }
                set = set.drillDownLevel(drillLevel, hierIndex);
            } else if (blockObj.length > 2 && blockObj[2] != null) {
                block23: {
                    if (blockObj[2] instanceof Double) {
                        hierIndex = ((Double)blockObj[2]).intValue();
                    } else if (blockObj[2] instanceof Integer) {
                        hierIndex = (Integer)blockObj[2];
                    } else {
                        if (blockObj[2] instanceof Value) {
                            Value v = (Value)blockObj[2];
                            if (!v.isNull()) {
                                hierIndex = v.getInteger();
                                break block23;
                            } else {
                                set = set.drillDownLevel();
                                continue;
                            }
                        }
                        set = set.drillDownLevel();
                        continue;
                    }
                }
                if (hierIndex >= 0 && set.size() > 0L && hierIndex < set.getTuple(0L).size()) {
                    set = set.drillDownLevelByHierarchyIndex(hierIndex);
                }
            } else {
                set = set.drillDownLevel();
            }
            block.add(blockIter, (Object)set);
        }
    }
}

