/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import java.util.ArrayList;

public class DrillDownLevelTop
implements Function {
    private static final String DRILL_DOWN_LEVEL_TOP = "DrillDownLevelTop";
    private static final int NUMBER_3 = 3;

    @Override
    public String getName() {
        return DRILL_DOWN_LEVEL_TOP;
    }

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext, this.getName());
        Block countParamB = (Block)parameterFetcher.getParameter(1);
        if (countParamB == null) {
            throw new InterpreterException("X01490", new String[]{"NULL", this.getName(), "CMP_TYPENUMERIC"});
        }
        countParamB.getValues(interpreterContext);
        Block levelParamB = null;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 2 && (levelParamB = (Block)parameterFetcher.getParameter(2)) == null) {
            levelParamB = new Block(interpreterContext, (Object)null);
        }
        Block[] wrkBlocks = null;
        wrkBlocks = paramCount > 2 ? new Block[]{setParamB, countParamB, levelParamB} : new Block[]{setParamB, countParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object drillLevel = null;
            if (paramCount > 2) {
                drillLevel = blockObj[2];
            }
            Set drilledSet = this.drillDownLevelTop(parameterFetcher, blockObj[0], blockObj[1], drillLevel);
            block.add(blockIter, (Object)drilledSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set drillDownLevelTop(ParameterFetcher parameterFetcher, Object setParam, Object countParam, Object drillLevelParam) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Set set = (Set)Caster.cast(setParam, Set.class, interpreterContext, this.getName());
        if (set.isEmpty()) {
            return new Set(new Tuple[0]);
        }
        double count = 0.0;
        if (countParam == null || countParam == NullObject.instance() || countParam instanceof Number || countParam instanceof Boolean) {
            count = parameterFetcher.getInterpreterContext().getDoubleOperand(countParam);
        } else if (countParam instanceof Value) {
            Value v = (Value)countParam;
            count = v.isNull() ? 0.0 : v.getDouble();
        } else {
            String countString = ParameterFetcher.getParameterName(countParam);
            throw new InterpreterException("X01490", new String[]{countString, this.getName(), "CMP_TYPENUMERIC"});
        }
        if (count > Double.MAX_VALUE) {
            throw new InterpreterException("X01490", new String[]{count + "", this.getName(), "<= 1.7976931348623157E308"});
        }
        Level drillLevel = null;
        if (drillLevelParam != null && drillLevelParam != NullObject.instance() && !(drillLevelParam instanceof Level)) {
            String paramString = ParameterFetcher.getParameterName(drillLevelParam);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPELEVEL"});
        }
        drillLevel = (Level)drillLevelParam;
        if (drillLevel != null && !set.contains(drillLevel.getHierarchy())) {
            throw new InterpreterException("X01456", new String[]{drillLevel.getHierarchy().getName()});
        }
        Set retSet = this.rank(set, drillLevel, (int)count, parameterFetcher);
        return retSet;
    }

    Set rank(Set set, Level level, int count, ParameterFetcher paramFetcher) throws InterpreterException {
        IHierarchy drillDownHier;
        if (level != null) {
            drillDownHier = level.getHierarchy();
        } else {
            level = set.getLowestLevel(0);
            drillDownHier = level.getHierarchy();
        }
        ArrayList<IMember> drillDownMembers = new ArrayList<IMember>();
        int drillDownHierIdx = set.getHierarchyIndex(drillDownHier);
        int i = 0;
        while ((long)i < set.size()) {
            IMember setMember = set.getTuple(i).getMember(drillDownHierIdx);
            if (setMember.getLevel() == level) {
                drillDownMembers.add(setMember);
            }
            ++i;
        }
        boolean drillTop = this.getName().equals(DRILL_DOWN_LEVEL_TOP);
        int paramCount = paramFetcher.getParameterCount();
        int paramIdx = 3;
        if (paramCount <= 3) {
            paramIdx = Integer.MAX_VALUE;
        }
        Set drillDownSet = new Set(Tuple.createTupleList(drillDownMembers.toArray(new IMember[0])));
        return set.drillDownMemberTopOrBottom(drillDownSet, count, paramFetcher, paramIdx, drillTop, false);
    }
}

