/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.HeadTailPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;

public class Head
implements Function {
    public static final String HEAD_FUNCTION_NAME = "Head";
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return HEAD_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 2) {
            throw new InterpreterException("X01517", new String[]{"1, 2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        boolean pushdown = this.isPushdown(interpreterContext);
        if (pushdown) {
            pushdown = HeadTailPushdownUtility.configurePushdown(parameterFetcher, this.getName());
        }
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block countParamB = null;
        countParamB = paramCount == 2 ? (Block)parameterFetcher.getParameter(1) : new Block(interpreterContext, new Integer(1));
        countParamB.getValues(interpreterContext);
        countParamB = Caster.castToInt(countParamB, interpreterContext);
        Block[] childBlocks = new Block[]{setParamB, countParamB};
        Block retBlock = new Block(interpreterContext, childBlocks);
        BlockIterator blockIter = new BlockIterator(childBlocks);
        pushdown = PushdownManager.isPushdownExecutionFinished(interpreterContext);
        if (pushdown) {
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Set headSet = (Set)blockObj[0];
                retBlock.add(blockIter, (Object)headSet);
            }
        } else {
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Set aSet = (Set)blockObj[0];
                aSet = aSet.removeNullMembers();
                Set headSet = this.doExecute(aSet, blockObj[1]);
                retBlock.add(blockIter, (Object)headSet);
            }
        }
        if (pushdown) {
            PushdownManager.resetPushdownContext(interpreterContext);
        }
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    public Set doExecute(Set set, Object countParam) throws InterpreterException {
        if (set == null) {
            return set;
        }
        long count = 0L;
        if (countParam != null) {
            if (countParam instanceof Value) {
                Value v = (Value)countParam;
                if (!(v.isNull() || v.isError() || v.isDivByZero())) {
                    count = v.getLong();
                }
            } else {
                count = ((Integer)countParam).intValue();
            }
        }
        return (Set)set.head(count);
    }

    private boolean isPushdown(InterpreterContext interpreterContext) {
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        boolean pushdown = false;
        if (dataSource != null && dataSource.isRelational()) {
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
            pushdown = providerCapabilities.isSupported("pushdownHeadTailToRelational");
        }
        return pushdown;
    }
}

