/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ComplexTupleValueComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.KeyWord;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SimpleTupleValueComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SortedTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;

public class Order
implements Function {
    private static final String ORDER_FUNCTION_NAME = "Order";
    private static final String NULLS_FRIST = " NULLS first'";
    private static final String NULLS_LAST = " NULLS last'";
    private static final int NUMBER_3 = 3;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return ORDER_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        boolean ascending = true;
        boolean breakHierarchy = false;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        NullBehavior nullHandling = NullBehavior.ZERO_FIRST;
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            nullHandling = NullBehavior.getDataSourceNullOrderBehavior(capabilities, NullBehavior.ZERO_FIRST);
        }
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        if (parameterFetcher.getParameterCount() > 2) {
            Block modeParamB = (Block)parameterFetcher.getParameter(2);
            Object modeParamFirstObj = modeParamB.first();
            String mode = null;
            if (modeParamFirstObj instanceof Value) {
                Value v = (Value)modeParamFirstObj;
                if (!v.isNull() && (mode = v.getString()) != null) {
                    int pos = mode.indexOf(NULLS_FRIST);
                    if (pos != -1) {
                        nullHandling = NullBehavior.NULL_FIRST;
                        mode = mode.substring(1, pos);
                    } else {
                        pos = mode.indexOf(NULLS_LAST);
                        if (pos != -1) {
                            nullHandling = NullBehavior.NULL_LAST;
                            mode = mode.substring(1, pos);
                        }
                    }
                }
            } else {
                mode = modeParamFirstObj instanceof KeyWord ? ((KeyWord)modeParamFirstObj).toString() : (String)modeParamFirstObj;
            }
            if (mode != null) {
                if (mode.equalsIgnoreCase("DESC")) {
                    ascending = false;
                } else if (mode.equalsIgnoreCase("BASC")) {
                    breakHierarchy = true;
                } else if (mode.equalsIgnoreCase("BDESC")) {
                    ascending = false;
                    breakHierarchy = true;
                }
            }
        }
        Collator collator = interpreterContext.getXDataContext().getLocalCollator();
        if (breakHierarchy) {
            Block numExprB = new Block(interpreterContext, setParamB, parameterFetcher, 1, true, true, false, false);
            Block[] childBlocks = new Block[]{setParamB, numExprB};
            Block retBlock = new Block(interpreterContext, childBlocks);
            IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Set s = (Set)blockObj[0];
                TreeSet v = (TreeSet)blockObj[1];
                TupleValue[] sortedTupleValues = this.sortByTreeSet(s, v, breakHierarchy, collator, ascending, nullHandling, interpreterContext);
                Set orderedSet = this.createSetFromSortedTupleValues(s, sortedTupleValues);
                retBlock.add(blockIter, (Object)orderedSet);
            }
            return retBlock;
        }
        Block[] childBlocks = new Block[]{setParamB};
        Block modSetB = new Block(interpreterContext, childBlocks);
        Block ttpcB = new Block(interpreterContext, childBlocks);
        IBlockIterator blockIter = setParamB.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set s = (Set)blockObj[0];
            ArrayList<Object> al = this.getModSet(s, interpreterContext);
            modSetB.add(blockIter, al.get(0));
            ttpcB.add(blockIter, al.get(1));
        }
        Block numExprB = new Block(interpreterContext, modSetB, parameterFetcher, 1, true, true, false, false);
        childBlocks = new Block[]{setParamB, modSetB, numExprB, ttpcB};
        Block retBlock = new Block(interpreterContext, childBlocks);
        blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set s = (Set)blockObj[0];
            Set modSet = (Set)blockObj[1];
            TreeSet v = (TreeSet)blockObj[2];
            HashMap ttpc = (HashMap)blockObj[3];
            TupleValue[] sortedTupleValues = this.sortByTreeSet(modSet, v, breakHierarchy, collator, ascending, nullHandling, interpreterContext);
            if (sortedTupleValues == null) {
                Set orderedSet = new Set(s.hierarchize());
                retBlock.add(blockIter, (Object)new Set(orderedSet));
                continue;
            }
            ArrayList<TupleValue> al = new ArrayList<TupleValue>();
            for (int i = 0; i < sortedTupleValues.length; ++i) {
                TupleValue tv = sortedTupleValues[i];
                Integer reps = (Integer)ttpc.get(tv.getTuple());
                if (reps == null) continue;
                int countRepeats = reps;
                for (int r = 0; r < countRepeats; ++r) {
                    al.add(tv);
                }
            }
            sortedTupleValues = al.toArray(new TupleValue[0]);
            ITuple[] sortedTuples = new Tuple[sortedTupleValues.length];
            for (int i = 0; i < sortedTupleValues.length; ++i) {
                sortedTuples[i] = sortedTupleValues[i].getTuple();
            }
            Set orderedSet = new Set(sortedTuples);
            retBlock.add(blockIter, (Object)new Set(orderedSet));
        }
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    public Set createSetFromSortedTupleValues(Set s, TupleValue[] sortedTupleValues) {
        Set orderedSet = null;
        if (sortedTupleValues == null) {
            orderedSet = s;
        } else {
            long[] orderMap = new long[sortedTupleValues.length];
            for (int i = 0; i < sortedTupleValues.length; ++i) {
                orderMap[i] = sortedTupleValues[i].getCell().getOrdinal();
            }
            ITupleList tl = SortedTupleList.construct(s.getTupleList(), orderMap);
            orderedSet = new Set(tl);
        }
        return orderedSet;
    }

    private ArrayList<Object> getModSet(Set s, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<Object> retArrayList = new ArrayList<Object>();
        HashMap<ITuple, Integer> tupleToRepeatCount = null;
        Set ms = null;
        if (s.size() == 0L) {
            ms = s;
        } else {
            tupleToRepeatCount = new HashMap<ITuple, Integer>();
            IIterator iit = s.iterator();
            while (iit.hasNext()) {
                ITuple tup = (ITuple)((ITuple)iit.next()).copy();
                Integer reps = (Integer)tupleToRepeatCount.get(tup);
                reps = reps == null ? XQEIntegerPool.getInteger(1) : XQEIntegerPool.getInteger(reps + 1);
                tupleToRepeatCount.put(tup, reps);
            }
            IHierarchy[] hiers = s.getHierarchies();
            HashSet<IMember>[] selections = s.selectionsInHierarchies(hiers);
            ISet[] sets = new Set[hiers.length];
            for (int i = 0; i < hiers.length; ++i) {
                HashSet<IMember> mems = selections[i];
                HashSet<IMember> newMems = new HashSet<IMember>();
                for (IMember m : mems) {
                    IMember parent = MemberOperations.getParentOp(m.getParent(), false, interpreterContext);
                    while (parent != null) {
                        if (!newMems.contains(parent) && !mems.contains(parent)) {
                            newMems.add(parent);
                        }
                        parent = MemberOperations.getParentOp(parent.getParent(), false, interpreterContext);
                    }
                }
                mems.addAll(newMems);
                sets[i] = new Set(Tuple.createTupleList(mems.toArray(new IMember[0])));
                sets[i] = ((Set)sets[i]).hierarchize();
            }
            ms = new CrossJoinedSet(sets);
        }
        retArrayList.add(ms);
        retArrayList.add(tupleToRepeatCount);
        return retArrayList;
    }

    protected TupleValue[] sortByTreeSet(ISet setToBeOrdered, TreeSet<Cell> rs, boolean breakHierarchy, Collator collator, boolean ascending, NullBehavior nullHandling, InterpreterContext interpreterContext) throws InterpreterException {
        if (rs == null || rs.size() == 0) {
            return null;
        }
        TupleValue[] tupleValuesToSort = Order.createTupleValues(setToBeOrdered, rs, interpreterContext);
        Comparator<Object> c = Order.getComparator(breakHierarchy, collator, ascending, nullHandling, tupleValuesToSort);
        Arrays.sort(tupleValuesToSort, c);
        return tupleValuesToSort;
    }

    protected static TupleValue[] createTupleValues(ISet set, TreeSet<Cell> resultSet, InterpreterContext interpreterContext) {
        TupleValue tupleValue;
        Tuple setTuple = null;
        int tupleOrd = 0;
        ResourceMonitor.checkMaxSetSize(set.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        TupleValue[] tupleValues = new TupleValue[(int)set.size()];
        IIterator setIter = ((Set)set).iterator();
        while (setIter.hasNext()) {
            setTuple = (Tuple)((ITuple)setIter.next()).copy();
            DoubleValue v = DataValueFactory.createDoubleValue();
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            Cell cell = new Cell(tupleOrd, v);
            tupleValue = new TupleValue(setTuple, cell);
            tupleValues[tupleOrd] = new TupleValue(setTuple, cell);
            ++tupleOrd;
        }
        for (Cell cell : resultSet) {
            setTuple = (Tuple)set.getTuple(cell.getOrdinal());
            tupleValues[(int)cell.getOrdinal()] = tupleValue = new TupleValue(setTuple, cell);
        }
        return tupleValues;
    }

    protected static Comparator<Object> getComparator(boolean breakHierarchy, Collator collator, boolean ascending, NullBehavior nullHandling, TupleValue[] tupleValuesToSort) {
        Comparator<Object> c;
        if (breakHierarchy) {
            c = new SimpleTupleValueComparator(collator, ascending, nullHandling);
            if (ascending) {
                c = new ReverseComparator((Comparator)c);
            }
        } else {
            HashMap<Tuple, TupleValue> tupleToValue = new HashMap<Tuple, TupleValue>();
            for (int k = 0; k < tupleValuesToSort.length; ++k) {
                tupleToValue.put(tupleValuesToSort[k].getTuple(), tupleValuesToSort[k]);
            }
            c = new ComplexTupleValueComparator(collator, tupleToValue, ascending, nullHandling);
        }
        return c;
    }
}

