/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.BaseSumResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.CellStreamProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.ICellStreamResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.IResultCalculatorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.CacheableFunction;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.TopBottomCountPushdownUtility;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;

public class TopSum
extends CacheableFunction {
    public static final String TOPSUM_FUNCTION_NAME = "TopSum";
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return TOPSUM_FUNCTION_NAME;
    }

    @Override
    public Object executeImpl(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        boolean pushdown = false;
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            pushdown = capabilities.getStringValue("pushdownTopPercentSumToRelational", STR_FALSE).equalsIgnoreCase(STR_TRUE);
        }
        interpreterContext.getContextSet();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block maxValueParamB = (Block)parameterFetcher.getParameter(1);
        maxValueParamB.getValues(interpreterContext);
        if (pushdown) {
            pushdown = TopBottomCountPushdownUtility.configurePushdown(setParamB, maxValueParamB, parameterFetcher, this.getName());
        }
        Block retBlock = null;
        ICellStreamResultCalculator[] previousResultCalculators = null;
        int numPass = 0;
        boolean retBlockFullyPopulated = false;
        while (!retBlockFullyPopulated) {
            Block numExpParamB = null;
            boolean prev = interpreterContext.getResultSetConfiguration().setIncrementalContextCells(true);
            numExpParamB = parameterFetcher.getParameterCount() > 2 ? new Block(interpreterContext, setParamB, parameterFetcher, 2, true, true) : new Block(interpreterContext, setParamB, null, 0, true, true);
            interpreterContext.getResultSetConfiguration().setIncrementalContextCells(prev);
            Block[] childBlocks = new Block[]{setParamB, maxValueParamB, numExpParamB};
            if (retBlock == null) {
                retBlock = new Block(interpreterContext, childBlocks);
            }
            IBlockIterator blockIter = Block.getStreamingBlockIterator(childBlocks, 2);
            IResultCalculatorFactory calculatorFactory = this.getCalculatorFactory(interpreterContext, previousResultCalculators);
            CellStreamProcessor streamProcessor = new CellStreamProcessor(calculatorFactory);
            streamProcessor.processAllCells(blockIter, retBlock, 0, 2);
            retBlockFullyPopulated = this.isBlockFullyPopulated(streamProcessor);
            previousResultCalculators = streamProcessor.getResultCalculators();
            ++numPass;
            if (!XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).isOn(LogLevel.INFO)) continue;
            String msg = CellStreamProcessor.generateLogMsg(this.getName(), previousResultCalculators, numPass);
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log(msg);
        }
        retBlock.removeInvalidTuples();
        PushdownManager.resetPushdownContext(interpreterContext);
        return retBlock;
    }

    protected boolean isBlockFullyPopulated(CellStreamProcessor streamProcessor) {
        return true;
    }

    protected static double calcSumParam(Object blockSumParam) {
        double maxValue = 0.0;
        if (blockSumParam != null) {
            if (blockSumParam instanceof Value) {
                Value v = (Value)blockSumParam;
                if (!v.isNull()) {
                    maxValue = v.getDouble();
                }
            } else {
                maxValue = (Double)blockSumParam;
            }
        }
        return maxValue;
    }

    protected IResultCalculatorFactory getCalculatorFactory(InterpreterContext interpreterContext, ICellStreamResultCalculator[] previousResultCalculators) {
        Comparator<Object> cellComparator = CellValueComparatorFactory.getComparator(interpreterContext, true);
        boolean nullsFirst = NullBehavior.NULL_FIRST.equals((Object)Utilities.getNullBehavior(interpreterContext));
        return new TopSumCalculatorFactory(cellComparator, nullsFirst);
    }

    private static class TopSumCalculator
    extends BaseSumResultCalculator {
        TopSumCalculator(double sumParam, Comparator<Object> aCellComparator, long aSetSize, boolean areNullsLargest) {
            super(sumParam, aCellComparator, aSetSize, areNullsLargest);
        }

        @Override
        public void processCell(Cell nextCell) {
            super.trackCell(nextCell);
            if (nextCell.isError()) {
                return;
            }
            double newCellValue = nextCell.getNumericValue();
            if (this.values.size() == 0) {
                if (newCellValue > 0.0 || this.goalSum <= 0.0 && newCellValue >= this.goalSum) {
                    this.insertValue(nextCell);
                }
            } else if (!this.madeGoalAmount()) {
                if (newCellValue > 0.0) {
                    this.insertValue(nextCell);
                }
            } else {
                Cell leastDesireableValue = this.getLeastDesireableValue();
                if (this.cellComparator.compare(nextCell, leastDesireableValue) < 0) {
                    this.insertValue(nextCell);
                }
            }
        }

        protected void insertValue(Cell cell) {
            if (this.goalSum > 0.0) {
                super.insertValue(cell, true);
                if (this.madeGoalAmount() && !this.nullsLargest) {
                    this.allSeenCells = null;
                }
            } else {
                this.insertSingleValueAsEntireAnswer(cell);
                if (this.currentSum > 0.0 && !this.nullsLargest) {
                    this.allSeenCells = null;
                }
            }
        }

        @Override
        public Cell[] getResult() {
            Cell[] topSumValues = null;
            if (this.madeGoalAmount()) {
                SequencedCollection<Object> returnValues = this.values;
                if (this.currentSum <= 0.0) {
                    List<Cell> nullCells = Utilities.getFirstNulls(1, true, this.setSize, this.allSeenCells);
                    if (nullCells.size() > 0) {
                        this.processCell(nullCells.get(0));
                    }
                } else if (this.nullsLargest) {
                    List<Cell> nullCells = Utilities.getFirstNulls(Integer.MAX_VALUE, true, this.setSize, this.allSeenCells);
                    nullCells.addAll(this.values);
                    returnValues = nullCells;
                }
                topSumValues = returnValues.toArray(new Cell[returnValues.size()]);
            } else {
                topSumValues = Utilities.buildEntireSetInSortedOrder(this.setSize, this.allSeenCells, this.cellComparator);
            }
            this.returnedCellCount = topSumValues.length;
            return topSumValues;
        }
    }

    private class TopSumCalculatorFactory
    implements IResultCalculatorFactory {
        private Comparator<Object> cellComparator = null;
        private final boolean nullsLargest;

        TopSumCalculatorFactory(Comparator<Object> aCellComparator, boolean aNullsLargest) {
            this.cellComparator = aCellComparator;
            this.nullsLargest = aNullsLargest;
        }

        @Override
        public ICellStreamResultCalculator createCalculatorForNewContext(Object[] blockObj, int contextId) {
            Set s = (Set)blockObj[0];
            double sumParam = TopSum.calcSumParam(blockObj[1]);
            return new TopSumCalculator(sumParam, this.cellComparator, s.size(), this.nullsLargest);
        }
    }
}

