/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.string;

import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternMatches
implements Function {
    private static final String PATTERNMATCHES_FUNCTION_NAME = "PatternMatches";
    Pattern curPattern = null;

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, String.class}, {Double.class, String.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return PATTERNMATCHES_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        b1.cast(String.class);
        Block b2 = (Block)parameterFetcher.getParameter(1);
        b2.getValues(interpreterContext);
        b2.cast(String.class);
        Block[] wrkBlocks = new Block[]{b1, b2};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object patterMatch = this.patternMatches(blockObj[0], blockObj[1]);
            block.add(blockIter, patterMatch, "0.0");
        }
        return block;
    }

    private Object patternMatches(Object param1, Object param2) throws InterpreterException {
        Value v;
        if (param1 == null || param1 == NullObject.instance() || param2 == null || param2 == NullObject.instance()) {
            return null;
        }
        if (param1 instanceof Double) {
            param1 = String.valueOf((Double)param1);
        }
        if (param2 instanceof Double) {
            param2 = String.valueOf((Double)param2);
        }
        String str1 = null;
        String str2 = null;
        if (param1 instanceof String) {
            str1 = (String)param1;
        } else if (param1 instanceof Value) {
            v = (Value)param1;
            if (!v.isNull()) {
                str1 = v.getString();
            } else {
                return null;
            }
        }
        if (param2 instanceof String) {
            str2 = (String)param2;
        } else if (param2 instanceof Value) {
            v = (Value)param2;
            if (!v.isNull()) {
                str2 = v.getString();
            } else {
                return null;
            }
        }
        if (str1 == null || str2 == null) {
            throw new InterpreterException("X01434", new String[]{this.getName(), "CMP_TYPESTRING"});
        }
        if (this.curPattern == null || this.curPattern.pattern().compareTo(str1) != 0) {
            try {
                this.curPattern = Pattern.compile(str1);
            }
            catch (PatternSyntaxException e) {
                throw new InterpreterException(e.toString(), e);
            }
        }
        if (this.curPattern.matcher(str2).matches()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }
}

