/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.string;

import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;

public class StartsWith
implements Function {
    private static final String SINGLE_QUOTE = "'";
    private static final String STARTS_WITH_FUNCTION_NAME = "StartsWith";
    protected static final String ENDS_WITH_FUNCTION_NAME = "EndsWith";

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount != 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block b2 = (Block)parameterFetcher.getParameter(1);
        b2.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1, b2};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object contains = this.startsWith(blockObj[0], blockObj[1]);
            block.add(blockIter, contains);
        }
        return block;
    }

    private Object startsWith(Object str1Param, Object str2Param) throws InterpreterException {
        Value v;
        BooleanValue result = null;
        String str1 = null;
        String str2 = null;
        if (str1Param == null) {
            return BooleanValue.FALSE;
        }
        if (str1Param instanceof Double) {
            str1 = String.valueOf((Double)str1Param);
        } else if (str1Param instanceof String) {
            str1 = (String)str1Param;
        } else if (str1Param instanceof Value && !(v = (Value)str1Param).isNull()) {
            str1 = v.getString();
        }
        if (str2Param == null) {
            return BooleanValue.FALSE;
        }
        if (str2Param instanceof Double) {
            str2 = String.valueOf((Double)str2Param);
        } else if (str2Param instanceof String) {
            str2 = (String)str2Param;
        } else if (str2Param instanceof Value && !(v = (Value)str2Param).isNull()) {
            str2 = v.getString();
        }
        if (str1 != null && str2 != null) {
            if (str1.length() > 2 && str1.startsWith(SINGLE_QUOTE) && str1.endsWith(SINGLE_QUOTE)) {
                str1 = str1.substring(1, str1.length() - 1);
            }
            if (str2.length() > 2 && str2.startsWith(SINGLE_QUOTE) && str2.endsWith(SINGLE_QUOTE)) {
                str2 = str2.substring(1, str2.length() - 1);
            }
        } else {
            throw new InterpreterException("X01490", new String[]{"", this.getName(), "CMP_TYPESTRING"});
        }
        result = this.performXWith(str1, str2);
        return result;
    }

    private BooleanValue performXWith(String str1, String str2) {
        boolean result = false;
        if (this.getName().equals(STARTS_WITH_FUNCTION_NAME)) {
            result = str1.startsWith(str2);
        } else if (this.getName().equals(ENDS_WITH_FUNCTION_NAME)) {
            result = str1.endsWith(str2);
        }
        if (result) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public String getName() {
        return STARTS_WITH_FUNCTION_NAME;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public Class<?> getSubjectType() {
        return String.class;
    }
}

