/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;

public class Format
implements Function {
    private static final String FORMAT_FUNCTION_NAME = "Format";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, String.class}, {Double.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return FORMAT_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount != 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block valueToFormatB = (Block)parameterFetcher.getParameter(0);
        valueToFormatB.getValues(interpreterContext);
        Block formatStrB = (Block)parameterFetcher.getParameter(1);
        Block[] wrkBlocks = new Block[]{valueToFormatB, formatStrB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IValue formattedValue = this.format((IValue)blockObj[0], (IValue)blockObj[1]);
            block.add(blockIter, (Object)formattedValue);
        }
        return block;
    }

    private IValue format(IValue valueToFormat, IValue formatStr) throws InterpreterException {
        if (valueToFormat == null) {
            return null;
        }
        if (valueToFormat instanceof TimestampValue) {
            TimestampValue timeStampVal = (TimestampValue)valueToFormat;
            String formattedStr = timeStampVal.toString();
            StringValue v = DataValueFactory.createStringValue();
            v.set(formattedStr);
            return v;
        }
        throw new InterpreterException("X01434", new String[]{valueToFormat.toString(), "CMP_TYPEDATE"});
    }
}

