/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.ibm.icu.text.StringSearch;

public class Instr
implements Function {
    private static final String INSTR_FUNCTION_NAME = "Instr";
    private static final int PARAMETER_INDEX_3 = 3;
    private static final String NULL_TERMINATOR = "\u0000";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, String.class}, {Double.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return INSTR_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Object blockFirstObj;
        Object blockFirstObj2;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount != 3 && paramCount != 2) {
            throw new InterpreterException("X01517", new String[]{"2, 3", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b0 = null;
        if (paramCount == 3) {
            b0 = (Block)parameterFetcher.getParameter(0);
        }
        Block b1 = (Block)parameterFetcher.getParameter(paramCount - 2);
        b1.getValues(interpreterContext);
        if (paramCount == 2 && (blockFirstObj2 = b1.first()) != null && blockFirstObj2 instanceof NumericValue) {
            throw new InterpreterException("X01490", new String[]{blockFirstObj2.toString(), this.getName(), "CMP_TYPESTRING"});
        }
        b1.cast(String.class);
        Block b2 = (Block)parameterFetcher.getParameter(paramCount - 1);
        b2.getValues(interpreterContext);
        if (paramCount == 2 && (blockFirstObj = b2.first()) != null && blockFirstObj instanceof NumericValue) {
            throw new InterpreterException("X01490", new String[]{blockFirstObj.toString(), this.getName(), "CMP_TYPESTRING"});
        }
        b2.cast(String.class);
        Block[] wrkBlocks = paramCount == 3 ? new Block[]{b0, b1, b2} : new Block[]{b1, b2};
        Object param0 = new Integer(1);
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (paramCount == 3) {
                param0 = blockObj[0];
            }
            Value instrValue = this.instr(parameterFetcher, param0, blockObj[paramCount - 2], blockObj[paramCount - 1]);
            block.add(blockIter, (Object)instrValue);
        }
        if (block.hasEmptyCells()) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0.0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            block.setDefaultValue(v);
        }
        return block;
    }

    private Value instr(ParameterFetcher parameterFetcher, Object startIdxParam, Object str1Param, Object str2Param) throws InterpreterException {
        double result;
        int startIdx = 1;
        if (startIdxParam == null || startIdxParam == NullObject.instance()) {
            throw new InterpreterException("X01490", new String[]{"Null", this.getName(), "Integer"});
        }
        try {
            startIdx = Caster.coerceParameterToInteger(parameterFetcher.getInterpreterContext(), startIdxParam);
        }
        catch (Exception e) {
            String paramString = ParameterFetcher.getParameterName(startIdxParam);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, e);
        }
        if (str1Param == null || str1Param == NullObject.instance()) {
            result = 0.0;
        } else if (str2Param == null || str2Param == NullObject.instance()) {
            result = startIdx;
        } else {
            Value v;
            int value = 0;
            if (!(str1Param instanceof String) && !(str1Param instanceof Value) || !(str2Param instanceof String) && !(str2Param instanceof Value)) {
                String param1String = ParameterFetcher.getParameterName(str1Param);
                String param2String = ParameterFetcher.getParameterName(str2Param);
                throw new InterpreterException("X01490", new String[]{param1String + ", " + param2String, this.getName(), "CMP_TYPESTRING"});
            }
            String str1 = null;
            String str2 = null;
            if (str1Param instanceof String) {
                str1 = (String)str1Param;
            } else if (str1Param instanceof Value && !(v = (Value)str1Param).isNull()) {
                str1 = v.getString();
            }
            if (str2Param instanceof String) {
                str2 = (String)str2Param;
            } else if (str2Param instanceof Value && !(v = (Value)str2Param).isNull()) {
                str2 = v.getString();
            }
            if (str1 == null) {
                result = 0.0;
            } else if (str2 == null) {
                result = startIdx;
            } else if (str1.equals(NULL_TERMINATOR) || str1.trim().length() == 0) {
                value = 0;
            } else if (str2.equals(NULL_TERMINATOR) || str2.trim().length() == 0) {
                value = str1.length() > 0 && startIdx < str1.length() ? startIdx : 0;
            } else if (startIdx - 1 > str1.length()) {
                value = 0;
            } else {
                StringSearch ss = new StringSearch(str2, str1);
                if (startIdx - 1 >= 0) {
                    ss.setIndex(startIdx - 1);
                } else {
                    ss.setIndex(0);
                }
                value = ss.next();
                ++value;
            }
            result = value;
        }
        DoubleValue v = DataValueFactory.createDoubleValue();
        ((Value)v).set(result);
        v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        return v;
    }
}

