/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;

public class Right
implements Function {
    private static final String RIGHT_FUNCTION_NAME = "Right";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return RIGHT_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block b2 = (Block)parameterFetcher.getParameter(1);
        b2.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1, b2};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object rightStr = this.right(parameterFetcher, blockObj[0], blockObj[1]);
            block.add(blockIter, rightStr);
        }
        return block;
    }

    private Object right(ParameterFetcher parameterFetcher, Object strParam, Object lengthParam) throws InterpreterException {
        int lengthOut;
        try {
            lengthOut = Caster.coerceParameterToInteger(parameterFetcher.getInterpreterContext(), lengthParam);
        }
        catch (Exception e) {
            String paramString = ParameterFetcher.getParameterName(lengthParam);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, e);
        }
        if (lengthOut < 0) {
            return TextValue.ERROR_VALUE;
        }
        String str = null;
        if (strParam instanceof String) {
            str = (String)strParam;
        } else if (strParam instanceof Double) {
            str = String.valueOf((Double)strParam);
            String[] doubleParts = str.split("\\.");
            int decimalPart = Integer.parseInt(doubleParts[1]);
            if (decimalPart == 0) {
                str = doubleParts[0];
            }
        } else if (strParam instanceof Value) {
            int decimalPos;
            Value v = (Value)strParam;
            if (v.isNull() || v.isError()) {
                return strParam;
            }
            str = v.getString();
            if (v.isNumeric() && (decimalPos = str.indexOf(46)) != -1) {
                str = str.substring(0, decimalPos);
            }
        } else {
            if (strParam == NullObject.instance()) {
                return strParam;
            }
            if (strParam != null) {
                throw new InterpreterException("X01490", new String[]{strParam.getClass().toString(), this.getName(), "String"});
            }
        }
        if (str != null) {
            int startIndex = str.length() - lengthOut;
            if (startIndex < 0) {
                startIndex = 0;
            }
            str = str.substring(startIndex, str.length());
        }
        StringValue strValue = DataValueFactory.createStringValue();
        strValue.set(str);
        return strValue;
    }
}

