/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Properties;

public class Round
implements Function {
    private static final String ROUND_FUNCTION_NAME = "Round";
    private static final String ZERO = "zero";
    private static final String ESCAPED_SINGLE_QUOTE = "'";
    private static final int MAX_PLACES_DOUBLE_53 = 53;

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}, {Double.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return ROUND_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        NullBehavior roundNull;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 2) {
            throw new InterpreterException("X01517", new String[]{"1, 2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block b2 = null;
        DoubleValue paramValue2 = DataValueFactory.createDoubleValue();
        ((Value)paramValue2).set(0.0);
        paramValue2.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        Object param2 = paramValue2;
        if (paramCount > 1) {
            b2 = (Block)parameterFetcher.getParameter(1);
            b2.getValues(interpreterContext);
        }
        Block[] wrkBlocks = null;
        wrkBlocks = paramCount == 1 || b2.isConstant() ? new Block[]{b1} : new Block[]{b1, b2};
        if (paramCount == 2 && b2.isConstant()) {
            param2 = b2.first();
        }
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (paramCount == 2 && !b2.isConstant()) {
                param2 = blockObj[1];
            }
            Value roundedValue = this.doRound(interpreterContext, blockObj[0], param2);
            block.add(blockIter, (Object)roundedValue);
        }
        if (block.hasEmptyCells() && (roundNull = NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.vb.math.function", NullBehavior.ZERO)) == NullBehavior.ZERO) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0.0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            block.setDefaultValue(v);
        }
        return block;
    }

    private Value doRound(InterpreterContext interpreterContext, Object valueParam, Object placesParam) throws InterpreterException {
        if (valueParam instanceof Value && !((Value)valueParam).isOK()) {
            DoubleValue resultValue = DataValueFactory.createDoubleValue();
            resultValue.setState(((Value)valueParam).getState());
            return resultValue;
        }
        if (placesParam != null && placesParam instanceof Value && !((Value)placesParam).isOK()) {
            DoubleValue resultValue = DataValueFactory.createDoubleValue();
            resultValue.setState(((Value)placesParam).getState());
            return resultValue;
        }
        double value = this.coerceToDouble(interpreterContext, valueParam);
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        if (valueParam instanceof Value) {
            operandIds.add(((Value)valueParam).getFormatId());
        }
        double places = 0.0;
        if (placesParam != null) {
            places = this.coerceToDouble(interpreterContext, placesParam);
        }
        DoubleValue roundedValue = DataValueFactory.createDoubleValue();
        FormatService service = FormatService.getInstance();
        Properties externalParameters = new Properties();
        externalParameters.setProperty("roundingPrecision", String.valueOf((int)places));
        FormatId resultFormatId = service.formatResult(ROUND_FUNCTION_NAME, operandIds, externalParameters);
        roundedValue.setFormatId(resultFormatId);
        ((Value)roundedValue).set(this.round(value, places));
        return roundedValue;
    }

    private double coerceToDouble(InterpreterContext interpreterContext, Object param) throws InterpreterException {
        if (param instanceof StringValue) {
            String str = ((StringValue)param).getString();
            try {
                param = str.trim().startsWith(ESCAPED_SINGLE_QUOTE) || str.trim().endsWith(ESCAPED_SINGLE_QUOTE) ? Double.valueOf(str.substring(1, str.length() - 1)) : Double.valueOf(str);
            }
            catch (Exception e) {
                throw new InterpreterException("X01490", new String[]{str, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        }
        double retDouble = 0.0;
        if (param instanceof Value) {
            Value v = (Value)param;
            if (v.isNull()) {
                retDouble = 0.0;
            } else {
                try {
                    retDouble = v.getDouble();
                }
                catch (Exception e) {
                    throw new InterpreterException("X01490", new String[]{v.getString(), this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
                }
            }
        } else {
            Double d = interpreterContext.getDoubleOperand(param);
            retDouble = d;
        }
        return retDouble;
    }

    protected RoundingMode getRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    private double round(double val, double places) throws InterpreterException {
        RoundingMode roundingMode = this.getRoundingMode();
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            return val;
        }
        if (Double.isInfinite(places) || Double.isNaN(places)) {
            return places;
        }
        if (places < 0.0) {
            throw new InterpreterException("X01490", new String[]{places + "", this.getName(), "CMP_TYPENUMERIC"}, 4L);
        }
        if (places > 53.0) {
            places = 53.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(val));
        bd = bd.setScale((int)places, roundingMode);
        return bd.doubleValue();
    }
}

