/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractBlockIterator
implements IBlockIterator {
    private static final String DEFAULT_VALUE_LOG_TXT = "defaultValue";
    private static final String BLOCK_ORDINAL_LOG_TXT = "Block ordinal= ";
    private static final long TWENTY = 20L;
    private static final long NINETEEN = 19L;
    public static final long DEFAULT_VALUE_ORDINAL = -9223372036854775788L;
    protected static final long USED_DEFAULT_VALUE = -9223372036854775789L;
    protected final Set[] blockSets;
    protected final OrdinalMath.SetArrayInfo blockSetsInfo;
    protected final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
    protected OrdinalMath ordinalMath;
    private long blockOrdSurrogateId;
    private final XQELogger logger;
    ICube cube;

    public AbstractBlockIterator(Block[] blocks) {
        this.blockSets = Block.getCombinedBlockSets(blocks[0].interpreterContext, blocks);
        this.cube = blocks[0].interpreterContext.getCube();
        this.ordinalMath = blocks[0].interpreterContext.getOrdinalMath();
        this.blockSetsInfo = this.ordinalMath.getSetArrayInfo(this.blockSets);
        XQELogger lgr = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "BlockIteration", LogLevel.INFO);
        if (lgr != null && lgr.isOn(LogLevel.INFO)) {
            this.logger = lgr;
            this.logger.log("New " + this.getClass().getName());
        } else {
            this.logger = null;
        }
    }

    @Override
    public long pos() {
        return this.getBlockOrdSurrogateId();
    }

    @Override
    public boolean isAtDefaultValuePos() {
        return this.getBlockOrdSurrogateId() == -9223372036854775788L;
    }

    @Override
    public ITuple getCurrentTuple() {
        ArrayList<IMember> retTupleMems = null;
        long[] blockSetOrd = this.ordinalMath.getSetOrdinals(this.getBlockOrdSurrogateId(), this.blockSetsInfo);
        for (int i = 0; i < blockSetOrd.length; ++i) {
            ITuple partialTuple = null;
            partialTuple = OrdinalMath.isSurrogateId(blockSetOrd[i]) ? this.blockSets[i].getTuple(this.ordinalMath.getBigInteger(blockSetOrd[i])) : this.blockSets[i].getTuple(blockSetOrd[i]);
            if (partialTuple.size() <= 0) continue;
            if (retTupleMems == null) {
                retTupleMems = new ArrayList<IMember>();
            }
            retTupleMems.addAll(Arrays.asList(partialTuple.getMembers()));
        }
        if (retTupleMems != null) {
            return new Tuple(retTupleMems.toArray(new IMember[retTupleMems.size()]), this.cube);
        }
        return new Tuple(new IMember[0], this.cube);
    }

    @Override
    public IMember getMeasuresForAllTuples() {
        for (int setIdx = 0; setIdx < this.blockSets.length; ++setIdx) {
            IHierarchy[] hiers = this.blockSets[setIdx].getHierarchies();
            for (int hierIdx = 0; hierIdx < hiers.length; ++hierIdx) {
                if (!hiers[hierIdx].getDimension().isMeasuresDimension()) continue;
                if (this.blockSets[setIdx].size() > 1L) {
                    return null;
                }
                return this.blockSets[setIdx].getTuple(0L).getMember(hierIdx);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBlockOrdSurrogateId() {
        return this.blockOrdSurrogateId;
    }

    @Override
    public void setBlockOrdSurrogateId(long surrogateId) {
        this.blockOrdSurrogateId = surrogateId;
    }

    protected boolean isLogging() {
        return this.logger != null;
    }

    protected void log(Object retObj, long blockOrd, long[] ordinalsForRetObject) {
        if (this.logger == null) {
            return;
        }
        StringBuilder logMsg = new StringBuilder(BLOCK_ORDINAL_LOG_TXT);
        logMsg.append(blockOrd);
        if (ordinalsForRetObject != null) {
            logMsg.append("   Ordinal from child blocks are [");
            boolean first = true;
            for (long ord : ordinalsForRetObject) {
                if (!first) {
                    logMsg.append(",");
                }
                if (ord != -9223372036854775789L) {
                    logMsg.append(ord);
                } else {
                    logMsg.append(DEFAULT_VALUE_LOG_TXT);
                }
                first = false;
            }
            logMsg.append("]");
        } else {
            logMsg.append("  Default value returned.");
        }
        if (this.logger.isOn(LogLevel.TRACE) && retObj instanceof Object[]) {
            this.addReturnObjectToLogMsg((Object[])retObj, logMsg, false);
            this.logger.log(LogLevel.TRACE, logMsg.toString());
        } else {
            this.logger.log(LogLevel.INFO, logMsg.toString());
        }
    }

    protected void log(Object retObj, long blockOrd, long pipelineBlockOrdinal, boolean unwrapCellArrays) {
        if (this.logger == null) {
            return;
        }
        StringBuilder logMsg = new StringBuilder(BLOCK_ORDINAL_LOG_TXT);
        logMsg.append(blockOrd);
        logMsg.append("   Pipeline block ordinal used= ");
        if (pipelineBlockOrdinal != -9223372036854775789L) {
            logMsg.append(pipelineBlockOrdinal);
        } else {
            logMsg.append(DEFAULT_VALUE_LOG_TXT);
        }
        if (this.logger.isOn(LogLevel.TRACE) && retObj instanceof Object[]) {
            this.addReturnObjectToLogMsg((Object[])retObj, logMsg, unwrapCellArrays);
            this.logger.log(LogLevel.TRACE, logMsg.toString());
        } else {
            this.logger.log(LogLevel.INFO, logMsg.toString());
        }
    }

    private void addReturnObjectToLogMsg(Object[] retObj, StringBuilder logMsg, boolean unwrapCellArrays) {
        logMsg.append("   Values= [");
        boolean first = true;
        for (Object o : retObj) {
            if (!first) {
                logMsg.append(", ");
            }
            if (unwrapCellArrays && o instanceof Cell[]) {
                Cell wrapperCell = ((Cell[])o)[0];
                logMsg.append("streaming contextId: " + wrapperCell.getOrdinal() + "  value= " + wrapperCell.getObjectValue());
            } else {
                logMsg.append(o);
            }
            first = false;
        }
        logMsg.append("] ");
    }
}

