/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.NullContextFlagValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockOrdinalTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockContextMap;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalChangeContextTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalChangeToPreviousContextTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ErrorCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MultiplexBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetConfiguration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TreeSetExpandingBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.NestedPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.pool.XQELongPool;
import com.cognos.xqe.util.primitive.ArrayListBoolean;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.ArrayListLong;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Block {
    private static final int CALLER_STACKFRAME_DEPTH = 3;
    private static final String THIS_FUNCTION_NOT_SUPPORTED_WHEN_PIPELINING = "This function not supported when pipelining";
    private Set[] contextSets;
    private Set[] sets;
    TreeSet<Cell> cellSet;
    private Object defaultValue = null;
    InterpreterContext interpreterContext;
    NamedSet namedSet;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
    private static final String ENABLE_EXPRESSION_CACHE = "enableExpressionCache";
    private static final long EXPRESSION_CACHE_MIN_TIME = Long.parseLong(System.getProperty("expressionCacheMinTime", "0"));
    private static final long EXPRESSION_CACHE_MAX_TUPLECOUNT = Long.parseLong(System.getProperty("expressionCacheMaxTupleCount", "10000000"));
    private static String cacheLogFileName = System.getProperty("expressionCacheLogFile");
    private IHierarchy[] numExpDegHiers = null;
    private IHierarchy[] setExpDegHiers = null;
    private boolean useDefaultValueObject = false;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final int TOSTRING_MAXCELLCOUNT = 1000;
    private AbstractBlockOrdinalTransformIterator cellPipelineIterator = null;

    public Block(InterpreterContext context, Set[] ctxSet, Set[] ss, TreeSet<Cell> c) {
        this.interpreterContext = context;
        this.contextSets = ctxSet;
        this.sets = ss;
        this.cellSet = c;
    }

    public Block(Block srcBlock, boolean[] keeps) {
        this.interpreterContext = srcBlock.interpreterContext;
        ArrayList<Set> newSets = new ArrayList<Set>();
        this.contextSets = srcBlock.contextSets;
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (!keeps[i]) continue;
            newSets.add(this.contextSets[i]);
        }
        this.sets = newSets.toArray(new Set[0]);
        this.cellSet = Block.createTreeSet();
    }

    public Block(Block srcBlock) {
        this.interpreterContext = srcBlock.interpreterContext;
        this.contextSets = srcBlock.contextSets;
        this.sets = srcBlock.sets;
        this.defaultValue = null;
        this.cellSet = Block.createTreeSet();
    }

    public Block(InterpreterContext ic, Object obj) {
        this.interpreterContext = ic;
        this.contextSets = ic.hasContextSet() && ic.getContextSet() != null ? ic.getContextSet().getSets() : new Set[0];
        this.sets = new Set[0];
        this.cellSet = Block.createTreeSet();
        Block.addCell(this.cellSet, 0L, obj, false, false);
    }

    public Block(InterpreterContext ic, TreeSet<Cell> blockCells) {
        this.interpreterContext = ic;
        this.contextSets = ic.getContextSet().getSets();
        this.sets = this.contextSets;
        this.cellSet = blockCells;
    }

    public Block(InterpreterContext ic, TreeSet<Cell> blockCells, ArrayListInt intNonDegenSets) {
        this.interpreterContext = ic;
        this.contextSets = ic.getContextSet().getSets();
        ArrayList<Set> nonDegenSets = new ArrayList<Set>();
        for (int i = 0; i < intNonDegenSets.size(); ++i) {
            nonDegenSets.add(this.contextSets[intNonDegenSets.get(i)]);
        }
        this.sets = nonDegenSets.toArray(new Set[0]);
        this.cellSet = blockCells;
    }

    public Block(InterpreterContext ic, Block srcBlock) {
        this.interpreterContext = ic;
        this.contextSets = (Set[])srcBlock.contextSets.clone();
        this.sets = (Set[])srcBlock.sets.clone();
        this.cellSet = Block.createTreeSet();
        this.cellSet.addAll(srcBlock.cellSet);
        this.setDefaultValue(srcBlock.getDefaultValue());
    }

    public Block(InterpreterContext ic, Block contextBlock, ParameterFetcher parameterFetcher, int paramIdx, boolean convertToValues, boolean pushNulls) throws InterpreterException {
        this(ic, contextBlock, parameterFetcher, paramIdx, convertToValues, pushNulls, true, false);
    }

    public Block(InterpreterContext ic, Block contextBlock, ParameterFetcher parameterFetcher, int paramIdx, boolean convertToValues, boolean pushNulls, boolean useDefValueObj) throws InterpreterException {
        this(ic, contextBlock, parameterFetcher, paramIdx, convertToValues, pushNulls, true, useDefValueObj);
    }

    public Block(InterpreterContext ic, Block contextBlock, ParameterFetcher parameterFetcher, int paramIdx, boolean convertToValues, boolean pushNulls, boolean suppressConversionException, boolean useDefValueObj) throws InterpreterException {
        this.interpreterContext = ic;
        this.useDefaultValueObject = useDefValueObj;
        ICalculationEngine calcEngine = this.interpreterContext.getCalculationEngine();
        Collection<NamedSet> namedSets = calcEngine.getNamedSets().values();
        InterpreterContext.ContextInfo ctxtInfo = contextBlock.buildInterpreterContext(pushNulls, namedSets);
        if (ctxtInfo.prevContextMap.isEmpty()) {
            this.cellSet = Block.createTreeSet();
            this.contextSets = this.interpreterContext.getContextSet().getSets();
            this.sets = new Set[0];
            return;
        }
        this.interpreterContext.pushContext(ctxtInfo);
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        this.contextSets = contextSet.getSets();
        if (parameterFetcher != null && parameterFetcher.getParameterCount() > 1) {
            HashMap<NamedSet, Block> currContextInsBlocks = new HashMap<NamedSet, Block>();
            for (NamedSet namedSetObj : namedSets) {
                if (!namedSetObj.isInlineAndActive()) continue;
                Block setB = (Block)namedSetObj.getSet1(this.interpreterContext);
                currContextInsBlocks.put(namedSetObj, new Block(this.interpreterContext, setB));
                setB.pushChangeContext(ctxtInfo);
            }
            Block numExpParam = (Block)parameterFetcher.getParameter(paramIdx, false);
            if (numExpParam == null) {
                this.sets = new Set[0];
                this.cellSet = Block.createTreeSet();
            } else {
                this.contextSets = new Set[numExpParam.contextSets.length];
                this.sets = new Set[numExpParam.sets.length];
                int setsIdx = 0;
                for (int i = 0; i < numExpParam.contextSets.length; ++i) {
                    this.contextSets[i] = numExpParam.contextSets[i];
                    if (numExpParam.isDegenerated(i)) continue;
                    this.sets[setsIdx] = this.contextSets[i];
                    ++setsIdx;
                }
                if (numExpParam.cellSetSize() == 1 && numExpParam.isConstant()) {
                    Object firstCellObj = numExpParam.first();
                    if (firstCellObj instanceof IMember) {
                        this.setNumExpDegHiers(new IHierarchy[]{((IMember)firstCellObj).getHierarchy()});
                    } else if (firstCellObj instanceof Tuple) {
                        this.setNumExpDegHiers(((Tuple)firstCellObj).getHierarchies());
                    }
                }
                this.cellSet = numExpParam.cellSet;
                this.setDefaultValue(numExpParam.getDefaultValue());
                if (convertToValues) {
                    this.getValues(suppressConversionException);
                }
            }
            for (NamedSet namedSetObj : namedSets) {
                if (!namedSetObj.isInlineAndActive()) continue;
                Block currContextInsBlock = (Block)currContextInsBlocks.get(namedSetObj);
                if (currContextInsBlock != null) {
                    namedSetObj.setBlock(currContextInsBlock, false);
                    continue;
                }
                Block setB = (Block)namedSetObj.getSet1(this.interpreterContext);
                Block modContextBlock = contextBlock;
                if (setB.hasExpandedSets()) {
                    modContextBlock = new Block(this.interpreterContext, contextBlock);
                    modContextBlock.expandDegeneratesSets(ctxtInfo.expandedSets);
                }
                setB.changeContext(modContextBlock, true);
            }
        } else {
            ArrayList<Set> contextMts = new ArrayList<Set>();
            ArrayList<IMember> contextSts = new ArrayList<IMember>();
            for (int i = 0; i < this.contextSets.length; ++i) {
                if (this.contextSets[i].hasMultipleTuples()) {
                    contextMts.add(this.contextSets[i]);
                    continue;
                }
                ITuple tuple = this.contextSets[i].getTuple(0L);
                for (int memIdx = 0; memIdx < tuple.size(); ++memIdx) {
                    contextSts.add(tuple.getMember(memIdx));
                }
            }
            this.sets = contextMts.toArray(new Set[0]);
            CrossJoinedSet axes = new CrossJoinedSet(this.sets);
            SetEvaluator se = new SetEvaluator(this.interpreterContext);
            IResultSet contextRs = se.getSetResults(new Set(new Tuple(contextSts.toArray(new IMember[0]), this.interpreterContext.getCube())), axes);
            this.cellSet = Block.createTreeSet();
            IResultSetIterator cellIter = contextRs.iterator();
            while (cellIter.hasNext()) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                Cell blockCell = (Cell)cellIter.next();
                this.addCell(this.cellSet, blockCell);
            }
        }
        if (this.hasExpandedSets()) {
            contextBlock.expandDegeneratesSets(ctxtInfo.expandedSets);
        }
        this.changeContext(contextBlock, false);
        this.interpreterContext.popContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block(InterpreterContext ic, Block contextBlock, ParameterFetcher parameterFetcher, int paramIdx) throws InterpreterException {
        this.interpreterContext = ic;
        ICalculationEngine calcEngine = this.interpreterContext.getCalculationEngine();
        Collection<NamedSet> namedSets = calcEngine.getNamedSets().values();
        InterpreterContext.ContextInfo ctxtInfo = contextBlock.buildInterpreterContext(true, namedSets);
        if (ctxtInfo.prevContextMap.isEmpty()) {
            this.cellSet = Block.createTreeSet();
            this.contextSets = this.interpreterContext.getContextSet().getSets();
            this.sets = new Set[0];
            return;
        }
        this.interpreterContext.pushContext(ctxtInfo);
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        this.contextSets = contextSet.getSets();
        if (parameterFetcher != null && parameterFetcher.getParameterCount() > 1) {
            for (NamedSet namedSetObj : namedSets) {
                if (!namedSetObj.isInlineAndActive()) continue;
                Block setB = (Block)namedSetObj.getSet1(this.interpreterContext);
                setB.pushChangeContext(ctxtInfo);
            }
            Block numExpParam = (Block)parameterFetcher.getParameter(paramIdx, false);
            if (numExpParam == null) {
                this.sets = new Set[0];
                this.cellSet = Block.createTreeSet();
            } else {
                this.contextSets = new Set[numExpParam.contextSets.length];
                this.sets = new Set[numExpParam.sets.length];
                int setsIdx = 0;
                for (int i = 0; i < numExpParam.contextSets.length; ++i) {
                    this.contextSets[i] = numExpParam.contextSets[i];
                    if (numExpParam.isDegenerated(i)) continue;
                    this.sets[setsIdx] = this.contextSets[i];
                    ++setsIdx;
                }
                this.cellSet = numExpParam.cellSet;
                this.setDefaultValue(numExpParam.getDefaultValue());
            }
            for (NamedSet namedSetObj : namedSets) {
                if (!namedSetObj.isInlineAndActive()) continue;
                Block setB = (Block)namedSetObj.getSet1(this.interpreterContext);
                Block modContextBlock = contextBlock;
                if (setB.hasExpandedSets()) {
                    modContextBlock = new Block(this.interpreterContext, contextBlock);
                    modContextBlock.expandDegeneratesSets(ctxtInfo.expandedSets);
                }
                setB.changeContext(modContextBlock, true);
            }
        } else {
            ArrayList<Set> contextMts = new ArrayList<Set>();
            for (int i = 0; i < this.contextSets.length; ++i) {
                if (this.contextSets[i].size() <= 1L) continue;
                contextMts.add(this.contextSets[i]);
            }
            this.sets = contextMts.toArray(new Set[0]);
            this.cellSet = Block.createTreeSet();
        }
        if (this.hasExpandedSets()) {
            contextBlock.expandDegeneratesSets(ctxtInfo.expandedSets);
        }
        if (this.isErrorBlock()) {
            this.interpreterContext.popContext();
            return;
        }
        try {
            this.buildDataTuples();
            this.changeContext(contextBlock, false);
        }
        finally {
            this.interpreterContext.popContext();
        }
    }

    public Block(InterpreterContext ic, Block[] compBlocks) {
        this.interpreterContext = ic;
        this.contextSets = Block.getCombinedBlockContextSets(this.interpreterContext, compBlocks);
        this.sets = Block.getCombinedBlockSets(this.interpreterContext, compBlocks);
        this.cellSet = Block.createTreeSet();
    }

    public Block(InterpreterContext ic, Block[] compBlocks, Block setBlock, Block numExpBlock) {
        this(ic, compBlocks);
        if (setBlock != null && numExpBlock != null) {
            this.setSetExpDegHiers(setBlock);
            this.setNumExpDegHiers(numExpBlock.getNumExpDegHiers());
        }
    }

    public static Set[] getCombinedBlockSets(InterpreterContext interpreterContext, Block[] blocks) {
        if (blocks.length == 0) {
            return new Set[0];
        }
        boolean expandSets = false;
        for (int blockIdx = 0; blockIdx < blocks.length; ++blockIdx) {
            if (!blocks[blockIdx].hasExpandedSets()) continue;
            expandSets = true;
            break;
        }
        Set[] combBlocksContextSets = null;
        if (expandSets) {
            combBlocksContextSets = interpreterContext.getContext().expSet.getSets();
            for (int blockIdx = 0; blockIdx < blocks.length; ++blockIdx) {
                if (blocks[blockIdx].hasExpandedSets()) continue;
                blocks[blockIdx].expandSets();
            }
        } else {
            combBlocksContextSets = blocks[0].contextSets;
        }
        ArrayList<Set> blockSets = new ArrayList<Set>();
        block2: for (int ctxtSetIdx = 0; ctxtSetIdx < combBlocksContextSets.length; ++ctxtSetIdx) {
            for (int blockIdx = 0; blockIdx < blocks.length; ++blockIdx) {
                if (blocks[blockIdx].isDegenerated(ctxtSetIdx)) continue;
                blockSets.add(combBlocksContextSets[ctxtSetIdx]);
                continue block2;
            }
        }
        return blockSets.toArray(new Set[0]);
    }

    public static Set[] getCombinedBlockContextSets(InterpreterContext interpreterContext, Block[] blocks) {
        for (int blockIdx = 0; blockIdx < blocks.length; ++blockIdx) {
            if (!blocks[blockIdx].hasExpandedSets()) continue;
            return interpreterContext.getContext().expSet.getSets();
        }
        return interpreterContext.getContextSet().getSets();
    }

    public static boolean isExpressionCacheEnabled() {
        String enableExpressionCacheStr = System.getProperty(ENABLE_EXPRESSION_CACHE);
        return enableExpressionCacheStr != null && enableExpressionCacheStr.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheLog(String msg) {
        if (cacheLogFileName == null) {
            return;
        }
        String string = cacheLogFileName;
        synchronized (string) {
            try {
                FileWriter cacheLogFile = new FileWriter(cacheLogFileName, true);
                cacheLogFile.append("\nthread=" + Thread.currentThread().getId() + "  " + msg);
                cacheLogFile.close();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public static Block getCachedBlock(String expStr, InterpreterContext interpreterContext) throws InterpreterException {
        CalculationEngine calcEngine = (CalculationEngine)interpreterContext.getCalculationEngine();
        Hashtable<String, Block> cachedBlocks = calcEngine.getCachedBlocks();
        Block cachedExpBlock = cachedBlocks.get(expStr);
        if (cachedExpBlock == null) {
            Block.cacheLog("Expression cache not reused. Expression not found in cache. ");
            return null;
        }
        ArrayList<IHierarchy> expDegHiers = new ArrayList<IHierarchy>();
        expDegHiers.addAll(Arrays.asList(cachedExpBlock.getNumExpDegHiers()));
        expDegHiers.addAll(Arrays.asList(cachedExpBlock.setExpDegHiers));
        for (int i = 0; i < cachedExpBlock.contextSets.length; ++i) {
            if (!cachedExpBlock.isDegenerated(i)) continue;
            IHierarchy[] degHiers = cachedExpBlock.contextSets[i].getHierarchies();
            for (int j = 0; j < degHiers.length; ++j) {
                if (expDegHiers.contains(degHiers[j])) continue;
                expDegHiers.add(degHiers[j]);
            }
        }
        ArrayList<IHierarchy> nonDegHiersList = new ArrayList<IHierarchy>();
        for (int i = 0; i < cachedExpBlock.sets.length; ++i) {
            nonDegHiersList.addAll(Arrays.asList(cachedExpBlock.sets[i].getHierarchies()));
        }
        IHierarchy[] nonDegHiers = nonDegHiersList.toArray(new IHierarchy[0]);
        Block retBlock = new Block(interpreterContext, (Object)null);
        ArrayList<Set> expBlockSets = new ArrayList<Set>();
        retBlock.contextSets = interpreterContext.getContextSet().getSets();
        for (int i = 0; i < retBlock.contextSets.length; ++i) {
            if (!Block.containAnyHierarchy(retBlock.contextSets[i], nonDegHiers)) continue;
            expBlockSets.add(retBlock.contextSets[i]);
        }
        retBlock.sets = expBlockSets.toArray(new Set[0]);
        IHierarchy[] hierOrder = null;
        HashMapObjectInt<IHierarchy> hierOrderMap = new HashMapObjectInt<IHierarchy>();
        HashMap<Tuple, Object> tupleValueMap = new HashMap<Tuple, Object>();
        BlockIterator blockIter = cachedExpBlock.iterator();
        while (blockIter.hasNext()) {
            int i;
            Object[] blockObj = (Object[])blockIter.next();
            Tuple tuple = (Tuple)blockIter.getCurrentTuple();
            for (i = 0; i < expDegHiers.size(); ++i) {
                tuple = (Tuple)tuple.remove((IHierarchy)expDegHiers.get(i));
            }
            if (hierOrder == null) {
                hierOrder = tuple.getHierarchies();
                for (i = 0; i < hierOrder.length; ++i) {
                    hierOrderMap.put(hierOrder[i], i);
                }
            }
            tupleValueMap.put(tuple, blockObj[0]);
        }
        CrossJoinedSet expCJSet = new CrossJoinedSet(retBlock.sets);
        if (!expCJSet.isEmpty()) {
            long newOrd = 0L;
            IIterator setIter = expCJSet.iterator();
            while (setIter.hasNext()) {
                Tuple tuple = (Tuple)setIter.next();
                for (int i = 0; i < expDegHiers.size(); ++i) {
                    tuple = (Tuple)tuple.remove((IHierarchy)expDegHiers.get(i));
                }
                IMember[] members = new IMember[tuple.size()];
                for (int i = 0; i < members.length; ++i) {
                    IHierarchy hier = tuple.getMember(i).getHierarchy();
                    if (!hierOrderMap.containsKey(hier)) {
                        Block.cacheLog("Expression cache not reused.  Expression contexts differ. ");
                        return null;
                    }
                    int idx = hierOrderMap.get(hier);
                    members[idx] = tuple.getMember(i);
                }
                tuple = new Tuple(members, interpreterContext.getCube());
                Object blockObj = tupleValueMap.get(tuple);
                if (blockObj == null) {
                    Block.cacheLog("Expression cache not reused. Expression contexts differ. ");
                    return null;
                }
                Block.addCell(retBlock.cellSet, newOrd, blockObj, false, false);
                ++newOrd;
            }
        } else {
            if (cachedExpBlock.cellSetSize() != 1) {
                Block.cacheLog("Expression cache not reused. Cached expression has  " + cachedExpBlock.cellSetSize() + "cells but new expression context is degenerated. ");
                return null;
            }
            Block.addCell(retBlock.cellSet, 0L, cachedExpBlock.first(), false, false);
        }
        Block.cacheLog("Reusing cached expression ");
        return retBlock;
    }

    public static void buildCacheableExpList(IXQEQueryNode node, InterpreterContext interpreterContext) {
        if (!Block.isExpressionCacheEnabled()) {
            Block.cacheLog("Expression not cached. Expression cache is not enabled.");
            return;
        }
        Hashtable<String, Integer> expList = new Hashtable<String, Integer>();
        Block.addNodeExpression(node, expList);
        CalculationEngine calcEngine = (CalculationEngine)interpreterContext.getCalculationEngine();
        Hashtable<String, Integer> cacheableExpList = calcEngine.getCacheableExpList();
        for (Map.Entry<String, Integer> entry : expList.entrySet()) {
            Integer refCount = entry.getValue();
            if (refCount <= 1) continue;
            cacheableExpList.put(entry.getKey(), refCount);
        }
    }

    private static void addNodeExpression(IXQEQueryNode node, Hashtable<String, Integer> cacheableExpList) {
        if (Block.isCacheableNode(node)) {
            String expStr = ((XQEBaseQueryNode)node).dumpToString(false);
            Integer expRefCount = cacheableExpList.get(expStr);
            if (expRefCount != null) {
                Integer n = expRefCount;
                Integer n2 = expRefCount = Integer.valueOf(expRefCount + 1);
            } else {
                expRefCount = 1;
            }
            cacheableExpList.put(expStr, expRefCount);
        }
        int childCount = node.getNumberChildren();
        for (int i = 0; i < childCount; ++i) {
            Block.addNodeExpression(node.getChild(i), cacheableExpList);
        }
    }

    private static boolean isCacheableNode(IXQEQueryNode node) {
        String ident;
        return node instanceof XMdxElement && ((ident = ((XMdxElement)node).getValue()).equalsIgnoreCase("TOPCOUNT") || ident.equalsIgnoreCase("BOTTOMCOUNT") || ident.equalsIgnoreCase("TOPPERCENT") || ident.equalsIgnoreCase("BOTTOMPERCENT") || ident.equalsIgnoreCase("TOPSUM") || ident.equalsIgnoreCase("BOTTOMSUM") || ident.equalsIgnoreCase("FILTER"));
    }

    public static void cacheBlock(String expStr, Block block, InterpreterContext interpreterContext, long calcTime) {
        if (!Block.isExpressionCacheEnabled() || block.isPipelining()) {
            return;
        }
        CalculationEngine calcEngine = (CalculationEngine)interpreterContext.getCalculationEngine();
        Hashtable<String, Integer> cacheableExpList = calcEngine.getCacheableExpList();
        Integer expRefCount = cacheableExpList.get(expStr);
        if (expRefCount == null) {
            Block.cacheLog("Expression not cached. Expression occurs only once in the MDX statement.");
            return;
        }
        if (calcTime < EXPRESSION_CACHE_MIN_TIME) {
            Block.cacheLog("Expression not cached. Calculation time (" + calcTime + "ms) less than expressionCacheMinTime (" + EXPRESSION_CACHE_MIN_TIME + "ms)");
            return;
        }
        long cachingSize = block.cachingSize();
        if (cachingSize > EXPRESSION_CACHE_MAX_TUPLECOUNT) {
            Block.cacheLog("Expression not cached. Number of tuples (" + cachingSize + ") is greater than expressionCacheMaxTupleCount (" + EXPRESSION_CACHE_MAX_TUPLECOUNT + ")");
            return;
        }
        Hashtable<String, Block> cachedBlocks = calcEngine.getCachedBlocks();
        calcEngine.makeRoomInCachedBlocks(cachingSize, EXPRESSION_CACHE_MAX_TUPLECOUNT);
        cachedBlocks.put(expStr, block);
        Block.cacheLog("Expression cached. Time: " + calcTime + "ms Size: " + cachingSize + " tuples");
    }

    public void setNamedSet(NamedSet namedSetObj) {
        this.namedSet = namedSetObj;
    }

    public NamedSet getNamedSet() {
        return this.namedSet;
    }

    public IHierarchy[] getNumExpDegHiers() {
        return this.numExpDegHiers;
    }

    public void setNumExpDegHiers(IHierarchy[] degHiers) {
        this.numExpDegHiers = degHiers != null ? degHiers : new IHierarchy[0];
    }

    public IHierarchy[] getSetExpDegHiers() {
        return this.setExpDegHiers;
    }

    public Iterator<?> getCellPipelineIterator() {
        return this.cellPipelineIterator;
    }

    public boolean isPipelining() {
        return this.cellPipelineIterator != null;
    }

    public void setSetExpDegHiers(Block setBlock) {
        Object firstCellObj = setBlock.first();
        if (firstCellObj == null) {
            return;
        }
        if (!(firstCellObj instanceof Set)) {
            return;
        }
        IHierarchy[] setHiers = ((Set)firstCellObj).getHierarchies();
        if (setBlock.isConstant()) {
            this.setExpDegHiers = setHiers;
        } else if (setHiers.length > 0) {
            ArrayList<IHierarchy> degHiers = new ArrayList<IHierarchy>();
            for (int i = 0; i < setHiers.length; ++i) {
                int setIdx = setBlock.getIndexOfSetContainingHierarchy(setBlock.contextSets, setHiers[i]);
                if (!setBlock.isDegenerated(setIdx)) continue;
                degHiers.add(setHiers[i]);
            }
            this.setExpDegHiers = degHiers.toArray(new IHierarchy[0]);
        } else {
            this.setExpDegHiers = new IHierarchy[0];
        }
    }

    public BlockIterator iterator() {
        this.isUnsupportedPipelineFunction(true);
        return new BlockIterator(new Block[]{this});
    }

    public BlockIterator iterator(boolean includeDegeneratedSets) {
        if (this.sets.length == this.contextSets.length) {
            return this.iterator();
        }
        if (!includeDegeneratedSets) {
            return this.iterator();
        }
        this.isUnsupportedPipelineFunction(true);
        boolean[] include = new boolean[this.contextSets.length];
        for (int i = 0; i < this.contextSets.length; ++i) {
            include[i] = true;
        }
        Block b2 = new Block(this, include);
        Block[] wrkBlocks = new Block[]{this, b2};
        return new BlockIterator(wrkBlocks);
    }

    public void add(IBlockIterator bIter, Object obj) {
        this.add(bIter, obj, null);
    }

    public void add(TupleValueIterator bIter, Object obj) {
        this.add(bIter, obj, null);
    }

    public void add(Iterator<TupleValue> bIter, Object obj) {
        this.add(bIter, obj, null);
    }

    public void add(Iterator<?> bIter, Object obj, String cellFormat) {
        this.isUnsupportedPipelineFunction(true);
        long cellOrdSurrogateId = bIter instanceof IBlockIterator ? ((IBlockIterator)bIter).pos() : ((TupleValueIterator)bIter).pos();
        this.add(cellOrdSurrogateId, obj, cellFormat);
    }

    public void add(long cellOrdSurrogateId, Object obj, String cellFormat) {
        this.isUnsupportedPipelineFunction(true);
        if (cellOrdSurrogateId == -9223372036854775788L) {
            this.setDefaultValue(obj);
        } else {
            Cell blockCell = Block.addCellSurrogateId(this.cellSet, cellOrdSurrogateId, obj, false, false, this.interpreterContext.getOrdinalMath());
            if (cellFormat != null && blockCell != null) {
                blockCell.setCellFormat(cellFormat);
            }
        }
    }

    protected static Cell addCell(TreeSet<Cell> dstCellSet, long ord, Object cellObj, boolean defValueAssigned, boolean checkValue) {
        if (Block.nullCell(cellObj)) {
            return null;
        }
        Cell cell = new Cell(cellObj, ord, checkValue);
        dstCellSet.add(cell);
        return cell;
    }

    protected static Cell addCellSurrogateId(TreeSet<Cell> dstCellSet, long ordSurrogateId, Object cellObj, boolean defValueAssigned, boolean checkValue, OrdinalMath ordinalMath) {
        if (Block.nullCell(cellObj)) {
            return null;
        }
        Cell cell = null;
        cell = OrdinalMath.isSurrogateId(ordSurrogateId) ? new BCell(ordinalMath.getBigInteger(ordSurrogateId), cellObj, defValueAssigned, checkValue) : new Cell(cellObj, ordSurrogateId, checkValue);
        if (dstCellSet != null) {
            dstCellSet.add(cell);
        }
        return cell;
    }

    protected static boolean nullCell(Object cellObj) {
        if (cellObj == null) {
            return true;
        }
        if (cellObj instanceof NullObject) {
            return true;
        }
        return cellObj instanceof Value && ((Value)cellObj).isNull();
    }

    private Cell addCell(TreeSet<Cell> dstCellSet, Cell cell) {
        Object cellObj = cell.getObjectValue();
        if (Block.nullCell(cellObj)) {
            return null;
        }
        dstCellSet.add(cell);
        return cell;
    }

    public Object first() {
        Cell firstCell;
        if (this.isPipelining()) {
            Cell nextCell = (Cell)this.cellPipelineIterator.peek();
            if (nextCell == null) {
                return this.defaultValue;
            }
            return nextCell.getObjectValue();
        }
        int cellCount = this.cellSetSize();
        long tupleCount = this.tupleSetSize();
        if (this.defaultValue != null) {
            if (cellCount == 0) {
                return this.defaultValue;
            }
            if ((tupleCount < 0L || tupleCount > (long)cellCount) && (firstCell = this.cellSet.first()).getOrdinal() > 0L) {
                return this.defaultValue;
            }
        }
        if (this.cellSet.size() == 0) {
            return null;
        }
        firstCell = this.cellSet.first();
        return firstCell.getObjectValue();
    }

    public boolean isEmpty() {
        return this.first() == null;
    }

    public boolean isAllEmptySet() {
        BlockIterator blockIter = this.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (!(blockObj[0] instanceof ISet)) {
                return false;
            }
            ISet set = (ISet)blockObj[0];
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptyCells() {
        int cellCount = this.cellSetSize();
        long tupleCount = this.tupleSetSize();
        if (cellCount == 0 || tupleCount > (long)cellCount || tupleCount < 0L) {
            return this.getDefaultValue() == null;
        }
        return false;
    }

    private void changeContext(Block ctxtBlock, boolean insBlock) {
        BlockContextMap ctxMap = new BlockContextMap(this, ctxtBlock, false);
        ctxMap.setInsBlock(insBlock);
        ctxMap.setBlockDefaultValue(this.getDefaultValue());
        if (ctxMap.getBlockDefaultValue() != null) {
            this.setDefaultValue(null);
        }
        if (this.isPipelining()) {
            boolean hasDefaultValue;
            boolean streaming = this.interpreterContext.getResultSetConfiguration().isIncrementalContextCells();
            boolean bl = hasDefaultValue = ctxMap.getBlockDefaultValue() != null;
            if (hasDefaultValue && streaming) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log("BlockOrdinalChangeContextTransformIterator does not support streaming with default values.");
            }
            this.cellPipelineIterator = new BlockOrdinalChangeContextTransformIterator(this.cellPipelineIterator, ctxMap, streaming && !hasDefaultValue);
        } else {
            ContextIteratorState state = new ContextIteratorState();
            boolean useSimpleIterator = true;
            boolean[] bkeeps = new boolean[this.contextSets.length];
            for (int i = 0; i < this.contextSets.length; ++i) {
                bkeeps[i] = false;
                if (!this.isDegenerated(i) || this.contextSets[i].size() <= 1L) continue;
                useSimpleIterator = false;
            }
            BlockIterator blockIter = null;
            if (useSimpleIterator) {
                blockIter = this.cellSet.iterator();
            } else {
                int uSetNumSets = ctxMap.getuSetNumSets();
                for (int i = 0; i < uSetNumSets; ++i) {
                    bkeeps[this.contextSets.length - 1 - i] = true;
                }
                Block b2 = new Block(this, bkeeps);
                Block[] wrkBlock = new Block[]{this, b2};
                blockIter = new BlockIterator(wrkBlock);
            }
            TreeSet<Cell> newBlockCells = Block.createTreeSet();
            while (blockIter.hasNext()) {
                long blockOrdinalSurrogateId;
                Object blockObject = null;
                if (useSimpleIterator) {
                    Cell blockCell = blockIter.next();
                    blockObject = blockCell.getObjectValue();
                    blockOrdinalSurrogateId = ctxMap.getCellOrdinalSurrogate(blockCell);
                } else {
                    Object[] blockObjs = (Object[])blockIter.next();
                    blockObject = blockObjs[0];
                    blockOrdinalSurrogateId = ((BlockIterator)blockIter).pos();
                }
                ctxMap.transformNextCell(newBlockCells, blockOrdinalSurrogateId, blockObject, state, true);
            }
            if (state.contextSetCells != null && state.contextSetCells.size() > 0 && state.isHasSetPrevBlockOrd()) {
                long prevBlockOrdSurrogateId = state.getPrevBlockOrdSurrogateId();
                boolean reuseTreeSet = state.isReuseTreeSet();
                TreeSet<Cell> lastTreeSet = state.getLastTreeSet();
                if (insBlock) {
                    Cell lastCell = state.contextSetCells.last();
                    if (lastCell.getOrdinal() == (long)(state.contextSetCells.size() - 1)) {
                        Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, lastCell.getObjectValue(), false, false, ctxMap.getOrdinalMath());
                    }
                } else if (reuseTreeSet && lastTreeSet.size() == state.contextSetCells.size()) {
                    Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, lastTreeSet, false, false, ctxMap.getOrdinalMath());
                } else {
                    Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, state.contextSetCells, false, false, ctxMap.getOrdinalMath());
                }
            }
            ctxMap.reassignDefaultValue(newBlockCells);
            this.cellSet = newBlockCells;
        }
        this.contextSets = ctxMap.getNewContext();
        this.sets = ctxMap.getNewSets();
    }

    private void expandDegeneratesSets(boolean[] setsToExpand) {
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        Block b2 = new Block(this, setsToExpand);
        Block[] wrkBlock = new Block[]{this, b2};
        BlockIterator blockIter = new BlockIterator(wrkBlock);
        while (blockIter.hasNext()) {
            Object[] blockObject = (Object[])blockIter.next();
            Block.addCellSurrogateId(newCellSet, blockIter.pos(), blockObject[0], false, false, this.interpreterContext.getOrdinalMath());
        }
        this.cellSet = newCellSet;
        ArrayList<Set> newSets = new ArrayList<Set>();
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (this.isDegenerated(i) && !setsToExpand[i]) continue;
            newSets.add(this.contextSets[i]);
        }
        this.sets = newSets.toArray(new Set[0]);
    }

    private void expandOrdinal(Object blockObject, TreeSet<Cell> newCellSet, OrdinalMath.SetArrayInfo nonExpSetsInfo, OrdinalMath.SetArrayInfo expSetsInfo, long[] setOrd, int currSetIdx) {
        long expFactor = expSetsInfo.getSize(currSetIdx) / nonExpSetsInfo.getSize(currSetIdx);
        int i = 0;
        while ((long)i < expFactor) {
            long expSetOrd = setOrd[currSetIdx] + (long)i * nonExpSetsInfo.getSize(currSetIdx);
            long savedSetOrd = setOrd[currSetIdx];
            setOrd[currSetIdx] = expSetOrd;
            if (currSetIdx < setOrd.length - 1) {
                this.expandOrdinal(blockObject, newCellSet, nonExpSetsInfo, expSetsInfo, setOrd, currSetIdx + 1);
                setOrd[currSetIdx] = savedSetOrd;
            } else {
                long expBlockOrd = this.interpreterContext.getOrdinalMath().getBlockOrdinal(setOrd, expSetsInfo);
                Block.addCellSurrogateId(newCellSet, expBlockOrd, blockObject, false, false, this.interpreterContext.getOrdinalMath());
            }
            setOrd[currSetIdx] = savedSetOrd;
            ++i;
        }
    }

    public void expandSets() {
        OrdinalMath ordinalMath = this.interpreterContext.getOrdinalMath();
        this.isUnsupportedPipelineFunction(true);
        InterpreterContext.ContextInfo currContext = this.interpreterContext.getContext();
        Set[] expContextSets = currContext.expSet.getSets();
        ArrayList<Set> nonExpSetList = new ArrayList<Set>();
        ArrayList<Set> expSetList = new ArrayList<Set>();
        boolean[] isExpandedSet = new boolean[this.contextSets.length];
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (this.contextSets[i].size() != expContextSets[i].size()) {
                isExpandedSet[i] = true;
                nonExpSetList.add(this.contextSets[i]);
                expSetList.add(expContextSets[i]);
                continue;
            }
            if (this.isDegenerated(i)) continue;
            isExpandedSet[i] = false;
            nonExpSetList.add(this.contextSets[i]);
            expSetList.add(expContextSets[i]);
        }
        OrdinalMath.SetArrayInfo nonExpSetsInfo = ordinalMath.getSetArrayInfo(nonExpSetList);
        if (OrdinalMath.isSurrogateId(nonExpSetsInfo.getSize())) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Sets are too big to expand. ");
        }
        ISet[] expSets = expSetList.toArray(new Set[0]);
        OrdinalMath.SetArrayInfo expSetsInfo = ordinalMath.getSetArrayInfo(expSets);
        if (OrdinalMath.isSurrogateId(expSetsInfo.getSize())) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Sets are too big to expand.");
        }
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        Block b2 = new Block(this, isExpandedSet);
        Block[] wrkBlock = new Block[]{this, b2};
        BlockIterator blockIter = new BlockIterator(wrkBlock);
        while (blockIter.hasNext()) {
            Object[] blockObject = (Object[])blockIter.next();
            long blockOrd = blockIter.pos();
            long[] setOrdSurrogateIds = ordinalMath.getSetOrdinals(blockOrd, nonExpSetsInfo);
            this.expandOrdinal(blockObject[0], newCellSet, nonExpSetsInfo, expSetsInfo, setOrdSurrogateIds, 0);
        }
        this.contextSets = expContextSets;
        this.sets = expSets;
        this.cellSet = newCellSet;
    }

    private InterpreterContext.ContextInfo buildContextSet(boolean pushNulls, boolean[] setsToExpand) throws InterpreterException {
        Block[] childBlocks;
        ArrayList<Set> setsToUnion = new ArrayList<Set>();
        OrdinalMath ordinalMath = this.interpreterContext.getOrdinalMath();
        ArrayListBoolean setsToExpandInContent = new ArrayListBoolean();
        int[] ctxtToNdSetsMap = new int[this.contextSets.length];
        IHierarchy[] contentHiers = this.getContentHiers();
        ISet[] nonDegSets = new ISet[]{};
        OrdinalMath.SetArrayInfo nonDegSetsInfo = null;
        IHierarchy[] nonDegHiers = null;
        if (setsToExpand != null) {
            Block b2 = new Block(this, setsToExpand);
            childBlocks = new Block[]{this, b2};
            ArrayList<IHierarchy> nonDegHierList = new ArrayList<IHierarchy>();
            ArrayList<Set> nonDegSetList = new ArrayList<Set>();
            for (int i = 0; i < this.contextSets.length; ++i) {
                if (!this.isDegenerated(i)) {
                    nonDegHierList.addAll(Arrays.asList(this.contextSets[i].getHierarchies()));
                    nonDegSetList.add(this.contextSets[i]);
                    ctxtToNdSetsMap[i] = nonDegSetList.size() - 1;
                    setsToExpandInContent.add(false);
                    continue;
                }
                if (!setsToExpand[i]) continue;
                nonDegSetList.add(this.contextSets[i]);
                ctxtToNdSetsMap[i] = nonDegSetList.size() - 1;
                setsToExpandInContent.add(Block.containAnyHierarchy(this.contextSets[i], contentHiers));
            }
            nonDegSets = nonDegSetList.toArray(new ISet[0]);
            nonDegSetsInfo = ordinalMath.getSetArrayInfo(nonDegSets);
            nonDegHiers = nonDegHierList.toArray(new Hierarchy[0]);
        } else {
            childBlocks = new Block[]{this};
        }
        BlockIterator blockIter = new BlockIterator(childBlocks);
        boolean firstSet = true;
        long setEnds = 0L;
        long lastBlockOrdSurrogateId = 0L;
        long expFactor = 1L;
        Set blockDefaultValue = (Set)this.getDefaultValue();
        InterpreterContext.ContextInfo currCtxtInfo = this.interpreterContext.getContext();
        InterpreterContext interpreterContext = this.interpreterContext;
        interpreterContext.getClass();
        InterpreterContext.ContextInfo ctxtInfo = interpreterContext.new InterpreterContext.ContextInfo(new CrossJoinedSet(new Set[0]));
        ctxtInfo.prevContextMap = new ArrayListLong();
        while (blockIter.hasNext()) {
            CrossJoinedSet mergedSet;
            Object[] blockObj = (Object[])blockIter.next();
            if (blockIter.isAtDefaultValuePos()) continue;
            Set contentSet = (Set)blockObj[0];
            if (!pushNulls) {
                contentSet = contentSet.removeNullMembers();
            }
            long blockOrdSurrogateId = blockIter.pos();
            long i = lastBlockOrdSurrogateId;
            while (ordinalMath.compare(i, blockOrdSurrogateId) < 0) {
                if (blockDefaultValue != null) {
                    setEnds += blockDefaultValue.size();
                }
                ctxtInfo.prevContextMap.add(setEnds);
                i = ordinalMath.add(i, 1L);
            }
            lastBlockOrdSurrogateId = ordinalMath.add(blockOrdSurrogateId, 1L);
            ctxtInfo.prevContextMap.add(setEnds += contentSet.size());
            if (contentSet.isEmpty()) continue;
            if (firstSet) {
                for (int i2 = 0; i2 < this.contextSets.length; ++i2) {
                    if (!this.isDegenerated(i2)) continue;
                    if (setsToExpand != null && currCtxtInfo.expSet != null) {
                        Set aExpSet = currCtxtInfo.expSet.getSets()[i2];
                        Set aSet = currCtxtInfo.set.getSets()[i2];
                        ctxtInfo.set = ctxtInfo.set.mergeSet(aExpSet);
                        if (aExpSet.size() < 0L) {
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Set is too big: " + aExpSet.noOverflowSize());
                        }
                        if (aExpSet.size() == aSet.size() || (expFactor = NumberOp.multiplyQuantities(expFactor, aExpSet.size())) >= 0L) continue;
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Set is too big.");
                    }
                    ctxtInfo.set = ctxtInfo.set.mergeSet(this.contextSets[i2]);
                }
            }
            Tuple contextTuple = (Tuple)blockIter.getCurrentTuple();
            if (setsToExpand != null) {
                if ((contextTuple = contextTuple.retain(nonDegHiers)).size() > 0) {
                    mergedSet = new Set(contextTuple).mergeSet(contentSet);
                    setsToUnion.add(mergedSet);
                } else {
                    boolean mergeContentSet = true;
                    long[] setOrdSurrogateIds = null;
                    setOrdSurrogateIds = ordinalMath.getSetOrdinals(blockOrdSurrogateId, nonDegSetsInfo);
                    for (int i3 = 0; i3 < setOrdSurrogateIds.length; ++i3) {
                        if (setsToExpandInContent.get(i3) || setOrdSurrogateIds[i3] == 0L) continue;
                        mergeContentSet = false;
                    }
                    if (mergeContentSet) {
                        CrossJoinedSet mergedSet2 = new Set(contextTuple).mergeSet(contentSet);
                        setsToUnion.add(mergedSet2);
                    }
                }
            } else {
                mergedSet = new Set(contextTuple).mergeSet(contentSet);
                setsToUnion.add(mergedSet);
            }
            if (setsToExpand != null && currCtxtInfo.expSet != null) {
                long[] setOrdSurrogateIds = ordinalMath.getSetOrdinals(blockOrdSurrogateId, nonDegSetsInfo);
                ISet[] expSetSets = currCtxtInfo.expSet.getSets();
                OrdinalMath.SetArrayInfo expSetSetsInfo = ordinalMath.getSetArrayInfo(expSetSets);
                ISet[] setSets = currCtxtInfo.set.getSets();
                OrdinalMath.SetArrayInfo setSetsInfo = ordinalMath.getSetArrayInfo(setSets);
                for (int i4 = this.contextSets.length - 1; i4 >= 0; --i4) {
                    if (ordinalMath.compare(expSetSetsInfo.getSize(i4), setSetsInfo.getSize(i4)) == 0 || this.isDegenerated(i4) || ordinalMath.compare(setOrdSurrogateIds[ctxtToNdSetsMap[i4]], ordinalMath.subtract(setSetsInfo.getSize(i4), 1L)) < 0) continue;
                    long ndExpFactor = ordinalMath.divide(expSetSetsInfo.getSize(i4), setSetsInfo.getSize(i4));
                    long lCopyCount = ordinalMath.multiply(setSetsInfo.getSize(i4), expSetSetsInfo.getWeight(i4));
                    if (ordinalMath.compare(lCopyCount, Integer.MAX_VALUE) > 0) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "", String.valueOf(lCopyCount), "integer");
                    }
                    int copyCount = (int)lCopyCount;
                    int j = 1;
                    while ((long)j <= ndExpFactor - 1L) {
                        for (int itemIdx = 0; itemIdx < copyCount; ++itemIdx) {
                            contentSet = (Set)setsToUnion.get(itemIdx);
                            ctxtInfo.prevContextMap.add(setEnds += contentSet.size());
                            setsToUnion.add(contentSet);
                        }
                        ++j;
                    }
                }
            }
            firstSet = false;
        }
        long totalSize = 1L;
        for (int i = 0; i < this.sets.length; ++i) {
            totalSize = ordinalMath.multiply(totalSize, this.sets[i].size());
        }
        long i = lastBlockOrdSurrogateId;
        while (ordinalMath.compare(i, totalSize) < 0) {
            if (blockDefaultValue != null) {
                setEnds += blockDefaultValue.size();
            }
            ctxtInfo.prevContextMap.add(setEnds);
            i = ordinalMath.add(i, 1L);
        }
        if (expFactor > 1L) {
            int copyCount = ctxtInfo.prevContextMap.size();
            int i5 = 1;
            while ((long)i5 <= expFactor) {
                for (int itemIdx = 0; itemIdx < copyCount; ++itemIdx) {
                    ctxtInfo.prevContextMap.add(ctxtInfo.prevContextMap.get(itemIdx));
                }
                ++i5;
            }
        }
        Set unionedContentSets = Set.union(setsToUnion.toArray(new Set[0]), true);
        ctxtInfo.setuSetCount(1);
        if (unionedContentSets instanceof CrossJoinedSet) {
            ctxtInfo.setuSetCount(((CrossJoinedSet)unionedContentSets).getSets().length);
        }
        ctxtInfo.set = ctxtInfo.set.mergeSet(unionedContentSets);
        if (ctxtInfo.set.isEmpty()) {
            ctxtInfo.prevContextMap.clear();
            ctxtInfo.setuSetCount(0);
        }
        return ctxtInfo;
    }

    private InterpreterContext.ContextInfo buildInterpreterContext(boolean pushNulls, Collection<NamedSet> namedSets) throws InterpreterException {
        InterpreterContext.ContextInfo currCtxtInfo = this.interpreterContext.getContext();
        boolean[] setsToExpand = new boolean[this.contextSets.length];
        boolean expandSets = false;
        for (NamedSet namedSetObj : namedSets) {
            if (!namedSetObj.isInlineAndActive()) continue;
            Block setB = (Block)namedSetObj.getSet1(this.interpreterContext);
            for (int i = 0; i < setB.contextSets.length; ++i) {
                if (setB.isDegenerated(i)) continue;
                if (this.isDegenerated(i)) {
                    if (currCtxtInfo.expSet == null) {
                        setsToExpand[i] = true;
                    } else if (currCtxtInfo.expSet.getSets()[i].size() == currCtxtInfo.set.getSets()[i].size()) {
                        setsToExpand[i] = true;
                    }
                    expandSets = true;
                    continue;
                }
                if (currCtxtInfo.expSet == null) continue;
                expandSets = true;
            }
        }
        InterpreterContext.ContextInfo expandedCtxtInfo = null;
        if (expandSets) {
            expandedCtxtInfo = this.buildContextSet(pushNulls, setsToExpand);
        }
        InterpreterContext.ContextInfo newCtxtInfo = this.buildContextSet(pushNulls, null);
        newCtxtInfo.insNextContextMap = newCtxtInfo.prevContextMap;
        if (expandSets) {
            newCtxtInfo.expandedSets = setsToExpand;
            newCtxtInfo.insNextContextMap = expandedCtxtInfo.prevContextMap;
            if (newCtxtInfo.set.size() != expandedCtxtInfo.set.size()) {
                newCtxtInfo.expSet = expandedCtxtInfo.set;
                newCtxtInfo.expPrevContextMap = expandedCtxtInfo.prevContextMap;
                newCtxtInfo.expuSetCount = expandedCtxtInfo.getuSetCount();
            }
        }
        return newCtxtInfo;
    }

    private void pushChangeContext(InterpreterContext.ContextInfo ctxtInfo) throws InterpreterException {
        int uSetCount;
        ArrayList<IHierarchy> nonDegHierList = new ArrayList<IHierarchy>();
        for (int i = 0; i < this.sets.length; ++i) {
            nonDegHierList.addAll(Arrays.asList(this.sets[i].getHierarchies()));
        }
        IHierarchy[] nonDegHiers = nonDegHierList.toArray(new IHierarchy[0]);
        Set[] newContextSets = null;
        ArrayListLong nextContextMap = null;
        nextContextMap = ctxtInfo.insNextContextMap;
        if (ctxtInfo.expSet == null) {
            newContextSets = ctxtInfo.set.getSets();
            uSetCount = ctxtInfo.getuSetCount();
        } else {
            newContextSets = ctxtInfo.expSet.getSets();
            uSetCount = ctxtInfo.expuSetCount;
        }
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        for (Cell blockCell : this.cellSet) {
            int blockOrd = (int)blockCell.getOrdinal();
            Object blockObj = blockCell.getObjectValue();
            long lowOrd = 0L;
            if (blockOrd > 0) {
                lowOrd = nextContextMap.get(blockOrd - 1);
            }
            long hiOrd = nextContextMap.get(blockOrd) - 1L;
            for (long newOrd = lowOrd; newOrd <= hiOrd; ++newOrd) {
                Block.addCell(newCellSet, newOrd, blockObj, false, false);
            }
        }
        this.contextSets = newContextSets;
        ArrayList<Set> newSets = new ArrayList<Set>();
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (Block.containAnyHierarchy(this.contextSets[i], nonDegHiers)) {
                newSets.add(this.contextSets[i]);
                continue;
            }
            if (i < this.contextSets.length - uSetCount) continue;
            newSets.add(this.contextSets[i]);
        }
        this.sets = newSets.toArray(new Set[0]);
        this.cellSet.clear();
        this.cellSet.addAll(newCellSet);
    }

    public void changeToCurrentContext(Block block, boolean truePart) throws InterpreterException {
        this.isUnsupportedPipelineFunction(true);
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        long cellOrd = 0L;
        Block[] wrkBlocks = new Block[]{block, this};
        Block combinedBlock = new Block(this.interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Boolean cellValue = null;
            try {
                cellValue = this.interpreterContext.getBooleanOperand(blockObj[0]);
            }
            catch (InterpreterException ie) {
                continue;
            }
            catch (ValueConversionException e) {
                continue;
            }
            if (cellValue != truePart) continue;
            Block.addCell(newCellSet, cellOrd, blockObj[1], false, false);
            ++cellOrd;
        }
        this.contextSets = this.interpreterContext.getContextSet().getSets();
        ArrayList<IHierarchy> nonDegHierList = new ArrayList<IHierarchy>();
        for (int i = 0; i < combinedBlock.sets.length; ++i) {
            nonDegHierList.addAll(Arrays.asList(combinedBlock.sets[i].getHierarchies()));
        }
        IHierarchy[] nonDegHiers = nonDegHierList.toArray(new IHierarchy[0]);
        ArrayList<Set> newSets = new ArrayList<Set>();
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (!Block.containAnyHierarchy(this.contextSets[i], nonDegHiers)) continue;
            newSets.add(this.contextSets[i]);
        }
        this.sets = newSets.toArray(new Set[0]);
        this.cellSet = newCellSet;
    }

    public void changeToPreviousContext(Block ctxtBlock, ArrayListLong usetLimit, boolean propagateValues) {
        BlockContextMap ctxMap = new BlockContextMap(this, ctxtBlock, true);
        ctxMap.setUsetLimit(usetLimit);
        if (this.defaultValue != null) {
            boolean usetDegenarated = ctxMap.getUsetIdx().size() == 0;
            this.expandNullCells(usetDegenarated);
        }
        if (this.isPipelining()) {
            boolean streaming = this.interpreterContext.getResultSetConfiguration().isIncrementalContextCells();
            this.cellPipelineIterator = new BlockOrdinalChangeToPreviousContextTransformIterator(this.cellPipelineIterator, ctxMap, streaming, propagateValues);
        } else {
            int i;
            ContextIteratorState state = new ContextIteratorState();
            TreeSet<Cell> newCellSet = Block.createTreeSet();
            state.uSetSetOrds = new long[ctxMap.getSetUSets().length];
            long lastBlockOrdSurrogateId = 0L;
            Object lastBlockObj = null;
            boolean[] bkeeps = new boolean[this.contextSets.length];
            for (i = 0; i < this.contextSets.length; ++i) {
                bkeeps[i] = false;
            }
            for (i = 0; i < ctxMap.getuSetNumSets(); ++i) {
                bkeeps[this.contextSets.length - 1 - i] = true;
            }
            Block b2 = new Block(this, bkeeps);
            Block[] wrkBlock = new Block[]{this, b2};
            BlockIterator blockIter = new BlockIterator(wrkBlock);
            while (blockIter.hasNext()) {
                Object blockObject = ((Object[])blockIter.next())[0];
                long blockOrdinalSurrogateId = blockIter.pos();
                long ordSurrogateId = ctxMap.transformNextCell(blockOrdinalSurrogateId, blockObject, newCellSet, ctxMap, state);
                if (!propagateValues) continue;
                ctxMap.propagateValues(lastBlockOrdSurrogateId, ordSurrogateId, lastBlockObj, newCellSet);
                lastBlockOrdSurrogateId = ordSurrogateId;
                lastBlockObj = blockObject;
            }
            if (propagateValues) {
                ctxMap.propagateValues(lastBlockOrdSurrogateId, ctxMap.getNewSetsInfo().getSize(), lastBlockObj, newCellSet);
            }
            this.cellSet = newCellSet;
        }
        this.contextSets = ctxMap.getNewContext();
        this.sets = ctxMap.getNewSets();
    }

    public void getValues(InterpreterContext ic) throws InterpreterException {
        this.getValues(true);
    }

    private void getValues(boolean suppressException) throws InterpreterException {
        ISet[] evalSets;
        boolean allowAdditionalDegenerationByExpression = !PipelineResultSet.usePipelining(this.interpreterContext);
        ArrayListInt mapSetsToEvalSets = new ArrayListInt();
        LongArrayList blockOrdMap = new LongArrayList();
        ArrayListBoolean isNewDegSet = null;
        if (allowAdditionalDegenerationByExpression) {
            isNewDegSet = new ArrayListBoolean();
        }
        if ((evalSets = this.getEvaluationSet(suppressException, mapSetsToEvalSets, blockOrdMap, isNewDegSet)) == null) {
            return;
        }
        CrossJoinedSet s = new CrossJoinedSet(evalSets);
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        SetEvaluator se = new SetEvaluator(this.interpreterContext);
        IExternalAggregateStrategy aggregateStrategy = this.interpreterContext.getProvider().getExternalAggregateStrategy();
        int hierIndex = AggregationUtils.getAggregateMemberHierarchyIndex(contextSet);
        boolean doesntRequireRandomAccess = aggregateStrategy == null || hierIndex == -1;
        ResultSetConfiguration config = this.interpreterContext.getResultSetConfiguration();
        boolean pipeEnable = config.setSupportPipelineProcessing(doesntRequireRandomAccess);
        IResultSet rs = se.getSetResults(s, contextSet);
        config.setSupportPipelineProcessing(pipeEnable);
        if (rs.isPipelining()) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log("Block.getValues() using a " + rs.getClass().getName());
        }
        if (aggregateStrategy != null) {
            rs = AggregationUtils.addAggregateContext(this.interpreterContext, rs);
        }
        this.cellSet.clear();
        IResultSetIterator origIterator = rs.iterator();
        Set[] reducedContextSets = this.contextSets;
        if (allowAdditionalDegenerationByExpression) {
            ArrayList<Set> reducedContextSetsList = new ArrayList<Set>();
            for (int i = 0; i < this.contextSets.length; ++i) {
                if (isNewDegSet.get(i)) continue;
                reducedContextSetsList.add(this.contextSets[i]);
            }
            reducedContextSets = reducedContextSetsList.toArray(new Set[0]);
        }
        BlockOrdinalTransformIterator it = new BlockOrdinalTransformIterator(origIterator, reducedContextSets, (Set[])evalSets, this.sets, blockOrdMap, mapSetsToEvalSets, this.interpreterContext.getOrdinalMath());
        if (rs.isPipelining()) {
            this.cellPipelineIterator = it;
            this.cellSet = null;
            PushdownManager pushdownManager = PushdownManager.getPushdownManager(this.interpreterContext);
            if (pushdownManager != null && pushdownManager.isEnabled()) {
                pushdownManager.setPushdownExecutionFinished(true);
            }
        } else {
            while (it.hasNext()) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                Cell cell = (Cell)it.next();
                this.addCell(this.cellSet, cell);
            }
        }
        this.sets = reducedContextSets;
        if (this.cellSetSize() == 1 && !ErrorCell.isErrorCell(this.cellSet.first().value)) {
            boolean allDegeneration = true;
            for (int i = 0; i < this.contextSets.length; ++i) {
                if (this.isDegenerated(i) || this.contextSets[i].size() <= 1L && this.contextSets[i].size() >= 0L) continue;
                allDegeneration = false;
                break;
            }
            if (allDegeneration) {
                this.setDefaultValue(this.cellSet.first().value);
                this.cellSet = new TreeSet();
            }
        }
    }

    public Set[] getEvaluationSet(boolean suppressException, ArrayListInt mapSetsToEvalSets, LongArrayList blockOrdMap, ArrayListBoolean isNewDegSet) throws InterpreterException {
        Object blockCell = this.first();
        if (blockCell == null) {
            return null;
        }
        if (blockCell instanceof Value || blockCell instanceof Number || blockCell instanceof String || blockCell instanceof Boolean || blockCell instanceof Timestamp) {
            return null;
        }
        this.isUnsupportedPipelineFunction(true);
        ArrayList<Set> setsToCombine = new ArrayList<Set>();
        ArrayList<Set> setsNotToCombine = new ArrayList<Set>();
        try {
            this.buildDataTuples(mapSetsToEvalSets, setsToCombine, setsNotToCombine, isNewDegSet);
        }
        catch (InterpreterException ie) {
            if (suppressException) {
                mErrorLogger.log(ie);
                return null;
            }
            throw ie;
        }
        this.sets = setsToCombine.toArray(new Set[0]);
        ArrayList<Tuple> datTuples = new ArrayList<Tuple>();
        BlockIterator blockIter = this.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Tuple dataTuple = (Tuple)blockObj[0];
            datTuples.add(dataTuple);
            blockOrdMap.add(blockIter.pos());
        }
        Set blockSet = new Set(datTuples.toArray(new Tuple[0]));
        Set[] evalSets = new Set[setsNotToCombine.size() + 1];
        int evalSetsIndex = 0;
        for (int i = 0; i < setsNotToCombine.size(); ++i) {
            evalSets[evalSetsIndex] = setsNotToCombine.get(i);
            ++evalSetsIndex;
        }
        if (!blockSet.isEmpty()) {
            evalSets[evalSetsIndex] = blockSet;
            ++evalSetsIndex;
            mapSetsToEvalSets.add(setsNotToCombine.size());
        }
        return evalSets;
    }

    private void buildDataTuples() throws InterpreterException {
        ArrayList<Set> retBlockSets = new ArrayList<Set>();
        boolean[] keeps = new boolean[this.contextSets.length];
        if (this.isErrorBlock()) {
            return;
        }
        Block castedBlock = Caster.cast(this, Tuple.class, this.interpreterContext);
        this.cellSet = castedBlock.cellSet;
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        IHierarchy[] contentHiers = new Hierarchy[]{};
        Tuple firstContentTuple = (Tuple)this.first();
        if (firstContentTuple != null) {
            contentHiers = firstContentTuple.getHierarchies();
            for (int i = 0; i < this.contextSets.length; ++i) {
                keeps[i] = false;
                if (!this.isDegenerated(i)) {
                    retBlockSets.add(this.contextSets[i]);
                    continue;
                }
                Tuple contextTuple = (Tuple)this.contextSets[i].getTuple(0L);
                Tuple contextTuple2 = null;
                Cube cube = (Cube)this.interpreterContext.getCube();
                contextTuple2 = cube.multipleHierarchySupport() ? contextTuple.retain(contentHiers) : contextTuple.retain((Dimension[])firstContentTuple.getDimensions());
                if (contextTuple.size() == contextTuple2.size()) continue;
                keeps[i] = true;
                retBlockSets.add(this.contextSets[i]);
            }
            Block b2 = new Block(this, keeps);
            Block[] wrkBlocks = new Block[]{this, b2};
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Tuple retBlockTuple = (Tuple)blockIter.getCurrentTuple();
                Tuple contentTuple = null;
                if (blockObj[0] instanceof Tuple) {
                    contentTuple = (Tuple)blockObj[0];
                } else if (blockObj[0] instanceof IMember) {
                    IMember contentMember = (IMember)blockObj[0];
                    contentTuple = new Tuple(contentMember, this.interpreterContext.getCube());
                }
                for (int i = 0; i < contentTuple.size(); ++i) {
                    retBlockTuple.addMember(contentTuple.getMember(i));
                }
                Block.addCellSurrogateId(newCellSet, blockIter.pos(), retBlockTuple, false, false, this.interpreterContext.getOrdinalMath());
            }
            this.sets = retBlockSets.toArray(new Set[0]);
        } else {
            CrossJoinedSet contextCjs = new CrossJoinedSet(this.contextSets);
            ResourceMonitor.checkMaxSetSize(contextCjs.size(), this.interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
            long tupleOrd = 0L;
            IIterator contextSetIter = contextCjs.iterator();
            while (contextSetIter.hasNext()) {
                Tuple contextTuple = (Tuple)contextSetIter.next();
                Block.addCell(newCellSet, tupleOrd++, contextTuple.copy(), false, false);
            }
        }
        this.cellSet = Block.createTreeSet();
        this.cellSet.addAll(newCellSet);
    }

    private void buildDataTuples(ArrayListInt retMap, ArrayList<Set> setsToCombine, ArrayList<Set> setsNotToCombine, ArrayListBoolean isNewDegSet) throws InterpreterException {
        ArrayList<Set> retBlockSets = new ArrayList<Set>();
        boolean[] keeps = new boolean[this.contextSets.length];
        Block castedBlock = Caster.cast(this, Tuple.class, this.interpreterContext);
        this.cellSet = castedBlock.cellSet;
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        IHierarchy[] contentHiers = new Hierarchy[]{};
        Tuple firstContentTuple = (Tuple)this.first();
        if (firstContentTuple != null) {
            contentHiers = firstContentTuple.getHierarchies();
            ArrayListInt dataTupleSets = new ArrayListInt();
            int nNewDegeneratedSets = 0;
            for (int i = 0; i < this.contextSets.length; ++i) {
                keeps[i] = false;
                if (!this.isDegenerated(i)) {
                    retBlockSets.add(this.contextSets[i]);
                    setsToCombine.add(this.contextSets[i]);
                    dataTupleSets.add(i - nNewDegeneratedSets);
                    if (isNewDegSet == null) continue;
                    isNewDegSet.add(false);
                    continue;
                }
                Tuple contextTuple = (Tuple)this.contextSets[i].getTuple(0L);
                Tuple contextTuple2 = null;
                Cube cube = (Cube)this.interpreterContext.getCube();
                contextTuple2 = cube.multipleHierarchySupport() ? contextTuple.retain(contentHiers) : contextTuple.retain((Dimension[])firstContentTuple.getDimensions());
                if (contextTuple.size() != contextTuple2.size()) {
                    if (contextTuple2.size() != 0) {
                        if (this.cellSetSize() == 1 && contextTuple2.size() == 1) {
                            Set setCopy = (Set)this.contextSets[i].copy();
                            IHierarchy contentHier = contextTuple2.getMember(0).getHierarchy();
                            setCopy = (Set)setCopy.removeHierarchy(contentHier, true);
                            setsNotToCombine.add(setCopy);
                            retMap.add(i - nNewDegeneratedSets);
                        } else {
                            keeps[i] = true;
                            retBlockSets.add(this.contextSets[i]);
                            setsToCombine.add(this.contextSets[i]);
                            dataTupleSets.add(i - nNewDegeneratedSets);
                        }
                    } else {
                        setsNotToCombine.add(this.contextSets[i]);
                        retMap.add(i - nNewDegeneratedSets);
                    }
                    if (isNewDegSet == null) continue;
                    isNewDegSet.add(false);
                    continue;
                }
                if (isNewDegSet != null) {
                    ++nNewDegeneratedSets;
                    isNewDegSet.add(true);
                    continue;
                }
                keeps[i] = true;
                retBlockSets.add(this.contextSets[i]);
                setsToCombine.add(this.contextSets[i]);
                dataTupleSets.add(i);
            }
            retMap.addAll(dataTupleSets);
            Block b2 = new Block(this, keeps);
            Block[] wrkBlocks = new Block[]{this, b2};
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Tuple retBlockTuple = (Tuple)blockIter.getCurrentTuple();
                Tuple contentTuple = (Tuple)blockObj[0];
                if (retBlockTuple.size() == 0) {
                    retBlockTuple = contentTuple;
                } else {
                    for (int i = 0; i < contentTuple.size(); ++i) {
                        retBlockTuple.addMember(contentTuple.getMember(i));
                    }
                }
                Block.addCellSurrogateId(newCellSet, blockIter.pos(), retBlockTuple, false, false, this.interpreterContext.getOrdinalMath());
            }
            this.sets = retBlockSets.toArray(new Set[0]);
        } else {
            CrossJoinedSet contextCjs = new CrossJoinedSet(this.contextSets);
            long tupleOrd = 0L;
            IIterator contextSetIter = contextCjs.iterator();
            while (contextSetIter.hasNext()) {
                Tuple contextTuple = (Tuple)contextSetIter.next();
                Block.addCell(newCellSet, tupleOrd++, contextTuple.copy(), false, false);
            }
        }
        this.cellSet = Block.createTreeSet();
        this.cellSet.addAll(newCellSet);
    }

    public void getCurrentMembers() throws InterpreterException {
        IMember[] mems;
        this.isUnsupportedPipelineFunction(true);
        Object dimOrHier = this.first();
        IHierarchy hierarchy = null;
        IMember hierarchyDefaultMember = null;
        if (dimOrHier instanceof IDimension) {
            hierarchy = ((IDimension)dimOrHier).getDefaultHierarchy();
        } else if (dimOrHier instanceof IHierarchy) {
            hierarchy = (IHierarchy)dimOrHier;
            try {
                hierarchyDefaultMember = MemberOperations.getDefaultMemberOp((IHierarchy)dimOrHier, this.interpreterContext);
            }
            catch (MetadataException e) {
                throw new MDXEngineException("X01408", (Throwable)e, new String[]{((IHierarchy)dimOrHier).toString()});
            }
        } else {
            throw new InterpreterException("Unhandled object type in Block.getCurrentMembers()");
        }
        int currMemSetIdx = -1;
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (!this.contextSets[i].contains(hierarchy)) continue;
            currMemSetIdx = i;
            break;
        }
        if (currMemSetIdx < 0 || currMemSetIdx >= this.contextSets.length) {
            currMemSetIdx = 0;
        }
        this.sets = new Set[]{this.contextSets[currMemSetIdx]};
        if (currMemSetIdx > -1 && ((Dimension)hierarchy.getDimension()).isAttributeDimension() && (mems = this.contextSets[currMemSetIdx].getMembers(hierarchy)).length == 1 && !mems[0].isCalculatedMember() && ((Cube)this.interpreterContext.getCube()).isDummyMember(mems[0])) {
            this.sets[0].replaceMember(hierarchy.getDefaultMember());
        }
        if (currMemSetIdx > -1 && ((Dimension)hierarchy.getDimension()).getCube() instanceof LOLAPTM1Cube && (mems = this.contextSets[currMemSetIdx].getMembers(hierarchy)).length == 1 && !mems[0].isCalculatedMember() && mems[0].isProviderDefaultMember()) {
            this.sets[0].replaceMember(hierarchy.getDefaultMember());
        }
        this.cellSet.clear();
        long ord = 0L;
        Set cmSet = this.sets[0];
        ResourceMonitor.checkMaxSetSize(cmSet.size(), this.interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        IIterator setIter = cmSet.iterator();
        while (setIter.hasNext()) {
            Tuple tuple = (Tuple)setIter.next();
            IMember currMember = tuple.getMember(hierarchy);
            if (dimOrHier instanceof IHierarchy && (currMember == null || currMember.getHierarchy() != (IHierarchy)dimOrHier)) {
                currMember = hierarchyDefaultMember;
            }
            Block.addCell(this.cellSet, ord++, currMember, false, false);
        }
    }

    private void isUnsupportedPipelineFunction(boolean materializable) {
        if (this.isPipelining()) {
            if (!materializable) {
                throw new UnsupportedOperationException(THIS_FUNCTION_NOT_SUPPORTED_WHEN_PIPELINING);
            }
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            String functionName = ste[3].toString();
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log("Function " + functionName + " is unsupported for pipeline blocks. The block will be materialized, which may be significantly less efficient.");
            this.materializePipeline();
        }
    }

    public void getLevelMembers() throws InterpreterException {
        if (!(this.first() instanceof ILevel)) {
            throw new InterpreterException("Unhandled object type in Block.getLevelMembers()");
        }
        ILevel level = (ILevel)this.first();
        List<IMember> memberList = level.getMembers();
        IMember[] mems = memberList.toArray(new IMember[0]);
        mems = MemberOperations.applySecurityToMembers(mems, level.getHierarchy(), this.interpreterContext);
        Set levelSet = new Set(Tuple.createTupleList(mems));
        this.cellSet.clear();
        Block.addCell(this.cellSet, 0L, levelSet, false, false);
    }

    public void expandNullCells(boolean usetDegenerated) {
        this.isUnsupportedPipelineFunction(true);
        if (usetDegenerated) {
            TreeSet<Cell> newDefValue = Block.createTreeSet();
            newDefValue.add(new Cell(0L, this.getDefaultValue()));
            this.setDefaultValue(newDefValue);
        } else {
            int newCellSetSize = 1;
            for (int i = 0; i < this.sets.length; ++i) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                newCellSetSize = (int)((long)newCellSetSize * this.sets[i].size());
            }
            for (int ord = 0; ord < newCellSetSize; ++ord) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                Block.addCell(this.cellSet, ord, this.getDefaultValue(), false, false);
            }
            this.setDefaultValue(null);
        }
    }

    public static IBlockIterator getStreamingBlockIterator(Block[] blocks, int streamingBlockPosition) {
        IBlockIterator baseIterator = Block.getBlockIterator(blocks, true, false);
        if (!baseIterator.returnsCellArray()) {
            baseIterator = new TreeSetExpandingBlockIterator(baseIterator, streamingBlockPosition);
        }
        return baseIterator;
    }

    public static IBlockIterator getBlockIterator(Block[] blocks) {
        return Block.getBlockIterator(blocks, false, false);
    }

    public static IBlockIterator getBlockIterator(Block[] blocks, boolean sparseIter) {
        return Block.getBlockIterator(blocks, false, sparseIter);
    }

    private static IBlockIterator getBlockIterator(Block[] blocks, boolean allowReturnCellArray, boolean sparseIter) {
        AbstractBlockIterator iter;
        ArrayList<Block> unsupportedPipelineBlocks;
        if (Block.havePipelineBlocks(blocks) && !MultiplexBlockIterator.supportsBlocks(blocks, unsupportedPipelineBlocks = new ArrayList<Block>())) {
            for (Block b : unsupportedPipelineBlocks) {
                b.materializePipeline();
            }
            ROLAPLog.log("ROLAPPipeline", "Had to materialize " + unsupportedPipelineBlocks.size() + " pipeline blocks when trying to create a blockIterator.");
        }
        if (Block.havePipelineBlocks(blocks)) {
            if (!allowReturnCellArray && PipelineBlockIterator.returnsCellArray(blocks)) {
                for (Block b : blocks) {
                    if (!b.isPipelining()) continue;
                    b.materializePipeline();
                }
                ROLAPLog.log("ROLAPPipeline", "Had to materialize all pipline blocks when creating  a blockIterator because pipelines were streaming and caller did not ask for a streaming iterator.");
                iter = new BlockIterator(blocks, sparseIter);
            } else {
                iter = new MultiplexBlockIterator(blocks);
            }
        } else {
            iter = new BlockIterator(blocks, sparseIter);
        }
        return iter;
    }

    private static boolean havePipelineBlocks(Block[] blocks) {
        for (Block block : blocks) {
            if (!block.isPipelining()) continue;
            return true;
        }
        return false;
    }

    public void materializePipeline() {
        if (!this.isPipelining()) {
            return;
        }
        if (this.cellPipelineIterator.hasStartedIteration()) {
            throw new UnsupportedOperationException("Cannot materialize a pipeline block after cells have been fetched.");
        }
        TreeSet<Cell> treeSet = Block.consumePipeline(this.cellPipelineIterator);
        this.cellSet = treeSet;
        this.cellPipelineIterator = null;
    }

    private static TreeSet<Cell> consumePipeline(AbstractBlockOrdinalTransformIterator pipelineIter) {
        boolean streaming = pipelineIter.allowsStreaming();
        TreeSet<Cell> treeSet = Block.createTreeSet();
        long startTime = System.currentTimeMillis();
        TreeSet lastContextSet = null;
        long lastContextOrdinal = 0L;
        while (pipelineIter.hasNext()) {
            Object obj = pipelineIter.next();
            if (streaming) {
                Cell wrapperCell = ((Cell[])obj)[0];
                if (wrapperCell.getValue() == NullContextFlagValue.NULLCONTEXTFLAGVALUE) continue;
                long contextOrdinal = wrapperCell.getOrdinal();
                if (lastContextOrdinal != contextOrdinal || lastContextSet == null) {
                    Cell contextSetCell = treeSet.floor(wrapperCell);
                    if (contextSetCell == null || contextSetCell.getOrdinal() != contextOrdinal) {
                        lastContextSet = Block.createTreeSet();
                        lastContextOrdinal = contextOrdinal;
                        Cell c = new Cell(lastContextOrdinal, lastContextSet);
                        treeSet.add(c);
                    } else {
                        lastContextOrdinal = contextSetCell.getOrdinal();
                        lastContextSet = (TreeSet)contextSetCell.getObjectValue();
                    }
                }
                lastContextSet.add((Cell)wrapperCell.getObjectValue());
                continue;
            }
            treeSet.add((Cell)obj);
        }
        long endTime = System.currentTimeMillis();
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log("Consumed " + pipelineIter.size() + " cells from the pipline  to build a treeSet of " + treeSet.size() + " entries in " + (endTime - startTime) + "ms.");
        return treeSet;
    }

    public boolean isDegenerated(int contextSetIdx) {
        boolean result = true;
        if (this.contextSets.length - 1 < contextSetIdx) {
            return result;
        }
        for (int i = 0; i < this.sets.length; ++i) {
            if (this.contextSets[contextSetIdx] != this.sets[i]) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean hasExpandedSets() {
        InterpreterContext.ContextInfo currContext = this.interpreterContext.getContext();
        if (currContext.expSet == null) {
            return false;
        }
        Set[] expContextSets = currContext.expSet.getSets();
        if (this.contextSets.length != expContextSets.length) {
            return false;
        }
        for (int i = 0; i < this.contextSets.length; ++i) {
            if (this.contextSets[i] == expContextSets[i]) continue;
            return false;
        }
        return true;
    }

    public int cellSetSize() {
        if (this.isPipelining()) {
            return this.cellPipelineIterator.size();
        }
        return this.cellSet.size();
    }

    public Set[] getContextSet() {
        return this.contextSets;
    }

    public Set[] getSets() {
        return this.sets;
    }

    public long tupleSetSize() {
        return this.crossjoinSize(this.sets);
    }

    private long crossjoinSize(Set[] crossJoinSets) {
        if (crossJoinSets.length == 0) {
            return 0L;
        }
        long size = 1L;
        for (int i = 0; i < crossJoinSets.length; ++i) {
            if ((size = NumberOp.multiplyQuantities(size, crossJoinSets[i].size())) >= 0L) continue;
            return size;
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cast(Class<?> destClass) throws InterpreterException {
        block14: {
            ArrayList<Set> castBlockSets;
            boolean[] keeps;
            Dimension[] srcDimension;
            block13: {
                this.isUnsupportedPipelineFunction(true);
                Object blockFirstObj = this.first();
                if (blockFirstObj == null) {
                    return;
                }
                if (destClass == IMember.class || destClass == Member.class) {
                    if (blockFirstObj instanceof IDimension || blockFirstObj instanceof IHierarchy) {
                        srcDimension = blockFirstObj instanceof Hierarchy ? new Dimension[]{(Dimension)((Hierarchy)blockFirstObj).getDimension()} : new Dimension[]{(Dimension)blockFirstObj};
                        keeps = new boolean[this.contextSets.length];
                        castBlockSets = new ArrayList<Set>();
                        break block13;
                    } else {
                        if (blockFirstObj instanceof IMember) {
                            return;
                        }
                        throw new InterpreterException("X01461", new String[]{blockFirstObj.getClass().getSimpleName(), destClass.getSimpleName()});
                    }
                }
                if (destClass != String.class) {
                    throw new InterpreterException("X01461", new String[]{blockFirstObj.getClass().getSimpleName(), destClass.getSimpleName()});
                }
                break block14;
            }
            for (int i = 0; i < this.contextSets.length; ++i) {
                keeps[i] = false;
                if (this.isDegenerated(i)) {
                    if (!this.contextSets[i].contains(srcDimension[0])) continue;
                    keeps[i] = true;
                    castBlockSets.add(this.contextSets[i]);
                    continue;
                }
                castBlockSets.add(this.contextSets[i]);
            }
            Block degBlock = new Block(this, keeps);
            Block[] wrkBlocks = new Block[]{this, degBlock};
            IMember castBlockDefValue = null;
            TreeSet<Cell> castBlockCells = Block.createTreeSet();
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (true) {
                if (!blockIter.hasNext()) {
                    this.setDefaultValue(castBlockDefValue);
                    this.sets = castBlockSets.toArray(new Set[0]);
                    this.cellSet = castBlockCells;
                    return;
                }
                blockIter.next();
                Tuple currIterTuple = (Tuple)blockIter.getCurrentTuple();
                IMember castObj = currIterTuple.retain(srcDimension).getMember(0);
                if (blockIter.isAtDefaultValuePos()) {
                    castBlockDefValue = castObj;
                    continue;
                }
                Block.addCellSurrogateId(castBlockCells, blockIter.pos(), castObj, false, false, this.interpreterContext.getOrdinalMath());
            }
        }
        Iterator<Cell> cellIter = this.cellSet.iterator();
        while (cellIter.hasNext()) {
            Cell blockCell = cellIter.next();
            Object cellObj = blockCell.getObjectValue();
            if (cellObj == NullObject.instance()) {
                blockCell.setValue(cellObj);
                continue;
            }
            String strValue = blockCell.getStringValue();
            blockCell.setValue(strValue);
        }
    }

    public void removeInvalidTuples() {
        if ("Metadata".equals(this.interpreterContext.getXDataContext().getEnvironment().getRequestEnvironment().getOperationName())) {
            return;
        }
        Object blockFirstObj = this.first();
        if (blockFirstObj == null || !(blockFirstObj instanceof ISet)) {
            return;
        }
        Set contentSet = (Set)blockFirstObj;
        if (!contentSet.multipleHierarchySupport(this.interpreterContext.getCube())) {
            return;
        }
        ArrayList<IHierarchy> skipHiers = null;
        ArrayList<IHierarchy[]> queryAxesHierarchies = this.interpreterContext.getQueryAxesHierarchies();
        if (queryAxesHierarchies != null) {
            for (IHierarchy[] hiers : queryAxesHierarchies) {
                boolean excludeAxis = true;
                for (IHierarchy iHierarchy : hiers) {
                    if (!contentSet.contains(iHierarchy)) continue;
                    excludeAxis = false;
                }
                if (!excludeAxis) continue;
                if (skipHiers == null) {
                    skipHiers = new ArrayList<IHierarchy>();
                }
                for (IHierarchy iHierarchy : hiers) {
                    skipHiers.add(iHierarchy);
                }
            }
        }
        boolean[] nonDegSets = new boolean[this.contextSets.length];
        ArrayList<Set> newSets = new ArrayList<Set>();
        IDimension[] contentDims = contentSet.getDimensions();
        block3: for (int setIdx = 0; setIdx < this.contextSets.length; ++setIdx) {
            nonDegSets[setIdx] = false;
            if (!this.isDegenerated(setIdx)) {
                nonDegSets[setIdx] = true;
                newSets.add(this.contextSets[setIdx]);
                continue;
            }
            for (int dimIdx = 0; dimIdx < contentDims.length; ++dimIdx) {
                if (this.contextSets[setIdx].contains(contentDims[dimIdx])) {
                    List<IHierarchy> dimHiers = contentDims[dimIdx].getHierarchies();
                    for (IHierarchy hier : dimHiers) {
                        if (!this.contextSets[setIdx].contains(hier) || contentSet.contains(hier)) continue;
                        nonDegSets[setIdx] = true;
                        newSets.add(this.contextSets[setIdx]);
                        break;
                    }
                }
                if (nonDegSets[setIdx]) continue block3;
            }
        }
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        HashMap<ILevel, Map<IMember, int[]>> convLevelMap = new HashMap<ILevel, Map<IMember, int[]>>();
        Block b2 = new Block(this, nonDegSets);
        Block[] blockArray = new Block[]{this, b2};
        BlockIterator blockIter = new BlockIterator(blockArray);
        boolean reductionApplied = false;
        while (blockIter.hasNext()) {
            Object[] blockObjs = (Object[])blockIter.next();
            Set set = (Set)blockObjs[0];
            ITuple contextTuple = null;
            if (!blockIter.isAtDefaultValuePos()) {
                contextTuple = blockIter.getCurrentTuple();
                if (skipHiers != null) {
                    ArrayList<IMember> mems = new ArrayList<IMember>();
                    for (int i = 0; i < contextTuple.size(); ++i) {
                        IMember member = contextTuple.getMember(i);
                        if (skipHiers.contains(member.getHierarchy())) continue;
                        mems.add(member);
                    }
                    contextTuple = new Tuple(mems.toArray(new IMember[mems.size()]), this.interpreterContext.getCube());
                }
            } else {
                contextTuple = new Tuple(new IMember[0], this.interpreterContext.getCube());
            }
            Set newSet = set.removeInvalidTuples(this.interpreterContext.getCube(), convLevelMap, contextTuple);
            if (blockIter.isAtDefaultValuePos()) {
                this.setDefaultValue(newSet);
            } else {
                Block.addCellSurrogateId(newCellSet, blockIter.pos(), newSet, false, false, this.interpreterContext.getOrdinalMath());
            }
            if (newSet == set) continue;
            reductionApplied = true;
        }
        if (reductionApplied) {
            this.cellSet = newCellSet;
            this.sets = newSets.toArray(new Set[newSets.size()]);
        }
    }

    protected int getIndexOfSetContainingHierarchy(Set[] setList, IHierarchy hier) {
        if (setList.length > 0 && setList[0].multipleHierarchySupport()) {
            for (int i = 0; i < setList.length; ++i) {
                if (!setList[i].contains(hier)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < setList.length; ++i) {
                if (!setList[i].contains(hier.getDimension())) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean containAnyHierarchy(ISet set, IHierarchy[] hierList) {
        for (int i = 0; i < hierList.length; ++i) {
            if (!set.contains(hierList[i])) continue;
            return true;
        }
        return false;
    }

    private IHierarchy[] getContentHiers() {
        Object firstObj = this.first();
        if (firstObj == null || !(firstObj instanceof Set)) {
            return new IHierarchy[0];
        }
        Set contentSet = (Set)firstObj;
        return contentSet.getHierarchies();
    }

    public void setDefaultValue(Object defValue) {
        if (defValue instanceof NullObject) {
            this.defaultValue = null;
            return;
        }
        if (defValue instanceof Value && ((Value)defValue).isNull()) {
            this.defaultValue = null;
            return;
        }
        this.defaultValue = defValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void keepOnlyErrorCells() {
        this.isUnsupportedPipelineFunction(true);
        TreeSet<Cell> newCellSet = Block.createTreeSet();
        for (Cell blockCell : this.cellSet) {
            Object cellValue = blockCell.getObjectValue();
            if (!ErrorCell.isErrorCell(cellValue)) continue;
            this.addCell(newCellSet, blockCell);
        }
        this.cellSet = newCellSet;
        this.defaultValue = null;
    }

    public boolean isConstant() {
        return this.sets == null || this.sets.length == 0;
    }

    public IResultSet toResultSet() {
        AbstractResultSet retResultSet;
        if (this.isPipelining() && this.cellPipelineIterator.hasStartedIteration()) {
            this.isUnsupportedPipelineFunction(false);
        }
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        OrdinalMath ordinalMath = this.interpreterContext.getOrdinalMath();
        ArrayList<Set> contextMts = new ArrayList<Set>();
        ArrayList<IMember> contextSts = new ArrayList<IMember>();
        Set[] context = null;
        context = contextSet != null ? contextSet.getSets() : new Set[]{};
        for (int i = 0; i < context.length; ++i) {
            if (context[i].size() > 1L || context[i].size() < 0L) {
                contextMts.add(context[i]);
                continue;
            }
            ITuple tuple = context[i].getTuple(0L);
            for (int memIdx = 0; memIdx < tuple.size(); ++memIdx) {
                contextSts.add(tuple.getMember(memIdx));
            }
        }
        CrossJoinedSet axes = new CrossJoinedSet(contextMts.toArray(new Set[0]));
        boolean[] degSets = new boolean[this.contextSets.length];
        boolean hasDegeneration = false;
        boolean allDegeneration = true;
        for (int i = 0; i < this.contextSets.length; ++i) {
            degSets[i] = false;
            if (this.isDegenerated(i)) {
                degSets[i] = true;
                if (this.contextSets[i].size() <= 1L && this.contextSets[i].size() >= 0L) continue;
                hasDegeneration = true;
                continue;
            }
            if (this.contextSets[i].size() <= 1L && this.contextSets[i].size() >= 0L) continue;
            allDegeneration = false;
        }
        if (this.isPipelining() && !hasDegeneration) {
            retResultSet = new NestedPipelineResultSet(new Set[]{axes}, new Set(new Tuple(contextSts.toArray(new IMember[0]), this.interpreterContext.getCube())), this.cellPipelineIterator);
            retResultSet.setDefaultValue(this.getDefaultValue());
        } else {
            boolean allowAdditionalDegenerationByExpression;
            retResultSet = new ResultSet(new Set[]{axes}, new Set(new Tuple(contextSts.toArray(new IMember[0]), this.interpreterContext.getCube())));
            boolean bl = allowAdditionalDegenerationByExpression = !PipelineResultSet.usePipelining(this.interpreterContext);
            if (allDegeneration && allowAdditionalDegenerationByExpression) {
                if (this.cellSet != null && !this.cellSet.isEmpty()) {
                    retResultSet.setDefaultValue(this.cellSet.first().getObjectValue());
                } else if (this.getDefaultValue() != null) {
                    retResultSet.setDefaultValue(this.getDefaultValue());
                }
                return retResultSet;
            }
            retResultSet.setDefaultValue(this.getDefaultValue());
            if (hasDegeneration) {
                Block degeneratedBlock = new Block(this, degSets);
                boolean allDegSets = true;
                for (boolean isDegSet : degSets) {
                    allDegSets = allDegSets && isDegSet;
                }
                if (allDegSets) {
                    ResourceMonitor.checkMaxSetSize(degeneratedBlock.tupleSetSize(), this.interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
                }
                IBlockIterator thisBlockIter = Block.getBlockIterator(new Block[]{this, degeneratedBlock});
                while (thisBlockIter.hasNext()) {
                    if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    Object[] blockObj = (Object[])thisBlockIter.next();
                    if (blockObj[0] == null) continue;
                    if (thisBlockIter.isAtDefaultValuePos()) {
                        retResultSet.setDefaultValue(blockObj[0]);
                        continue;
                    }
                    long cellOrdSurrogateId = thisBlockIter.pos();
                    Cell rsCell = null;
                    rsCell = OrdinalMath.isSurrogateId(cellOrdSurrogateId) ? new BCell(ordinalMath.getBigInteger(cellOrdSurrogateId), blockObj[0], false, false) : new Cell(blockObj[0], cellOrdSurrogateId, false);
                    retResultSet.addCell(rsCell);
                }
            } else {
                Iterator<Cell> cellIter = this.cellSet.iterator();
                while (cellIter.hasNext()) {
                    if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    Cell cell = cellIter.next();
                    retResultSet.addCell(cell);
                }
            }
        }
        if (!retResultSet.isPipelining()) {
            ((ResultSet)retResultSet).setIgnoreChangeContext(true);
        }
        return retResultSet;
    }

    public Iterator<TupleValue> tupleValueIterator() {
        this.isUnsupportedPipelineFunction(true);
        return new TupleValueIterator();
    }

    public String toString() {
        int cellCount = 0;
        String blockStr = "[";
        if (this.cellSet != null) {
            for (Cell blockCell : this.cellSet) {
                Integer moreCount;
                Long cellOrd = XQELongPool.getLong(blockCell.getOrdinal());
                Object cellValue = blockCell.getObjectValue();
                if (cellCount > 0) {
                    blockStr = blockStr + " ";
                }
                blockStr = blockStr + "Ord:" + cellOrd.toString() + ", Val:" + cellValue.toString();
                if (++cellCount < 1000 || (moreCount = Integer.valueOf(this.cellSet.size() - cellCount)) <= 0) continue;
                blockStr = blockStr + "... " + moreCount.toString() + " more";
                break;
            }
        } else {
            blockStr = blockStr + "Using pipelining for this block.";
        }
        blockStr = blockStr + "]";
        return blockStr;
    }

    public long cachingSize() {
        int i;
        long retVal = 0L;
        for (i = 0; i < this.contextSets.length; ++i) {
            retVal += this.contextSets[i].size();
        }
        for (i = 0; i < this.sets.length; ++i) {
            retVal += this.sets[i].size();
        }
        BlockIterator blockIter = this.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (!(blockObj[0] instanceof ISet)) continue;
            retVal += ((ISet)blockObj[0]).size();
        }
        return retVal;
    }

    public Cell getCellForOrdinal(Cell c) {
        if (this.isPipelining()) {
            throw new UnsupportedOperationException("Random access is not supported when pipelining.");
        }
        Cell cell = this.cellSet.floor(c);
        if (cell != null && cell.getOrdinal() != c.getOrdinal()) {
            cell = null;
        }
        return cell;
    }

    public boolean isUseDefaultValueObject() {
        return this.useDefaultValueObject;
    }

    public static TreeSet<Cell> createTreeSet() {
        return new TreeSet<Cell>();
    }

    public boolean isErrorBlock() {
        return this.cellSetSize() == 1 && ErrorCell.isErrorCell(this.cellSet.first().value);
    }

    public static class ContextIteratorState {
        HashMapLongObject<TreeSet<Cell>> treeSetCache = null;
        TreeSet<Cell> lastTreeSet = null;
        Iterator<Cell> lastTreeSetIter = null;
        boolean reuseTreeSet = false;
        long prevBlockOrdSurrogateId = -1L;
        boolean hasSetPrevBlockOrd = false;
        long ctxtBlockOrd = 0L;
        TreeSet<Cell> contextSetCells = null;
        long[] uSetSetOrds;

        public HashMapLongObject<TreeSet<Cell>> getTreeSetCache() {
            return this.treeSetCache;
        }

        public void setTreeSetCache(HashMapLongObject<TreeSet<Cell>> tsCache) {
            this.treeSetCache = tsCache;
        }

        public TreeSet<Cell> getLastTreeSet() {
            return this.lastTreeSet;
        }

        public void setLastTreeSet(TreeSet<Cell> lastTS) {
            this.lastTreeSet = lastTS;
        }

        public Iterator<Cell> getLastTreeSetIter() {
            return this.lastTreeSetIter;
        }

        public void setLastTreeSetIter(Iterator<Cell> lastTSIter) {
            this.lastTreeSetIter = lastTSIter;
        }

        public boolean isReuseTreeSet() {
            return this.reuseTreeSet;
        }

        public void setReuseTreeSet(boolean reuseTS) {
            this.reuseTreeSet = reuseTS;
        }

        public long getPrevBlockOrdSurrogateId() {
            return this.prevBlockOrdSurrogateId;
        }

        public void setPrevBlockOrdSurrogateId(long prevOrdSurrogateId) {
            this.prevBlockOrdSurrogateId = prevOrdSurrogateId;
        }

        public boolean isHasSetPrevBlockOrd() {
            return this.hasSetPrevBlockOrd;
        }

        public void setHasSetPrevBlockOrd(boolean hasSetPrevOrd) {
            this.hasSetPrevBlockOrd = hasSetPrevOrd;
        }
    }

    private final class TupleValueIterator
    implements Iterator<TupleValue> {
        private final CrossJoinedSet crossJoinedSet;
        private final Iterator<Cell> cellSetIterator;
        private long counter = 0L;
        private final long size;
        private Cell currentCell;

        private TupleValueIterator() {
            this.crossJoinedSet = new CrossJoinedSet(Block.this.sets);
            this.size = this.crossJoinedSet.size();
            this.cellSetIterator = Block.this.cellSet.iterator();
            if (this.cellSetIterator.hasNext()) {
                this.currentCell = this.cellSetIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.size;
        }

        @Override
        public TupleValue next() {
            if (Block.this.cancelManager != null && Block.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            Cell c = null;
            if (this.currentCell != null && this.currentCell.getOrdinal() == this.counter) {
                c = this.currentCell;
                if (this.cellSetIterator.hasNext()) {
                    this.currentCell = this.cellSetIterator.next();
                }
            }
            ITuple t = this.crossJoinedSet.getTuple(this.counter);
            TupleValue result = new TupleValue(t, c);
            ++this.counter;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long pos() {
            return this.counter - 1L;
        }
    }
}

