/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.util.CellTreeSet;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.util.primitive.ArrayListBoolean;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.ArrayListLong;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class BlockContextMap {
    private OrdinalMath ordinalMath;
    private OrdinalMath.SetArrayInfo ctxtBlockSetsInfo;
    private ArrayListLong usetLimit;
    private long[] usetLimitSurrogateIds;
    private int uSetNumSets = 0;
    private OrdinalMath.SetArrayInfo setsPlusUSetInfo = null;
    private int[] newCtxtToBlock;
    private final ArrayListInt newSetToSet = new ArrayListInt();
    private final ArrayListBoolean mapsToUset = new ArrayListBoolean();
    private Set[] newSets;
    private OrdinalMath.SetArrayInfo newSetsInfo;
    private long[] usetSize;
    private Set[] newContext;
    private Set[] setUSets;
    private OrdinalMath.SetArrayInfo setUSetsInfo;
    private OrdinalMath.SetArrayInfo contextUSetInfo;
    private final ArrayListInt usetIdx = new ArrayListInt();
    private Set[] contextUSet;
    private int[] newCtxtToCtxtUSet;
    private boolean insBlock;
    private Object blockDefaultValue;
    private final Block currBlk;

    public BlockContextMap(Block currBlock, Block ctxtBlock, boolean previousContext) {
        if (previousContext) {
            this.initializeChangeToPreviousContext(currBlock, ctxtBlock);
        } else {
            this.initializeChangeContext(currBlock, ctxtBlock);
        }
        this.currBlk = currBlock;
    }

    private void initializeChangeContext(Block currBlock, Block ctxtBlock) {
        Cell blockCell;
        int i;
        this.ordinalMath = currBlock.interpreterContext.getOrdinalMath();
        InterpreterContext.ContextInfo ctxtInfo = currBlock.interpreterContext.getContext();
        this.ctxtBlockSetsInfo = this.ordinalMath.getSetArrayInfo(ctxtBlock.getSets());
        this.usetLimit = new ArrayListLong();
        if (currBlock.hasExpandedSets()) {
            this.usetLimit.addAll(ctxtInfo.expPrevContextMap);
            this.uSetNumSets = ctxtInfo.expuSetCount;
        } else {
            this.usetLimit.addAll(ctxtInfo.prevContextMap);
            this.uSetNumSets = ctxtInfo.getuSetCount();
        }
        int usetLimitSize = this.usetLimit.size();
        this.usetLimitSurrogateIds = new long[usetLimitSize];
        for (int i2 = 0; i2 < usetLimitSize; ++i2) {
            long usetLimitSurrogateId = this.usetLimit.get(i2);
            if (usetLimitSurrogateId < 0L) {
                usetLimitSurrogateId = this.ordinalMath.createSurrogateId(BigInteger.valueOf(usetLimitSurrogateId));
            }
            this.usetLimitSurrogateIds[i2] = usetLimitSurrogateId;
        }
        Set[] contextSets = currBlock.getContextSet();
        Set[] sets = currBlock.getSets();
        ISet[] setsPlusUSet = null;
        if (contextSets.length > 0) {
            ArrayList<Set> uSetSets = new ArrayList<Set>();
            for (int i3 = 0; i3 < this.uSetNumSets; ++i3) {
                uSetSets.add(0, contextSets[contextSets.length - 1 - i3]);
            }
            CrossJoinedSet uSet = new CrossJoinedSet(uSetSets.toArray(new Set[0]));
            ArrayList<Set> as = new ArrayList<Set>();
            for (i = 0; i < sets.length; ++i) {
                if (uSetSets.contains(sets[i])) continue;
                as.add(sets[i]);
            }
            as.add(uSet);
            setsPlusUSet = as.toArray(new Set[as.size()]);
            this.setsPlusUSetInfo = this.ordinalMath.getSetArrayInfo(setsPlusUSet);
        }
        Set setParam = null;
        Iterator<Cell> cellIter = ctxtBlock.cellSet.iterator();
        while (cellIter.hasNext() && (setParam = (Set)(blockCell = cellIter.next()).getObjectValue()).isEmpty()) {
        }
        this.newContext = ctxtBlock.getContextSet();
        this.newCtxtToBlock = new int[this.newContext.length];
        ArrayList<Set> newSetsList = new ArrayList<Set>();
        block4: for (i = 0; i < this.newContext.length; ++i) {
            IHierarchy[] newCtxtSetHiers = this.newContext[i].getHierarchies();
            this.newCtxtToBlock[i] = -1;
            for (int j = 0; j < setsPlusUSet.length; ++j) {
                for (int hierIdx = 0; hierIdx < newCtxtSetHiers.length; ++hierIdx) {
                    if (!((Set)setsPlusUSet[j]).contains(newCtxtSetHiers[hierIdx])) continue;
                    int ctxtBlockSetIdx = currBlock.getIndexOfSetContainingHierarchy(ctxtBlock.getSets(), newCtxtSetHiers[hierIdx]);
                    if (ctxtBlockSetIdx != -1) {
                        newSetsList.add(this.newContext[i]);
                        this.newCtxtToBlock[i] = j;
                        if (j < setsPlusUSet.length - 1) {
                            this.newSetToSet.add(j);
                            this.mapsToUset.add(false);
                            break;
                        }
                        this.newSetToSet.add(ctxtBlockSetIdx);
                        this.mapsToUset.add(true);
                        break;
                    }
                    if (setParam.contains(newCtxtSetHiers[hierIdx])) break;
                    newSetsList.add(this.newContext[i]);
                    this.newCtxtToBlock[i] = j;
                    if (j < setsPlusUSet.length - 1) {
                        this.newSetToSet.add(j);
                        this.mapsToUset.add(false);
                        break;
                    }
                    this.newSetToSet.add(ctxtBlockSetIdx);
                    this.mapsToUset.add(true);
                    break;
                }
                if (this.newCtxtToBlock[i] != -1) continue block4;
            }
        }
        this.newSets = newSetsList.toArray(new Set[newSetsList.size()]);
        this.newSetsInfo = this.ordinalMath.getSetArrayInfo(this.newSets);
        this.usetSize = new long[this.usetLimit.size()];
        for (i = 0; i < this.usetLimit.size(); ++i) {
            this.usetSize[i] = i == 0 ? this.usetLimit.get(0) : this.usetLimit.get(i) - this.usetLimit.get(i - 1);
        }
    }

    private void initializeChangeToPreviousContext(Block currBlock, Block ctxtBlock) {
        this.ordinalMath = currBlock.interpreterContext.getOrdinalMath();
        InterpreterContext.ContextInfo ctxtInfo = currBlock.interpreterContext.getContext();
        this.uSetNumSets = ctxtInfo.getuSetCount();
        Set[] contextSets = currBlock.getContextSet();
        ISet[] sets = currBlock.getSets();
        this.newCtxtToCtxtUSet = new int[ctxtBlock.getContextSet().length];
        ISet[] setsPlusUSet = null;
        if (contextSets.length > 0) {
            int i;
            ArrayList<Set> uSetSets = new ArrayList<Set>();
            for (int i2 = 0; i2 < this.uSetNumSets; ++i2) {
                uSetSets.add(0, contextSets[contextSets.length - 1 - i2]);
            }
            this.setUSets = uSetSets.toArray(new Set[uSetSets.size()]);
            this.setUSetsInfo = this.ordinalMath.getSetArrayInfo(this.setUSets);
            CrossJoinedSet uSet = new CrossJoinedSet(this.setUSets);
            IHierarchy[] usetHiers = uSet.getHierarchies();
            if (sets.length > 0) {
                block1: for (int i3 = 0; i3 < sets.length; ++i3) {
                    for (int j = 0; j < usetHiers.length; ++j) {
                        if (!((Set)sets[i3]).contains(usetHiers[j])) continue;
                        this.usetIdx.add(i3);
                        continue block1;
                    }
                }
            }
            if (this.usetIdx.size() > 0) {
                setsPlusUSet = sets;
            } else {
                ArrayList<ISet> as = new ArrayList<ISet>();
                for (i = 0; i < sets.length; ++i) {
                    if (uSetSets.contains(sets[i])) continue;
                    as.add(sets[i]);
                }
                as.add(uSet);
                setsPlusUSet = as.toArray(new Set[0]);
                this.usetIdx.add(sets.length);
            }
            this.setsPlusUSetInfo = this.ordinalMath.getSetArrayInfo(setsPlusUSet);
            if (this.usetIdx.size() > 0) {
                ArrayList<Set> ctxtUSet = new ArrayList<Set>();
                block4: for (i = 0; i < ctxtBlock.getContextSet().length; ++i) {
                    this.newCtxtToCtxtUSet[i] = -1;
                    if (ctxtBlock.isDegenerated(i)) continue;
                    for (int hierIdx = 0; hierIdx < usetHiers.length; ++hierIdx) {
                        if (!ctxtBlock.getContextSet()[i].contains(usetHiers[hierIdx])) continue;
                        ctxtUSet.add(ctxtBlock.getContextSet()[i]);
                        this.newCtxtToCtxtUSet[i] = ctxtUSet.size() - 1;
                        continue block4;
                    }
                }
                this.contextUSet = ctxtUSet.toArray(new Set[0]);
                this.contextUSetInfo = this.ordinalMath.getSetArrayInfo(this.contextUSet);
            }
        }
        this.newContext = ctxtBlock.getContextSet();
        this.newCtxtToBlock = new int[this.newContext.length];
        ArrayList<Set> tmpNewSets = new ArrayList<Set>();
        this.newSetsInfo = null;
        block6: for (int i = 0; i < this.newContext.length; ++i) {
            if (!ctxtBlock.isDegenerated(i) && setsPlusUSet.length == 0) {
                tmpNewSets.add(this.newContext[i]);
                continue;
            }
            IHierarchy[] newCtxtSetHiers = this.newContext[i].getHierarchies();
            this.newCtxtToBlock[i] = -1;
            for (int j = 0; j < setsPlusUSet.length; ++j) {
                for (int hierIdx = 0; hierIdx < newCtxtSetHiers.length; ++hierIdx) {
                    if (!((Set)setsPlusUSet[j]).contains(newCtxtSetHiers[hierIdx])) continue;
                    tmpNewSets.add(this.newContext[i]);
                    this.newCtxtToBlock[i] = j;
                    break;
                }
                if (this.newCtxtToBlock[i] != -1) continue block6;
            }
        }
        this.newSets = tmpNewSets.toArray(new Set[tmpNewSets.size()]);
        this.newSetsInfo = this.ordinalMath.getSetArrayInfo(tmpNewSets);
    }

    public OrdinalMath getOrdinalMath() {
        return this.ordinalMath;
    }

    private OrdinalMath.SetArrayInfo getCtxtBlockSetsInfo() {
        return this.ctxtBlockSetsInfo;
    }

    private ArrayListLong getUsetLimit() {
        return this.usetLimit;
    }

    public void setUsetLimit(ArrayListLong limit) {
        this.usetLimit = limit;
    }

    public int getuSetNumSets() {
        return this.uSetNumSets;
    }

    private OrdinalMath.SetArrayInfo getSetsPlusUSetInfo() {
        return this.setsPlusUSetInfo;
    }

    private int[] getNewCtxtToBlock() {
        return this.newCtxtToBlock;
    }

    public Set[] getNewSets() {
        return this.newSets;
    }

    public OrdinalMath.SetArrayInfo getNewSetsInfo() {
        return this.newSetsInfo;
    }

    public Set[] getNewContext() {
        return this.newContext;
    }

    private long[] getUsetLimitSurrogateIds() {
        return this.usetLimitSurrogateIds;
    }

    public long getCellOrdinalSurrogate(Cell blockCell) {
        long cellOrdinal = blockCell.getOrdinal();
        if (cellOrdinal == -123L) {
            cellOrdinal = this.ordinalMath.createSurrogateId(blockCell.getBigOrdinal());
        }
        return cellOrdinal;
    }

    private long getNextContextBlockOrdinal(long ctxtBlockOrd, long[] setOrdSurrogateId) {
        if (ctxtBlockOrd > 0L && this.ordinalMath.compare(setOrdSurrogateId[setOrdSurrogateId.length - 1], this.usetLimitSurrogateIds[(int)ctxtBlockOrd - 1]) < 0) {
            ctxtBlockOrd = 0L;
        }
        while (this.ordinalMath.compare(setOrdSurrogateId[setOrdSurrogateId.length - 1], this.usetLimitSurrogateIds[(int)ctxtBlockOrd]) >= 0 && ctxtBlockOrd < (long)(this.usetLimit.size() - 1)) {
            ++ctxtBlockOrd;
        }
        return ctxtBlockOrd;
    }

    private long[] getNewSetOrdinalSurrogateIds(long[] setOrdSurrogateId, long[] ctxtUsetSetOrdSurrogateId) {
        long[] newSetOrdSurrogateId = new long[this.newSets.length];
        for (int i = 0; i < newSetOrdSurrogateId.length; ++i) {
            newSetOrdSurrogateId[i] = this.mapsToUset.get(i) ? ctxtUsetSetOrdSurrogateId[this.newSetToSet.get(i)] : setOrdSurrogateId[this.newSetToSet.get(i)];
        }
        return newSetOrdSurrogateId;
    }

    private boolean getContinueTreeSetReuse(Iterator<Cell> lastTreeSetIter, boolean reuseTreeSet, Object blockObject, long ordSurrogateId) {
        if (reuseTreeSet) {
            if (!lastTreeSetIter.hasNext()) {
                reuseTreeSet = false;
            } else {
                Cell lastCell = lastTreeSetIter.next();
                long lastCellOrd = lastCell.getOrdinal();
                BigInteger bigOrd = null;
                if (OrdinalMath.isSurrogateId(ordSurrogateId)) {
                    bigOrd = this.ordinalMath.getBigInteger(ordSurrogateId);
                }
                if (lastCellOrd == -123L && (bigOrd == null || lastCell.getBigOrdinal().compareTo(bigOrd) != 0)) {
                    reuseTreeSet = false;
                } else if (this.ordinalMath.compare(lastCellOrd, ordSurrogateId) != 0) {
                    reuseTreeSet = false;
                } else if (lastCell.getObjectValue() != blockObject) {
                    reuseTreeSet = false;
                }
            }
        }
        return reuseTreeSet;
    }

    private static TreeSet<Cell> getTreeSet(long newBlockOrdSurrogateId, HashMapLongObject<TreeSet<Cell>> treeSetCache) {
        if (treeSetCache == null) {
            return Block.createTreeSet();
        }
        TreeSet<Cell> newSet = treeSetCache.get(newBlockOrdSurrogateId);
        if (newSet == null) {
            newSet = Block.createTreeSet();
            treeSetCache.put(newBlockOrdSurrogateId, newSet);
        }
        return newSet;
    }

    private long getNewBlockOrdSurrogateId(long ctxBlockOrd, long[] setOrdSurrogateId) {
        long[] ctxtUsetSetOrdSurrogateId = this.ordinalMath.getSetOrdinals(ctxBlockOrd, this.ctxtBlockSetsInfo);
        long[] newSetOrdSurrogateId = this.getNewSetOrdinalSurrogateIds(setOrdSurrogateId, ctxtUsetSetOrdSurrogateId);
        long newBlockOrdSurrogateId = this.ordinalMath.getBlockOrdinal(newSetOrdSurrogateId, this.newSetsInfo);
        return newBlockOrdSurrogateId;
    }

    private void addCompletedContextBlockCellAndGetNewCell(TreeSet<Cell> newBlockCells, long ctxtBlockOrd, long newBlockOrdSurrogateId, Block.ContextIteratorState state) {
        HashMapLongObject<TreeSet<Cell>> treeSetCache = state.getTreeSetCache();
        TreeSet contextSetCells = state.contextSetCells;
        if (state.isHasSetPrevBlockOrd() && this.ordinalMath.compare(state.getPrevBlockOrdSurrogateId(), newBlockOrdSurrogateId) != 0) {
            if (this.insBlock) {
                Cell lastCell = contextSetCells.last();
                long lOrdinal = this.getCellOrdinalSurrogate(lastCell);
                if (this.ordinalMath.compare(lOrdinal, contextSetCells.size() - 1) == 0) {
                    Block.addCellSurrogateId(newBlockCells, state.getPrevBlockOrdSurrogateId(), lastCell.getObjectValue(), false, false, this.ordinalMath);
                }
                contextSetCells = BlockContextMap.getTreeSet(newBlockOrdSurrogateId, state.getTreeSetCache());
            } else {
                long prevBlockOrdSurrogateId = state.getPrevBlockOrdSurrogateId();
                boolean reuseTreeSet = state.isReuseTreeSet();
                TreeSet<Cell> lastTreeSet = state.getLastTreeSet();
                if (this.blockDefaultValue != null) {
                    Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, contextSetCells, false, false, this.ordinalMath);
                    contextSetCells = new CellTreeSet(this.blockDefaultValue, this.usetSize[(int)ctxtBlockOrd] - 1L);
                } else if (treeSetCache == null && reuseTreeSet && lastTreeSet.size() == contextSetCells.size()) {
                    Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, lastTreeSet, false, false, this.ordinalMath);
                    contextSetCells.clear();
                    state.setLastTreeSetIter(lastTreeSet.iterator());
                } else {
                    Block.addCellSurrogateId(newBlockCells, prevBlockOrdSurrogateId, contextSetCells, false, false, this.ordinalMath);
                    state.setReuseTreeSet(true);
                    state.setLastTreeSet(contextSetCells);
                    state.setLastTreeSetIter(contextSetCells.iterator());
                    contextSetCells = BlockContextMap.getTreeSet(newBlockOrdSurrogateId, treeSetCache);
                }
            }
        }
        if (contextSetCells == null) {
            contextSetCells = this.blockDefaultValue != null ? new CellTreeSet(this.blockDefaultValue, this.usetSize[(int)ctxtBlockOrd] - 1L) : Block.createTreeSet();
            if (treeSetCache != null) {
                treeSetCache.put(newBlockOrdSurrogateId, contextSetCells);
            }
        }
        state.contextSetCells = contextSetCells;
    }

    public void addDefaultValueCells(TreeSet<Cell> newCellSet, Object defValue) {
        long nextIdx = 0L;
        long nextCellIdxSurrogateId = 0L;
        long lastIdxSurrogateId = this.ordinalMath.subtract(this.newSetsInfo.getSize(), 1L);
        TreeSet<Cell> allDefValueCells = Block.createTreeSet();
        Iterator<Cell> cellIter = newCellSet.iterator();
        while (this.ordinalMath.compare(nextIdx, lastIdxSurrogateId) <= 0) {
            Cell cell;
            long lCellOrdinal;
            nextCellIdxSurrogateId = cellIter.hasNext() ? ((lCellOrdinal = (cell = cellIter.next()).getOrdinal()) == -123L ? this.ordinalMath.createSurrogateId(cell.getBigOrdinal()) : lCellOrdinal) : this.newSetsInfo.getSize();
            while (this.ordinalMath.compare(nextIdx, nextCellIdxSurrogateId) < 0) {
                long[] newSetOrdSurrogateId = this.ordinalMath.getSetOrdinals(nextIdx, this.newSetsInfo);
                long[] ctxtUsetSetOrd = new long[this.ctxtBlockSetsInfo.getSizes().length];
                for (int i = 0; i < newSetOrdSurrogateId.length; ++i) {
                    if (!this.mapsToUset.get(i)) continue;
                    ctxtUsetSetOrd[this.newSetToSet.get((int)i)] = newSetOrdSurrogateId[i];
                }
                long ctxtBlockOrdSurrogateId = this.ordinalMath.getBlockOrdinal(ctxtUsetSetOrd, this.ctxtBlockSetsInfo);
                if (this.ordinalMath.compare(ctxtBlockOrdSurrogateId, Integer.MAX_VALUE) > 0) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "", String.valueOf(ctxtBlockOrdSurrogateId), "integer");
                }
                CellTreeSet newCell = new CellTreeSet(defValue, this.usetSize[(int)ctxtBlockOrdSurrogateId] - 1L);
                Block.addCell(allDefValueCells, nextIdx, newCell, false, false);
                ++nextIdx;
            }
            ++nextIdx;
        }
        newCellSet.addAll(allDefValueCells);
    }

    public Cell transformNextCell(TreeSet<Cell> newBlockCells, long blockOrdinalSurrogateId, Object blockObject, Block.ContextIteratorState state, boolean groupByContext) {
        long[] setOrdSurrogateId = this.ordinalMath.getSetOrdinals(blockOrdinalSurrogateId, this.getSetsPlusUSetInfo());
        long ctxtBlockOrd = this.getNextContextBlockOrdinal(state.ctxtBlockOrd, setOrdSurrogateId);
        long newBlockOrdSurrogateId = this.getNewBlockOrdSurrogateId(ctxtBlockOrd, setOrdSurrogateId);
        if (groupByContext) {
            this.addCompletedContextBlockCellAndGetNewCell(newBlockCells, ctxtBlockOrd, newBlockOrdSurrogateId, state);
        }
        long ordSurrogateId = setOrdSurrogateId[setOrdSurrogateId.length - 1];
        if (ctxtBlockOrd > 0L) {
            ordSurrogateId = this.ordinalMath.subtract(ordSurrogateId, this.getUsetLimitSurrogateIds()[(int)ctxtBlockOrd - 1]);
        }
        Cell localNewCell = Block.addCellSurrogateId(state.contextSetCells, ordSurrogateId, blockObject, false, false, this.ordinalMath);
        state.setPrevBlockOrdSurrogateId(newBlockOrdSurrogateId);
        state.ctxtBlockOrd = ctxtBlockOrd;
        if (groupByContext) {
            state.setHasSetPrevBlockOrd(true);
            state.setReuseTreeSet(this.getContinueTreeSetReuse(state.getLastTreeSetIter(), state.isReuseTreeSet(), blockObject, ordSurrogateId));
        }
        return localNewCell;
    }

    public void reassignDefaultValue(TreeSet<Cell> newBlockCells) {
        if (this.getBlockDefaultValue() != null) {
            if (this.insBlock) {
                this.currBlk.setDefaultValue(this.getBlockDefaultValue());
            } else {
                int cellCount = newBlockCells.size();
                long totalSize = this.newSetsInfo.getSize();
                if (cellCount == 0 || OrdinalMath.isSurrogateId(totalSize) || totalSize > (long)cellCount) {
                    if (this.currBlk.isUseDefaultValueObject()) {
                        this.currBlk.setDefaultValue(this.getBlockDefaultValue());
                    } else {
                        this.addDefaultValueCells(newBlockCells, this.getBlockDefaultValue());
                    }
                }
            }
        }
    }

    private long[] getNewSetOrd(long[] setOrd, Block.ContextIteratorState state) {
        long[] newSetOrd = new long[this.getNewSets().length];
        int newSetOrdIdx = 0;
        for (int i = 0; i < this.getNewContext().length; ++i) {
            if (this.newCtxtToBlock[i] == -1) continue;
            if (!this.getUsetIdx().contains(this.newCtxtToBlock[i])) {
                newSetOrd[newSetOrdIdx] = setOrd[this.newCtxtToBlock[i]];
            } else {
                state.ctxtBlockOrd = this.uSetNumSets > 1 ? this.ordinalMath.getBlockOrdinal(state.uSetSetOrds, this.getSetUSetsInfo()) : setOrd[this.newCtxtToBlock[i]];
                if (this.getContextUSet().length != 0) {
                    if (OrdinalMath.isSurrogateId(this.getContextUSetInfo().getSize())) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "", String.valueOf(this.getContextUSetInfo().getSize()), "integer");
                    }
                    if (OrdinalMath.isSurrogateId(state.ctxtBlockOrd) || state.ctxtBlockOrd > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "", String.valueOf(state.ctxtBlockOrd), "integer");
                    }
                    long[] ctxtUsetSetOrd = this.ordinalMath.getSetOrdinals(this.getUsetLimit().get((int)state.ctxtBlockOrd), this.getContextUSetInfo());
                    newSetOrd[newSetOrdIdx] = ctxtUsetSetOrd[this.getNewCtxtToCtxtUSet()[i]];
                } else {
                    newSetOrd[newSetOrdIdx] = 0L;
                }
            }
            ++newSetOrdIdx;
        }
        return newSetOrd;
    }

    public long transformNextCell(long blockOrdinalSurrogateId, Object blockObject, TreeSet<Cell> newCellSet, BlockContextMap ctxMap, Block.ContextIteratorState state) {
        ++state.ctxtBlockOrd;
        long[] setOrd = this.ordinalMath.getSetOrdinals(blockOrdinalSurrogateId, this.setsPlusUSetInfo);
        if (this.uSetNumSets > 1) {
            if (this.uSetNumSets == setOrd.length) {
                state.uSetSetOrds = setOrd;
            } else {
                for (int j = this.uSetNumSets - 1; j >= 0; --j) {
                    state.uSetSetOrds[this.uSetNumSets - j - 1] = setOrd[setOrd.length - 1 - j];
                }
            }
        }
        long[] newSetOrd = ctxMap.getNewSetOrd(setOrd, state);
        long ordSurrogateId = this.ordinalMath.getBlockOrdinal(newSetOrd, this.newSetsInfo);
        Block.addCellSurrogateId(newCellSet, ordSurrogateId, blockObject, false, false, this.ordinalMath);
        return ordSurrogateId;
    }

    public void propagateValues(long fromOrdSurrogateId, long toOrdSurrogateId, Object lastBlockObj, TreeSet<Cell> newBlockCells) {
        block4: {
            if (lastBlockObj == null) break block4;
            if (OrdinalMath.isSurrogateId(toOrdSurrogateId)) {
                long i = this.ordinalMath.add(fromOrdSurrogateId, 1L);
                while (this.ordinalMath.compare(i, toOrdSurrogateId) < 0) {
                    Block.addCellSurrogateId(newBlockCells, i, lastBlockObj, false, false, this.ordinalMath);
                    i = this.ordinalMath.add(i, 1L);
                }
            } else {
                for (long i = fromOrdSurrogateId + 1L; i < toOrdSurrogateId; ++i) {
                    Block.addCellSurrogateId(newBlockCells, i, lastBlockObj, false, false, this.ordinalMath);
                }
            }
        }
    }

    private boolean isInsBlock() {
        return this.insBlock;
    }

    public void setInsBlock(boolean ins) {
        this.insBlock = ins;
    }

    public Set[] getSetUSets() {
        return this.setUSets;
    }

    private OrdinalMath.SetArrayInfo getSetUSetsInfo() {
        return this.setUSetsInfo;
    }

    private OrdinalMath.SetArrayInfo getContextUSetInfo() {
        return this.contextUSetInfo;
    }

    public ArrayListInt getUsetIdx() {
        return this.usetIdx;
    }

    private Set[] getContextUSet() {
        return this.contextUSet;
    }

    private int[] getNewCtxtToCtxtUSet() {
        return this.newCtxtToCtxtUSet;
    }

    public Object getBlockDefaultValue() {
        return this.blockDefaultValue;
    }

    public void setBlockDefaultValue(Object defaultValue) {
        this.blockDefaultValue = defaultValue;
    }
}

