/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockOrdinalTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockContextMap;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalChangeContextTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetCellIteratorDecorator;
import java.util.NoSuchElementException;

public class BlockOrdinalChangeToPreviousContextTransformIterator
extends BlockOrdinalChangeContextTransformIterator {
    private final boolean propagateValues;
    Object lastBlockObj = null;

    public BlockOrdinalChangeToPreviousContextTransformIterator(AbstractBlockOrdinalTransformIterator cellPipelineIterator, BlockContextMap contextMap, boolean streaming, boolean propagate) {
        super(cellPipelineIterator, contextMap, streaming);
        this.state.uSetSetOrds = new long[this.ctxMap.getSetUSets().length];
        this.propagateValues = propagate;
        if (this.propagateValues) {
            throw new UnsupportedOperationException("Propagate values is unsupported from a source Pipeline Block");
        }
    }

    @Override
    protected Object nextHelper() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("BlockOrdinalChangeToPreviousContextTransformIterator has no more elements.");
        }
        ICell temp = (ICell)this.newCellSetIterator.next();
        return temp;
    }

    @Override
    protected IResultSetIterator initializeCellIterator() {
        while (this.previousIterator.hasNext()) {
            Cell blockCell = (Cell)this.previousIterator.next();
            Object blockObject = blockCell.getObjectValue();
            long blockOrdinalSurrogateId = blockCell.getOrdinal();
            long l = this.ctxMap.transformNextCell(blockOrdinalSurrogateId, blockObject, this.newBlockCells, this.ctxMap, this.state);
        }
        this.numFetchedCells = this.newBlockCells.size();
        return new ResultSetCellIteratorDecorator(this.newBlockCells.iterator());
    }

    @Override
    protected Cell transformCell(Cell blockCell) {
        if (blockCell == null) {
            return null;
        }
        Object blockObject = blockCell.getObjectValue();
        long blockOrdinalSurrogateId = blockCell.getOrdinal();
        long ordSurrogateId = this.ctxMap.transformNextCell(blockOrdinalSurrogateId, blockObject, null, this.ctxMap, this.state);
        Cell localNewCell = Block.addCellSurrogateId(null, ordSurrogateId, blockObject, false, false, this.ctxMap.getOrdinalMath());
        Cell returnCell = Block.addCellSurrogateId(null, blockOrdinalSurrogateId, localNewCell, false, false, this.ctxMap.getOrdinalMath());
        this.state.setPrevBlockOrdSurrogateId(blockOrdinalSurrogateId);
        return returnCell;
    }
}

