/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CalculationCache {
    private static final long ONE_MILLION = 1000000L;
    private final Map<String, ArrayList<IResultSet>> calculatedMemberToResultSetsCache;
    private final Map<String, ArrayList<CrossJoinedSet>> calculatedMemberToCalcSetsCache;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final int CACHE_MAXSIZE = 10;

    public CalculationCache() {
        this.calculatedMemberToResultSetsCache = new HashMap<String, ArrayList<IResultSet>>();
        this.calculatedMemberToCalcSetsCache = new HashMap<String, ArrayList<CrossJoinedSet>>();
    }

    public CalculationCache(CalculationCache toClone) {
        this();
        for (String key : toClone.calculatedMemberToResultSetsCache.keySet()) {
            if (this.calculatedMemberToResultSetsCache.containsKey(key)) continue;
            this.calculatedMemberToResultSetsCache.put(key, toClone.calculatedMemberToResultSetsCache.get(key));
        }
        for (String key : toClone.calculatedMemberToCalcSetsCache.keySet()) {
            if (this.calculatedMemberToCalcSetsCache.containsKey(key)) continue;
            this.calculatedMemberToCalcSetsCache.put(key, toClone.calculatedMemberToCalcSetsCache.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet getResultSet(String cm, CrossJoinedSet calcSet) {
        this.rwLock.readLock().lock();
        try {
            IResultSet rs = null;
            ArrayList<CrossJoinedSet> calcsetArray = this.calculatedMemberToCalcSetsCache.get(cm);
            if (calcsetArray != null) {
                for (int i = 0; i < calcsetArray.size(); ++i) {
                    boolean theSame = this.quickEqualsCJS(calcsetArray.get(i), calcSet);
                    calcsetArray.get(i).release();
                    if (!theSame) continue;
                    ArrayList<IResultSet> cachedResultSetArray = this.calculatedMemberToResultSetsCache.get(cm);
                    rs = cachedResultSetArray.get(i);
                    break;
                }
            }
            IResultSet iResultSet = rs;
            return iResultSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultSet(String cm, CrossJoinedSet calcSet, IResultSet rs) {
        if (!rs.isPipelining()) {
            this.rwLock.writeLock().lock();
            try {
                ArrayList<CrossJoinedSet> calcsetArray = this.calculatedMemberToCalcSetsCache.get(cm);
                ArrayList<IResultSet> resultsetArray = this.calculatedMemberToResultSetsCache.get(cm);
                if (calcsetArray == null) {
                    calcsetArray = new ArrayList();
                    resultsetArray = new ArrayList();
                } else if (calcsetArray.size() >= 10) {
                    ArrayList<CrossJoinedSet> newCalcsetArray = new ArrayList<CrossJoinedSet>();
                    ArrayList<IResultSet> newResultsetArray = new ArrayList<IResultSet>();
                    for (int i = 1; i < calcsetArray.size(); ++i) {
                        newCalcsetArray.add(calcsetArray.get(i));
                        newResultsetArray.add(resultsetArray.get(i));
                    }
                    calcsetArray = newCalcsetArray;
                    resultsetArray = newResultsetArray;
                }
                calcsetArray.add(calcSet);
                resultsetArray.add(rs);
                this.calculatedMemberToCalcSetsCache.put(cm, calcsetArray);
                this.calculatedMemberToResultSetsCache.put(cm, resultsetArray);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
    }

    public boolean quickEqualsCJS(CrossJoinedSet a1, CrossJoinedSet b1) {
        Set[] b1s;
        if (a1.size() != b1.size()) {
            return false;
        }
        Set[] a1s = a1.getSets();
        if (a1s.length == (b1s = b1.getSets()).length) {
            boolean allSetsEqual = true;
            int i = 0;
            for (Set as : a1s) {
                if (as.equals(b1s[i++])) continue;
                allSetsEqual = false;
                break;
            }
            if (allSetsEqual) {
                return true;
            }
        }
        if (a1.size() > 1000000L) {
            return false;
        }
        int[] ordinalToIndexes = null;
        IIterator b1Iter = b1.iterator();
        BitSet visitedOrdinals = new BitSet();
        while (b1Iter.hasNext()) {
            long[] ordinals;
            Tuple b1Tuple = (Tuple)b1Iter.next();
            if (ordinalToIndexes == null) {
                ordinalToIndexes = b1.getOrdinalsToIndex(b1Tuple);
            }
            if ((ordinals = a1.getOrdinals((ITuple)b1Tuple, ordinalToIndexes)) == null || ordinals.length == 0 || ordinals.length > 1) {
                return false;
            }
            if (visitedOrdinals.get((int)ordinals[0])) {
                return false;
            }
            visitedOrdinals.set((int)ordinals[0], true);
        }
        return true;
    }
}

