/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.trace.XQEDebugLog;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;

public class ComplexTupleValueComparator
implements Comparator<Object> {
    private boolean ascending = true;
    private NullBehavior nullHandling = NullBehavior.ZERO;
    private Map<Tuple, TupleValue> tupleToValue;
    private Collator collator;

    public ComplexTupleValueComparator(Collator theCollator, Map<Tuple, TupleValue> tupToValue, boolean asc, NullBehavior nh) {
        this.ascending = asc;
        this.tupleToValue = tupToValue;
        this.collator = theCollator;
        this.nullHandling = nh;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int result = 0;
        TupleValue tv1 = (TupleValue)o1;
        TupleValue tv2 = (TupleValue)o2;
        Tuple t1 = tv1.getTuple();
        Tuple t2 = tv2.getTuple();
        int dimCount = t1.getDimensions().length;
        ArrayList[] ancestorMembersT1 = new ArrayList[dimCount];
        ArrayList[] ancestorMembersT2 = new ArrayList[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            ArrayList<IMember> ancestorMemberT1 = new ArrayList<IMember>();
            ArrayList<IMember> ancestorMemberT2 = new ArrayList<IMember>();
            ancestorMembersT1[i] = ancestorMemberT1;
            ancestorMembersT2[i] = ancestorMemberT2;
            for (IMember m1 = t1.getMember(i); m1 != null; m1 = m1.getParent()) {
                ancestorMemberT1.add(m1);
            }
            for (IMember m2 = t2.getMember(i); m2 != null; m2 = m2.getParent()) {
                ancestorMemberT2.add(m2);
            }
        }
        IMember[] compareTuple1 = new IMember[dimCount];
        IMember[] compareTuple2 = new IMember[dimCount];
        boolean differenceFound = false;
        for (int i = 0; i < dimCount; ++i) {
            ArrayList ancestorsT1 = ancestorMembersT1[i];
            ArrayList ancestorsT2 = ancestorMembersT2[i];
            int maxIndex = ancestorsT2.size();
            if (ancestorsT1.size() < maxIndex) {
                maxIndex = ancestorsT1.size();
            }
            if (!differenceFound) {
                for (int j = 0; j < maxIndex && !differenceFound; ++j) {
                    int ancestorsT1Size = ancestorsT1.size();
                    int ancestorsT2Size = ancestorsT2.size();
                    IMember an1 = (IMember)ancestorsT1.get(ancestorsT1Size - 1 - j);
                    IMember an2 = (IMember)ancestorsT2.get(ancestorsT2Size - 1 - j);
                    compareTuple1[i] = an1;
                    compareTuple2[i] = an2;
                    if (an1 != an2) {
                        XQEDebugLog.out.println("Difference found index " + i + " members " + an1.getName() + " and " + an2.getName());
                        differenceFound = true;
                        continue;
                    }
                    if (j != maxIndex - 1 || ancestorsT1Size == ancestorsT2Size) continue;
                    compareTuple1[i] = an1;
                    compareTuple2[i] = an1;
                    differenceFound = true;
                }
                continue;
            }
            compareTuple1[i] = (IMember)ancestorsT1.get(ancestorsT1.size() - 1);
            compareTuple2[i] = (IMember)ancestorsT2.get(ancestorsT2.size() - 1);
        }
        Tuple ct1 = new Tuple(compareTuple1, false);
        Tuple ct2 = new Tuple(compareTuple2, false);
        TupleValue ptv1 = this.tupleToValue.get(ct1);
        TupleValue ptv2 = this.tupleToValue.get(ct2);
        if (ptv1 != null && ptv2 != null) {
            Object value1 = ptv1.getCell().getObjectValue();
            Object value2 = ptv2.getCell().getObjectValue();
            if (value2 instanceof Value) {
                boolean hasNullValue = false;
                if (value2 instanceof TextValue) {
                    boolean descendingNullFirst;
                    if (value1 == null || value2 == null) {
                        hasNullValue = true;
                    }
                    result = ((TextValue)value2).compareTo(value1, this.collator);
                    boolean ascendingNullLast = this.ascending && (this.nullHandling == NullBehavior.ZERO_LAST || this.nullHandling == NullBehavior.NULL_LAST);
                    boolean bl = descendingNullFirst = !this.ascending && (this.nullHandling == NullBehavior.ZERO_FIRST || this.nullHandling == NullBehavior.NULL_FIRST);
                    if (hasNullValue && (ascendingNullLast || descendingNullFirst)) {
                        result = -result;
                    }
                } else {
                    result = ((Value)value2).compareTo(value1, this.nullHandling);
                    if (hasNullValue && (!this.ascending && this.nullHandling == NullBehavior.NULL_LAST || this.ascending && this.nullHandling == NullBehavior.NULL_FIRST)) {
                        result = -result;
                    }
                }
            } else if (value1 instanceof String || value2 instanceof String) {
                result = this.collator.compare((String)value2, (String)value1);
            } else if (value1 instanceof Double && value2 instanceof Double) {
                result = ((Double)value2).compareTo((Double)value1);
            } else if (value1 instanceof Integer && value2 instanceof Integer) {
                result = ((Integer)value2).compareTo((Integer)value1);
            } else if (value1 instanceof Boolean && value2 instanceof Boolean) {
                result = ((Boolean)value2).compareTo((Boolean)value1);
            } else if (value1 != null) {
                result = 1;
            } else if (value2 != null) {
                result = -1;
            }
            if (this.ascending) {
                result *= -1;
            }
        } else {
            XQEDebugLog.out.println("Could not locate parent tuple value during hierarchized sort. t1=" + ct1 + " t2=" + ct2);
        }
        return result;
    }
}

