/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.data.IXmlSerializable;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.LeafSetTupleMap;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.storage.ValueTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.runtree.olap.mdx.util.SetTupleMap;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.xml.XMLWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.set.ListOrderedSet;

public class CrossJoinedSet
extends Set
implements IXmlSerializable {
    private static final int ORDINAL_CACHE_SIZE = 500;
    private static final int MIN_SIZE_FOR_SETTUPLEMAP = 25000;
    private static final long MAX_SIZE_FOR_SETTUPLEMAP = 5000000L;
    private static final String MIN_SIZE_FOR_SETTUPLEMAP_STR = "MIN_SIZE_FOR_SETTUPLEMAP";
    public static final float TUPLE_TO_INDEXES_LOAD_FACTOR = 0.75f;
    private static final int TUPLE_TO_INDEXES_SIZE_FACTOR = 10;
    private boolean setTupleMapEnabled = false;
    private boolean btreeEnabled = false;
    private boolean leafSetTupleMapEnabled = false;
    private boolean disableTupleIndex = false;
    private boolean disableTupleIndexIsSet = false;
    private Set[] sets;
    private HashMapLongObject<long[]> tupleToIndexesOptimized;
    private Map<Object, long[]> tupleToIndexes;
    private ValueTupleStorage tupleToIndexesBTree;
    private SetTupleMap tupleMap;
    private LeafSetTupleMap leafSetTupleMap;
    private volatile int[][] setHierarchyOrdinals = null;
    private int[] cubeHierToTupleHierMap = null;
    private long[] setSizesInReverseOrder = null;
    private int width;
    private long cachedSetSize = -1L;
    private final LRUMap cachedOrdinalMap = new LRUMap(500);
    private static final long MAX_TUPLE_MATERIALIZATION_FACTOR = 100L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static XQELogger mWarningLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.WARN);
    protected static final CrossJoinedSet EMPTY_CJS = new CrossJoinedSet(new ISet[0]);
    private volatile boolean initializedForOrdinalScan = false;
    private MemberLevelInfo memberLevelInfo = null;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    public CrossJoinedSet(ISet[] ss) {
        super((ITupleList)null, false);
        int i;
        ArrayList<ISet> al = new ArrayList<ISet>();
        for (i = 0; i < ss.length; ++i) {
            if (ss[i] instanceof CrossJoinedSet) {
                Set[] sets2 = ((CrossJoinedSet)ss[i]).getSets();
                for (int j = 0; j < sets2.length; ++j) {
                    if (sets2[j].isEmpty()) continue;
                    al.add(sets2[j]);
                }
                continue;
            }
            if (ss[i].isEmpty()) continue;
            al.add(ss[i]);
        }
        this.sets = al.toArray(new Set[al.size()]);
        if (!this.isEmpty()) {
            for (i = 0; i < ss.length; ++i) {
                Set s = (Set)ss[i];
                this.addCurrentMemberDimensions(s.getCurrentMemberDimensions());
                this.addCurrentMemberHierarchies(s.getCurrentMemberHierarchies());
                IHierarchy[] hiers = s.getHierarchies();
                this.width += hiers.length;
                HashSet<IHierarchy> seenHierarchies = new HashSet<IHierarchy>();
                for (int j = 0; j < hiers.length; ++j) {
                    if (seenHierarchies.contains(hiers[j])) {
                        throw new InterpreterRuntimeException("Error creating CrossJoinedSet. Hierarchy " + hiers[j] + " encountered more than once.");
                    }
                    seenHierarchies.add(hiers[j]);
                }
            }
        }
        this.rebuildCrossJoinTupleList();
        this.memberLevelInfo = new MemberLevelInfo(this);
        this.recordSetSizeRequestMetric();
    }

    private void rebuildCrossJoinTupleList() {
        ArrayList<ITupleList> childTupleLists = new ArrayList<ITupleList>();
        for (int i = 0; i < this.sets.length; ++i) {
            childTupleLists.add(this.sets[i].getTupleList());
        }
        ITupleList crossjoinTupleList = CrossJoinTupleList.construct(childTupleLists);
        this.initializeTupleList(crossjoinTupleList);
        if (this.tupleList != crossjoinTupleList) {
            this.sets = this.tupleList == null ? new Set[]{new Set(new Tuple[0])} : new Set[]{new Set(this.tupleList)};
        }
    }

    @Override
    public Object copy() {
        ISet[] cloneSets = new Set[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            cloneSets[i] = (Set)this.sets[i].copy();
        }
        CrossJoinedSet clone = new CrossJoinedSet(cloneSets);
        return clone;
    }

    @Override
    public ISet getSingleTupleSet() {
        ISet result = new Set(new Tuple[0]);
        for (int i = 0; i < this.sets.length; ++i) {
            Set set = this.sets[i];
            ISet sts = set.getSingleTupleSet();
            if (sts.isEmpty()) continue;
            result = result.crossjoin(sts);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceMember(IMember m) throws InterpreterException {
        IHierarchy hier = m.getHierarchy();
        for (int i = 0; i < this.sets.length; ++i) {
            if (!this.sets[i].contains(hier)) continue;
            this.tupleToIndexes = null;
            this.tupleToIndexesOptimized = null;
            this.tupleToIndexesBTree = null;
            LRUMap lRUMap = this.cachedOrdinalMap;
            synchronized (lRUMap) {
                this.cachedOrdinalMap.clear();
            }
            this.resetDimensionCardinality();
            this.sets[i].replaceMember(m);
        }
        if (this.tupleToIndexes == null && this.tupleToIndexesOptimized == null && this.tupleToIndexesBTree == null) {
            this.rebuildCrossJoinTupleList();
        }
    }

    public CrossJoinedSet createDistinct() throws InterpreterException {
        ISet[] currSets = this.getSets();
        for (int i = 0; i < currSets.length; ++i) {
            Set set = currSets[i];
            currSets[i] = set.distinct();
        }
        return new CrossJoinedSet(currSets);
    }

    private void populateTupleToIndex() {
        long tupleToIndexesSize = this.calculateTupleToIndexSize() * (long)((int)Math.ceil(1.3333333730697632));
        this.tupleToIndexes = new HashMap<Object, long[]>((int)Math.min(Integer.MAX_VALUE, tupleToIndexesSize), 0.75f);
        for (int i = 0; i < this.sets.length; ++i) {
            Set set = this.sets[i];
            int count = 0;
            for (ITuple tuple : set.getTupleList()) {
                long[] indexes = this.tupleToIndexes.get(tuple);
                if (indexes == null) {
                    indexes = new long[]{count++};
                } else {
                    long[] newIndexes = new long[indexes.length + 1];
                    System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                    newIndexes[indexes.length] = count++;
                    indexes = newIndexes;
                }
                this.tupleToIndexes.put(tuple.copy(), indexes);
                if (this.cancelManager == null || !this.cancelManager.isRequestCancelled()) continue;
                throw new OperationCanceledException();
            }
        }
    }

    public long calculateTupleToIndexSize() {
        long tupleCount = 0L;
        for (int i = 0; i < this.sets.length; ++i) {
            tupleCount += this.sets[i].size();
        }
        return tupleCount;
    }

    public boolean contains(Dimension dimension) {
        boolean result = false;
        if (this.size() > 0L) {
            for (int i = 0; !result && i < this.sets.length; ++i) {
                result = this.sets[i].getTuple(0L).contains(dimension);
            }
        }
        return result;
    }

    @Override
    public long size() {
        if (this.cachedSetSize != -1L) {
            return this.cachedSetSize;
        }
        this.cachedSetSize = 0L;
        if (this.sets.length > 0) {
            this.cachedSetSize = this.sets[0].size();
        }
        for (int i = 1; i < this.sets.length; ++i) {
            this.cachedSetSize = NumberOp.multiplyQuantities(this.cachedSetSize, this.sets[i].size());
            if (this.cachedSetSize >= 0L) continue;
            return this.cachedSetSize;
        }
        return this.cachedSetSize;
    }

    @Override
    public BigInteger noOverflowSize() {
        if (this.sets == null) {
            return BigInteger.ZERO;
        }
        BigInteger bIntSize = BigInteger.ONE;
        if (this.sets.length > 0) {
            bIntSize = this.sets[0].noOverflowSize();
        }
        for (int i = 1; i < this.sets.length; ++i) {
            bIntSize = bIntSize.multiply(this.sets[i].noOverflowSize());
        }
        return bIntSize;
    }

    @Override
    public boolean isEmpty() {
        if (this.sets == null || this.sets.length == 0) {
            return true;
        }
        for (Set set : this.sets) {
            if (!set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set[] getSets() {
        return (Set[])this.sets.clone();
    }

    @Override
    public IDimension[] getDimensions() {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        if (!this.isEmpty()) {
            for (int i = 0; i < this.sets.length; ++i) {
                Set set = this.sets[i];
                Dimension[] d = (Dimension[])set.getDimensions();
                for (int j = 0; j < d.length; ++j) {
                    if (result.contains(d[j])) continue;
                    result.add(d[j]);
                }
            }
        }
        return result.toArray(new Dimension[result.size()]);
    }

    @Override
    public IHierarchy[] getHierarchies() {
        ArrayList<IHierarchy> result = new ArrayList<IHierarchy>();
        if (!this.isEmpty()) {
            for (int i = 0; i < this.sets.length; ++i) {
                Set set = this.sets[i];
                IHierarchy[] hierarchies = set.getHierarchies();
                for (int j = 0; j < hierarchies.length; ++j) {
                    if (result.contains(hierarchies[j])) continue;
                    result.add(hierarchies[j]);
                }
            }
        }
        return result.toArray(new IHierarchy[result.size()]);
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        ListOrderedSet result = new ArrayList();
        result = ListOrderedSet.decorate((List)((List)result));
        if (this.size() != 0L) {
            for (Set s : this.sets) {
                IMember[] members;
                if (!s.contains(d)) continue;
                for (IMember m : members = s.getMembers(d)) {
                    result.add(m);
                }
            }
        }
        return result.toArray(new IMember[0]);
    }

    @Override
    public IMember[] getMembers(IHierarchy h) {
        ListOrderedSet result = new ArrayList();
        result = ListOrderedSet.decorate((List)((List)result));
        if (this.size() != 0L) {
            for (int i = 0; result.size() == 0 && i < this.sets.length; ++i) {
                Set s = this.sets[i];
                ITuple t = s.getTuple(0L);
                IHierarchy[] hiers = t.getHierarchies();
                for (int j = 0; result.size() == 0 && j < hiers.length; ++j) {
                    if (!hiers[j].equals(h)) continue;
                    return s.getMembers(h);
                }
            }
        }
        return result.toArray(new IMember[0]);
    }

    @Override
    public IMember[] getMembersRetainDuplicates(IDimension d) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        int setIdx = -1;
        for (int i = 0; i < this.sets.length; ++i) {
            if (!this.sets[i].contains(d)) continue;
            setIdx = i;
            break;
        }
        if (setIdx == -1) {
            return new IMember[0];
        }
        int dimIdx = this.sets[setIdx].getDimensionIndex(d);
        int i = 0;
        while ((long)i < this.sets[setIdx].size()) {
            ITuple tuple = this.sets[setIdx].getTuple(i);
            IMember m = tuple.getMember(dimIdx);
            if (m != null) {
                result.add(m);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    @Override
    public IMember[] getMembersRetainDuplicates(IHierarchy h) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        int setIdx = -1;
        for (int i = 0; i < this.sets.length; ++i) {
            if (!this.sets[i].contains(h)) continue;
            setIdx = i;
            break;
        }
        if (setIdx == -1) {
            return new IMember[0];
        }
        int hierIdx = this.sets[setIdx].getHierarchyIndex(h);
        int i = 0;
        while ((long)i < this.sets[setIdx].size()) {
            ITuple tuple = this.sets[setIdx].getTuple(i);
            IMember m = tuple.getMember(hierIdx);
            if (m != null) {
                result.add(m);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public IMember[][] getMembersRetainDuplicates(IHierarchy[] hierarchies) {
        int i;
        ArrayList[] result = new ArrayList[hierarchies.length];
        IMember[][] resultAsArray = new IMember[hierarchies.length][];
        for (i = 0; i < result.length; ++i) {
            result[i] = new ArrayList();
        }
        block1: for (int setIdx = 0; setIdx < this.sets.length; ++setIdx) {
            Set set = this.sets[setIdx];
            int[] hierarchyIndex = new int[hierarchies.length];
            for (int k = 0; k < hierarchies.length; ++k) {
                hierarchyIndex[k] = set.getHierarchyIndex(hierarchies[k]);
            }
            if (set.getHierarchyCount() == 1 && set.getTupleList() instanceof SingleHierarchySimpleTupleList) {
                ITupleList tl = set.getTupleList();
                int[] dimHierIndex = new int[]{0};
                IMember[][] tlMembers = ((SingleHierarchySimpleTupleList)tl).getMembersRetainDuplicates(dimHierIndex);
                for (int j = 0; j < hierarchies.length; ++j) {
                    if (hierarchyIndex[j] < 0) continue;
                    resultAsArray[j] = tlMembers[0];
                    continue block1;
                }
                continue;
            }
            ResourceMonitor.checkMaxSetSize(set.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            int i2 = 0;
            while ((long)i2 < set.size()) {
                ITuple tuple = this.sets[setIdx].getTuple(i2);
                for (int j = 0; j < hierarchies.length; ++j) {
                    IMember m;
                    if (hierarchyIndex[j] < 0 || (m = tuple.getMember(hierarchyIndex[j])) == null) continue;
                    result[j].add(m);
                }
                ++i2;
            }
        }
        for (i = 0; i < result.length; ++i) {
            if (resultAsArray[i] != null) continue;
            resultAsArray[i] = result[i].toArray(new IMember[result[i].size()]);
        }
        return resultAsArray;
    }

    public int[] getOrdinalsToIndex(ITuple tuple) {
        IHierarchy[] hiers = tuple.getHierarchies();
        if (hiers.length == 0) {
            return new int[0];
        }
        Cube cube = (Cube)tuple.getCube();
        if (cube == null) {
            cube = (Cube)hiers[0].getDimension().getCube();
        }
        List<IHierarchy> allHiers = cube.getHierarchies();
        int[] ordinalsToIndex = new int[allHiers.size()];
        for (IHierarchy hier : allHiers) {
            boolean found = false;
            int i = 0;
            while (i < hiers.length && !found) {
                boolean sameHierarchy = true;
                if (null == hiers[i]) {
                    sameHierarchy = false;
                }
                if (this.multipleHierarchySupport(cube)) {
                    sameHierarchy = hier.equals(hiers[i]);
                } else {
                    boolean bl = sameHierarchy = hiers[i] != null && hiers[i].getDimension().equals(hier.getDimension());
                }
                if (sameHierarchy) {
                    found = true;
                    continue;
                }
                ++i;
            }
            int hierIndex = 0;
            hierIndex = this.multipleHierarchySupport() ? ((Hierarchy)hier).getOrdinal(cube.getName()) : ((Dimension)hier.getDimension()).getIndex(cube.getName());
            if (found) {
                ordinalsToIndex[hierIndex] = i;
                continue;
            }
            ordinalsToIndex[hierIndex] = -1;
        }
        return ordinalsToIndex;
    }

    public void calcOrdinalsToIndex(ITuple tuple) {
        this.cubeHierToTupleHierMap = this.getOrdinalsToIndex(tuple);
    }

    @Override
    public long[] getOrdinals(ITuple tuple) {
        int[] ordinalsToIndex = this.getOrdinalsToIndex(tuple);
        return this.getOrdinals(tuple, ordinalsToIndex);
    }

    public long[] getOrdinals(ITuple tuple, int[] ordinalsToIndex) {
        List<long[]> tupleOrdinals = this.getTupleOrdinals(tuple, ordinalsToIndex, false, null, null);
        if (tupleOrdinals.isEmpty()) {
            return EMPTY_LONG_ARRAY;
        }
        long[] axesSizes = this.getSetSizesInReverseOrder();
        long[] result = new long[tupleOrdinals.size()];
        for (int i = 0; i < tupleOrdinals.size(); ++i) {
            result[i] = ResultSetMetadata.computeCellOrdinal(tupleOrdinals.get(i), axesSizes);
        }
        return result;
    }

    public long[] getSetSizesInReverseOrder() {
        if (this.setSizesInReverseOrder != null) {
            return this.setSizesInReverseOrder;
        }
        this.setSizesInReverseOrder = new long[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            this.setSizesInReverseOrder[this.sets.length - i - 1] = this.sets[i].size();
        }
        return this.setSizesInReverseOrder;
    }

    public Number[] getSetSizesInReverseOrder(boolean overload) {
        Number[] axesSizes = new Number[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            long setSize = this.sets[i].size();
            axesSizes[this.sets.length - i - 1] = setSize < 0L ? this.sets[i].noOverflowSize() : Long.valueOf(setSize);
        }
        return axesSizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeForOrdinalScan(ITuple tuple, boolean checkDisableIndex) {
        if (!this.initializedForOrdinalScan) {
            CrossJoinedSet crossJoinedSet = this;
            synchronized (crossJoinedSet) {
                if (!this.initializedForOrdinalScan) {
                    this.size();
                    if (!this.disableTupleIndexIsSet) {
                        if (!(this.setTupleMapEnabled || this.leafSetTupleMapEnabled || this.btreeEnabled)) {
                            long noTupleIndexThreshold = CrossJoinedSet.getNoTupleIndexThreshold();
                            long tupleToIndexSize = this.calculateTupleToIndexSize();
                            if (tupleToIndexSize >= noTupleIndexThreshold) {
                                this.disableTupleIndex = true;
                            }
                        }
                        this.disableTupleIndexIsSet = true;
                    }
                    if (!this.disableTupleIndex || !checkDisableIndex) {
                        this.calcOrdinalsToIndex(tuple);
                        this.initializeTupleToIndex();
                        this.initializedForOrdinalScan = true;
                    }
                }
            }
        }
    }

    public List<long[]> getTupleOrdinals(ITuple tuple, TupleOrdinalCalculationCache cache, List<long[]> result) {
        this.initializeForOrdinalScan(tuple, true);
        if (this.disableTupleIndex) {
            if (result == null) {
                result = new ArrayList<long[]>();
            }
            ArrayList<List<Number>> tupleIndexesInSet = new ArrayList<List<Number>>();
            for (int i = this.sets.length - 1; i >= 0; --i) {
                Set set = this.sets[i];
                List<Number> indexes = ((TupleList)set.getTupleList()).find(tuple, cache);
                tupleIndexesInSet.add(indexes);
            }
            TupleList.computeTupleOrdinals(tupleIndexesInSet, result);
        } else {
            result = this.getTupleOrdinals(tuple, this.cubeHierToTupleHierMap, true, cache, result);
        }
        return result;
    }

    public List<Number[]> getTupleOrdinals(ITuple tuple, boolean overload) {
        ArrayList<Number[]> result = null;
        result = new ArrayList<Number[]>();
        ArrayList<List<Number>> tupleIndexesInSet = new ArrayList<List<Number>>();
        for (int i = this.sets.length - 1; i >= 0; --i) {
            Set set = this.sets[i];
            List<Number> indexes = ((TupleList)set.getTupleList()).find(tuple, null);
            tupleIndexesInSet.add(indexes);
        }
        TupleList.computeTupleOrdinals(tupleIndexesInSet, result, true);
        return result;
    }

    private List<long[]> getTupleOrdinals(ITuple tuple, int[] ordinalsToIndex, boolean tupleIndexFlag, TupleOrdinalCalculationCache cache, List<long[]> result) {
        if (result == null) {
            result = new ArrayList<long[]>();
        }
        List<long[]> tupleIndexesInSet = null;
        tupleIndexesInSet = cache != null ? cache.getCachedTupleIndexesInSetList() : new ArrayList<long[]>();
        if (this.size() != 0L) {
            this.initializeForOrdinalScan(tuple, tupleIndexFlag);
            for (int i = this.sets.length - 1; i >= 0; --i) {
                long[] indexes;
                Set set = this.sets[i];
                if (this.leafSetTupleMapEnabled) {
                    indexes = this.leafSetTupleMap.getOrdinals(set, i, tuple, ordinalsToIndex);
                } else {
                    int[] aChildSetHierarchyOrdinals = this.getChildSetHierarchyOrdinals(i, tuple);
                    IMember[] mems = cache != null ? cache.getMemberArray(i, aChildSetHierarchyOrdinals.length) : new IMember[aChildSetHierarchyOrdinals.length];
                    boolean nullFlag = false;
                    nullFlag = this.populateMembersByHierarchy(tuple, ordinalsToIndex, aChildSetHierarchyOrdinals, mems, nullFlag);
                    indexes = !nullFlag ? this.extractIndexesFromMembers(mems, i) : this.extractIndexesFromSet(set);
                }
                tupleIndexesInSet.add(indexes);
            }
            CrossJoinedSet.computeTupleOrdinals(tupleIndexesInSet, result);
        } else {
            result.clear();
        }
        return result;
    }

    private static void computeTupleOrdinals(List<long[]> tupleIndexesInSet, List<long[]> result) {
        int i;
        int numberOfTupleOrdinals = 1;
        int tupleOrdinalArraySize = tupleIndexesInSet.size();
        for (i = 0; i < tupleOrdinalArraySize; ++i) {
            numberOfTupleOrdinals *= tupleIndexesInSet.get(i).length;
        }
        for (i = result.size() - 1; i >= 0; --i) {
            if (result.get(i).length == tupleOrdinalArraySize) continue;
            result.remove(i);
        }
        if (result.size() > numberOfTupleOrdinals) {
            for (i = result.size() - 1; i >= numberOfTupleOrdinals; --i) {
                result.remove(i);
            }
        } else if (result.size() < numberOfTupleOrdinals) {
            for (i = result.size(); i < numberOfTupleOrdinals; ++i) {
                result.add(new long[tupleOrdinalArraySize]);
            }
        }
        if (numberOfTupleOrdinals > 0) {
            int duplicates = 1;
            for (int setIndex = tupleOrdinalArraySize - 1; setIndex >= 0; --setIndex) {
                long[] indexes = tupleIndexesInSet.get(setIndex);
                int indexPosition = 0;
                int numberOfCopy = 0;
                for (int tupleOrdinalIndex = 0; tupleOrdinalIndex < result.size(); ++tupleOrdinalIndex) {
                    if (indexPosition == indexes.length) {
                        indexPosition = 0;
                    }
                    int index = indexPosition++;
                    long aTupleIndexInSet = indexes[index];
                    long[] aTupleOrdinal = result.get(tupleOrdinalIndex);
                    aTupleOrdinal[setIndex] = aTupleIndexInSet;
                    if (++numberOfCopy != duplicates) continue;
                    numberOfCopy = 0;
                }
                duplicates *= indexes.length;
            }
        }
    }

    private void initializeTupleToIndex() {
        if (this.tupleToIndexes == null && this.tupleToIndexesOptimized == null && this.tupleToIndexesBTree == null) {
            long setTupleMapThreshold = CrossJoinedSet.getSetTupleMapThreshold();
            long maxTupleMapThreshold = 5000000L;
            long maxTupleMaterializationFactor = CrossJoinedSet.getMaxTupleMaterializationFactor();
            long tupleToIndexSize = this.calculateTupleToIndexSize();
            this.leafSetTupleMapEnabled = this.tupleList.listSize() < maxTupleMapThreshold && this.tupleList.listSize() * maxTupleMaterializationFactor < tupleToIndexSize;
            boolean bl = this.setTupleMapEnabled = tupleToIndexSize >= setTupleMapThreshold;
            if (this.leafSetTupleMapEnabled) {
                this.leafSetTupleMap = new LeafSetTupleMap(this);
                return;
            }
            if (this.setTupleMapEnabled) {
                try {
                    this.tupleMap = new SetTupleMap(this);
                    this.tupleToIndexesOptimized = this.tupleMap.getTupleToIndexes();
                    return;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (XQERuntimeException e) {
                    this.setTupleMapEnabled = false;
                }
            }
            this.populateTupleToIndex();
        }
    }

    private static long getMaxTupleMaterializationFactor() {
        IDataSource ds;
        long factor = 100L;
        ExecutionEnvironment ee = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (ee != null && (ds = ee.getDataSource()) != null) {
            String thresholdString = ds.getCapabilities().getStringValue("mdx.cjs.maxTupleMaterialization.threshold", Long.toString(factor));
            try {
                factor = Long.valueOf(thresholdString);
            }
            catch (NumberFormatException e) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidPropertyValue, (Object)thresholdString, (Object)"mdx.cjs.maxTupleMaterialization.threshold", (Object)Long.class.getSimpleName());
            }
        }
        return factor;
    }

    private static int getSetTupleMapThreshold() {
        IDataSource ds;
        long threshold = 25000L;
        ExecutionEnvironment ee = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (ee != null && (ds = ee.getDataSource()) != null) {
            String thresholdString = ds.getCapabilities().getStringValue("mdx.cjs.tupleToIndBitMap.threshold", Long.toString(25000L));
            try {
                threshold = Long.valueOf(thresholdString);
            }
            catch (NumberFormatException e) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidPropertyValue, (Object)thresholdString, (Object)"mdx.cjs.tupleToIndBitMap.threshold", (Object)Integer.class.getSimpleName());
            }
        }
        if (System.getProperty(MIN_SIZE_FOR_SETTUPLEMAP_STR) != null) {
            try {
                threshold = Integer.parseInt(System.getProperty(MIN_SIZE_FOR_SETTUPLEMAP_STR));
            }
            catch (NumberFormatException ne) {
                mErrorLogger.log(ne);
            }
            if (threshold < 0L) {
                threshold = 0L;
            }
        }
        return (int)threshold;
    }

    private static long getNoTupleIndexThreshold() {
        IDataSource ds;
        long threshold = 5000000L;
        ExecutionEnvironment ee = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (ee != null && (ds = ee.getDataSource()) != null) {
            String thresholdString = ds.getCapabilities().getStringValue("mdx.cjs.noTupleIndex.threshold", Long.toString(5000000L));
            try {
                threshold = Long.valueOf(thresholdString);
            }
            catch (NumberFormatException e) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidPropertyValue, (Object)thresholdString, (Object)"mdx.cjs.noTupleIndex.threshold", (Object)Integer.class.getSimpleName());
            }
        }
        return threshold;
    }

    public boolean exceedsThreshold() {
        if (this.size() > Integer.MAX_VALUE) {
            return true;
        }
        return this.size() > (long)(CrossJoinedSet.getSetTupleMapThreshold() * 10);
    }

    @Override
    public Set intersect(Set s, boolean allowDuplicates) throws InterpreterException {
        Set[] s2Sets;
        if (!(s instanceof CrossJoinedSet)) {
            return super.intersect(s, allowDuplicates);
        }
        Set[] s1Sets = this.getSets();
        if (s1Sets.length != (s2Sets = ((CrossJoinedSet)s).getSets()).length) {
            return super.intersect(s, allowDuplicates);
        }
        for (int i = 0; i < s1Sets.length; ++i) {
            IHierarchy[] s2iHierarchies;
            IHierarchy[] s1iHierarchies = s1Sets[i].getHierarchies();
            if (s1iHierarchies.length != (s2iHierarchies = s2Sets[i].getHierarchies()).length) {
                return super.intersect(s, allowDuplicates);
            }
            for (int j = 0; j < s1iHierarchies.length; ++j) {
                if (s1iHierarchies[j] == s2iHierarchies[j]) continue;
                return super.intersect(s, allowDuplicates);
            }
        }
        ISet[] newSet = new ISet[s1Sets.length];
        for (int i = 0; i < newSet.length; ++i) {
            Set aSet = s1Sets[i].intersect(s2Sets[i], allowDuplicates);
            if (aSet.isEmpty()) {
                return new CrossJoinedSet(new ISet[0]);
            }
            newSet[i] = aSet;
        }
        return new CrossJoinedSet(newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getChildSetHierarchyOrdinals(int childSetIndex, ITuple tuple) {
        if (childSetIndex < 0 || childSetIndex >= this.sets.length) {
            return new int[0];
        }
        if (this.setHierarchyOrdinals == null) {
            CrossJoinedSet crossJoinedSet = this;
            synchronized (crossJoinedSet) {
                ICube tupleCube = tuple.getCube();
                String cubeName = null;
                if (tupleCube != null) {
                    cubeName = tupleCube.getName();
                }
                boolean hasMulitpleHierarchySupport = this.multipleHierarchySupport(tupleCube);
                if (this.setHierarchyOrdinals == null) {
                    int[][] tmpOrdinalArray = new int[this.sets.length][];
                    for (int i = 0; i < this.sets.length; ++i) {
                        Set set = this.sets[i];
                        IHierarchy[] hierarchies = set.getHierarchies();
                        int[] aChildSetHierarchyOrdinals = new int[hierarchies.length];
                        for (int j = 0; j < hierarchies.length; ++j) {
                            int hierarchyIndex = 0;
                            hierarchyIndex = hasMulitpleHierarchySupport ? ((Hierarchy)hierarchies[j]).getOrdinal(cubeName) : ((Dimension)hierarchies[j].getDimension()).getIndex(cubeName);
                            aChildSetHierarchyOrdinals[j] = hierarchyIndex;
                        }
                        tmpOrdinalArray[i] = aChildSetHierarchyOrdinals;
                    }
                    this.setHierarchyOrdinals = tmpOrdinalArray;
                }
            }
        }
        return this.setHierarchyOrdinals[childSetIndex];
    }

    private boolean populateMembersByHierarchy(ITuple tuple, int[] ordinalsToIndex, int[] hierarchyOrdinals, IMember[] mems, boolean nullFlag) {
        for (int j = 0; j < mems.length; ++j) {
            int idx = -1;
            int hierarchyIndex = hierarchyOrdinals[j];
            if (hierarchyIndex >= 0 && hierarchyIndex < ordinalsToIndex.length) {
                idx = ordinalsToIndex[hierarchyIndex];
            }
            if (idx != -1) {
                mems[j] = tuple.getMember(idx);
                continue;
            }
            nullFlag = true;
            mems[j] = null;
        }
        return nullFlag;
    }

    private long[] extractIndexesFromMembers(IMember[] mems, int setIndex) {
        long[] indexes;
        if (this.setTupleMapEnabled) {
            long tupleBM = this.tupleMap.getTupleBitMapBySetIndex(mems, setIndex);
            indexes = this.tupleToIndexesOptimized.get(tupleBM);
        } else {
            Tuple subTuple = new Tuple(mems, false);
            indexes = this.btreeEnabled ? this.tupleToIndexesBTree.getLongArray(subTuple) : this.tupleToIndexes.get(subTuple);
        }
        if (indexes == null) {
            return EMPTY_LONG_ARRAY;
        }
        return indexes;
    }

    private long[] extractIndexesFromSet(Set set) {
        ResourceMonitor.checkMaxSetSize(set.size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        long[] indexes = new long[(int)set.size()];
        for (int j = 0; j < indexes.length; ++j) {
            indexes[j] = j;
        }
        return indexes;
    }

    @Override
    public boolean containsNullMembers() {
        for (int i = 0; i < this.sets.length; ++i) {
            if (!this.sets[i].containsNullMembers()) continue;
            return true;
        }
        return false;
    }

    public boolean[] containsNullTag(long ordinal) {
        boolean[] nullTag = new boolean[this.sets.length];
        long n = this.size();
        long index = ordinal;
        for (int i = this.sets.length - 1; i >= 0; --i) {
            Set s = this.sets[i];
            long tupIndex = index / (n /= s.size());
            ITuple t = s.getTuple(tupIndex);
            if (((Tuple)t).containsNullTag()) {
                nullTag[i] = true;
            }
            index -= tupIndex * n;
        }
        return nullTag;
    }

    public CrossJoinedSet removeNullMembersFromCrossJoinedSet() {
        if (this.containsNullMembers()) {
            ISet[] outputSets = new Set[this.sets.length];
            for (int i = 0; i < this.sets.length; ++i) {
                outputSets[i] = this.sets[i].removeNullMembers();
                if (!((Set)outputSets[i]).isEmpty()) continue;
                return new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
            }
            return new CrossJoinedSet(outputSets);
        }
        return this;
    }

    @Override
    public Set removeNullMembers() {
        return this.removeNullMembersFromCrossJoinedSet();
    }

    @Override
    public Set hierarchize(boolean post) {
        ISet[] sortedSets = new Set[this.sets.length];
        for (int i = 0; i < sortedSets.length; ++i) {
            sortedSets[i] = this.sets[i].hierarchize(post);
        }
        return new CrossJoinedSet(sortedSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITuple getTuple(long ordinal) {
        Tuple result = null;
        Long lOrdinal = XQESoftLongPool.getLong(ordinal);
        LRUMap lRUMap = this.cachedOrdinalMap;
        synchronized (lRUMap) {
            result = (Tuple)this.cachedOrdinalMap.get((Object)lOrdinal);
        }
        if (result == null) {
            result = new Tuple((IMember[])super.getTuple(ordinal).getMembers().clone(), false);
            lRUMap = this.cachedOrdinalMap;
            synchronized (lRUMap) {
                this.cachedOrdinalMap.put((Object)lOrdinal, (Object)result);
            }
        }
        return result;
    }

    public Member[] getCalculations() {
        ListOrderedSet result = ListOrderedSet.decorate(new ArrayList());
        for (int i = 0; i < this.sets.length; ++i) {
            Set set = this.sets[i];
            result.addAll(set.getTupleList().getCalculatedMembers());
        }
        return (Member[])result.toArray((Object[])new Member[0]);
    }

    public CrossJoinedSet merge(CrossJoinedSet cjs) throws InterpreterException {
        Set[] sets2 = cjs.sets;
        this.cachedSetSize = -1L;
        ISet[] ss = new Set[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            ss[i] = Set.union(new Set[]{this.sets[i], sets2[i]}, false);
        }
        CrossJoinedSet result = new CrossJoinedSet(ss);
        return result;
    }

    @Override
    public Set subset(long start, long count) throws InterpreterException {
        return super.subset(start, count);
    }

    @Override
    public ISet removeDimensions(IDimension[] d, boolean retainDuplicates) {
        ISet cjs = null;
        for (int i = 0; i < this.sets.length; ++i) {
            ISet s = this.sets[i].removeDimensions(d, retainDuplicates);
            if (s.isEmpty()) continue;
            cjs = cjs == null ? s : ((Set)cjs).crossjoin(s);
        }
        if (cjs == null) {
            cjs = new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
        }
        return cjs;
    }

    @Override
    public ISet removeHierarchies(IHierarchy[] h, boolean retainDuplicates) {
        ISet cjs = null;
        for (int i = 0; i < this.sets.length; ++i) {
            ISet s = this.sets[i].removeHierarchies(h, retainDuplicates);
            if (s.isEmpty()) continue;
            cjs = cjs == null ? s : ((Set)cjs).crossjoin(s);
        }
        if (cjs == null) {
            cjs = new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
        }
        return cjs;
    }

    @Override
    public ISet removeDimension(IDimension d, boolean retainDuplicates) {
        ArrayList<Set> al = new ArrayList<Set>();
        for (int i = 0; i < this.sets.length; ++i) {
            Set s = (Set)this.sets[i].removeDimension(d, retainDuplicates);
            al.add(s);
        }
        return new CrossJoinedSet(al.toArray(new Set[al.size()]));
    }

    @Override
    public void removeCurrentMemberDimensions() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].removeCurrentMemberDimensions();
        }
    }

    @Override
    public int[] getDimensionCardinality() {
        if (this.dimensionCardinality == null) {
            if (this.size() != 0L) {
                this.dimensionCardinality = new int[this.getHierarchyCount()];
                int dimOffset = 0;
                for (int i = 0; i < this.sets.length; ++i) {
                    Set set = this.sets[i];
                    int[] setCard = set.getDimensionCardinality();
                    int setDimCount = set.getHierarchyCount();
                    System.arraycopy(setCard, 0, this.dimensionCardinality, dimOffset, setDimCount);
                    dimOffset += setDimCount;
                }
            } else {
                this.dimensionCardinality = new int[0];
            }
        }
        return this.dimensionCardinality;
    }

    @Override
    public boolean[] getSingleMemberHierarchyFlags() {
        block4: {
            if (this.singleMemberHierarchyFlags != null) break block4;
            int hierCount = this.getHierarchyCount();
            this.singleMemberHierarchyFlags = new boolean[hierCount];
            if (this.dimensionCardinality == null) {
                int dimOffset = 0;
                for (int i = 0; i < this.sets.length; ++i) {
                    Set set = this.sets[i];
                    boolean[] setFlags = set.getSingleMemberHierarchyFlags();
                    int setDimCount = set.getHierarchyCount();
                    System.arraycopy(setFlags, 0, this.singleMemberHierarchyFlags, dimOffset, setDimCount);
                    dimOffset += setDimCount;
                }
            } else {
                for (int i = 0; i < hierCount; ++i) {
                    this.singleMemberHierarchyFlags[i] = this.dimensionCardinality[i] == 1;
                }
            }
        }
        return this.singleMemberHierarchyFlags;
    }

    public void release() {
        if (this.tupleToIndexesBTree != null) {
            this.tupleToIndexesBTree.close();
            this.tupleToIndexesBTree = null;
        }
    }

    @Override
    public String toString() {
        String result = "CJS::";
        for (int i = 0; i < this.sets.length; ++i) {
            result = result + i + this.sets[i].toString() + "";
        }
        return result;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("CrossJoinedSet", -1);
        for (Set s : this.sets) {
            s.toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    public Iterator<CrossJoinedSet> subCrossJoinedSetIterator() {
        return new SubCrossJoinedSetIterator(this);
    }

    public IIterator dimensionOrderedIterator(Dimension[] dimensionOrder) {
        return new DimensionOrderedSetIterator(this, dimensionOrder);
    }

    public IIterator hierarchyOrderedIterator(IHierarchy[] hierarchyOrder) {
        return new HierarchyOrderedSetIterator(this, hierarchyOrder);
    }

    public boolean sizeOne() {
        for (Set set : this.sets) {
            long tupleSize;
            long setSize = set.size();
            if (setSize == 1L || !(setSize > 1L ? (tupleSize = (long)set.getTuple(0L).size()) != 1L : setSize == 0L)) continue;
            return false;
        }
        return true;
    }

    public MemberLevelInfo getMemberLevelInfo() {
        return this.memberLevelInfo;
    }

    public void populateMemberLevelInfo(MemberLevelInfo other) {
        this.memberLevelInfo.populateFrom(other);
    }

    @Override
    public long sizeOf() {
        long size = super.sizeOf();
        for (Set s : this.sets) {
            size += s.sizeOf();
        }
        return size;
    }

    public static final boolean notEqualCJS(CrossJoinedSet a, CrossJoinedSet b) {
        if (a.size() != b.size()) {
            return true;
        }
        if (a.isEmpty()) {
            return false;
        }
        int tupleSize = ((Tuple)a.getTuple(0L)).size();
        if (tupleSize != ((Tuple)b.getTuple(0L)).size()) {
            return true;
        }
        Object[] aMembers = new IMember[tupleSize];
        Object[] bMembers = new IMember[tupleSize];
        long setSize = a.size();
        ResourceMonitor.checkMaxSetSize(setSize, null, XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (long i = 0L; i < setSize; ++i) {
            int j;
            ITuple aTuple = a.getTuple(i);
            ITuple bTuple = b.getTuple(i);
            for (j = 0; j < tupleSize; ++j) {
                aMembers[j] = aTuple.getMember(j);
            }
            for (j = 0; j < tupleSize; ++j) {
                bMembers[j] = bTuple.getMember(j);
            }
            if (Arrays.equals(aMembers, bMembers)) continue;
            return true;
        }
        return false;
    }

    private final class HierarchyOrderedSetIterator
    implements IIterator {
        private long count;
        private final CrossJoinedSet cjs;
        private final long cjsSize;
        int[] dimensionOrderIndex;

        private HierarchyOrderedSetIterator(CrossJoinedSet theCjs, IHierarchy[] hierarchyOrder) {
            this.cjs = theCjs;
            this.cjsSize = theCjs.size();
            IHierarchy[] hierInSet = theCjs.getHierarchies();
            this.dimensionOrderIndex = new int[hierInSet.length];
            for (int k = 0; k < hierInSet.length; ++k) {
                this.dimensionOrderIndex[k] = 0;
            }
            for (int i = 0; i < hierarchyOrder.length; ++i) {
                for (int k = 0; k < hierInSet.length; ++k) {
                    if (!hierInSet[k].equals(hierarchyOrder[i])) continue;
                    this.dimensionOrderIndex[k] = i;
                }
            }
        }

        @Override
        public long getIndex() {
            return this.count;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.cjsSize;
        }

        @Override
        public Object next() {
            ITuple t = this.cjs.getTuple(this.count++);
            IMember[] mems = new IMember[t.size()];
            Tuple result = null;
            for (int k = 0; k < mems.length; ++k) {
                IMember m = t.getMember(k);
                int i = this.dimensionOrderIndex[k];
                mems[i] = m;
            }
            result = new Tuple(mems, false);
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    }

    private final class DimensionOrderedSetIterator
    implements IIterator {
        private long count;
        private final CrossJoinedSet cjs;
        private final long cjsSize;
        int[] dimensionOrderIndex;

        private DimensionOrderedSetIterator(CrossJoinedSet theCjs, Dimension[] dimensionOrder) {
            this.cjs = theCjs;
            this.cjsSize = theCjs.size();
            IDimension[] dimsInSet = theCjs.getDimensions();
            this.dimensionOrderIndex = new int[dimsInSet.length];
            for (int k = 0; k < dimsInSet.length; ++k) {
                this.dimensionOrderIndex[k] = 0;
            }
            for (int i = 0; i < dimensionOrder.length; ++i) {
                for (int k = 0; k < dimsInSet.length; ++k) {
                    if (!dimsInSet[k].equals(dimensionOrder[i])) continue;
                    this.dimensionOrderIndex[k] = i;
                }
            }
        }

        @Override
        public long getIndex() {
            return this.count;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.cjsSize;
        }

        @Override
        public Object next() {
            if (CrossJoinedSet.this.cancelManager != null && CrossJoinedSet.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            ITuple t = this.cjs.getTuple(this.count++);
            IMember[] mems = new IMember[t.size()];
            Tuple result = null;
            for (int k = 0; k < mems.length; ++k) {
                IMember m = t.getMember(k);
                int i = this.dimensionOrderIndex[k];
                mems[i] = m;
            }
            result = new Tuple(mems, false);
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    }

    private final class SubCrossJoinedSetIterator
    implements Iterator<CrossJoinedSet> {
        private final CrossJoinedSet cjs;
        long[] next = null;
        boolean firstSubCJS = true;
        boolean overflow = false;
        int maxTuples = Integer.MAX_VALUE;

        private SubCrossJoinedSetIterator(CrossJoinedSet set) {
            this.cjs = set;
            this.initializeNext();
        }

        private void initializeNext() {
            int numberOfSets = this.cjs.sets.length;
            this.next = new long[numberOfSets];
            long size = this.cjs.sets[numberOfSets - 1].size();
            this.next[numberOfSets - 1] = size < 0L ? 0L : -1L;
            for (int i = numberOfSets - 2; i >= 0; --i) {
                this.next[i] = size < 0L ? 0L : ((size = this.noOverflowMultiply(this.cjs.sets[i].size(), size)) == -1L ? 0L : -1L);
            }
        }

        long noOverflowMultiply(long a, long b) {
            if (b == 0L || a <= Long.MAX_VALUE / b) {
                return a * b;
            }
            this.maxTuples = (int)Math.floor(Long.MAX_VALUE / b);
            return -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.next[0] == -1L) {
                if (this.firstSubCJS) {
                    this.firstSubCJS = false;
                    return true;
                }
                return false;
            }
            return !this.overflow || this.next[0] != 0L;
        }

        @Override
        public CrossJoinedSet next() {
            int numberOfSets = this.cjs.sets.length;
            boolean sameCJS = true;
            ISet[] subSets = new Set[numberOfSets];
            boolean firstPartialSet = true;
            for (int i = numberOfSets - 1; i >= 0; --i) {
                if (this.next[i] == -1L) {
                    subSets[i] = this.cjs.sets[i];
                    continue;
                }
                sameCJS = false;
                if (firstPartialSet) {
                    firstPartialSet = false;
                    int numberOfTuples = this.maxTuples;
                    if (this.cjs.sets[i].size() - this.next[i] < (long)this.maxTuples) {
                        numberOfTuples = (int)((long)((int)this.cjs.sets[i].size()) - this.next[i]);
                    }
                    ITuple[] tuples = new Tuple[numberOfTuples];
                    for (int j = 0; j < numberOfTuples; ++j) {
                        tuples[j] = (Tuple)this.cjs.sets[i].getTuple(this.next[i] + (long)j);
                    }
                    subSets[i] = new Set(tuples);
                    this.next[i] = this.next[i] + (long)(numberOfTuples - 1);
                    continue;
                }
                subSets[i] = new Set(this.cjs.sets[i].getTuple(this.next[i]));
            }
            boolean carry = false;
            for (int i = numberOfSets - 1; i >= 0; --i) {
                if (this.next[i] == -1L) continue;
                if (this.next[i] + 1L < this.cjs.sets[i].size()) {
                    this.next[i] = this.next[i] + 1L;
                    carry = false;
                    break;
                }
                if (this.next[i] + 1L != this.cjs.sets[i].size()) continue;
                this.next[i] = 0L;
                carry = true;
            }
            if (carry) {
                this.overflow = true;
            }
            if (sameCJS) {
                return this.cjs;
            }
            return new CrossJoinedSet(subSets);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

