/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.runtree.olap.mdx.interpreter.IStatementResult;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;

public class DDLResult
implements IStatementResult {
    public static final int DDL_UNINITIALIZED = -1;
    public static final int DDL_CREATE_SESSION_MEMBER = 1;
    public static final int DDL_DROP_SESSION_MEMBER = 2;
    public static final int DDL_CREATE_SESSION_SET = 3;
    public static final int DDL_DROP_SESSION_SET = 4;
    private boolean createStatement = false;
    private boolean dropStatement = false;
    private Object resultObject = null;
    private Set namedSetContents = null;

    @Override
    public boolean isDDLResult() {
        return true;
    }

    @Override
    public boolean isDrillThroughResultSet() {
        return false;
    }

    @Override
    public boolean isMDResultSet() {
        return false;
    }

    public DDLResult(boolean aCreateStatement, boolean aDropStatement, Object aResultObject) {
        this.resultObject = aResultObject;
        this.createStatement = aCreateStatement;
        this.dropStatement = aDropStatement;
    }

    public String getDDLType() {
        int op = this.getCSOperationType();
        switch (op) {
            case -1: {
                return "UNINITIALIZED DDL OPERATION TYPE";
            }
            case 1: {
                return "CREATE SESSION MEMBER";
            }
            case 2: {
                return "DROP SESSION MEMBER";
            }
            case 3: {
                return "CREATE SESSION SET";
            }
            case 4: {
                return "DROP SESSION SET";
            }
        }
        return "INVALID DDL OPERATION TYPE";
    }

    public CalculatedMember getCalculatedMember() {
        if (this.resultObject instanceof CalculatedMember) {
            CalculatedMember member = (CalculatedMember)this.resultObject;
            return member;
        }
        return null;
    }

    public NamedSet getNamedSet() {
        if (this.resultObject instanceof NamedSet) {
            NamedSet set = (NamedSet)this.resultObject;
            return set;
        }
        return null;
    }

    public Set getNamedSetContents() {
        return this.namedSetContents;
    }

    public void setNamedSetContents(Set theNamedSetContents) {
        this.namedSetContents = theNamedSetContents;
    }

    public String toString() {
        return this.getDDLType() + " " + this.resultObject;
    }

    public String getCSCubeName() {
        if (this.resultObject instanceof CalculatedMember) {
            CalculatedMember member = (CalculatedMember)this.resultObject;
            return member.getDimension().getCube().getName();
        }
        if (this.resultObject instanceof NamedSet) {
            NamedSet set = (NamedSet)this.resultObject;
            return set.getCubeName();
        }
        return null;
    }

    public String getCSMemberName() {
        if (this.resultObject instanceof CalculatedMember) {
            CalculatedMember member = (CalculatedMember)this.resultObject;
            return member.getName();
        }
        return null;
    }

    public String getSetName() {
        if (this.resultObject instanceof NamedSet) {
            NamedSet set = (NamedSet)this.resultObject;
            return set.getName();
        }
        return null;
    }

    public int getCSOperationType() {
        if (this.createStatement) {
            if (this.resultObject instanceof CalculatedMember) {
                return 1;
            }
            if (this.resultObject instanceof NamedSet) {
                return 3;
            }
            return -1;
        }
        if (this.dropStatement) {
            if (this.resultObject instanceof CalculatedMember) {
                return 2;
            }
            if (this.resultObject instanceof NamedSet) {
                return 4;
            }
            return -1;
        }
        return -1;
    }
}

