/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.trace.XQEDebugLog;

public class IsEmptySet
extends Set {
    private Set nonEmptySet;
    private Set emptyValueSet;

    public IsEmptySet(Set baseSet, Set theNonEmptySet) throws InterpreterException {
        super(new Tuple[0]);
        XQEDebugLog.out.println("Creating IsEmptySet");
        this.nonEmptySet = theNonEmptySet;
        this.emptyValueSet = this.getEmptyValueSet(baseSet);
    }

    public Set notIsEmpty() throws InterpreterException {
        XQEDebugLog.out.println("returning notIsEmpty");
        return this.nonEmptySet;
    }

    public Set getEmptyValueSet(Set baseSet) throws InterpreterException {
        ITuple[] tuples = new Tuple[(int)baseSet.size() - (int)this.nonEmptySet.size()];
        if (this.nonEmptySet.size() == 0L) {
            int i = 0;
            while ((long)i < baseSet.size()) {
                tuples[i] = (Tuple)baseSet.getTuple(i);
                ++i;
            }
        } else {
            int k = 0;
            int i = 0;
            while ((long)i < baseSet.size()) {
                ITuple baseSetTuple = baseSet.getTuple(i);
                Tuple t = new Tuple((Tuple)this.nonEmptySet.getTuple(0L));
                for (int j = 0; j < baseSetTuple.size(); ++j) {
                    IMember m = baseSetTuple.getMember(j);
                    int hierIndex = baseSet.getHierarchyIndex(m.getHierarchy());
                    if (hierIndex < 0) {
                        throw new InterpreterException("X01481", new String[]{"IsEmpty", m.getHierarchy().getName()});
                    }
                    t.replaceMember(hierIndex, m);
                }
                if (this.nonEmptySet.getOrdinals(t).length == 0) {
                    tuples[k++] = t;
                }
                ++i;
            }
        }
        return new Set(tuples);
    }

    @Override
    public boolean isEmpty() {
        return this.emptyValueSet.isEmpty();
    }

    @Override
    public long size() {
        return this.emptyValueSet.size();
    }

    public boolean contains(Dimension dimension) {
        return this.emptyValueSet.contains(dimension);
    }

    @Override
    public IDimension[] getDimensions() {
        return this.emptyValueSet.getDimensions();
    }

    @Override
    public IIterator iterator() {
        return this.emptyValueSet.iterator();
    }

    @Override
    public ITuple getTuple(long index) {
        return this.emptyValueSet.getTuple(index);
    }
}

