/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LeafSetTupleMap {
    private Map<Object, long[]> tupleToIndexes;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    public LeafSetTupleMap(CrossJoinedSet cjs) {
        Set[] sets = cjs.getSets();
        long tlSize = cjs.tupleList.listSize();
        int tupleToIndexesSize = (int)Math.ceil((float)tlSize / 0.75f);
        this.tupleToIndexes = new HashMap<Object, long[]>(tupleToIndexesSize, 0.75f);
        for (int i = 0; i < sets.length; ++i) {
            Set set = sets[i];
            int leafSetIndex = 0;
            this.populateLeafSetTupleToIndex(set, leafSetIndex);
        }
    }

    private int populateLeafSetTupleToIndex(Set set, int leafSetIndex) {
        ITupleList tl = set.tupleList;
        int count = 0;
        if (tl instanceof CrossJoinTupleList) {
            ITupleList[] childTupleLists = ((CrossJoinTupleList)tl).getChildTupleLists();
            for (int i = 0; i < childTupleLists.length; ++i) {
                leafSetIndex = this.populateLeafSetTupleToIndex(new Set(childTupleLists[i]), leafSetIndex);
            }
        } else if (tl instanceof UnionTupleList) {
            ITupleList[] childTupleLists = ((UnionTupleList)tl).getChildTupleLists();
            for (int i = 0; i < childTupleLists.length; ++i) {
                leafSetIndex = this.populateLeafSetTupleToIndex(new Set(childTupleLists[i]), leafSetIndex);
            }
        } else {
            int leafInd = ++leafSetIndex * -1;
            ITupleIterator ti = tl.iterator();
            for (long index = 0L; index < tl.size(); ++index) {
                ITuple o = ti.getTuple(index);
                long[] indexes = this.tupleToIndexes.get(o);
                if (indexes == null) {
                    indexes = new long[]{leafInd, count++};
                } else {
                    long[] newIndexes = new long[indexes.length + 2];
                    System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                    newIndexes[newIndexes.length - 2] = leafInd;
                    newIndexes[newIndexes.length - 1] = count++;
                    indexes = newIndexes;
                }
                this.tupleToIndexes.put((Tuple)o, indexes);
            }
        }
        return leafSetIndex;
    }

    public long[] getOrdinals(Set set, int setIndex, ITuple tuple, int[] ordinalsToIndex) {
        boolean[] nullFlag = new boolean[1];
        long[] indexes = this.extractIndexes(set, tuple, ordinalsToIndex, setIndex, nullFlag);
        int[] leafSetIndex = new int[]{0};
        Object tmpIndexes = this.getOrdinalsBottomUp(set, tuple, ordinalsToIndex, setIndex, leafSetIndex, indexes, nullFlag[0]);
        if (tmpIndexes instanceof Integer) {
            indexes = this.getOrdinalsForLeafSet(indexes, (Integer)tmpIndexes, new int[]{0}, new int[]{0});
        } else if (tmpIndexes instanceof long[]) {
            indexes = (long[])tmpIndexes;
        }
        return indexes;
    }

    private Object getOrdinalsBottomUp(Set set, ITuple tuple, int[] ordinalsToIndex, int rootSetIndex, int[] leafSetIndex, long[] indexes, boolean nullFlag) {
        ITupleList tl = set.getTupleList();
        if (tl instanceof CrossJoinTupleList) {
            ITupleList[] childTupleLists = ((CrossJoinTupleList)tl).getChildTupleLists();
            ArrayList<Object> childOrdinalsList = new ArrayList<Object>();
            for (int i = 0; i < childTupleLists.length; ++i) {
                boolean[] flags = new boolean[1];
                indexes = this.extractIndexes(new Set(childTupleLists[i]), tuple, ordinalsToIndex, rootSetIndex, flags);
                Object childOrd = this.getOrdinalsBottomUp(new Set(childTupleLists[i]), tuple, ordinalsToIndex, rootSetIndex, leafSetIndex, indexes, nullFlag = flags[0]);
                if (childOrd instanceof Integer) {
                    childOrdinalsList.add(this.getOrdinalsForLeafSet(indexes, (Integer)childOrd, new int[]{0}, new int[]{0}));
                    continue;
                }
                childOrdinalsList.add(childOrd);
            }
            int columns = childTupleLists.length;
            int rows = 1;
            int[] sizes = new int[columns];
            for (int i = 0; i < columns; ++i) {
                sizes[i] = (int)childTupleLists[i].size();
                rows *= ((long[])childOrdinalsList.get(i)).length;
            }
            long[] result = new long[rows];
            long[] cjsIndexes = new long[columns];
            for (int r = 0; r < rows; ++r) {
                long[] childOrdinals = new long[columns];
                for (int i = 0; i < cjsIndexes.length; ++i) {
                    childOrdinals[i] = ((long[])childOrdinalsList.get(i))[(int)cjsIndexes[i]];
                }
                result[r] = this.getOrdinalInParentSet(sizes, childOrdinals);
                cjsIndexes = this.getNextIndexes(cjsIndexes, sizes);
            }
            return result;
        }
        if (tl instanceof UnionTupleList) {
            ITupleList[] childTupleLists = ((UnionTupleList)tl).getChildTupleLists();
            ArrayList<Object> childOrdinalsList = new ArrayList<Object>();
            for (int i = 0; i < childTupleLists.length; ++i) {
                childOrdinalsList.add(this.getOrdinalsBottomUp(new Set(childTupleLists[i]), tuple, ordinalsToIndex, rootSetIndex, leafSetIndex, indexes, nullFlag));
            }
            this.getOrdinalsForLeafSets(childOrdinalsList, indexes);
            int size = 0;
            for (int i = 0; i < childOrdinalsList.size(); ++i) {
                size += ((long[])childOrdinalsList.get(i)).length;
            }
            if (size == 0) {
                return EMPTY_LONG_ARRAY;
            }
            long[] result = new long[size];
            int indexOffset = 0;
            long ordinalOffset = 0L;
            for (int i = 0; i < childOrdinalsList.size(); ++i) {
                long[] childOrdinals = (long[])childOrdinalsList.get(i);
                for (int j = 0; j < childOrdinals.length; ++j) {
                    result[j + indexOffset] = childOrdinals[j] + ordinalOffset;
                }
                ordinalOffset += childTupleLists[i].size();
                indexOffset += childOrdinals.length;
            }
            return result;
        }
        leafSetIndex[0] = leafSetIndex[0] + 1;
        return leafSetIndex[0];
    }

    private long[] getOrdinalsForLeafSet(long[] setTupleIndexes, int setIndex, int[] currSetTupleIndex, int[] startInd) {
        setIndex = -1 * setIndex;
        long[] setOrdinals = new long[setTupleIndexes.length];
        int k = 0;
        while (startInd[0] < setTupleIndexes.length) {
            if (setTupleIndexes[startInd[0]] < 0L) {
                currSetTupleIndex[0] = (int)setTupleIndexes[startInd[0]];
            } else {
                if (currSetTupleIndex[0] < setIndex) break;
                if (currSetTupleIndex[0] == setIndex) {
                    setOrdinals[k] = setTupleIndexes[startInd[0]];
                    ++k;
                }
            }
            startInd[0] = startInd[0] + 1;
        }
        if (k == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] resultOrdinals = new long[k];
        System.arraycopy(setOrdinals, 0, resultOrdinals, 0, k);
        return resultOrdinals;
    }

    private void getOrdinalsForLeafSets(List<Object> childOrdinalsList, long[] setTupleIndexes) {
        int[] curSetIndex = new int[]{0};
        int[] startInd = new int[]{0};
        for (int i = 0; i < childOrdinalsList.size(); ++i) {
            Object result = childOrdinalsList.get(i);
            if (!(result instanceof Integer)) continue;
            int setIndex = (Integer)result;
            childOrdinalsList.set(i, EMPTY_LONG_ARRAY);
            childOrdinalsList.set(i, this.getOrdinalsForLeafSet(setTupleIndexes, setIndex, curSetIndex, startInd));
        }
    }

    private long[] extractIndexes(Set set, ITuple tuple, int[] ordinalsToIndex, int rootSetIndex, boolean[] flags) {
        IMember[] mems;
        boolean nullFlag = flags[0];
        if (set.multipleHierarchySupport()) {
            IHierarchy[] hierachies = set.getHierarchies();
            mems = new IMember[hierachies.length];
            nullFlag = this.populateMembersByHierarchies(tuple, ordinalsToIndex, hierachies, mems, nullFlag);
        } else {
            Dimension[] dimensions = (Dimension[])set.getDimensions();
            mems = new IMember[dimensions.length];
            nullFlag = this.populateMembersByDimensions(tuple, ordinalsToIndex, dimensions, mems, nullFlag);
        }
        long[] indexes = !nullFlag ? this.extractIndexesFromMembers(mems, rootSetIndex) : this.extractIndexesFromSet(set);
        flags[0] = nullFlag;
        return indexes;
    }

    private boolean populateMembersByDimensions(ITuple tuple, int[] ordinalsToIndex, Dimension[] dimensions, IMember[] mems, boolean nullFlag) {
        for (int j = 0; j < mems.length; ++j) {
            int idx = -1;
            int dimensionIndex = dimensions[j].getIndex();
            if (dimensionIndex >= 0 && dimensionIndex < ordinalsToIndex.length) {
                idx = ordinalsToIndex[dimensionIndex];
            }
            if (idx != -1) {
                mems[j] = tuple.getMember(idx);
                continue;
            }
            nullFlag = true;
            mems[j] = null;
        }
        return nullFlag;
    }

    private boolean populateMembersByHierarchies(ITuple tuple, int[] ordinalsToIndex, IHierarchy[] hierarchies, IMember[] mems, boolean nullFlag) {
        for (int j = 0; j < mems.length; ++j) {
            int idx = -1;
            int hierarchyIndex = ((Hierarchy)hierarchies[j]).getOrdinal();
            if (hierarchyIndex >= 0 && hierarchyIndex < ordinalsToIndex.length) {
                idx = ordinalsToIndex[hierarchyIndex];
            }
            if (idx != -1) {
                mems[j] = tuple.getMember(idx);
                continue;
            }
            nullFlag = true;
            mems[j] = null;
        }
        return nullFlag;
    }

    private long[] extractIndexesFromMembers(IMember[] mems, int setIndex) {
        Tuple subTuple = new Tuple(mems, false);
        long[] indexes = this.tupleToIndexes.get(subTuple);
        if (indexes == null) {
            return EMPTY_LONG_ARRAY;
        }
        return indexes;
    }

    private long[] extractIndexesFromSet(Set set) {
        long[] indexes = new long[(int)set.size()];
        for (int j = 0; j < indexes.length; ++j) {
            indexes[j] = j;
        }
        return indexes;
    }

    public long getOrdinalInParentSet(int[] sizes, long[] ordinals) {
        int i;
        long ordinal = 0L;
        long n = 1L;
        for (i = 0; i < sizes.length; ++i) {
            n *= (long)sizes[i];
        }
        for (i = 0; i < sizes.length; ++i) {
            long size = sizes[i];
            ordinal += ordinals[i] * (n /= size);
        }
        return ordinal;
    }

    public long[] getNextIndexes(long[] indexes, int[] sizes) {
        int columns = indexes.length;
        for (int c = columns - 1; c >= 0; --c) {
            if (indexes[c] + 1L < (long)sizes[c]) {
                indexes[c] = indexes[c] + 1L;
                break;
            }
            indexes[c] = 0L;
        }
        return indexes;
    }
}

