/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.LevelCombination;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LevelCombinationsManager {
    private static final String COLON_STR = ":";
    Cube cube;
    HashSet<LevelCombination> levelCombinations;
    ArrayList<LevelCombination> sortedLevelCombinations;
    HashMap<String, int[]> memeberIdAndLevelTargetToDependentIds;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public LevelCombinationsManager(Cube c) {
        this.cube = c;
        this.readLevelCombinationsFile();
    }

    public void setLevelCombination(LevelCombination lc) {
        this.levelCombinations.add(lc);
        this.sortedLevelCombinations.add(lc);
    }

    private void readLevelCombinationsFile() {
        this.cube.getDimensions();
        this.levelCombinations = new HashSet();
        this.sortedLevelCombinations = new ArrayList();
    }

    public ArrayList<IMember>[] getDependantMembers(Tuple t) {
        LevelCombination combi = null;
        ArrayList<IMember>[] dependents = null;
        Iterator<LevelCombination> it = this.sortedLevelCombinations.iterator();
        while (combi == null && it.hasNext()) {
            LevelCombination nextCombi = it.next();
            if (!nextCombi.covers(t)) continue;
            combi = nextCombi;
        }
        dependents = combi.getDependentMembers(t);
        this.scoreDependents(dependents);
        return dependents;
    }

    public int[][] getDependentMemberIDs(Tuple t) {
        LevelCombination combi = null;
        int[][] dependents = null;
        Iterator<LevelCombination> it = this.sortedLevelCombinations.iterator();
        while (combi == null && it.hasNext()) {
            LevelCombination nextCombi = it.next();
            if (!nextCombi.covers(t)) continue;
            combi = nextCombi;
        }
        dependents = new int[t.size()][0];
        for (int i = 0; i < t.size(); ++i) {
            IMember m = t.getMember(i);
            int targetLevel = combi.getLevelIndex(i);
            dependents[i] = this.memeberIdAndLevelTargetToDependentIds.get(i + COLON_STR + ((IMemberCubics)m).getMemberId() + COLON_STR + targetLevel);
        }
        return dependents;
    }

    public void cacheDependentIds() {
        List<IDimension> dimsList = this.cube.getDimensions();
        Dimension[] dimensions = dimsList.toArray(new Dimension[0]);
        int dimCount = dimensions.length;
        HashSet[] dimensionsToTargetLevels = new HashSet[dimCount];
        for (LevelCombination lc : this.levelCombinations) {
            for (int i = 0; i < dimCount; ++i) {
                HashSet targetLevels = null;
                if (dimensionsToTargetLevels[i] == null) {
                    dimensionsToTargetLevels[i] = targetLevels = new HashSet();
                }
                dimensionsToTargetLevels[i].add(new Integer(lc.getLevelIndex(i)));
            }
        }
        this.memeberIdAndLevelTargetToDependentIds = new HashMap();
        for (int i = 0; i < dimCount; ++i) {
            HashSet targetLevels = dimensionsToTargetLevels[i];
            Dimension dim = (Dimension)this.cube.getDimension(i);
            Level[] levels = (Level[])dim.getLevels();
            Iterator lvlIt = targetLevels.iterator();
            while (lvlIt.hasNext()) {
                int targetLevel = (Integer)lvlIt.next();
                for (int j = 0; j < targetLevel + 1; ++j) {
                    try {
                        List<IMember> membersList = levels[j].getMembers();
                        IMember[] mems = membersList.toArray(new IMember[0]);
                        for (int k = 0; k < mems.length; ++k) {
                            int[] dependentIds = ((IMemberCubics)mems[k]).getDescendantsIds(levels[targetLevel]);
                            this.memeberIdAndLevelTargetToDependentIds.put(i + COLON_STR + ((IMemberCubics)mems[k]).getMemberId() + COLON_STR + targetLevel, dependentIds);
                        }
                        continue;
                    }
                    catch (MetadataException e) {
                        mErrorLogger.log(e);
                    }
                }
            }
        }
    }

    public Set getDependentSet(Tuple t) throws InterpreterException {
        LevelCombination combi = null;
        ArrayList<IMember>[] dependents = null;
        Iterator<LevelCombination> it = this.sortedLevelCombinations.iterator();
        while (combi == null && it.hasNext()) {
            LevelCombination nextCombi = it.next();
            if (!nextCombi.covers(t)) continue;
            combi = nextCombi;
        }
        dependents = combi.getDependentMembersExperimental(t);
        this.scoreDependents(dependents);
        Set result = null;
        result = new Set(new Tuple(t.getMember(0)), false);
        for (int i = 1; i < dependents.length; ++i) {
            ArrayList<IMember> members = dependents[i];
            ITuple[] tuples = new Tuple[members.size()];
            for (int j = 0; j < members.size(); ++j) {
                tuples[j] = new Tuple(members.get(j));
            }
            result = (Set)result.crossjoin(new Set(tuples, false), false);
        }
        return result;
    }

    private long scoreDependents(ArrayList<IMember>[] descendants) {
        long result = 1L;
        for (int i = 0; i < descendants.length; ++i) {
            ArrayList<IMember> al = descendants[i];
            result *= (long)al.size();
        }
        XQEDebugLog.out.println("Score:" + result);
        return result;
    }

    public boolean isAggregatedCombination(Tuple t) {
        String indexesString = "";
        int[] indexes = new int[t.size()];
        for (int i = 0; i < t.size(); ++i) {
            ILevel l = t.getMember(i).getLevel();
            indexes[i] = ((Level)l).getIndex();
            indexesString = indexesString + " " + ((Level)l).getIndex();
        }
        LevelCombination lc = new LevelCombination(indexes, -1L);
        boolean result = this.levelCombinations.contains(lc);
        return result;
    }

    public int getAggregatedCombinationId(Tuple t) {
        LevelCombination combi = null;
        Iterator<LevelCombination> it = this.sortedLevelCombinations.iterator();
        while (combi == null && it.hasNext()) {
            LevelCombination nextCombi = it.next();
            if (!nextCombi.covers(t)) continue;
            combi = nextCombi;
        }
        if (combi != null) {
            return combi.getCombinationId();
        }
        return -1;
    }
}

