/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;

public class MetadataResolver {
    private static final String UTF_EIGHT = "UTF-8";
    private Provider provider;
    private ICube cube;

    public MetadataResolver(Provider p, ICube c) {
        this.provider = p;
        this.cube = c;
    }

    public Object resolveObject(String mdxString) throws InterpreterException {
        ByteArrayInputStream ioStream;
        Object result = null;
        try {
            ioStream = new ByteArrayInputStream(mdxString.getBytes(UTF_EIGHT));
        }
        catch (IOException e) {
            throw new InterpreterException("X01499", new String[]{e.getMessage()}, e);
        }
        MDXParser parser = new MDXParser(ioStream, UTF_EIGHT);
        try {
            parser.Composite();
            InterpreterContext context = new InterpreterContext(this.provider);
            context.setCube(this.cube);
            Interpreter interp = new Interpreter(context, parser);
            SelectQuery q = context.createSelectQuery();
            interp.setQuery(q);
            result = interp.interpretObject();
        }
        catch (ParseException e) {
            throw new InterpreterException("X01499", new String[]{mdxString}, e);
        }
        return result;
    }

    private IMember resolveMemberInDimension(Dimension dim, int partIdx, String[] parts) {
        IMember result = null;
        if (partIdx < parts.length) {
            result = dim.findMember(parts[partIdx]);
            for (int i = ++partIdx; i < parts.length && result != null; ++i) {
                result = dim.findDescendant(result, parts[i]);
            }
        }
        return result;
    }

    public IMember resolveMember(String mdxString) throws InterpreterException {
        IMember result = null;
        Object resolvedObject = this.resolveObject(mdxString);
        if (resolvedObject instanceof IMember) {
            result = (IMember)resolvedObject;
        } else if (resolvedObject instanceof IDimension) {
            result = ((IDimension)resolvedObject).getDefaultHierarchy().getDefaultMember();
        } else if (resolvedObject instanceof IHierarchy) {
            result = ((IHierarchy)resolvedObject).getDefaultMember();
        } else {
            IDimension idim = null;
            UniqueNameParser parser = new UniqueNameParser();
            try {
                String[] parts = parser.parse(mdxString);
                int partIndex = 0;
                if (parts.length > 0) {
                    idim = this.cube.getDimension(parts[partIndex]);
                    if (idim != null) {
                        result = this.resolveMemberInDimension((Dimension)idim, ++partIndex, parts);
                    } else {
                        List<IDimension> dims = this.cube.getDimensions();
                        int szList = dims.size();
                        for (int i = 0; i < szList && result == null; ++i) {
                            IDimension dim = dims.get(i);
                            result = this.resolveMemberInDimension((Dimension)dim, partIndex, parts);
                        }
                    }
                }
            }
            catch (UniqueNameParserException e) {
                throw new InterpreterException("X01499", new String[]{mdxString}, e);
            }
        }
        return result;
    }

    public IDimension resolveDimension(String mdxString) throws InterpreterException {
        IDimension result = null;
        Object resolvedObject = this.resolveObject(mdxString);
        if (resolvedObject instanceof IDimension) {
            result = (IDimension)resolvedObject;
        } else {
            try {
                UniqueNameParser parser = new UniqueNameParser();
                String[] parts = parser.parse(mdxString);
                if (parts.length == 1) {
                    result = this.cube.getDimension(parts[0]);
                } else if (parts.length == 2 && this.cube.getName().equals(parts[0])) {
                    result = this.cube.getDimension(parts[1]);
                }
            }
            catch (UniqueNameParserException e) {
                throw new InterpreterException("X01499", new String[]{mdxString}, e);
            }
        }
        return result;
    }

    public IHierarchy resolveHierarchy(String mdxString) throws InterpreterException {
        IHierarchy result;
        block5: {
            String trimmedMDXString;
            Object resolvedObject;
            block6: {
                block4: {
                    result = null;
                    resolvedObject = this.resolveObject(mdxString);
                    if (!(resolvedObject instanceof IHierarchy)) break block4;
                    result = (IHierarchy)resolvedObject;
                    break block5;
                }
                trimmedMDXString = mdxString.trim();
                if (!(resolvedObject instanceof ILevel)) break block6;
                IHierarchy candidate = ((ILevel)resolvedObject).getHierarchy();
                if (candidate.getUniqueName().equals(trimmedMDXString)) {
                    result = candidate;
                }
                if (result != null) break block5;
                List<IHierarchy> hiers = ((ILevel)resolvedObject).getDimension().getHierarchies();
                int sz = hiers.size();
                for (int i = 0; i < sz && result == null; ++i) {
                    candidate = hiers.get(i);
                    if (!candidate.getUniqueName().equals(trimmedMDXString)) continue;
                    result = candidate;
                }
                break block5;
            }
            if (resolvedObject instanceof IDimension) {
                List<IHierarchy> hiers = ((IDimension)resolvedObject).getHierarchies();
                int sz = hiers.size();
                for (int i = 0; i < sz && result == null; ++i) {
                    IHierarchy candidate = hiers.get(i);
                    if (!candidate.getUniqueName().equals(trimmedMDXString)) continue;
                    result = candidate;
                }
            }
        }
        return result;
    }

    public ILevel resolveLevel(String mdxString) throws InterpreterException {
        ILevel result;
        block4: {
            String trimmedMDXString;
            Object resolvedObject;
            block5: {
                block3: {
                    result = null;
                    resolvedObject = this.resolveObject(mdxString);
                    if (!(resolvedObject instanceof ILevel)) break block3;
                    result = (ILevel)resolvedObject;
                    break block4;
                }
                trimmedMDXString = mdxString.trim();
                if (!(resolvedObject instanceof IDimension)) break block5;
                List<IHierarchy> hiers = ((IDimension)resolvedObject).getHierarchies();
                int sz = hiers.size();
                for (int i = 0; i < sz && result == null; ++i) {
                    IHierarchy hier = hiers.get(i);
                    List<ILevel> levs = hier.getLevels();
                    int szLevs = levs.size();
                    for (int k = 0; k < szLevs && result == null; ++k) {
                        ILevel candidate = levs.get(k);
                        if (!candidate.getUniqueName().equals(trimmedMDXString)) continue;
                        result = candidate;
                    }
                }
                break block4;
            }
            if (!(resolvedObject instanceof IHierarchy)) break block4;
            List<ILevel> levs = ((IHierarchy)resolvedObject).getLevels();
            int sz = levs.size();
            for (int i = 0; i < sz && result == null; ++i) {
                ILevel candidate = levs.get(i);
                if (!candidate.getUniqueName().equals(trimmedMDXString)) continue;
                result = candidate;
            }
        }
        return result;
    }
}

