/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.NullContextFlagValue;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.IOrdinalFilter;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiplexBlockIterator
extends AbstractBlockIterator {
    private static final int TEN_THOUSAND = 10000;
    private final PipelineBlockIterator pipelineBlockIterator;
    private boolean crossproductPipelineValues;
    private Object[] savedPipelineValues = null;
    private final Block[] pipelineBlocks;
    private final ArrayList<Object[]> nonPipelineBlockValues;
    private final Block[] nonPipelineBlocks;
    private final IteratorTracker[] iteratorTrackerArray;
    private final OrdinalTracker returnedOrdinals;
    private Object[] nextValuesFromNonPipelineBlocks = null;
    private long ordinalForNextValuesFromNonPipelineBlocks = -1L;
    private boolean hasNonPipelineDefaultValueCell = false;
    private long pipelineOrdinalUsed;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultiplexBlockIterator(Block[] blocks) {
        super(blocks);
        this.iteratorTrackerArray = new IteratorTracker[blocks.length];
        ArrayList<Block> pipelineBlockList = new ArrayList<Block>();
        ArrayList<Block> nonPipelineBlockList = new ArrayList<Block>();
        long pipelineBlockMaxSetSize = 0L;
        for (int blockIndex = 0; blockIndex < blocks.length; ++blockIndex) {
            Block block = blocks[blockIndex];
            if (block.isPipelining()) {
                pipelineBlockList.add(block);
                this.iteratorTrackerArray[blockIndex] = new IteratorTracker(pipelineBlockList.size() - 1, true);
                if (block.tupleSetSize() <= pipelineBlockMaxSetSize) continue;
                pipelineBlockMaxSetSize = block.tupleSetSize();
                continue;
            }
            nonPipelineBlockList.add(block);
            this.iteratorTrackerArray[blockIndex] = new IteratorTracker(nonPipelineBlockList.size() - 1, false);
        }
        this.pipelineBlocks = new Block[pipelineBlockList.size()];
        pipelineBlockList.toArray(this.pipelineBlocks);
        this.nonPipelineBlocks = new Block[nonPipelineBlockList.size()];
        nonPipelineBlockList.toArray(this.nonPipelineBlocks);
        this.crossproductPipelineValues = false;
        if (pipelineBlockList.size() <= 0) throw new UnsupportedOperationException("All multiplex block iterators must have at least one pipeline block.");
        this.pipelineBlockIterator = new PipelineBlockIterator(this.pipelineBlocks);
        long pipelineBlockSize = ((Block)pipelineBlockList.get(0)).tupleSetSize();
        if (pipelineBlockSize < this.blockSetsInfo.getSize()) {
            if (pipelineBlockSize != 1L && pipelineBlockSize != 0L) throw new UnsupportedOperationException("Pipeline blocks size of " + pipelineBlockSize + " is less than total combined block size of " + this.blockSetsInfo.getSize() + " so values must be crossjoined....not supported yet.");
            this.crossproductPipelineValues = true;
        }
        if (this.nonPipelineBlocks.length > 0) {
            this.nonPipelineBlockValues = this.calculateNonPipelineBlockValues(this.nonPipelineBlocks, blocks);
            this.returnedOrdinals = new OrdinalTracker(this.nonPipelineBlockValues.size());
            return;
        } else {
            this.nonPipelineBlockValues = null;
            this.returnedOrdinals = null;
        }
    }

    private ArrayList<Object[]> calculateNonPipelineBlockValues(Block[] theNonPipelineBlocks, Block[] allBlocks) {
        BlockIterator nonPipelineBlockIterator = new BlockIterator(theNonPipelineBlocks, allBlocks);
        ArrayList<Object[]> blockValues = new ArrayList<Object[]>();
        int numNullEntries = 0;
        while (nonPipelineBlockIterator.hasNext()) {
            Object[] value = (Object[])nonPipelineBlockIterator.next();
            if (!nonPipelineBlockIterator.isAtDefaultValuePos()) {
                long ordinal = nonPipelineBlockIterator.pos();
                if (ordinal < 0L || ordinal > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("We do not support large ordinals for the non pipeline blocks.  Ordinal = " + ordinal);
                }
                if (ordinal > (long)blockValues.size()) {
                    int i = blockValues.size();
                    while ((long)i < ordinal) {
                        blockValues.add(null);
                        ++numNullEntries;
                        ++i;
                    }
                }
                blockValues.add((int)ordinal, value);
                continue;
            }
            this.hasNonPipelineDefaultValueCell = true;
        }
        if (blockValues.size() > 10000) {
            ROLAPLog.logWarn("ROLAPPipeline", "Created an array of " + blockValues.size() + ", " + numNullEntries + " of which are null, of nonPipelineBlockValues in MultiplexBlockIterator.");
        }
        return blockValues;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.pipelineBlockIterator.hasNext();
        if (!hasNext && this.nonPipelineBlockValues != null) {
            if (this.crossproductPipelineValues && this.savedPipelineValues != null) {
                long lastReturnedOrdinal = this.getBlockOrdSurrogateId();
                boolean bl = hasNext = this.getNextNonNullNonPipelineBlockValuesIndex(lastReturnedOrdinal + 1L, false) != -1;
            }
            if (!hasNext) {
                if (this.nextValuesFromNonPipelineBlocks == null) {
                    this.nextValuesFromNonPipelineBlocks = this.findNextNonPipelineValues();
                }
                hasNext = this.nextValuesFromNonPipelineBlocks != null;
            }
        }
        return hasNext;
    }

    @Override
    public Object next() {
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        if (this.hasNext()) {
            Object[] nextValues = this.nextHelper();
            if (this.isLogging()) {
                this.log(nextValues, this.getBlockOrdSurrogateId(), this.pipelineOrdinalUsed, this.returnsCellArray());
            }
            return nextValues;
        }
        StringBuilder msg = new StringBuilder();
        if (this.pipelineBlockIterator != null && !this.pipelineBlockIterator.hasNext()) {
            msg.append("PipelineBlockIterator has no more next items. ");
        }
        if (this.nonPipelineBlocks.length > 0 && this.nextValuesFromNonPipelineBlocks == null) {
            msg.append("Non-PipelineBlockIterator has no more next items.");
        }
        throw new NoSuchElementException(msg.toString());
    }

    private Object[] createNullContextValue(long ordinal) {
        return new Object[]{new Cell[]{new Cell(ordinal, NullContextFlagValue.NULLCONTEXTFLAGVALUE)}};
    }

    private Object[] getValuesFromNonPipelineBlocks(long ordinal) {
        Object[] returnArray;
        if (ordinal < (long)this.nonPipelineBlockValues.size()) {
            returnArray = this.nonPipelineBlockValues.get((int)ordinal);
            if (returnArray == null) {
                returnArray = this.getDefaultValuesForNonPipelinedBlocks();
            }
        } else {
            returnArray = this.getDefaultValuesForNonPipelinedBlocks();
        }
        return returnArray;
    }

    private Object[] getDefaultValuesForNonPipelinedBlocks() {
        Object[] returnArray = new Object[this.nonPipelineBlocks.length];
        for (int i = 0; i < this.nonPipelineBlocks.length; ++i) {
            returnArray[i] = this.nonPipelineBlocks[i].getDefaultValue();
        }
        return returnArray;
    }

    private Object[] reorderValuesToMatchBlocks(Object[] returnNext, Object[] pipelineIteratorNext, Object[] nonPipelineIteratorNext) {
        for (int index = 0; index < this.iteratorTrackerArray.length; ++index) {
            IteratorTracker itTracker = this.iteratorTrackerArray[index];
            if (itTracker.isFromPipelineIterator && pipelineIteratorNext != null) {
                returnNext[index] = pipelineIteratorNext[itTracker.iteratorIndex];
                continue;
            }
            if (itTracker.isFromPipelineIterator || nonPipelineIteratorNext == null) continue;
            returnNext[index] = nonPipelineIteratorNext[itTracker.iteratorIndex];
        }
        return returnNext;
    }

    private Object[] nextHelper() {
        Object[] returnNext = new Object[this.iteratorTrackerArray.length];
        Object[] pipelineIteratorNext = this.savedPipelineValues;
        Object[] nonPipelineIteratorNext = null;
        long ordinal = Long.MIN_VALUE;
        this.pipelineOrdinalUsed = -9223372036854775789L;
        if (pipelineIteratorNext != null && this.crossproductPipelineValues) {
            long lastReturnedOrdinal = this.getBlockOrdSurrogateId();
            int nextValidListIndex = this.getNextNonNullNonPipelineBlockValuesIndex(lastReturnedOrdinal + 1L, false);
            if (nextValidListIndex < 0) {
                pipelineIteratorNext = null;
                this.savedPipelineValues = null;
            } else {
                ordinal = nextValidListIndex;
            }
        }
        if (pipelineIteratorNext == null && this.pipelineBlockIterator.hasNext()) {
            pipelineIteratorNext = (Object[])this.pipelineBlockIterator.next();
            if (this.crossproductPipelineValues) {
                ordinal = this.getNextNonNullNonPipelineBlockValuesIndex(0L, false);
                this.savedPipelineValues = pipelineIteratorNext;
            } else {
                ordinal = this.pipelineBlockIterator.getBlockOrdSurrogateId();
            }
        }
        if (pipelineIteratorNext != null) {
            this.pipelineOrdinalUsed = this.pipelineBlockIterator.getBlockOrdSurrogateId();
            if (this.nonPipelineBlocks.length > 0) {
                nonPipelineIteratorNext = this.getValuesFromNonPipelineBlocks(ordinal);
            }
        } else {
            nonPipelineIteratorNext = this.nextValuesFromNonPipelineBlocks;
            this.nextValuesFromNonPipelineBlocks = null;
            ordinal = this.ordinalForNextValuesFromNonPipelineBlocks;
            if (!this.returnsCellArray()) {
                pipelineIteratorNext = new Object[this.iteratorTrackerArray.length - this.nonPipelineBlocks.length];
                for (int i = 0; i < this.pipelineBlocks.length; ++i) {
                    pipelineIteratorNext[i] = this.pipelineBlocks[i].getDefaultValue();
                }
            } else {
                pipelineIteratorNext = this.createNullContextValue(ordinal);
            }
        }
        this.setBlockOrdSurrogateId(ordinal);
        if (this.returnedOrdinals != null && ordinal != -9223372036854775788L) {
            this.returnedOrdinals.markOrdinal(ordinal);
        }
        return this.reorderValuesToMatchBlocks(returnNext, pipelineIteratorNext, nonPipelineIteratorNext);
    }

    @Override
    public boolean returnsCellArray() {
        if (this.pipelineBlockIterator != null) {
            return this.pipelineBlockIterator.returnsCellArray();
        }
        return false;
    }

    private int getNextNonNullNonPipelineBlockValuesIndex(long startingPosition, boolean filterOrdinals) {
        if (startingPosition < 0L || startingPosition > (long)this.nonPipelineBlockValues.size()) {
            throw new IllegalArgumentException("Asked to get index " + startingPosition + " in the nonPipelineBlockValues list of size " + this.nonPipelineBlockValues.size());
        }
        int foundPosition = -1;
        for (int pos = (int)startingPosition; pos < this.nonPipelineBlockValues.size(); ++pos) {
            if (filterOrdinals && this.returnedOrdinals.hasOrdinalBeenMarked(pos) || this.nonPipelineBlockValues.get(pos) == null) continue;
            foundPosition = pos;
            break;
        }
        return foundPosition;
    }

    private Object[] findNextNonPipelineValues() {
        Object[] newValues = null;
        if (this.ordinalForNextValuesFromNonPipelineBlocks == -9223372036854775788L) {
            return null;
        }
        if (this.nonPipelineBlockValues != null && this.ordinalForNextValuesFromNonPipelineBlocks != Long.MIN_VALUE) {
            int nextIndex = this.getNextNonNullNonPipelineBlockValuesIndex(this.ordinalForNextValuesFromNonPipelineBlocks + 1L, true);
            if (nextIndex >= 0) {
                newValues = this.nonPipelineBlockValues.get(nextIndex);
                this.ordinalForNextValuesFromNonPipelineBlocks = nextIndex;
            } else {
                this.ordinalForNextValuesFromNonPipelineBlocks = Long.MIN_VALUE;
            }
        }
        if (newValues == null && this.hasNonPipelineDefaultValueCell) {
            this.ordinalForNextValuesFromNonPipelineBlocks = -9223372036854775788L;
            newValues = this.getDefaultValuesForNonPipelinedBlocks();
            this.hasNonPipelineDefaultValueCell = false;
        }
        return newValues;
    }

    public static boolean supportsBlocks(Block[] blocks, List<Block> unsupportedPipelineBlocks) {
        int i;
        Block b2;
        boolean supported = true;
        ISet[] blockSets = Block.getCombinedBlockSets(blocks[0].interpreterContext, blocks);
        OrdinalMath ordinalMath = blocks[0].interpreterContext.getOrdinalMath();
        OrdinalMath.SetArrayInfo blockSetsInfo = ordinalMath.getSetArrayInfo(blockSets);
        long combinedBlockSize = blockSetsInfo.getSize();
        ArrayList<Block> pipelineBlocks = new ArrayList<Block>();
        for (Block b2 : blocks) {
            if (!b2.isPipelining()) continue;
            pipelineBlocks.add(b2);
        }
        if (pipelineBlocks.size() == 0) {
            return false;
        }
        long largestSurvivingSize = -1L;
        for (i = pipelineBlocks.size() - 1; i >= 0; --i) {
            b2 = (Block)pipelineBlocks.get(i);
            long blockSize = b2.tupleSetSize();
            if (blockSize != combinedBlockSize && blockSize != 1L && blockSize != 0L) {
                unsupportedPipelineBlocks.add(b2);
                pipelineBlocks.remove(i);
                supported = false;
                continue;
            }
            if (blockSize <= largestSurvivingSize) continue;
            largestSurvivingSize = blockSize;
        }
        for (i = pipelineBlocks.size() - 1; i >= 0; --i) {
            b2 = (Block)pipelineBlocks.get(i);
            if (b2.tupleSetSize() == largestSurvivingSize) continue;
            unsupportedPipelineBlocks.add(b2);
            pipelineBlocks.remove(i);
            supported = false;
        }
        return supported;
    }

    class IteratorTracker {
        int iteratorIndex;
        boolean isFromPipelineIterator;

        IteratorTracker(int iteratorIdx, boolean isFromPipelineItr) {
            this.iteratorIndex = iteratorIdx;
            this.isFromPipelineIterator = isFromPipelineItr;
        }
    }

    private static class OrdinalTracker {
        private final long setSize;
        private final IOrdinalFilter ordinalTracker;

        OrdinalTracker(long aSetSize) {
            this.setSize = aSetSize;
            this.ordinalTracker = Utilities.getBestOrdinalFilter(aSetSize);
        }

        public void markOrdinal(long ordinal) {
            if (ordinal < 0L) {
                throw new UnsupportedOperationException("Negative ordinal surrogates are not supported.");
            }
            if (ordinal < this.setSize) {
                this.ordinalTracker.enable(ordinal);
            }
        }

        public boolean hasOrdinalBeenMarked(long ordinal) {
            if (ordinal >= 0L && ordinal < this.setSize) {
                return this.ordinalTracker.isEnabled(ordinal);
            }
            return false;
        }
    }
}

