/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTSet;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxComposite;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxExpression;
import com.cognos.xqe.runtree.olap.mdx.XMdxInlineNamedSet;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxSelect;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ParseTreePrinter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.olap.XQEOlapPlanningException;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class NamedSet
extends Metadata
implements INamedSet {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NamedSet.class);
    private static final long serialVersionUID = -6569440205482701958L;
    private String cubeName;
    private boolean hasExpandedNamedSetDefinition;
    private String setString = null;
    private ASTSet setExpressionNode = null;
    protected XMdxNode runtreeSetNode = null;
    private Block setB = null;
    private boolean inlineSet = false;
    private int inlineSetRefCount = 0;
    private boolean defInsideNamedSet = false;

    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public String getExpression() {
        return this.setString;
    }

    @Override
    public String toString() {
        String id = this.getUniqueName();
        if (this.cubeName != null) {
            id = "[" + this.cubeName + "]." + id;
        }
        return "NamedSet " + id + " = " + this.setString;
    }

    public void setCubeName(String cName) {
        this.cubeName = cName;
    }

    public void setExpression(String mdxSetExpr) {
        this.setString = mdxSetExpr;
    }

    public boolean isInline() {
        return this.inlineSet;
    }

    public boolean isInlineAndActive() {
        return this.inlineSet && this.inlineSetRefCount > 0;
    }

    public void decrementInlineRef() {
        if (this.inlineSet && this.inlineSetRefCount > 0) {
            --this.inlineSetRefCount;
        }
    }

    public void setBlock(Block setBlock, boolean copy) {
        this.setB = new Block(setBlock);
        BlockIterator blockIter = setBlock.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set set = copy ? (Set)((Set)blockObj[0]).copy() : (Set)blockObj[0];
            this.setB.add(blockIter, (Object)set);
        }
        setBlock.setNamedSet(this);
    }

    public void setBlock(Block setBlock) {
        this.setBlock(setBlock, true);
    }

    public NamedSet(String name, String mdxString) {
        super(name);
        if (mdxString.trim().indexOf(39) == 0) {
            mdxString = mdxString.substring(mdxString.indexOf(39) + 1, mdxString.lastIndexOf(39));
        }
        this.setString = mdxString;
    }

    public NamedSet(String name, ASTSet astSet) {
        super(name);
        this.setExpressionNode = astSet;
    }

    public NamedSet(String name, XMdxNode runtreeSet) {
        super(name);
        this.runtreeSetNode = runtreeSet;
        this.hasExpandedNamedSetDefinition = XMdxLocal.getExpandedNamedSetDefinition(runtreeSet, name) != null;
    }

    @Deprecated
    public NamedSet(String name, Set[] sets) {
    }

    public NamedSet(String name, Block sets) {
        super(name);
        this.setString = null;
        this.setBlock(sets);
        this.inlineSet = false;
        this.defInsideNamedSet = false;
    }

    public NamedSet(String name, Block sets, boolean isInlineSet, InterpreterContext interpreterContext) {
        super(name);
        this.setString = null;
        this.setBlock(sets);
        this.inlineSet = isInlineSet;
        CalculationEngine calculationEngine = (CalculationEngine)interpreterContext.getCalculationEngine();
        if (this.inlineSet) {
            this.inlineSetRefCount = calculationEngine.getInlineNamedSetRefCount(name);
        }
        this.defInsideNamedSet = interpreterContext.getEvaluatingNamedSet();
    }

    protected void setDefaultProperties() {
    }

    @Deprecated
    public Set[] getSet(InterpreterContext interpreterContext) throws InterpreterException {
        return null;
    }

    private void processSetExpressionNode(InterpreterContext interpreterContext) throws InterpreterException {
        InterpreterContext ic2 = new InterpreterContext(interpreterContext, interpreterContext.getRootContextSet());
        Interpreter interpreter = new Interpreter(ic2, null);
        interpreter.setInterpreterSubject(this.getName());
        Object o = interpreter.interpretCalculation(this.setExpressionNode);
        this.setB = (Block)o;
        this.setB = Caster.cast(this.setB, Set.class, ic2);
        this.setB.setNamedSet(this);
        this.setB.removeInvalidTuples();
    }

    private void processSetString(InterpreterContext interpreterContext) throws InterpreterException {
        ByteArrayInputStream bais;
        String utf8 = "UTF-8";
        try {
            bais = new ByteArrayInputStream(this.setString.getBytes(utf8));
        }
        catch (IOException e) {
            throw new InterpreterException("X01515", e);
        }
        MDXParser parser = new MDXParser(bais, utf8);
        XQEDebugLog.out.println("parser : " + parser);
        try {
            XQEDebugLog.out.println("Parsing ...");
            parser.Set();
        }
        catch (ParseException e) {
            throw new InterpreterException("X01515", e);
        }
        XQEDebugLog.out.println("Printing parse tree for " + this.getName() + " Named Set...");
        ParseTreePrinter printer = new ParseTreePrinter(parser);
        printer.print();
        CrossJoinedSet namedSetContext = this.buildNamedSetContext(interpreterContext);
        InterpreterContext ic2 = new InterpreterContext(interpreterContext, namedSetContext);
        Interpreter interpreter = new Interpreter(ic2, parser);
        interpreter.setInterpreterSubject(this.getName());
        Object o = interpreter.interpretObject();
        this.setB = (Block)o;
        this.setB = Caster.cast(this.setB, Set.class, ic2);
        this.setB.setNamedSet(this);
        this.setB.removeInvalidTuples();
    }

    public void processRuntreeSetNode(InterpreterContext interpreterContext) throws InterpreterException {
        XDataContext context = interpreterContext.getXDataContext();
        InterpreterContext oldContext = context.getInterpreterContext();
        CrossJoinedSet namedSetContext = this.buildNamedSetContext(oldContext);
        InterpreterContext newContext = new InterpreterContext(oldContext, namedSetContext);
        context.setInterpreterContext(newContext);
        try {
            Object o = null;
            newContext.setEvaluatingNamedSet(true);
            o = this.runtreeSetNode.execute(context);
            newContext.setEvaluatingNamedSet(false);
            if (o instanceof CubicsValue) {
                o = ((CubicsValue)o).getCubicsObject();
            }
            this.setB = (Block)o;
            this.setB = Caster.cast(this.setB, Set.class, newContext);
            this.setB.removeInvalidTuples();
        }
        catch (InterpreterException e) {
            throw new MDXEngineException("X01515", (Throwable)e);
        }
        finally {
            ICalculationEngine newCE = newContext.getCalculationEngine();
            Map<String, NamedSet> newNamedSets = newCE.getNamedSets();
            ICalculationEngine oldCE = oldContext.getCalculationEngine();
            Map<String, NamedSet> oldNamedSets = oldCE.getNamedSets();
            for (Map.Entry<String, NamedSet> entry : newNamedSets.entrySet()) {
                if (oldNamedSets.containsKey(entry.getKey())) continue;
                oldCE.addNamedSet(entry.getValue());
            }
            context.setInterpreterContext(oldContext);
        }
    }

    public Object getSet1(InterpreterContext interpreterContext) throws InterpreterException {
        if (this.setB == null) {
            if (this.runtreeSetNode != null) {
                this.processRuntreeSetNode(interpreterContext);
            } else if (this.setExpressionNode != null) {
                this.processSetExpressionNode(interpreterContext);
            } else if (this.setString != null) {
                this.processSetString(interpreterContext);
            }
        }
        Block retBlock = this.setB;
        if (!this.inlineSet || this.defInsideNamedSet) {
            retBlock = new Block(interpreterContext, this.setB.first());
            retBlock.setNamedSet(this);
        }
        this.setB.interpreterContext = interpreterContext;
        if (!this.hasExpandedNamedSetDefinition) {
            interpreterContext.disableAncestorNodesCache();
        }
        return retBlock;
    }

    private CrossJoinedSet buildNamedSetContext(InterpreterContext interpreterContext) throws InterpreterException {
        ITuple whereTuple;
        CrossJoinedSet baseContext = interpreterContext.getRootContextSet();
        Set[] sets = baseContext.getSets();
        ArrayList<IMember> al = new ArrayList<IMember>();
        for (int setIdx = 0; setIdx < sets.length; ++setIdx) {
            IHierarchy[] setHierarchies = sets[setIdx].getHierarchies();
            for (int hierIdx = 0; hierIdx < setHierarchies.length; ++hierIdx) {
                Dimension dim = (Dimension)setHierarchies[hierIdx].getDimension();
                if (dim.isAttributeDimension()) {
                    al.add(dim.getDummyMember(setHierarchies[hierIdx]));
                    continue;
                }
                Hierarchy hier = (Hierarchy)setHierarchies[hierIdx];
                IMember defaultMember = !dim.isMeasuresDimension() && dim.getCube() instanceof LOLAPTM1Cube ? hier.getProviderDefaultMember() : MemberOperations.getDefaultMemberOp(setHierarchies[hierIdx], interpreterContext);
                if (defaultMember instanceof CalculatedMember) {
                    defaultMember = XMdxSelect.resolveCalculatedDefaultMemberFromQuery(this.runtreeSetNode, setHierarchies[hierIdx], (CalculatedMember)defaultMember);
                }
                al.add(defaultMember);
            }
        }
        IMember[] memberArray = al.toArray(new IMember[0]);
        Tuple defMembertuple = new Tuple(memberArray, interpreterContext.getCube());
        Set defMemberSet = new Set(defMembertuple);
        CrossJoinedSet namedSetContext = new CrossJoinedSet(new ISet[]{defMemberSet});
        SelectQuery selectQuery = (SelectQuery)interpreterContext.getXDataContext().getProperty("selectQuery");
        if (selectQuery != null && (whereTuple = selectQuery.getWhereTuple()) != null) {
            namedSetContext = namedSetContext.mergeSet(new Set(whereTuple));
        }
        return namedSetContext;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.NAMED_SET;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    public XNode getRuntreeSetNode() {
        return this.runtreeSetNode;
    }

    public static void buildInlineNamedSetRefCountTable(IXQEQueryNode node, InterpreterContext interpreterContext) {
        Hashtable<String, Integer> inlineRefCountTable = ((CalculationEngine)interpreterContext.getCalculationEngine()).getInlineNamedSetRefCountTable();
        NamedSet.addNodeInlineNamedSetRefCount(node, inlineRefCountTable);
    }

    private static void addNodeInlineNamedSetRefCount(IXQEQueryNode node, Hashtable<String, Integer> inlineRefCountTable) {
        if (node instanceof XMdxElement) {
            boolean isNameOfInLinenamedSet = false;
            IXQEQueryNode parent = node.getParent();
            if (parent instanceof XMdxComposite) {
                IXQEQueryNode grandParent = parent.getParent();
                if (grandParent instanceof XMdxInlineNamedSet) {
                    isNameOfInLinenamedSet = true;
                } else if (grandParent instanceof XMdxExpression && ((XMdxExpression)grandParent).isInlineSet()) {
                    isNameOfInLinenamedSet = true;
                }
            }
            String setName = ((XMdxElement)node).getValue();
            if (isNameOfInLinenamedSet) {
                inlineRefCountTable.put(setName, 0);
            } else {
                Integer refCount = inlineRefCountTable.get(setName);
                if (refCount != null) {
                    Integer n = refCount;
                    Integer n2 = refCount = Integer.valueOf(refCount + 1);
                    inlineRefCountTable.put(setName, refCount);
                }
            }
        }
        int childCount = node.getNumberChildren();
        for (int i = 0; i < childCount; ++i) {
            NamedSet.addNodeInlineNamedSetRefCount(node.getChild(i), inlineRefCountTable);
        }
    }

    @Override
    public List<ILevel> getLevels() {
        return Collections.emptyList();
    }

    @Override
    public IDimension getDimension() {
        return null;
    }

    @Override
    public IHierarchy getHierarchy() {
        return null;
    }

    @Override
    public IXQEQueryNode getSet(PlanningEnvironment environment, MetadataConnection mdConnection, MDXQuery mdxQuery) throws XQEOlapPlanningException {
        return null;
    }
}

